from infra.rtc_sla_tentacles.backend.lib.api.proto import allocation_zone_details_pb2
from infra.rtc_sla_tentacles.backend.lib.config.interface import ConfigInterface
from infra.rtc_sla_tentacles.backend.lib.metrics import metrics_provider


def _fill_manage_session_info(reroll: metrics_provider.Reroll, allocation_zone_id: str, protobuf_manage_session):
    protobuf_manage_session.start_ts = reroll.start_ts
    protobuf_manage_session.end_ts = reroll.end_ts
    protobuf_manage_session.taskgroups_ids.extend(
        f"https://nanny.yandex-team.ru/ui/#/alemate/taskgroups/{taskgroup_id}/"
        for taskgroup_id in reroll.taskgroup_ids
    )
    protobuf_manage_session.snapshot_ids.extend(
        f"https://nanny.yandex-team.ru/ui/#/services/catalog/{allocation_zone_id}/runtime_attrs_history/{snapshot_id}/"
        for snapshot_id in reroll.snapshot_ids
    )
    protobuf_manage_session.is_in_progress = reroll.is_in_progress


def fill_allocation_zone_processes(
    redeploy_metrics: metrics_provider.MetricsTentaclesTimestampResourceFreshness,
    reallocation_metrics: metrics_provider.MetricsTentaclesReallocation,
    config_interface: ConfigInterface,
    allocation_zone_id: str,
    protobuf_result: allocation_zone_details_pb2.TManageProcesses,
):
    # Add current and completed redeploy sessions as protobuf.
    if current_reroll := redeploy_metrics.get_current_reroll():
        session = protobuf_result.redeployment.sessions.add()
        _fill_manage_session_info(current_reroll, allocation_zone_id, session)
    for complete_reroll in redeploy_metrics.get_complete_rerolls():
        session = protobuf_result.redeployment.sessions.add()
        _fill_manage_session_info(complete_reroll, allocation_zone_id, session)

    if config_interface.tentacles_groups_config.is_reallocation_enable(allocation_zone_id):
        # If reallocation enabled - add current and completed reallocation sessions as protobuf.
        if current_reroll := reallocation_metrics.get_current_reroll():
            session = protobuf_result.reallocation.sessions.add()
            _fill_manage_session_info(current_reroll, allocation_zone_id, session)
        for complete_reroll in reallocation_metrics.get_complete_rerolls():
            session = protobuf_result.reallocation.sessions.add()
            _fill_manage_session_info(complete_reroll, allocation_zone_id, session)
