import enum
import json
from dateutil.parser import parse as date_parse


class IncorrectRequestParameters(Exception):
    pass


def form_metric_name(base, word=None, suffix="summ"):
    if word:
        return "_".join((base, word, suffix))
    else:
        return "_".join((base, suffix))


def parse_request_params(prms):
    deserialized = json.loads(prms)

    if type(deserialized) == str:
        return eval(deserialized)
    elif type(deserialized) == dict or type(deserialized) == list:
        return deserialized
    else:
        raise IncorrectRequestParameters("Incorrect request parameters were sent")


def transform_datetime(val):

    if isinstance(val, int):
        return val
    elif isinstance(val, str):
        return int(date_parse(val).timestamp())
    else:
        raise ValueError("start_time and end_time must be of type int or of type str")


def from_db_to_proto(raw_val):
    if isinstance(raw_val, enum.Enum):
        return raw_val.name
    elif isinstance(raw_val, (str, int)):
        return raw_val
    else:
        raise RuntimeError(f"unknown field type '{raw_val}'")
