
from jsonschema import validate
import copy

from infra.rtc_sla_tentacles.backend.lib.config.base_config import BaseConfig


class ApiConfig(BaseConfig):

    def _resolve_secret_values_from_stubs(self):
        # No secret values to resolve.
        pass

    def _validate_and_return_part_of_full_config(self, full_config):

        schema = {
            "type": "object",
            "properties": {
                "api": {
                    "type": "object",
                    "properties": {
                        "server_config": {"$ref": "#/definitions/server_config_schema"},
                        "gui_config": {"$ref": "#/definitions/gui_config_schema"},
                    },
                    "required": ["server_config", "gui_config"],
                },
            },
            "definitions": {
                "server_config_schema": {
                    "type": "object",
                    "properties": {
                        "clickhouse": {
                            "type": "object",
                            "properties": {
                                "credentials": {
                                    "type": "string",
                                    "minLength": 1,
                                },
                                "connection": {
                                    "type": "string",
                                    "minLength": 1,
                                },
                            },
                            "required": ["credentials", "connection"],
                        },
                        "port": {
                            "type": "integer",
                            "minimum": 1,
                            "maximum": 65535,
                        },
                        "listen_queue": {
                            "type": "integer",
                            "minimum": 1,
                        },
                        "processes": {
                            "type": "integer",
                            "minimum": 1,
                            "maximum": 8,
                        },
                        "threads": {
                            "type": "integer",
                            "minimum": 1,
                            "maximum": 8,
                        },
                        "logfile": {
                            "type": "string",
                            "minLength": 1,
                        },
                        "log_maxsize": {
                            "type": "integer",
                            "minimum": 4096,
                            "title": "Single logfile size (in bytes)",
                        },
                    },
                    "required": [
                        "clickhouse",
                        "port",
                        "listen_queue",
                        "processes",
                        "threads",
                        "logfile"
                    ],
                },
                "gui_config_schema": {
                    "type": "object",
                    "properties": {
                        "yasm_panel_all_metrics": {"type": "string", "minLength": 1},
                    },
                },
            },
        }

        validate(full_config, schema)
        api_config = copy.deepcopy(full_config["api"])

        return api_config
