# encoding: utf-8
import copy

from jsonschema import validate

from infra.rtc_sla_tentacles.backend.lib.config.base_config import BaseConfig


class HarvestersConfig(BaseConfig):
    """
        Holds Harvesters config..
    """
    def _resolve_secret_values_from_stubs(self):
        # No secret values to resolve.
        pass

    def _validate_and_return_part_of_full_config(self, full_config):
        harvesters_config_schema = {
            "type": "object",
            "properties": {
                "harvesters": {
                    "type": "object",
                    "properties": {
                        "results_storage": {"$ref": "#/definitions/results_storage_schema"},
                        "harvesters": {"type": "object"},
                    },
                    "required": ["results_storage", "harvesters"],
                },
            },
            "required": ["harvesters"],

            "definitions": {

                "results_storage_schema": {
                    "type": "object",
                    "properties": {
                        "mongodb": {
                            "type": "object",
                            "properties": {
                                "connection": {
                                    "type": "string",
                                    "minLength": 1,
                                },
                                "credentials": {
                                    "type": "string",
                                    "minLength": 1,
                                },
                                "locks_collection_name": {
                                    "type": "string",
                                    "minLength": 1,
                                },
                                "pymongo_additional_params": {
                                    "type": "object",
                                    "minProperties": 1,
                                }
                            },
                            "required": [
                                "connection",
                                "credentials",
                                "locks_collection_name",
                            ],
                        },
                    },
                    "required": ["mongodb"],
                },

            },
        }
        validate(full_config, harvesters_config_schema)

        harvesters_config = copy.deepcopy(full_config["harvesters"])
        return harvesters_config
