from jsonschema import validate
import copy

from infra.rtc_sla_tentacles.backend.lib.config.base_config import BaseConfig


class IncidentsConfig(BaseConfig):

    def _resolve_secret_values_from_stubs(self):
        # No secret values to resolve.
        pass

    def _validate_and_return_part_of_full_config(self, full_config):
        schema = {
            "type": "object",
            "properties": {
                "incidents": {
                    "type": "object",
                    "properties": {
                        "assignees": {"$ref": "#/definitions/assignees_schema"},
                        "incidents_collection_name": {
                            "type": "string",
                            "minLength": 1,
                        }
                    },
                    "required": ["assignees", "incidents_collection_name"],
                },
            },
            "required": ["incidents"],

            "definitions": {

                "assignees_schema": {
                    "type": "array",
                    "items": [
                        {
                            "type": "string",
                            "minLength": 1,
                        }
                    ],
                    "minItems": 1,
                }
            },
        }
        validate(full_config, schema)
        return copy.deepcopy(full_config["incidents"])
