# encoding: utf-8
import copy
import logging.config

from jsonschema import validate

from infra.rtc_sla_tentacles.backend.lib.config.base_config import BaseConfig
from infra.rtc_sla_tentacles.backend.lib.config.exceptions import ConfigValidationError


class LoggingConfig(BaseConfig):
    """
        Holds logging config dictionary.
    """
    def _resolve_secret_values_from_stubs(self):
        # No secret values to resolve.
        pass

    def _validate_and_return_part_of_full_config(self, full_config):
        logging_config_schema = {
            "type": "object",
            "properties": {
                "logging": {
                    "type": "object",
                }
            },
            "required": ["logging"],
        }
        validate(full_config, logging_config_schema)

        logging_config = copy.deepcopy(full_config["logging"])

        # https://docs.python.org/3/library/logging.config.html#logging.config.dictConfig
        try:
            logging.config.dictConfig(logging_config)
        except (ValueError, TypeError, AttributeError, ImportError) as _exc:
            raise ConfigValidationError("Exception while configuring logging "
                                        f"from 'logging' section of configuration file: {_exc}")
        return logging_config
