# encoding: utf-8
import copy

from jsonschema import validate

from infra.rtc_sla_tentacles.backend.lib.config.base_config import BaseConfig


class MiscConfig(BaseConfig):
    """
        Holds miscellaneous settings.
    """
    def _resolve_secret_values_from_stubs(self):
        # No secret values to resolve.
        pass

    def _validate_and_return_part_of_full_config(self, full_config):
        misc_config_schema = {
            "type": "object",
            "properties": {
                "misc": {
                    "type": "object",
                    "properties": {
                        "my_datacenter_name": {"$ref": "#/definitions/my_datacenter_name"},
                        "env_name": {"$ref": "#/definitions/env_name"},
                        "url": {"type": "string", "minLength": 1},
                    },
                    "required": ["my_datacenter_name", "env_name", "url"],
                },
            },
            "required": ["misc"],

            "definitions": {

                "my_datacenter_name": {
                    "anyOf": [
                        {"type": "string", "enum": self._valid_datacenter_names},
                        {"type": "null"},
                    ],
                },

                "env_name": {
                    "anyOf": [
                        {"type": "string", "enum": self._valid_env_names}
                    ],
                },
            },
        }
        validate(full_config, misc_config_schema)

        misc_config = copy.deepcopy(full_config["misc"])
        return misc_config
