from jsonschema import validate
import copy

from infra.rtc_sla_tentacles.backend.lib.config.base_config import BaseConfig


class NannyConfig(BaseConfig):

    def _resolve_secret_values_from_stubs(self):
        self._config["nanny_oauth_token"] = self._secrets_config.get_secret(
            self._config["nanny_oauth_token_secret_name"])
        del self._config["nanny_oauth_token_secret_name"]

    def _validate_and_return_part_of_full_config(self, full_config):

        schema = {
            "type": "object",
            "properties": {
                "nanny": {
                    "type": "object",
                    "properties": {
                        "nanny_oauth_token_secret_name": {
                            "type": "string",
                            "pattern": self._secret_name_re,
                            "title": "ENV variable name with token value",
                        },
                    },
                    "required": ["nanny_oauth_token_secret_name"],
                },
            }
        }

        validate(full_config, schema)
        return copy.deepcopy(full_config["nanny"])
