import copy

from jsonschema import validate

from infra.rtc_sla_tentacles.backend.lib.config.base_config import BaseConfig


class WorkerConfig(BaseConfig):
    """
    Holds worker config.
    """

    def _resolve_secret_values_from_stubs(self):
        # No secret values to resolve.
        pass

    def _validate_and_return_part_of_full_config(self, full_config):
        worker_config_schema = {
            "type": "object",
            "properties": {
                "worker": {"$ref": "#/definitions/worker_schema"},
            },
            "required": ["worker"],
            "definitions": {
                "worker_schema": {
                    "type": "object",
                    "properties": {
                        "http": {
                            "type": "object",
                            "properties": {
                                "port": {
                                    "type": "integer",
                                    "minimum": 1,
                                },
                            },
                            "required": ["port"],
                        },
                        "debug": {
                            "type": "object",
                            "properties": {
                                "sock_path": {
                                    "type": ["string", "null"],
                                },
                            },
                            "required": ["sock_path"],
                        },
                    },
                    "required": ["http", "debug"],
                },
            },
        }
        validate(full_config, worker_config_schema)

        worker_config = copy.deepcopy(full_config["worker"])
        return worker_config
