from jsonschema import validate
import copy

from infra.rtc_sla_tentacles.backend.lib.config.base_config import BaseConfig


class YpConfig(BaseConfig):

    def _resolve_secret_values_from_stubs(self):
        self._config["yp_token"] = self._secrets_config.get_secret(self._config["yp_token_secret_name"])
        del self._config["yp_token_secret_name"]

    def _validate_and_return_part_of_full_config(self, full_config):

        schema = {
            "type": "object",
            "properties": {
                "yp": {
                    "type": "object",
                    "properties": {
                        "yp_token_secret_name": {
                            "type": "string",
                            "pattern": self._secret_name_re,
                            "title": "ENV variable name with token value",
                        },
                        "masters": {
                            "type": "object",
                            "minProperties": 1,
                            "additionalProperties": {
                                "type": "string",
                                "minLength": 1,
                                "title": "YP master url",
                                "description": "Mapping from cluster name to YP master",
                                "examples": ["man-pre.yp.yandex.net:8090"],
                            },
                        },
                    },
                    "required": ["yp_token_secret_name", "masters"],
                },
            }
        }

        validate(full_config, schema)
        return copy.deepcopy(full_config["yp"])
