from jsonschema import validate
import copy

from infra.rtc_sla_tentacles.backend.lib.config.base_config import BaseConfig


class YpLitePodsManagerConfig(BaseConfig):

    def _resolve_secret_values_from_stubs(self):
        pass

    def _validate_and_return_part_of_full_config(self, full_config):

        schema = {
            "type": "object",
            "properties": {
                "yp_lite_pods_manager": {
                    "type": "object",
                    "properties": {
                        "clickhouse": {
                            "type": "object",
                            "properties": {
                                "connection": {
                                    "type": "string",
                                    "minLength": 1,
                                },
                                "credentials": {
                                    "type": "string",
                                    "minLength": 1,
                                },
                            },
                            "required": ["connection", "credentials"],
                        },
                        "new_pods_allocation_batch_size": {
                            "type": "integer",
                            "title": "Allocate no more than X pods at once",
                            "minimum": 1,
                        },
                        "pods_without_nodes_removal_batch_size": {
                            "type": "integer",
                            "title": "Remove no more than X pods at once",
                            "minimum": 1,
                        },
                    },
                    "required": [
                        "clickhouse",
                        "new_pods_allocation_batch_size",
                        "pods_without_nodes_removal_batch_size"
                    ],
                },
            }
        }

        validate(full_config, schema)
        return copy.deepcopy(full_config["yp_lite_pods_manager"])
