import typing

from infra.rtc_sla_tentacles.backend.lib.clickhouse.client import ClickhouseClient
from infra.rtc_sla_tentacles.backend.lib.clickhouse import database
from infra.rtc_sla_tentacles.backend.lib.harvesters.base import Harvester


class ClickhouseDropper(Harvester):
    harvester_type = "clickhouse_dropper"

    def _make_client(self):
        clickhouse_params = self.config_interface.get_api_config()["clickhouse_parameters"]
        self.database = clickhouse_params["database"]
        return ClickhouseClient(self.config_interface, leader_only=True)

    def extract(self, ts: int) -> typing.Any:
        client = self._make_client()
        result = {}
        for table_class in database.ROTATING_TABLES:
            table_name = table_class.table_name()
            query = (
                f"SELECT DISTINCT partition FROM system.parts "
                f"WHERE table = '{table_name}' AND (max_time < toDateTime({ts - table_class.history_depth}))"
            )
            partitions = [line.strip("\\'")
                          for line in client.raw(query).split('\n')
                          if line]
            for p in partitions:
                client.raw("ALTER TABLE {tbl} DROP PARTITION {part}".format(tbl=table_name, part=p))
            result[table_name] = len(partitions)
        return {"dropped": result}
