import typing

from infra.rtc_sla_tentacles.backend.lib.harvesters.base import Harvester


class DummyHarvester(Harvester):
    secrets_map = {
        "DUMMY_LOCALHOST_TOKEN": None,
    }
    harvester_type = "dummy"

    def extract(self, ts: int) -> typing.Any:
        return [1, 2, 3, self.name, str(self.common_parameters), str(self.arguments)]

    def transform(self, ts: int, raw_data: typing.Any) -> typing.Tuple[typing.Any, typing.Any]:
        data = {"values_dummy": raw_data}
        meta = {"length": len(raw_data)}
        return meta, data
