import requests

from infra.rtc_sla_tentacles.backend.lib.harvesters.base import Harvester
from infra.rtc_sla_tentacles.backend.lib.util import requests_retry_session


MASTER_GROUPS = {
    "man": "MAN_RUNTIME",
    "vla": "VLA_RUNTIME",
    "sas": "SAS_RUNTIME",
    "msk": "MSK_RUNTIME",
}


class GencfgError(Exception):
    """Can't fetch gencfg group content"""


class GencfgHarvester(Harvester):
    harvester_type = "gencfg"

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._session = requests_retry_session()

    def extract(self, ts: int):
        nanny_service_id = self.name
        master_group = self.config_interface.tentacles_groups_config.get_option(nanny_service_id, "gencfg_master_group")
        response = self._session.get(f'http://api.gencfg.yandex-team.ru/trunk/groups/{master_group}', timeout=60)
        try:
            response.raise_for_status()
        except requests.exceptions.HTTPError:
            raise GencfgError(f"Can't fetch gencfg group {master_group}")
        try:
            answer = response.json()
        except ValueError:
            raise GencfgError(f"Can't parse gencfg response for {master_group}")
        if not answer["hosts"]:
            raise GencfgError(f"Empty gencfg group {master_group}")
        return answer["hosts"]
