import typing
from urllib.parse import urljoin

from nanny_rpc_client import RequestsRpcClient
from infra.rtc_sla_tentacles.backend.lib.harvesters.base import Harvester
from yp_proto.yp.client.hq.proto import hq_pb2
from infra.nanny2.stubs.python import hq_stub

from infra.rtc_sla_tentacles.backend.lib.funccall_stats_server import server as stat_server


class HarvesterHQ(Harvester):
    harvester_type = "hq"

    def transform(self, ts: int, data) -> typing.Tuple[typing.Any, typing.Any]:
        result: typing.Dict[str, typing.List[dict]] = {
            "values": []
        }
        meta = {
            "length": 0
        }
        for instance in data:
            item: typing.Dict[str, typing.Dict[str, typing.Any]] = {
                "meta": {
                    "id": instance.meta.id
                },
                "spec": {
                    "hostname": instance.spec.hostname,
                    "node_name": instance.spec.node_name
                },
            }
            result["values"].append(item)
        meta["length"] = len(result["values"])
        return meta, result

    def extract(self, ts: int) -> typing.Any:
        allocation_zone_config = self.config_interface.get_allocation_zone_config(self.name)
        hq_api_url = urljoin(self.common_parameters["hq_located_api"][allocation_zone_config["location"]],
                             self.common_parameters["instances_url_prefix"])
        client = RequestsRpcClient(hq_api_url, request_timeout=30)
        hq_client = hq_stub.InstanceServiceStub(client)
        request_params = hq_pb2.FindInstancesRequest(
            filter=hq_pb2.InstanceFilter(
                service_id=self.name,
                ready_only=False
            ),
        )
        request_params.field_mask.paths.extend([
            'spec.node_name',
            'spec.hostname',
        ])
        with stat_server.nanny_timing():
            return hq_client.find_instances(request_params).instance
