import collections

from infra.rtc_sla_tentacles.backend.lib.clickhouse.client import ClickhouseClient
from infra.rtc_sla_tentacles.backend.lib.harvesters.base import Harvester
from infra.rtc_sla_tentacles.backend.lib.missing_nodes import missing_nodes


class MissingNodesMonitoring(Harvester):
    harvester_type = "missing_nodes_monitoring"

    def extract(self, ts: int):
        client = ClickhouseClient(self.config_interface)
        yasm_missing_nodes_metrics = []
        total_count = 0
        per_location = collections.defaultdict(int)
        per_project = collections.defaultdict(int)
        query = missing_nodes.get_overview_query(
            input_ts=None,
            columns=["location_short_datacenter_name", "project"],
        )
        for row in client.select(query):
            count = row.count
            total_count += count
            per_location[row.location_short_datacenter_name] += count
            per_project[row.project] += count
        yasm_missing_nodes_metrics.append(("total_missing_nodes_axxx", total_count))
        for location, location_count in per_location.items():
            yasm_missing_nodes_metrics.append((f"per_location_{location}_missing_nodes_axxx", location_count))
        for project, project_count in per_project.items():
            yasm_missing_nodes_metrics.append((f"per_project_{project}_missing_nodes_axxx", project_count))
        return {"yasm_missing_nodes_metrics": yasm_missing_nodes_metrics}
