from infra.rtc_sla_tentacles.backend.lib.harvesters.base import Harvester
from infra.rtc_sla_tentacles.backend.lib.yp_lite.pods_manager import YpLitePodsManager


class YpLitePodCountTuner(Harvester):
    """
    Adjust pods count to the count of alive nodes in cluster.
    """
    harvester_type = "yp_lite_pod_count_tuner"

    _instance_config_schema = {
        "properties": {
            "restrict_nodes_to_specified_in_podset": {
                "type": "boolean",
                "title": "(Optional) Narrow YP nodes to nodes specified in podset's '/spec/node_filter'",
            }
        },
    }

    def extract(self, ts: int):
        """
        Allocate or deallocate pods in service to adjust to cluster size
        """
        # noinspection PyProtectedMember
        nanny_service_name = self.name
        yp_cluster = self.config_interface.tentacles_groups_config.get_option(nanny_service_name, "yp_cluster")
        restrict_nodes_to_specified_in_podset = self.config_interface.tentacles_groups_config.get_option(
            nanny_service_name, "restrict_nodes_to_specified_in_podset")
        with YpLitePodsManager(nanny_service_name=nanny_service_name,
                               yp_cluster=yp_cluster,
                               logger=self.logger,
                               restrict_nodes_to_specified_in_podset=restrict_nodes_to_specified_in_podset,
                               config_interface=self.config_interface,
                               init_clickhouse_client=True,
                               init_nanny_podsets_service_stub=True,
                               init_yp_client=True,
                               ) as pods_manager:
            pods_manager.load_pods_from_clickhouse(ts_to_wait_for=ts)
            pods_manager.update_pods()
