import typing

from infra.rtc_sla_tentacles.backend.lib.harvesters.base import Harvester
from infra.rtc_sla_tentacles.backend.lib.yp_lite.pods_manager import YpLitePodsManager


class YpLitePodsTracker(Harvester):
    harvester_type = 'yp_lite_pods_tracker'

    _instance_config_schema = {
        "properties": {
            "restrict_nodes_to_specified_in_podset": {
                "type": "boolean",
                "title": "(Optional) Narrow YP nodes to nodes specified in podset's '/spec/node_filter'",
            }
        },
    }

    def extract(self, ts: int) -> typing.Dict[str, int]:
        # noinspection PyProtectedMember
        nanny_service_name = self.name
        yp_cluster = self.config_interface.tentacles_groups_config.get_option(nanny_service_name, "yp_cluster")
        restrict_nodes_to_specified_in_podset = self.config_interface.tentacles_groups_config.get_option(
            nanny_service_name, "restrict_nodes_to_specified_in_podset")
        with YpLitePodsManager(nanny_service_name=nanny_service_name,
                               yp_cluster=yp_cluster,
                               logger=self.logger,
                               restrict_nodes_to_specified_in_podset=restrict_nodes_to_specified_in_podset,
                               config_interface=self.config_interface,
                               init_yp_client=True,
                               init_clickhouse_client=True,
                               init_nanny_service_repo_client=True) as pods_manager:
            pods_manager.load_data_from_api()
            pods_manager.write_pods_to_clickhouse(ts=ts)
            return pods_manager.get_stats()

    def transform(self, ts: int, raw_data: typing.Dict[str, int]) -> typing.Tuple[dict, dict]:
        meta = {
            "success": True,
            "stats": raw_data
        }
        return meta, {}
