import dataclasses
import typing


@dataclasses.dataclass
class HarvesterSnapshotLabel:
    """
        This structure used to identify unique harvesters' results
        snapshots in database, and unify this data in code.
          - timestamp of a run, unix timestamp
          - harvester type name, for example "dummy"
          - harvester name, for example "dummy_foo".
    """
    ts: int
    harvester_type: str
    harvester_name: str
    chunk_size: int = 0
    data_list_path: str = None


@dataclasses.dataclass
class HarvesterSnapshot:
    """
        This structure holds harvesters' results data:
          - label to lookup for it in database
          - debug_info, which holds harvester's extract and transform
            start and end times
          - meta information about the data received
          - data received
    """
    label: HarvesterSnapshotLabel
    debug_info: typing.Dict
    meta: typing.Optional[dict]
    data: typing.Optional[typing.Any]
