import typing
import http.client

from juggler_sdk import Check, FlapOptions

from infra.rtc_sla_tentacles.backend.lib.juggler_checks_manager.config import BACKEND_JUGGLER_NAMESPACE, \
    STAGE_CONFIG
from infra.rtc_sla_tentacles.backend.lib.juggler_checks_manager.util import get_juggler_children


def get_all_backends_ping_checks(stage: str) -> typing.List[Check]:
    result = []
    stage_params = STAGE_CONFIG[stage]
    for backend_itype in stage_params["backend_common_checks"]:
        result.append(_get_backend_ping_check(stage=stage, backend_itype=backend_itype))
    return result


def _get_backend_ping_check(stage: str, backend_itype: str) -> Check:
    stage_params = STAGE_CONFIG[stage]

    namespace = BACKEND_JUGGLER_NAMESPACE
    host = stage_params["backend_common_checks"][backend_itype]["juggler_hostname"]
    service = stage_params["backend_common_checks"][backend_itype]["juggler_ping_servicename"]
    tags = stage_params["backend_common_checks"][backend_itype]["tags"]
    children = get_juggler_children(
        children=stage_params["backend_common_checks"][backend_itype]["children"],
        juggler_service_name=service)
    aggregator = "logic_or"
    refresh_time = 30
    ttl = 600
    active = "http"
    active_kwargs = {
        "path": "/ping",
        "ok_codes": [http.client.OK],
        "always_show_body": False
    }
    flap_options = FlapOptions(stable=600, critical=1800)
    description = "Tentacles backend 'ping' check"
    mark = stage_params["checks_sets_marks"]["common"]

    result = Check(
        namespace=namespace,
        host=host,
        service=service,
        tags=tags,
        children=children,
        aggregator=aggregator,
        refresh_time=refresh_time,
        ttl=ttl,
        active=active,
        active_kwargs=active_kwargs,
        flaps_config=flap_options,
        description=description,
        mark=mark
    )
    return result
