JUGGLER_API_URL: str = "http://juggler-api.search.yandex.net"
BACKEND_JUGGLER_NAMESPACE: str = "tentacles"
TENTACLES_CONTAINERS_JUGGLER_NAMESPACE: str = "tentacles_containers"
TENTACLES_VAULT_SECRET_UUID: str = "sec-01d9yhg4qvp0neks1ajbp4zfht"

TENTACLES_ABC_SERVICE = "rtcslatentacles"

WORKER_ITYPE = "tentacles-worker"
API_ITYPE = "tentacles-api"

CHAT_NOTIFICATION_TAG = "chat_notification"

STAGE_CONFIG: dict = {
    "testing": {
        "backend_common_checks": {
            "api": {
                "juggler_hostname": "tentacles_backend_api_testing",
                "juggler_ping_servicename": "ping",
                "children": [
                    {
                        "group_type": "NANNY",
                        "group": "tentacles_backend_api_testing"
                    }
                ],
                "tags": ["backend", "api", "testing", CHAT_NOTIFICATION_TAG]
            },
            "worker": {
                "juggler_hostname": "tentacles_backend_worker_testing",
                "juggler_ping_servicename": "ping",
                "children": [
                    {
                        "group_type": "NANNY",
                        "group": "tentacles_backend_worker_testing"
                    }
                ],
                "tags": ["backend", "worker", "testing", CHAT_NOTIFICATION_TAG]
            }
        },
        "api_slo_checks": {
            "slo_web_interface_url": "https://tentacles-testing.yandex-team.ru/slo",
        },
        "checks_sets_marks": {
            "common": "common_tentacles_managed_checks_testing",
            "harvesters_snapshots_freshness": "harvesters_snapshots_freshness_tentacles_managed_checks_testing",
            "slo": "slo_tentacles_managed_checks_testing",
            "tentacles_containers": "tentacles_containers_managed_checks_testing",
        },
        "tentacles_containers_checks": {
            # Specific tag name not to clash with backend-related checks marked with "testing" tag.
            "tags": ["tentacles_containers_testing"],
            "checks": {
                "rtc_sla_tentacles_testing": {  # Used as Juggler check `hostname`.
                    "children": [
                        {
                            "group_type": "NANNY",
                            "group": "rtc_sla_tentacles_testing_sas"
                        },
                        {
                            "group_type": "NANNY",
                            "group": "rtc_sla_tentacles_testing_man"
                        },
                        {
                            "group_type": "NANNY",
                            "group": "rtc_sla_tentacles_testing_vla"
                        },
                        {
                            "group_type": "NANNY",
                            "group": "rtc_sla_tentacles_testing_msk_myt"
                        }
                    ],
                    "flap_options_stable_time": 240,
                }
            }
        }
    },

    "production": {
        "backend_common_checks": {
            "api": {
                "juggler_hostname": "tentacles_backend_api_production",
                "juggler_ping_servicename": "ping",
                "children": [
                    {
                        "group_type": "NANNY",
                        "group": "tentacles_backend_api_production"
                    }
                ],
                "tags": ["backend", "api", "production", CHAT_NOTIFICATION_TAG]
            },
            "worker": {
                "juggler_hostname": "tentacles_backend_worker_production",
                "juggler_ping_servicename": "ping",
                "children": [
                    {
                        "group_type": "NANNY",
                        "group": "tentacles_backend_worker_production"
                    }
                ],
                "tags": ["backend", "worker", "production", CHAT_NOTIFICATION_TAG]
            }
        },
        "api_slo_checks": {
            "slo_web_interface_url": "https://tentacles.yandex-team.ru/slo",
        },
        "checks_sets_marks": {
            "common": "common_tentacles_managed_checks_production",
            "harvesters_snapshots_freshness": "harvesters_snapshots_freshness_tentacles_managed_checks_production",
            "slo": "slo_tentacles_managed_checks_production",
            "tentacles_containers": "tentacles_containers_managed_checks_production",
        },
        "tentacles_containers_checks": {
            # Specific tag name not to clash with backend-related checks marked with "production" tag.
            "tags": ["tentacles_containers_production"],
            "checks": {
                "rtc_sla_tentacles_production_sas": {
                    "children": [
                        {
                            "group_type": "NANNY",
                            "group": "rtc_sla_tentacles_production_sas"
                        }
                    ],
                    "flap_options_stable_time": 240,
                },
                "rtc_sla_tentacles_production_man": {
                    "children": [
                        {
                            "group_type": "NANNY",
                            "group": "rtc_sla_tentacles_production_man"
                        }
                    ],
                    "flap_options_stable_time": 240,
                },
                "rtc_sla_tentacles_production_vla": {
                    "children": [
                        {
                            "group_type": "NANNY",
                            "group": "rtc_sla_tentacles_production_vla"
                        }
                    ],
                    "flap_options_stable_time": 240,
                },
                "rtc_sla_tentacles_production_msk": {
                    "children": [
                        {
                            "group_type": "NANNY",
                            "group": "rtc_sla_tentacles_production_msk"
                        }
                    ],
                    "flap_options_stable_time": 240,
                },
                "yp_rtc_sla_tentacles_production_sas": {
                    "children": [
                        {
                            "group_type": "YP_PODSET",
                            "group": "yp-rtc-sla-tentacles-production-sas@cluster=sas"
                        }
                    ],
                    "flap_options_stable_time": 300,
                },
                "yp_rtc_sla_tentacles_production_man": {
                    "children": [
                        {
                            "group_type": "YP_PODSET",
                            "group": "yp-rtc-sla-tentacles-production-man@cluster=man"
                        }
                    ],
                    "flap_options_stable_time": 240,
                },
                "yp_rtc_sla_tentacles_production_vla": {
                    "children": [
                        {
                            "group_type": "YP_PODSET",
                            "group": "yp-rtc-sla-tentacles-production-vla@cluster=vla"
                        }
                    ],
                    "flap_options_stable_time": 300,
                },
                "yp_rtc_sla_tentacles_production_man_pre": {
                    "children": [
                        {
                            "group_type": "YP_PODSET",
                            "group": "yp-rtc-sla-tentacles-production-man-pre@cluster=man-pre"
                        }
                    ],
                    "flap_options_stable_time": 300,
                },
                "yp_daemonset_sas_test_rtc_sla_tentacles_production": {
                    "children": [
                        {
                            "group_type": "YP_PODSET",
                            "group": "yp-daemonset-sas-test-rtc-sla-tentacles-production@cluster=sas-test"
                        }
                    ],
                    "flap_options_stable_time": 300,
                },
                "yp_daemonset_man_pre_rtc_sla_tentacles_production": {
                    "children": [
                        {
                            "group_type": "YP_PODSET",
                            "group": "yp-daemonset-man-pre-rtc-sla-tentacles-production@cluster=man-pre"
                        }
                    ],
                    "flap_options_stable_time": 300,
                },
                "yp_daemonset_sas_rtc_sla_tentacles_production": {
                    "children": [
                        {
                            "group_type": "YP_PODSET",
                            "group": "yp-daemonset-sas-rtc-sla-tentacles-production@cluster=sas"
                        }
                    ],
                    "flap_options_stable_time": 300,
                },
                "yp_daemonset_man_rtc_sla_tentacles_production": {
                    "children": [
                        {
                            "group_type": "YP_PODSET",
                            "group": "yp-daemonset-man-rtc-sla-tentacles-production@cluster=man"
                        }
                    ],
                    "flap_options_stable_time": 300,
                },
                "yp_daemonset_iva_rtc_sla_tentacles_production": {
                    "children": [
                        {
                            "group_type": "YP_PODSET",
                            "group": "yp-daemonset-iva-rtc-sla-tentacles-production@cluster=iva"
                        }
                    ],
                    "flap_options_stable_time": 300,
                },
                "yp_daemonset_myt_rtc_sla_tentacles_production": {
                    "children": [
                        {
                            "group_type": "YP_PODSET",
                            "group": "yp-daemonset-myt-rtc-sla-tentacles-production@cluster=myt"
                        }
                    ],
                    "flap_options_stable_time": 300,
                },
                "yp_daemonset_vla_rtc_sla_tentacles_production": {
                    "children": [
                        {
                            "group_type": "YP_PODSET",
                            "group": "yp-daemonset-vla-rtc-sla-tentacles-production@cluster=vla"
                        }
                    ],
                    "flap_options_stable_time": 300,
                },
                "yp_daemonset_xdc_rtc_sla_tentacles_production": {
                    "children": [
                        {
                            "group_type": "YP_PODSET",
                            "group": "yp-daemonset-xdc-rtc-sla-tentacles-production@cluster=xdc"
                        }
                    ],
                    "flap_options_stable_time": 300,
                },
            }
        }
    }

}
