import typing

from infra.rtc_sla_tentacles.backend.lib.juggler_checks_manager import common_checks, \
    harvesters_snapshots_freshness_checks, slo_checks, tentacles_checks


class JugglerChecksFactory:
    def __init__(self,
                 file_config: dict):
        self._file_config = file_config

    def get_checks(self, stage: str, checks_group: str) -> typing.Iterator:
        if checks_group == "common":
            return self._get_common_checks(stage)
        elif checks_group == "harvesters_snapshots_freshness":
            return self._get_harvesters_snapshots_freshness_checks(stage, self._file_config)
        elif checks_group == "slo":
            return self._get_slo_checks(stage, self._file_config)
        elif checks_group == "tentacles_containers":
            return self._get_tentacles_containers_checks(stage)
        else:
            raise ValueError(f"Not supported: stage={stage!r}, checks_group={checks_group!r}")

    @staticmethod
    def _get_common_checks(stage: str) -> typing.Iterator:
        for check in common_checks.get_all_backends_ping_checks(stage=stage):
            yield check

    @staticmethod
    def _get_harvesters_snapshots_freshness_checks(stage: str, file_config: dict) -> typing.Iterator:
        for check in harvesters_snapshots_freshness_checks.get_freshness_checks(stage=stage, file_config=file_config):
            yield check

    @staticmethod
    def _get_slo_checks(stage: str, file_config: dict) -> typing.Iterator:
        yield from slo_checks.get_slo_checks(file_config, stage)

    @staticmethod
    def _get_tentacles_containers_checks(stage: str) -> typing.Iterator:
        for timestamp_age_check in tentacles_checks.get_all_tentacles_timestamp_age_checks(stage=stage):
            yield timestamp_age_check
