import typing
import http.client

from juggler_sdk import Check, FlapOptions
from infra.rtc_sla_tentacles.backend.lib.juggler_checks_manager.config import TENTACLES_CONTAINERS_JUGGLER_NAMESPACE, \
    STAGE_CONFIG
from infra.rtc_sla_tentacles.backend.lib.juggler_checks_manager.util import get_juggler_children


def get_all_tentacles_timestamp_age_checks(stage: str) -> typing.List[Check]:
    result = []
    stage_params = STAGE_CONFIG[stage]
    for juggler_hostname in stage_params["tentacles_containers_checks"]["checks"]:
        result.append(_get_tentacle_timestamp_age_check(stage=stage, juggler_hostname=juggler_hostname))
    return result


def _get_tentacle_timestamp_age_check(stage: str, juggler_hostname: str) -> Check:
    stage_params = STAGE_CONFIG[stage]

    namespace = TENTACLES_CONTAINERS_JUGGLER_NAMESPACE
    host = juggler_hostname
    service = "timestamp-age"
    tags = stage_params["tentacles_containers_checks"]["tags"]
    children = get_juggler_children(children=(stage_params["tentacles_containers_checks"]
                                                          ["checks"]
                                                          [juggler_hostname]
                                                          ["children"]),
                                    juggler_service_name=service)
    aggregator = "logic_and"
    refresh_time = 60
    ttl = 300
    active = "http"
    active_kwargs = {
        "always_show_body": True,
        "fail_threshold": 2,
        "ok_codes": [http.client.OK],
        "path": "/juggler"
    }
    flap_options_stable_time = (stage_params["tentacles_containers_checks"]
                                            ["checks"]
                                            [juggler_hostname]
                                            ["flap_options_stable_time"])
    flap_options = FlapOptions(stable=flap_options_stable_time, critical=flap_options_stable_time*5)
    description = "Tentacles containers 'timestamp-age' check"
    mark = stage_params["checks_sets_marks"]["tentacles_containers"]

    result = Check(
        namespace=namespace,
        host=host,
        service=service,
        tags=tags,
        children=children,
        aggregator=aggregator,
        refresh_time=refresh_time,
        ttl=ttl,
        active=active,
        active_kwargs=active_kwargs,
        flaps_config=flap_options,
        description=description,
        mark=mark
    )
    return result
