import typing

import juggler_sdk

from infra.rtc_sla_tentacles.backend.lib.config.harvesters_config import HarvestersConfig

# TODO: Use TypedDict for `children` when `ya py -3` will be 3.8, https://www.python.org/dev/peps/pep-0589/


def get_juggler_children(children: typing.List[dict],
                         juggler_service_name: typing.AnyStr) -> typing.List[juggler_sdk.Child]:
    return [
        juggler_sdk.Child(host=child["group"],
                          service=juggler_service_name,
                          instance="all",
                          group_type=child["group_type"])
        for child in children
    ]


def get_nanny_service_geo_tags(nanny_service_name: str, file_config: dict) -> typing.List[str]:
    """Reads location from "hq" harvester's config."""
    harvesters_config_dict = HarvestersConfig(full_config=file_config).to_dict()
    dc = None
    for __, hq_harvester_config in harvesters_config_dict["harvesters"]["hq"]["arguments"].items():
        if hq_harvester_config["nanny_service_name"] == nanny_service_name:
            dc = hq_harvester_config["location"]
            break
    if dc is None:
        raise ValueError("Can not find location for Nanny service name %s" % nanny_service_name)
    return [f"a_geo_{dc}"] if dc != "msk" else ["a_geo_myt", "a_geo_iva"]


def add_event_prefix(stage: str, check_name: str) -> str:
    return f"tentacles.{stage}.{check_name}"


def get_allocation_zone_description_part(config_interface, allocation_zone_id):
    return (
        f"\nTentacles https://{config_interface.get_url()}/allocation_zone?name={allocation_zone_id}\n"
        f"Nanny service https://nanny.yandex-team.ru/ui/#/services/catalog/{allocation_zone_id}/\n"
        f"More https://nda.ya.ru/t/hPVD0BCq3YjKY2"
    )
