import dataclasses
import enum


class SloType(str, enum.Enum):
    availability = "availability"
    redeployed_on_time = "redeployed_on_time"
    reallocation = "reallocation"
    unused_nodes = "unused_nodes"
    scheduling_errors = "scheduling_errors"


@dataclasses.dataclass
class ConfiguredCheck:
    allocation_zone_id: str
    host: str
    service: str
    slo_type: SloType
    limit: int
    ttl: int

    def get_force_ok_after_infra_event_interval(self):
        if self.slo_type in {SloType.redeployed_on_time, SloType.reallocation}:
            return 60 * 60
        elif self.slo_type is SloType.availability:
            return 15 * 60
        else:
            return 0
