from infra.rtc_sla_tentacles.backend.lib.clickhouse import database


EXTERNAL_VISIBLE_WALLE_COLUMNS = [
    "state",
    "project",
    "rtc_stage",
    "location_short_datacenter_name",
    "operation_state",
]


def get_overview_query(input_ts, columns):
    if input_ts:
        target_ts = f"'{database.to_clickhouse_datetime(input_ts)}'"
    else:
        target_ts = f"(SELECT MAX(ts) FROM {database.Iteration.table_name()})"
    columns_by_comma = ",".join(columns)

    query = f"""
    SELECT {columns_by_comma}, COUNT() as count
    FROM {database.WalleHost.table_name()}
    WHERE
      ts = {target_ts}
      AND fqdn NOT IN (SELECT DISTINCT fqdn FROM {database.Tentacle.table_name()} WHERE ts = {target_ts})
      AND state NOT IN ('probation', 'free')
      AND operation_state != 'decommissioned'
    GROUP BY {columns_by_comma}
    ORDER BY count DESC
    """
    return query


def _get_walle_filters(params):
    result = {}
    for column_name in EXTERNAL_VISIBLE_WALLE_COLUMNS:
        column_value = params.get(column_name)
        if column_value is not None:
            result[column_name] = column_value
    return result


def get_missing_nodes_query(input_ts, columns, params):
    if input_ts:
        target_ts = f"'{database.to_clickhouse_datetime(input_ts)}'"
    else:
        target_ts = f"(SELECT MAX(ts) FROM {database.Iteration.table_name()})"

    columns_by_comma = ",".join(columns)

    additional_filters = _get_walle_filters(params)
    if additional_filters:
        filters_str = (f"{f_name}='{f_value}'" for f_name, f_value in additional_filters.items())
        additional_filters_str = f"AND {' AND '.join(filters_str)}"
    else:
        additional_filters_str = ""

    query = f"""
    SELECT {columns_by_comma}
    FROM {database.WalleHost.table_name()}
    WHERE
      ts = {target_ts}
      AND fqdn NOT IN (SELECT DISTINCT fqdn FROM {database.Tentacle.table_name()} WHERE ts = {target_ts})
      AND state NOT IN ('probation', 'free')
      AND operation_state != 'decommissioned'
      {additional_filters_str}
    ORDER BY fqdn ASC
    LIMIT {int(params.get("limit", 1000))} OFFSET {int(params.get("offset", 0))}
    """
    return query
