import pymongo


class MongoClient:

    def __init__(self, config_interface):
        self._config_interface = config_interface
        self._client = None
        self.init_client()

    def init_client(self):
        self._client = pymongo.MongoClient(
            socketTimeoutMS=40 * 1000,
            **self._config_interface.get_mongo_url_dict()
        )

    def get_database(self, db_name):
        assert self._client, "MongoClient was not initialized"
        return self._client.get_database(db_name)
