import requests

from infra.rtc_sla_tentacles.backend.lib.util import requests_retry_session


class NannyClient:

    GET_SERVICE_RUNTIME_ATTR_URL_TEMPLATE = "http://nanny.yandex-team.ru/v2/services/{}/runtime_attrs/"

    def __init__(self, nanny_oauth_token):
        session = requests.session()
        session.headers["Content-Type"] = "application/json"
        session.headers["Accept"] = "application/json"
        session.headers["Authorization"] = "OAuth {}".format(nanny_oauth_token)
        self._session = requests_retry_session(session=session)

    def get_change_time(self, allocation_zone_id):
        # TODO(rocco66): one client for this, nanny_state_dumper and pod_manager (???)
        url = self.GET_SERVICE_RUNTIME_ATTR_URL_TEMPLATE.format(allocation_zone_id)
        return self._session.get(url, timeout=15).json()["change_info"]["ctime"] / 1000
