interface AccountsResponse {
    default_uid: string;
    accounts: {
        defaultEmail: string;
        login: string;
        uid: string;
        displayName: {
            default_avatar: string;
            firstname: string;
            lastname: string;
            name: string;
        };
    }[];
}

export const fetchAccounts = async () => {
    const response = await fetch('https://api.passport.yandex-team.ru/accounts', {credentials: 'include'});
    const result = await response.json();

    if (!result.default_uid) {
        return;
    }

    return result as AccountsResponse;
};
