import {NTentaclesApi} from './stubs/tentacles';
import {API} from './constants';

const {TCreateIncidentRequest: Request} = NTentaclesApi;
const {TCreateIncidentResponse: Response} = NTentaclesApi;

export async function createIncident(requestData: NTentaclesApi.ITCreateIncidentRequest, init?: RequestInit) {
    const request = Request.create(requestData);
    const response = await fetch(API + '/incidents/create', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(request.toJSON()),
        ...init,
    });

    const data = await response.json();
    const responseData = Response.fromObject(data);

    if (responseData.error) {
        throw new Error(responseData.error);
    }

    return responseData
}
