import {NTentaclesApi} from './stubs/tentacles';
import {API} from './constants';

const {TDeleteIncidentRequest: Request} = NTentaclesApi;
const {TDeleteIncidentResponse: Response} = NTentaclesApi;

export async function deleteIncident(requestData: NTentaclesApi.ITDeleteIncidentRequest, init?: RequestInit) {
    const request = Request.create(requestData);
    const response = await fetch(API + '/incidents/delete', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(request.toJSON()),
        ...init,
    });

    const data = await response.json();
    return Response.fromObject(data);
}
