import {NTentaclesApi} from './stubs/tentacles';
import {API} from './constants';

const {TAllocationZoneDetailsRequest: Request} = NTentaclesApi;
const {TAllocationZoneDetailsResponse: Response} = NTentaclesApi;

export async function fetchAllocationZoneDetails(zoneId: string) {
    const request = Request.create({allocation_zone_id: zoneId});
    const response = await fetch(API + '/data/allocation_zone_details/', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(request.toJSON()),
    });

    const data = await response.json();
    return  Response.fromObject(data);
}
