import {NTentaclesApi} from './stubs/tentacles';
import {API} from './constants';

const {TReadIncidentDataRequest: Request} = NTentaclesApi;
const {TReadIncidentDataResponse: Response} = NTentaclesApi;

export async function fetchIncidentData(requestData: NTentaclesApi.ITReadIncidentDataRequest, init?: RequestInit) {
    const request = Request.create(requestData);
    const response = await fetch(API + '/incidents/read_data', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(request.toJSON()),
        ...init,
    });

    const data = await response.json();
    return Response.fromObject(data);
}
