import {NTentaclesApi} from './stubs/tentacles';
import {API} from './constants';

const {TListIncidentFiltersRequest: Request} = NTentaclesApi;
const {TListIncidentFiltersResponse: Response} = NTentaclesApi;

export async function fetchIncidentFilters(
    requestData: NTentaclesApi.ITListIncidentFiltersRequest,
    init?: RequestInit
) {
    const request = Request.create(requestData);
    const response = await fetch(API + '/incidents/list_filters', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(request.toJSON()),
        ...init,
    });

    const data = await response.json();
    return Response.fromObject(data);
}
