import {NTentaclesApi} from './stubs/tentacles';
import {API} from './constants';

const {TReadIncidentsRequest: Request} = NTentaclesApi;
const {TReadIncidentsResponse: Response} = NTentaclesApi;

export async function fetchIncidents(requestData: NTentaclesApi.ITReadIncidentsRequest, init?: RequestInit) {
    const request = Request.create(requestData);
    const response = await fetch(API + '/incidents/read', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(request.toJSON()),
        ...init,
    });

    const data = await response.json();
    return Response.fromObject(data);
}
