import {API} from './constants';

interface Request {
    limit: number;
    columns: string;

    [key: string]: any;
}

interface Response {
    meta: {ts: number};
    result: {
        columns: string[];
        values: any[][];
    };
}

export async function fetchMissingNodes(request: Request, init?: RequestInit) {
    const response = await fetch(API + '/data/missing_nodes/', {
        method: 'POST',
        body: JSON.stringify(request),
        ...init,
    });

    const data = (await response.json()) as Response;
    return data;
}
