import {NTentaclesApi} from './stubs/tentacles';
import {API} from './constants';
import {NetworkError} from '../NetworkError';

const {TDataOverviewResponse: Response} = NTentaclesApi;

export async function fetchOverview(init?: RequestInit) {
    let response;

    try {
        response = await fetch(API + '/data/overview/', init);
    } catch (e) {
        throw new NetworkError(e.message);
    }

    if (!response.ok) {
        throw new Error(response.statusText || 'Unexpected API error');
    }

    const data = await response.json();
    return Response.fromObject(data);
}
