import {NTentaclesApi} from './stubs/tentacles';
import {API} from './constants';

const {TPodsListRequest: Request} = NTentaclesApi;
const {TPodsListResponse: Response} = NTentaclesApi;

export async function fetchPodsList(requestData: NTentaclesApi.ITPodsListRequest, init?: RequestInit) {
    const request = Request.create(requestData);
    const response = await fetch(API + '/data/pods_list/', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(request.toJSON()),
        ...init,
    });

    const data = await response.json();
    return Response.fromObject(data);
}
