import * as $protobuf from "protobufjs";
/** Namespace NTentaclesApi. */
export namespace NTentaclesApi {

    /** Properties of a TFreshness. */
    interface ITFreshness {

        /** TFreshness walle_ts */
        walle_ts?: (number|null);

        /** TFreshness juggler_ts */
        juggler_ts?: (number|null);

        /** TFreshness hq_ts */
        hq_ts?: (number|null);

        /** TFreshness yp_ts */
        yp_ts?: (number|null);
    }

    /** Represents a TFreshness. */
    class TFreshness implements ITFreshness {

        /**
         * Constructs a new TFreshness.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITFreshness);

        /** TFreshness walle_ts. */
        public walle_ts: number;

        /** TFreshness juggler_ts. */
        public juggler_ts: number;

        /** TFreshness hq_ts. */
        public hq_ts: number;

        /** TFreshness yp_ts. */
        public yp_ts: number;

        /**
         * Creates a new TFreshness instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TFreshness instance
         */
        public static create(properties?: NTentaclesApi.ITFreshness): NTentaclesApi.TFreshness;

        /**
         * Encodes the specified TFreshness message. Does not implicitly {@link NTentaclesApi.TFreshness.verify|verify} messages.
         * @param message TFreshness message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITFreshness, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TFreshness message, length delimited. Does not implicitly {@link NTentaclesApi.TFreshness.verify|verify} messages.
         * @param message TFreshness message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITFreshness, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TFreshness message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TFreshness
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TFreshness;

        /**
         * Decodes a TFreshness message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TFreshness
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TFreshness;

        /**
         * Verifies a TFreshness message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TFreshness message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TFreshness
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TFreshness;

        /**
         * Creates a plain object from a TFreshness message. Also converts values to other types if specified.
         * @param message TFreshness
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TFreshness, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TFreshness to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TSlice. */
    interface ITSlice {

        /** TSlice filter */
        filter?: (NTentaclesApi.EPodFilter|null);

        /** TSlice columns */
        columns?: (string[]|null);
    }

    /** Represents a TSlice. */
    class TSlice implements ITSlice {

        /**
         * Constructs a new TSlice.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITSlice);

        /** TSlice filter. */
        public filter: NTentaclesApi.EPodFilter;

        /** TSlice columns. */
        public columns: string[];

        /**
         * Creates a new TSlice instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TSlice instance
         */
        public static create(properties?: NTentaclesApi.ITSlice): NTentaclesApi.TSlice;

        /**
         * Encodes the specified TSlice message. Does not implicitly {@link NTentaclesApi.TSlice.verify|verify} messages.
         * @param message TSlice message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITSlice, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TSlice message, length delimited. Does not implicitly {@link NTentaclesApi.TSlice.verify|verify} messages.
         * @param message TSlice message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITSlice, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TSlice message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TSlice
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TSlice;

        /**
         * Decodes a TSlice message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TSlice
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TSlice;

        /**
         * Verifies a TSlice message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TSlice message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TSlice
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TSlice;

        /**
         * Creates a plain object from a TSlice message. Also converts values to other types if specified.
         * @param message TSlice
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TSlice, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TSlice to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TWallePipelineNode. */
    interface ITWallePipelineNode {

        /** TWallePipelineNode excluded_decommissioned_nodes_count */
        excluded_decommissioned_nodes_count?: (number|null);

        /** TWallePipelineNode excluded_probation_or_free_nodes_count */
        excluded_probation_or_free_nodes_count?: (number|null);

        /** TWallePipelineNode slices */
        slices?: (NTentaclesApi.ITSlice[]|null);
    }

    /** Represents a TWallePipelineNode. */
    class TWallePipelineNode implements ITWallePipelineNode {

        /**
         * Constructs a new TWallePipelineNode.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITWallePipelineNode);

        /** TWallePipelineNode excluded_decommissioned_nodes_count. */
        public excluded_decommissioned_nodes_count: number;

        /** TWallePipelineNode excluded_probation_or_free_nodes_count. */
        public excluded_probation_or_free_nodes_count: number;

        /** TWallePipelineNode slices. */
        public slices: NTentaclesApi.ITSlice[];

        /**
         * Creates a new TWallePipelineNode instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TWallePipelineNode instance
         */
        public static create(properties?: NTentaclesApi.ITWallePipelineNode): NTentaclesApi.TWallePipelineNode;

        /**
         * Encodes the specified TWallePipelineNode message. Does not implicitly {@link NTentaclesApi.TWallePipelineNode.verify|verify} messages.
         * @param message TWallePipelineNode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITWallePipelineNode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TWallePipelineNode message, length delimited. Does not implicitly {@link NTentaclesApi.TWallePipelineNode.verify|verify} messages.
         * @param message TWallePipelineNode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITWallePipelineNode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TWallePipelineNode message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TWallePipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TWallePipelineNode;

        /**
         * Decodes a TWallePipelineNode message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TWallePipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TWallePipelineNode;

        /**
         * Verifies a TWallePipelineNode message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TWallePipelineNode message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TWallePipelineNode
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TWallePipelineNode;

        /**
         * Creates a plain object from a TWallePipelineNode message. Also converts values to other types if specified.
         * @param message TWallePipelineNode
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TWallePipelineNode, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TWallePipelineNode to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TAllocatorPipelineNode. */
    interface ITAllocatorPipelineNode {

        /** TAllocatorPipelineNode total_nodes_count */
        total_nodes_count?: (number|null);

        /** TAllocatorPipelineNode total_pods_count */
        total_pods_count?: (number|null);

        /** TAllocatorPipelineNode pods_scheduling_errors */
        pods_scheduling_errors?: (number|null);

        /** TAllocatorPipelineNode unused_nodes_count */
        unused_nodes_count?: (number|null);

        /** TAllocatorPipelineNode slices */
        slices?: (NTentaclesApi.ITSlice[]|null);
    }

    /** Represents a TAllocatorPipelineNode. */
    class TAllocatorPipelineNode implements ITAllocatorPipelineNode {

        /**
         * Constructs a new TAllocatorPipelineNode.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITAllocatorPipelineNode);

        /** TAllocatorPipelineNode total_nodes_count. */
        public total_nodes_count: number;

        /** TAllocatorPipelineNode total_pods_count. */
        public total_pods_count: number;

        /** TAllocatorPipelineNode pods_scheduling_errors. */
        public pods_scheduling_errors: number;

        /** TAllocatorPipelineNode unused_nodes_count. */
        public unused_nodes_count: number;

        /** TAllocatorPipelineNode slices. */
        public slices: NTentaclesApi.ITSlice[];

        /**
         * Creates a new TAllocatorPipelineNode instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TAllocatorPipelineNode instance
         */
        public static create(properties?: NTentaclesApi.ITAllocatorPipelineNode): NTentaclesApi.TAllocatorPipelineNode;

        /**
         * Encodes the specified TAllocatorPipelineNode message. Does not implicitly {@link NTentaclesApi.TAllocatorPipelineNode.verify|verify} messages.
         * @param message TAllocatorPipelineNode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITAllocatorPipelineNode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TAllocatorPipelineNode message, length delimited. Does not implicitly {@link NTentaclesApi.TAllocatorPipelineNode.verify|verify} messages.
         * @param message TAllocatorPipelineNode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITAllocatorPipelineNode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TAllocatorPipelineNode message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TAllocatorPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TAllocatorPipelineNode;

        /**
         * Decodes a TAllocatorPipelineNode message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TAllocatorPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TAllocatorPipelineNode;

        /**
         * Verifies a TAllocatorPipelineNode message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TAllocatorPipelineNode message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TAllocatorPipelineNode
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TAllocatorPipelineNode;

        /**
         * Creates a plain object from a TAllocatorPipelineNode message. Also converts values to other types if specified.
         * @param message TAllocatorPipelineNode
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TAllocatorPipelineNode, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TAllocatorPipelineNode to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a THqPipelineNode. */
    interface ITHqPipelineNode {

        /** THqPipelineNode total_pods */
        total_pods?: (number|null);

        /** THqPipelineNode slices */
        slices?: (NTentaclesApi.ITSlice[]|null);
    }

    /** Represents a THqPipelineNode. */
    class THqPipelineNode implements ITHqPipelineNode {

        /**
         * Constructs a new THqPipelineNode.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITHqPipelineNode);

        /** THqPipelineNode total_pods. */
        public total_pods: number;

        /** THqPipelineNode slices. */
        public slices: NTentaclesApi.ITSlice[];

        /**
         * Creates a new THqPipelineNode instance using the specified properties.
         * @param [properties] Properties to set
         * @returns THqPipelineNode instance
         */
        public static create(properties?: NTentaclesApi.ITHqPipelineNode): NTentaclesApi.THqPipelineNode;

        /**
         * Encodes the specified THqPipelineNode message. Does not implicitly {@link NTentaclesApi.THqPipelineNode.verify|verify} messages.
         * @param message THqPipelineNode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITHqPipelineNode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified THqPipelineNode message, length delimited. Does not implicitly {@link NTentaclesApi.THqPipelineNode.verify|verify} messages.
         * @param message THqPipelineNode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITHqPipelineNode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a THqPipelineNode message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns THqPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.THqPipelineNode;

        /**
         * Decodes a THqPipelineNode message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns THqPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.THqPipelineNode;

        /**
         * Verifies a THqPipelineNode message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a THqPipelineNode message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns THqPipelineNode
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.THqPipelineNode;

        /**
         * Creates a plain object from a THqPipelineNode message. Also converts values to other types if specified.
         * @param message THqPipelineNode
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.THqPipelineNode, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this THqPipelineNode to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TJugglerPipelineNode. */
    interface ITJugglerPipelineNode {

        /** TJugglerPipelineNode total_pods */
        total_pods?: (number|null);

        /** TJugglerPipelineNode excluded_not_present */
        excluded_not_present?: (number|null);

        /** TJugglerPipelineNode excluded_not_visible */
        excluded_not_visible?: (number|null);

        /** TJugglerPipelineNode slices */
        slices?: (NTentaclesApi.ITSlice[]|null);
    }

    /** Represents a TJugglerPipelineNode. */
    class TJugglerPipelineNode implements ITJugglerPipelineNode {

        /**
         * Constructs a new TJugglerPipelineNode.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITJugglerPipelineNode);

        /** TJugglerPipelineNode total_pods. */
        public total_pods: number;

        /** TJugglerPipelineNode excluded_not_present. */
        public excluded_not_present: number;

        /** TJugglerPipelineNode excluded_not_visible. */
        public excluded_not_visible: number;

        /** TJugglerPipelineNode slices. */
        public slices: NTentaclesApi.ITSlice[];

        /**
         * Creates a new TJugglerPipelineNode instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TJugglerPipelineNode instance
         */
        public static create(properties?: NTentaclesApi.ITJugglerPipelineNode): NTentaclesApi.TJugglerPipelineNode;

        /**
         * Encodes the specified TJugglerPipelineNode message. Does not implicitly {@link NTentaclesApi.TJugglerPipelineNode.verify|verify} messages.
         * @param message TJugglerPipelineNode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITJugglerPipelineNode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TJugglerPipelineNode message, length delimited. Does not implicitly {@link NTentaclesApi.TJugglerPipelineNode.verify|verify} messages.
         * @param message TJugglerPipelineNode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITJugglerPipelineNode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TJugglerPipelineNode message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TJugglerPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TJugglerPipelineNode;

        /**
         * Decodes a TJugglerPipelineNode message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TJugglerPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TJugglerPipelineNode;

        /**
         * Verifies a TJugglerPipelineNode message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TJugglerPipelineNode message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TJugglerPipelineNode
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TJugglerPipelineNode;

        /**
         * Creates a plain object from a TJugglerPipelineNode message. Also converts values to other types if specified.
         * @param message TJugglerPipelineNode
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TJugglerPipelineNode, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TJugglerPipelineNode to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TAvailabilityPipelineNode. */
    interface ITAvailabilityPipelineNode {

        /** TAvailabilityPipelineNode total_count */
        total_count?: (number|null);

        /** TAvailabilityPipelineNode ok_count */
        ok_count?: (number|null);

        /** TAvailabilityPipelineNode excluded_not_reachable */
        excluded_not_reachable?: (number|null);

        /** TAvailabilityPipelineNode slices */
        slices?: (NTentaclesApi.ITSlice[]|null);
    }

    /** Represents a TAvailabilityPipelineNode. */
    class TAvailabilityPipelineNode implements ITAvailabilityPipelineNode {

        /**
         * Constructs a new TAvailabilityPipelineNode.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITAvailabilityPipelineNode);

        /** TAvailabilityPipelineNode total_count. */
        public total_count: number;

        /** TAvailabilityPipelineNode ok_count. */
        public ok_count: number;

        /** TAvailabilityPipelineNode excluded_not_reachable. */
        public excluded_not_reachable: number;

        /** TAvailabilityPipelineNode slices. */
        public slices: NTentaclesApi.ITSlice[];

        /**
         * Creates a new TAvailabilityPipelineNode instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TAvailabilityPipelineNode instance
         */
        public static create(properties?: NTentaclesApi.ITAvailabilityPipelineNode): NTentaclesApi.TAvailabilityPipelineNode;

        /**
         * Encodes the specified TAvailabilityPipelineNode message. Does not implicitly {@link NTentaclesApi.TAvailabilityPipelineNode.verify|verify} messages.
         * @param message TAvailabilityPipelineNode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITAvailabilityPipelineNode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TAvailabilityPipelineNode message, length delimited. Does not implicitly {@link NTentaclesApi.TAvailabilityPipelineNode.verify|verify} messages.
         * @param message TAvailabilityPipelineNode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITAvailabilityPipelineNode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TAvailabilityPipelineNode message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TAvailabilityPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TAvailabilityPipelineNode;

        /**
         * Decodes a TAvailabilityPipelineNode message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TAvailabilityPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TAvailabilityPipelineNode;

        /**
         * Verifies a TAvailabilityPipelineNode message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TAvailabilityPipelineNode message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TAvailabilityPipelineNode
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TAvailabilityPipelineNode;

        /**
         * Creates a plain object from a TAvailabilityPipelineNode message. Also converts values to other types if specified.
         * @param message TAvailabilityPipelineNode
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TAvailabilityPipelineNode, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TAvailabilityPipelineNode to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TRedeploymentPipelineNode. */
    interface ITRedeploymentPipelineNode {

        /** TRedeploymentPipelineNode total_count */
        total_count?: (number|null);

        /** TRedeploymentPipelineNode ok_count */
        ok_count?: (number|null);

        /** TRedeploymentPipelineNode slices */
        slices?: (NTentaclesApi.ITSlice[]|null);
    }

    /** Represents a TRedeploymentPipelineNode. */
    class TRedeploymentPipelineNode implements ITRedeploymentPipelineNode {

        /**
         * Constructs a new TRedeploymentPipelineNode.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITRedeploymentPipelineNode);

        /** TRedeploymentPipelineNode total_count. */
        public total_count: number;

        /** TRedeploymentPipelineNode ok_count. */
        public ok_count: number;

        /** TRedeploymentPipelineNode slices. */
        public slices: NTentaclesApi.ITSlice[];

        /**
         * Creates a new TRedeploymentPipelineNode instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TRedeploymentPipelineNode instance
         */
        public static create(properties?: NTentaclesApi.ITRedeploymentPipelineNode): NTentaclesApi.TRedeploymentPipelineNode;

        /**
         * Encodes the specified TRedeploymentPipelineNode message. Does not implicitly {@link NTentaclesApi.TRedeploymentPipelineNode.verify|verify} messages.
         * @param message TRedeploymentPipelineNode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITRedeploymentPipelineNode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TRedeploymentPipelineNode message, length delimited. Does not implicitly {@link NTentaclesApi.TRedeploymentPipelineNode.verify|verify} messages.
         * @param message TRedeploymentPipelineNode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITRedeploymentPipelineNode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TRedeploymentPipelineNode message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TRedeploymentPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TRedeploymentPipelineNode;

        /**
         * Decodes a TRedeploymentPipelineNode message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TRedeploymentPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TRedeploymentPipelineNode;

        /**
         * Verifies a TRedeploymentPipelineNode message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TRedeploymentPipelineNode message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TRedeploymentPipelineNode
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TRedeploymentPipelineNode;

        /**
         * Creates a plain object from a TRedeploymentPipelineNode message. Also converts values to other types if specified.
         * @param message TRedeploymentPipelineNode
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TRedeploymentPipelineNode, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TRedeploymentPipelineNode to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TPipeline. */
    interface ITPipeline {

        /** TPipeline walle_node */
        walle_node?: (NTentaclesApi.ITWallePipelineNode|null);

        /** TPipeline allocator_node */
        allocator_node?: (NTentaclesApi.ITAllocatorPipelineNode|null);

        /** TPipeline hq_node */
        hq_node?: (NTentaclesApi.ITHqPipelineNode|null);

        /** TPipeline juggler_node */
        juggler_node?: (NTentaclesApi.ITJugglerPipelineNode|null);

        /** TPipeline availability_node */
        availability_node?: (NTentaclesApi.ITAvailabilityPipelineNode|null);

        /** TPipeline redeployment_node */
        redeployment_node?: (NTentaclesApi.ITRedeploymentPipelineNode|null);
    }

    /** Represents a TPipeline. */
    class TPipeline implements ITPipeline {

        /**
         * Constructs a new TPipeline.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITPipeline);

        /** TPipeline walle_node. */
        public walle_node?: (NTentaclesApi.ITWallePipelineNode|null);

        /** TPipeline allocator_node. */
        public allocator_node?: (NTentaclesApi.ITAllocatorPipelineNode|null);

        /** TPipeline hq_node. */
        public hq_node?: (NTentaclesApi.ITHqPipelineNode|null);

        /** TPipeline juggler_node. */
        public juggler_node?: (NTentaclesApi.ITJugglerPipelineNode|null);

        /** TPipeline availability_node. */
        public availability_node?: (NTentaclesApi.ITAvailabilityPipelineNode|null);

        /** TPipeline redeployment_node. */
        public redeployment_node?: (NTentaclesApi.ITRedeploymentPipelineNode|null);

        /**
         * Creates a new TPipeline instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TPipeline instance
         */
        public static create(properties?: NTentaclesApi.ITPipeline): NTentaclesApi.TPipeline;

        /**
         * Encodes the specified TPipeline message. Does not implicitly {@link NTentaclesApi.TPipeline.verify|verify} messages.
         * @param message TPipeline message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITPipeline, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TPipeline message, length delimited. Does not implicitly {@link NTentaclesApi.TPipeline.verify|verify} messages.
         * @param message TPipeline message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITPipeline, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TPipeline message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TPipeline
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TPipeline;

        /**
         * Decodes a TPipeline message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TPipeline
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TPipeline;

        /**
         * Verifies a TPipeline message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TPipeline message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TPipeline
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TPipeline;

        /**
         * Creates a plain object from a TPipeline message. Also converts values to other types if specified.
         * @param message TPipeline
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TPipeline, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TPipeline to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TManageSession. */
    interface ITManageSession {

        /** TManageSession start_ts */
        start_ts?: (number|null);

        /** TManageSession end_ts */
        end_ts?: (number|null);

        /** TManageSession nanny_links */
        nanny_links?: (string[]|null);

        /** TManageSession taskgroups_ids */
        taskgroups_ids?: (string[]|null);

        /** TManageSession snapshot_ids */
        snapshot_ids?: (string[]|null);

        /** TManageSession is_in_progress */
        is_in_progress?: (boolean|null);
    }

    /** Represents a TManageSession. */
    class TManageSession implements ITManageSession {

        /**
         * Constructs a new TManageSession.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITManageSession);

        /** TManageSession start_ts. */
        public start_ts: number;

        /** TManageSession end_ts. */
        public end_ts: number;

        /** TManageSession nanny_links. */
        public nanny_links: string[];

        /** TManageSession taskgroups_ids. */
        public taskgroups_ids: string[];

        /** TManageSession snapshot_ids. */
        public snapshot_ids: string[];

        /** TManageSession is_in_progress. */
        public is_in_progress: boolean;

        /**
         * Creates a new TManageSession instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TManageSession instance
         */
        public static create(properties?: NTentaclesApi.ITManageSession): NTentaclesApi.TManageSession;

        /**
         * Encodes the specified TManageSession message. Does not implicitly {@link NTentaclesApi.TManageSession.verify|verify} messages.
         * @param message TManageSession message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITManageSession, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TManageSession message, length delimited. Does not implicitly {@link NTentaclesApi.TManageSession.verify|verify} messages.
         * @param message TManageSession message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITManageSession, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TManageSession message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TManageSession
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TManageSession;

        /**
         * Decodes a TManageSession message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TManageSession
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TManageSession;

        /**
         * Verifies a TManageSession message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TManageSession message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TManageSession
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TManageSession;

        /**
         * Creates a plain object from a TManageSession message. Also converts values to other types if specified.
         * @param message TManageSession
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TManageSession, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TManageSession to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TManageProcessInfo. */
    interface ITManageProcessInfo {

        /** TManageProcessInfo last_success_process */
        last_success_process?: (NTentaclesApi.ITManageSession|null);

        /** TManageProcessInfo current_process */
        current_process?: (NTentaclesApi.ITManageSession|null);

        /** TManageProcessInfo last_success_end_border_config */
        last_success_end_border_config?: (number|null);

        /** TManageProcessInfo current_length_border_config */
        current_length_border_config?: (number|null);

        /** TManageProcessInfo cooldown_config */
        cooldown_config?: (number|null);

        /** TManageProcessInfo sessions */
        sessions?: (NTentaclesApi.ITManageSession[]|null);
    }

    /** Represents a TManageProcessInfo. */
    class TManageProcessInfo implements ITManageProcessInfo {

        /**
         * Constructs a new TManageProcessInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITManageProcessInfo);

        /** TManageProcessInfo last_success_process. */
        public last_success_process?: (NTentaclesApi.ITManageSession|null);

        /** TManageProcessInfo current_process. */
        public current_process?: (NTentaclesApi.ITManageSession|null);

        /** TManageProcessInfo last_success_end_border_config. */
        public last_success_end_border_config: number;

        /** TManageProcessInfo current_length_border_config. */
        public current_length_border_config: number;

        /** TManageProcessInfo cooldown_config. */
        public cooldown_config: number;

        /** TManageProcessInfo sessions. */
        public sessions: NTentaclesApi.ITManageSession[];

        /**
         * Creates a new TManageProcessInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TManageProcessInfo instance
         */
        public static create(properties?: NTentaclesApi.ITManageProcessInfo): NTentaclesApi.TManageProcessInfo;

        /**
         * Encodes the specified TManageProcessInfo message. Does not implicitly {@link NTentaclesApi.TManageProcessInfo.verify|verify} messages.
         * @param message TManageProcessInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITManageProcessInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TManageProcessInfo message, length delimited. Does not implicitly {@link NTentaclesApi.TManageProcessInfo.verify|verify} messages.
         * @param message TManageProcessInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITManageProcessInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TManageProcessInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TManageProcessInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TManageProcessInfo;

        /**
         * Decodes a TManageProcessInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TManageProcessInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TManageProcessInfo;

        /**
         * Verifies a TManageProcessInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TManageProcessInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TManageProcessInfo
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TManageProcessInfo;

        /**
         * Creates a plain object from a TManageProcessInfo message. Also converts values to other types if specified.
         * @param message TManageProcessInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TManageProcessInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TManageProcessInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TManageProcesses. */
    interface ITManageProcesses {

        /** TManageProcesses redeployment */
        redeployment?: (NTentaclesApi.ITManageProcessInfo|null);

        /** TManageProcesses reallocation */
        reallocation?: (NTentaclesApi.ITManageProcessInfo|null);
    }

    /** Represents a TManageProcesses. */
    class TManageProcesses implements ITManageProcesses {

        /**
         * Constructs a new TManageProcesses.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITManageProcesses);

        /** TManageProcesses redeployment. */
        public redeployment?: (NTentaclesApi.ITManageProcessInfo|null);

        /** TManageProcesses reallocation. */
        public reallocation?: (NTentaclesApi.ITManageProcessInfo|null);

        /**
         * Creates a new TManageProcesses instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TManageProcesses instance
         */
        public static create(properties?: NTentaclesApi.ITManageProcesses): NTentaclesApi.TManageProcesses;

        /**
         * Encodes the specified TManageProcesses message. Does not implicitly {@link NTentaclesApi.TManageProcesses.verify|verify} messages.
         * @param message TManageProcesses message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITManageProcesses, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TManageProcesses message, length delimited. Does not implicitly {@link NTentaclesApi.TManageProcesses.verify|verify} messages.
         * @param message TManageProcesses message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITManageProcesses, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TManageProcesses message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TManageProcesses
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TManageProcesses;

        /**
         * Decodes a TManageProcesses message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TManageProcesses
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TManageProcesses;

        /**
         * Verifies a TManageProcesses message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TManageProcesses message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TManageProcesses
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TManageProcesses;

        /**
         * Creates a plain object from a TManageProcesses message. Also converts values to other types if specified.
         * @param message TManageProcesses
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TManageProcesses, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TManageProcesses to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TAllocationZoneDetailsResult. */
    interface ITAllocationZoneDetailsResult {

        /** TAllocationZoneDetailsResult features */
        features?: (NTentaclesApi.ITAllocationZoneFeatures|null);

        /** TAllocationZoneDetailsResult freshness */
        freshness?: (NTentaclesApi.ITFreshness|null);

        /** TAllocationZoneDetailsResult pipeline */
        pipeline?: (NTentaclesApi.ITPipeline|null);

        /** TAllocationZoneDetailsResult manage_processes */
        manage_processes?: (NTentaclesApi.ITManageProcesses|null);
    }

    /** Represents a TAllocationZoneDetailsResult. */
    class TAllocationZoneDetailsResult implements ITAllocationZoneDetailsResult {

        /**
         * Constructs a new TAllocationZoneDetailsResult.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITAllocationZoneDetailsResult);

        /** TAllocationZoneDetailsResult features. */
        public features?: (NTentaclesApi.ITAllocationZoneFeatures|null);

        /** TAllocationZoneDetailsResult freshness. */
        public freshness?: (NTentaclesApi.ITFreshness|null);

        /** TAllocationZoneDetailsResult pipeline. */
        public pipeline?: (NTentaclesApi.ITPipeline|null);

        /** TAllocationZoneDetailsResult manage_processes. */
        public manage_processes?: (NTentaclesApi.ITManageProcesses|null);

        /**
         * Creates a new TAllocationZoneDetailsResult instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TAllocationZoneDetailsResult instance
         */
        public static create(properties?: NTentaclesApi.ITAllocationZoneDetailsResult): NTentaclesApi.TAllocationZoneDetailsResult;

        /**
         * Encodes the specified TAllocationZoneDetailsResult message. Does not implicitly {@link NTentaclesApi.TAllocationZoneDetailsResult.verify|verify} messages.
         * @param message TAllocationZoneDetailsResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITAllocationZoneDetailsResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TAllocationZoneDetailsResult message, length delimited. Does not implicitly {@link NTentaclesApi.TAllocationZoneDetailsResult.verify|verify} messages.
         * @param message TAllocationZoneDetailsResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITAllocationZoneDetailsResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TAllocationZoneDetailsResult message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TAllocationZoneDetailsResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TAllocationZoneDetailsResult;

        /**
         * Decodes a TAllocationZoneDetailsResult message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TAllocationZoneDetailsResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TAllocationZoneDetailsResult;

        /**
         * Verifies a TAllocationZoneDetailsResult message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TAllocationZoneDetailsResult message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TAllocationZoneDetailsResult
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TAllocationZoneDetailsResult;

        /**
         * Creates a plain object from a TAllocationZoneDetailsResult message. Also converts values to other types if specified.
         * @param message TAllocationZoneDetailsResult
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TAllocationZoneDetailsResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TAllocationZoneDetailsResult to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TAllocationZoneDetailsResponse. */
    interface ITAllocationZoneDetailsResponse {

        /** TAllocationZoneDetailsResponse result */
        result?: (NTentaclesApi.ITAllocationZoneDetailsResult|null);
    }

    /** Represents a TAllocationZoneDetailsResponse. */
    class TAllocationZoneDetailsResponse implements ITAllocationZoneDetailsResponse {

        /**
         * Constructs a new TAllocationZoneDetailsResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITAllocationZoneDetailsResponse);

        /** TAllocationZoneDetailsResponse result. */
        public result?: (NTentaclesApi.ITAllocationZoneDetailsResult|null);

        /**
         * Creates a new TAllocationZoneDetailsResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TAllocationZoneDetailsResponse instance
         */
        public static create(properties?: NTentaclesApi.ITAllocationZoneDetailsResponse): NTentaclesApi.TAllocationZoneDetailsResponse;

        /**
         * Encodes the specified TAllocationZoneDetailsResponse message. Does not implicitly {@link NTentaclesApi.TAllocationZoneDetailsResponse.verify|verify} messages.
         * @param message TAllocationZoneDetailsResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITAllocationZoneDetailsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TAllocationZoneDetailsResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TAllocationZoneDetailsResponse.verify|verify} messages.
         * @param message TAllocationZoneDetailsResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITAllocationZoneDetailsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TAllocationZoneDetailsResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TAllocationZoneDetailsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TAllocationZoneDetailsResponse;

        /**
         * Decodes a TAllocationZoneDetailsResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TAllocationZoneDetailsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TAllocationZoneDetailsResponse;

        /**
         * Verifies a TAllocationZoneDetailsResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TAllocationZoneDetailsResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TAllocationZoneDetailsResponse
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TAllocationZoneDetailsResponse;

        /**
         * Creates a plain object from a TAllocationZoneDetailsResponse message. Also converts values to other types if specified.
         * @param message TAllocationZoneDetailsResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TAllocationZoneDetailsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TAllocationZoneDetailsResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TAllocationZoneDetailsRequest. */
    interface ITAllocationZoneDetailsRequest {

        /** TAllocationZoneDetailsRequest allocation_zone_id */
        allocation_zone_id?: (string|null);
    }

    /** Represents a TAllocationZoneDetailsRequest. */
    class TAllocationZoneDetailsRequest implements ITAllocationZoneDetailsRequest {

        /**
         * Constructs a new TAllocationZoneDetailsRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITAllocationZoneDetailsRequest);

        /** TAllocationZoneDetailsRequest allocation_zone_id. */
        public allocation_zone_id: string;

        /**
         * Creates a new TAllocationZoneDetailsRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TAllocationZoneDetailsRequest instance
         */
        public static create(properties?: NTentaclesApi.ITAllocationZoneDetailsRequest): NTentaclesApi.TAllocationZoneDetailsRequest;

        /**
         * Encodes the specified TAllocationZoneDetailsRequest message. Does not implicitly {@link NTentaclesApi.TAllocationZoneDetailsRequest.verify|verify} messages.
         * @param message TAllocationZoneDetailsRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITAllocationZoneDetailsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TAllocationZoneDetailsRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TAllocationZoneDetailsRequest.verify|verify} messages.
         * @param message TAllocationZoneDetailsRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITAllocationZoneDetailsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TAllocationZoneDetailsRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TAllocationZoneDetailsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TAllocationZoneDetailsRequest;

        /**
         * Decodes a TAllocationZoneDetailsRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TAllocationZoneDetailsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TAllocationZoneDetailsRequest;

        /**
         * Verifies a TAllocationZoneDetailsRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TAllocationZoneDetailsRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TAllocationZoneDetailsRequest
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TAllocationZoneDetailsRequest;

        /**
         * Creates a plain object from a TAllocationZoneDetailsRequest message. Also converts values to other types if specified.
         * @param message TAllocationZoneDetailsRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TAllocationZoneDetailsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TAllocationZoneDetailsRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** EFeatureStatus enum. */
    enum EFeatureStatus {
        UNKNOWN = 0,
        BROKEN = 1,
        OK = 2
    }

    /** Properties of a TDataFreshnessFeature. */
    interface ITDataFreshnessFeature {

        /** TDataFreshnessFeature status */
        status?: (NTentaclesApi.EFeatureStatus|null);

        /** TDataFreshnessFeature data_timestamp */
        data_timestamp?: (number|null);
    }

    /** Represents a TDataFreshnessFeature. */
    class TDataFreshnessFeature implements ITDataFreshnessFeature {

        /**
         * Constructs a new TDataFreshnessFeature.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITDataFreshnessFeature);

        /** TDataFreshnessFeature status. */
        public status: NTentaclesApi.EFeatureStatus;

        /** TDataFreshnessFeature data_timestamp. */
        public data_timestamp: number;

        /**
         * Creates a new TDataFreshnessFeature instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TDataFreshnessFeature instance
         */
        public static create(properties?: NTentaclesApi.ITDataFreshnessFeature): NTentaclesApi.TDataFreshnessFeature;

        /**
         * Encodes the specified TDataFreshnessFeature message. Does not implicitly {@link NTentaclesApi.TDataFreshnessFeature.verify|verify} messages.
         * @param message TDataFreshnessFeature message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITDataFreshnessFeature, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TDataFreshnessFeature message, length delimited. Does not implicitly {@link NTentaclesApi.TDataFreshnessFeature.verify|verify} messages.
         * @param message TDataFreshnessFeature message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITDataFreshnessFeature, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TDataFreshnessFeature message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TDataFreshnessFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TDataFreshnessFeature;

        /**
         * Decodes a TDataFreshnessFeature message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TDataFreshnessFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TDataFreshnessFeature;

        /**
         * Verifies a TDataFreshnessFeature message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TDataFreshnessFeature message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TDataFreshnessFeature
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TDataFreshnessFeature;

        /**
         * Creates a plain object from a TDataFreshnessFeature message. Also converts values to other types if specified.
         * @param message TDataFreshnessFeature
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TDataFreshnessFeature, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TDataFreshnessFeature to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TAvailabilityFeature. */
    interface ITAvailabilityFeature {

        /** TAvailabilityFeature status */
        status?: (NTentaclesApi.EFeatureStatus|null);

        /** TAvailabilityFeature ok_count */
        ok_count?: (number|null);

        /** TAvailabilityFeature total_count */
        total_count?: (number|null);
    }

    /** Represents a TAvailabilityFeature. */
    class TAvailabilityFeature implements ITAvailabilityFeature {

        /**
         * Constructs a new TAvailabilityFeature.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITAvailabilityFeature);

        /** TAvailabilityFeature status. */
        public status: NTentaclesApi.EFeatureStatus;

        /** TAvailabilityFeature ok_count. */
        public ok_count: number;

        /** TAvailabilityFeature total_count. */
        public total_count: number;

        /**
         * Creates a new TAvailabilityFeature instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TAvailabilityFeature instance
         */
        public static create(properties?: NTentaclesApi.ITAvailabilityFeature): NTentaclesApi.TAvailabilityFeature;

        /**
         * Encodes the specified TAvailabilityFeature message. Does not implicitly {@link NTentaclesApi.TAvailabilityFeature.verify|verify} messages.
         * @param message TAvailabilityFeature message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITAvailabilityFeature, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TAvailabilityFeature message, length delimited. Does not implicitly {@link NTentaclesApi.TAvailabilityFeature.verify|verify} messages.
         * @param message TAvailabilityFeature message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITAvailabilityFeature, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TAvailabilityFeature message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TAvailabilityFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TAvailabilityFeature;

        /**
         * Decodes a TAvailabilityFeature message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TAvailabilityFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TAvailabilityFeature;

        /**
         * Verifies a TAvailabilityFeature message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TAvailabilityFeature message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TAvailabilityFeature
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TAvailabilityFeature;

        /**
         * Creates a plain object from a TAvailabilityFeature message. Also converts values to other types if specified.
         * @param message TAvailabilityFeature
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TAvailabilityFeature, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TAvailabilityFeature to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TRedeployFeature. */
    interface ITRedeployFeature {

        /** TRedeployFeature status */
        status?: (NTentaclesApi.EFeatureStatus|null);

        /** TRedeployFeature ok_count */
        ok_count?: (number|null);

        /** TRedeployFeature total_count */
        total_count?: (number|null);

        /** TRedeployFeature last_success_redeploy_timestamp */
        last_success_redeploy_timestamp?: (number|null);

        /** TRedeployFeature current_redeploy_timestamp */
        current_redeploy_timestamp?: (number|null);
    }

    /** Represents a TRedeployFeature. */
    class TRedeployFeature implements ITRedeployFeature {

        /**
         * Constructs a new TRedeployFeature.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITRedeployFeature);

        /** TRedeployFeature status. */
        public status: NTentaclesApi.EFeatureStatus;

        /** TRedeployFeature ok_count. */
        public ok_count: number;

        /** TRedeployFeature total_count. */
        public total_count: number;

        /** TRedeployFeature last_success_redeploy_timestamp. */
        public last_success_redeploy_timestamp: number;

        /** TRedeployFeature current_redeploy_timestamp. */
        public current_redeploy_timestamp: number;

        /**
         * Creates a new TRedeployFeature instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TRedeployFeature instance
         */
        public static create(properties?: NTentaclesApi.ITRedeployFeature): NTentaclesApi.TRedeployFeature;

        /**
         * Encodes the specified TRedeployFeature message. Does not implicitly {@link NTentaclesApi.TRedeployFeature.verify|verify} messages.
         * @param message TRedeployFeature message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITRedeployFeature, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TRedeployFeature message, length delimited. Does not implicitly {@link NTentaclesApi.TRedeployFeature.verify|verify} messages.
         * @param message TRedeployFeature message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITRedeployFeature, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TRedeployFeature message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TRedeployFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TRedeployFeature;

        /**
         * Decodes a TRedeployFeature message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TRedeployFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TRedeployFeature;

        /**
         * Verifies a TRedeployFeature message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TRedeployFeature message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TRedeployFeature
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TRedeployFeature;

        /**
         * Creates a plain object from a TRedeployFeature message. Also converts values to other types if specified.
         * @param message TRedeployFeature
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TRedeployFeature, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TRedeployFeature to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TReallocationFeature. */
    interface ITReallocationFeature {

        /** TReallocationFeature enable */
        enable?: (boolean|null);

        /** TReallocationFeature status */
        status?: (NTentaclesApi.EFeatureStatus|null);

        /** TReallocationFeature last_success_reallocation_timestamp */
        last_success_reallocation_timestamp?: (number|null);

        /** TReallocationFeature current_reallocation_timestamp */
        current_reallocation_timestamp?: (number|null);
    }

    /** Represents a TReallocationFeature. */
    class TReallocationFeature implements ITReallocationFeature {

        /**
         * Constructs a new TReallocationFeature.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITReallocationFeature);

        /** TReallocationFeature enable. */
        public enable: boolean;

        /** TReallocationFeature status. */
        public status: NTentaclesApi.EFeatureStatus;

        /** TReallocationFeature last_success_reallocation_timestamp. */
        public last_success_reallocation_timestamp: number;

        /** TReallocationFeature current_reallocation_timestamp. */
        public current_reallocation_timestamp: number;

        /**
         * Creates a new TReallocationFeature instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TReallocationFeature instance
         */
        public static create(properties?: NTentaclesApi.ITReallocationFeature): NTentaclesApi.TReallocationFeature;

        /**
         * Encodes the specified TReallocationFeature message. Does not implicitly {@link NTentaclesApi.TReallocationFeature.verify|verify} messages.
         * @param message TReallocationFeature message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITReallocationFeature, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TReallocationFeature message, length delimited. Does not implicitly {@link NTentaclesApi.TReallocationFeature.verify|verify} messages.
         * @param message TReallocationFeature message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITReallocationFeature, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TReallocationFeature message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TReallocationFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TReallocationFeature;

        /**
         * Decodes a TReallocationFeature message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TReallocationFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TReallocationFeature;

        /**
         * Verifies a TReallocationFeature message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TReallocationFeature message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TReallocationFeature
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TReallocationFeature;

        /**
         * Creates a plain object from a TReallocationFeature message. Also converts values to other types if specified.
         * @param message TReallocationFeature
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TReallocationFeature, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TReallocationFeature to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TUnusedNodesFeature. */
    interface ITUnusedNodesFeature {

        /** TUnusedNodesFeature enable */
        enable?: (boolean|null);

        /** TUnusedNodesFeature status */
        status?: (NTentaclesApi.EFeatureStatus|null);

        /** TUnusedNodesFeature unused_count */
        unused_count?: (number|null);

        /** TUnusedNodesFeature total_count */
        total_count?: (number|null);
    }

    /** Represents a TUnusedNodesFeature. */
    class TUnusedNodesFeature implements ITUnusedNodesFeature {

        /**
         * Constructs a new TUnusedNodesFeature.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITUnusedNodesFeature);

        /** TUnusedNodesFeature enable. */
        public enable: boolean;

        /** TUnusedNodesFeature status. */
        public status: NTentaclesApi.EFeatureStatus;

        /** TUnusedNodesFeature unused_count. */
        public unused_count: number;

        /** TUnusedNodesFeature total_count. */
        public total_count: number;

        /**
         * Creates a new TUnusedNodesFeature instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TUnusedNodesFeature instance
         */
        public static create(properties?: NTentaclesApi.ITUnusedNodesFeature): NTentaclesApi.TUnusedNodesFeature;

        /**
         * Encodes the specified TUnusedNodesFeature message. Does not implicitly {@link NTentaclesApi.TUnusedNodesFeature.verify|verify} messages.
         * @param message TUnusedNodesFeature message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITUnusedNodesFeature, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TUnusedNodesFeature message, length delimited. Does not implicitly {@link NTentaclesApi.TUnusedNodesFeature.verify|verify} messages.
         * @param message TUnusedNodesFeature message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITUnusedNodesFeature, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TUnusedNodesFeature message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TUnusedNodesFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TUnusedNodesFeature;

        /**
         * Decodes a TUnusedNodesFeature message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TUnusedNodesFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TUnusedNodesFeature;

        /**
         * Verifies a TUnusedNodesFeature message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TUnusedNodesFeature message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TUnusedNodesFeature
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TUnusedNodesFeature;

        /**
         * Creates a plain object from a TUnusedNodesFeature message. Also converts values to other types if specified.
         * @param message TUnusedNodesFeature
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TUnusedNodesFeature, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TUnusedNodesFeature to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TSchedulingErrorsFeature. */
    interface ITSchedulingErrorsFeature {

        /** TSchedulingErrorsFeature enable */
        enable?: (boolean|null);

        /** TSchedulingErrorsFeature status */
        status?: (NTentaclesApi.EFeatureStatus|null);

        /** TSchedulingErrorsFeature scheduling_errors_on_up_nodes_count */
        scheduling_errors_on_up_nodes_count?: (number|null);

        /** TSchedulingErrorsFeature total_up_nodes_count */
        total_up_nodes_count?: (number|null);
    }

    /** Represents a TSchedulingErrorsFeature. */
    class TSchedulingErrorsFeature implements ITSchedulingErrorsFeature {

        /**
         * Constructs a new TSchedulingErrorsFeature.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITSchedulingErrorsFeature);

        /** TSchedulingErrorsFeature enable. */
        public enable: boolean;

        /** TSchedulingErrorsFeature status. */
        public status: NTentaclesApi.EFeatureStatus;

        /** TSchedulingErrorsFeature scheduling_errors_on_up_nodes_count. */
        public scheduling_errors_on_up_nodes_count: number;

        /** TSchedulingErrorsFeature total_up_nodes_count. */
        public total_up_nodes_count: number;

        /**
         * Creates a new TSchedulingErrorsFeature instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TSchedulingErrorsFeature instance
         */
        public static create(properties?: NTentaclesApi.ITSchedulingErrorsFeature): NTentaclesApi.TSchedulingErrorsFeature;

        /**
         * Encodes the specified TSchedulingErrorsFeature message. Does not implicitly {@link NTentaclesApi.TSchedulingErrorsFeature.verify|verify} messages.
         * @param message TSchedulingErrorsFeature message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITSchedulingErrorsFeature, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TSchedulingErrorsFeature message, length delimited. Does not implicitly {@link NTentaclesApi.TSchedulingErrorsFeature.verify|verify} messages.
         * @param message TSchedulingErrorsFeature message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITSchedulingErrorsFeature, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TSchedulingErrorsFeature message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TSchedulingErrorsFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TSchedulingErrorsFeature;

        /**
         * Decodes a TSchedulingErrorsFeature message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TSchedulingErrorsFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TSchedulingErrorsFeature;

        /**
         * Verifies a TSchedulingErrorsFeature message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TSchedulingErrorsFeature message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TSchedulingErrorsFeature
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TSchedulingErrorsFeature;

        /**
         * Creates a plain object from a TSchedulingErrorsFeature message. Also converts values to other types if specified.
         * @param message TSchedulingErrorsFeature
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TSchedulingErrorsFeature, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TSchedulingErrorsFeature to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TTags. */
    interface ITTags {

        /** TTags location */
        location?: (string|null);

        /** TTags deploy_engine */
        deploy_engine?: (string|null);
    }

    /** Represents a TTags. */
    class TTags implements ITTags {

        /**
         * Constructs a new TTags.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITTags);

        /** TTags location. */
        public location: string;

        /** TTags deploy_engine. */
        public deploy_engine: string;

        /**
         * Creates a new TTags instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TTags instance
         */
        public static create(properties?: NTentaclesApi.ITTags): NTentaclesApi.TTags;

        /**
         * Encodes the specified TTags message. Does not implicitly {@link NTentaclesApi.TTags.verify|verify} messages.
         * @param message TTags message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITTags, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TTags message, length delimited. Does not implicitly {@link NTentaclesApi.TTags.verify|verify} messages.
         * @param message TTags message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITTags, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TTags message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TTags
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TTags;

        /**
         * Decodes a TTags message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TTags
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TTags;

        /**
         * Verifies a TTags message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TTags message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TTags
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TTags;

        /**
         * Creates a plain object from a TTags message. Also converts values to other types if specified.
         * @param message TTags
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TTags, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TTags to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TAllocationZoneFeatures. */
    interface ITAllocationZoneFeatures {

        /** TAllocationZoneFeatures allocation_zone */
        allocation_zone?: (string|null);

        /** TAllocationZoneFeatures data_freshness */
        data_freshness?: (NTentaclesApi.ITDataFreshnessFeature|null);

        /** TAllocationZoneFeatures availability */
        availability?: (NTentaclesApi.ITAvailabilityFeature|null);

        /** TAllocationZoneFeatures redeploy */
        redeploy?: (NTentaclesApi.ITRedeployFeature|null);

        /** TAllocationZoneFeatures reallocation */
        reallocation?: (NTentaclesApi.ITReallocationFeature|null);

        /** TAllocationZoneFeatures unused_nodes */
        unused_nodes?: (NTentaclesApi.ITUnusedNodesFeature|null);

        /** TAllocationZoneFeatures scheduling_errors */
        scheduling_errors?: (NTentaclesApi.ITSchedulingErrorsFeature|null);

        /** TAllocationZoneFeatures tags */
        tags?: (NTentaclesApi.ITTags|null);
    }

    /** Represents a TAllocationZoneFeatures. */
    class TAllocationZoneFeatures implements ITAllocationZoneFeatures {

        /**
         * Constructs a new TAllocationZoneFeatures.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITAllocationZoneFeatures);

        /** TAllocationZoneFeatures allocation_zone. */
        public allocation_zone: string;

        /** TAllocationZoneFeatures data_freshness. */
        public data_freshness?: (NTentaclesApi.ITDataFreshnessFeature|null);

        /** TAllocationZoneFeatures availability. */
        public availability?: (NTentaclesApi.ITAvailabilityFeature|null);

        /** TAllocationZoneFeatures redeploy. */
        public redeploy?: (NTentaclesApi.ITRedeployFeature|null);

        /** TAllocationZoneFeatures reallocation. */
        public reallocation?: (NTentaclesApi.ITReallocationFeature|null);

        /** TAllocationZoneFeatures unused_nodes. */
        public unused_nodes?: (NTentaclesApi.ITUnusedNodesFeature|null);

        /** TAllocationZoneFeatures scheduling_errors. */
        public scheduling_errors?: (NTentaclesApi.ITSchedulingErrorsFeature|null);

        /** TAllocationZoneFeatures tags. */
        public tags?: (NTentaclesApi.ITTags|null);

        /**
         * Creates a new TAllocationZoneFeatures instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TAllocationZoneFeatures instance
         */
        public static create(properties?: NTentaclesApi.ITAllocationZoneFeatures): NTentaclesApi.TAllocationZoneFeatures;

        /**
         * Encodes the specified TAllocationZoneFeatures message. Does not implicitly {@link NTentaclesApi.TAllocationZoneFeatures.verify|verify} messages.
         * @param message TAllocationZoneFeatures message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITAllocationZoneFeatures, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TAllocationZoneFeatures message, length delimited. Does not implicitly {@link NTentaclesApi.TAllocationZoneFeatures.verify|verify} messages.
         * @param message TAllocationZoneFeatures message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITAllocationZoneFeatures, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TAllocationZoneFeatures message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TAllocationZoneFeatures
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TAllocationZoneFeatures;

        /**
         * Decodes a TAllocationZoneFeatures message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TAllocationZoneFeatures
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TAllocationZoneFeatures;

        /**
         * Verifies a TAllocationZoneFeatures message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TAllocationZoneFeatures message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TAllocationZoneFeatures
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TAllocationZoneFeatures;

        /**
         * Creates a plain object from a TAllocationZoneFeatures message. Also converts values to other types if specified.
         * @param message TAllocationZoneFeatures
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TAllocationZoneFeatures, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TAllocationZoneFeatures to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** EPodFilter enum. */
    enum EPodFilter {
        NONE = 0,
        EXCLUDED_DECOMMISSIONED_NODES = 1,
        EXCLUDED_PROBATION_OR_FREE_NODES = 2,
        PODS_SCHEDULING_ERRORS = 3,
        UNUSED_YP_NODES = 4,
        EXCLUDED_NOT_PRESENT = 5,
        EXCLUDED_NOT_VISIBLE = 6,
        EXCLUDED_NOT_REACHABLE = 7
    }

    /** ESloType enum. */
    enum ESloType {
        AVAILABILITY = 0,
        REDEPLOYED_ON_TIME = 1,
        REALLOCATION = 2,
        UNUSED_NODES = 3
    }

    /** Properties of a TIncident. */
    interface ITIncident {

        /** TIncident id */
        id?: (string|null);

        /** TIncident start_time_ts */
        start_time_ts?: (number|null);

        /** TIncident end_time_ts */
        end_time_ts?: (number|null);

        /** TIncident allocation_zone */
        allocation_zone?: (string|null);

        /** TIncident slo_type */
        slo_type?: (NTentaclesApi.ESloType|null);

        /** TIncident assignee */
        assignee?: (string|null);

        /** TIncident minutes_out_of_slo */
        minutes_out_of_slo?: (number|null);

        /** TIncident startrek_ticket_id */
        startrek_ticket_id?: (string|null);
    }

    /** Represents a TIncident. */
    class TIncident implements ITIncident {

        /**
         * Constructs a new TIncident.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITIncident);

        /** TIncident id. */
        public id: string;

        /** TIncident start_time_ts. */
        public start_time_ts: number;

        /** TIncident end_time_ts. */
        public end_time_ts: number;

        /** TIncident allocation_zone. */
        public allocation_zone: string;

        /** TIncident slo_type. */
        public slo_type: NTentaclesApi.ESloType;

        /** TIncident assignee. */
        public assignee: string;

        /** TIncident minutes_out_of_slo. */
        public minutes_out_of_slo: number;

        /** TIncident startrek_ticket_id. */
        public startrek_ticket_id: string;

        /**
         * Creates a new TIncident instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TIncident instance
         */
        public static create(properties?: NTentaclesApi.ITIncident): NTentaclesApi.TIncident;

        /**
         * Encodes the specified TIncident message. Does not implicitly {@link NTentaclesApi.TIncident.verify|verify} messages.
         * @param message TIncident message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITIncident, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TIncident message, length delimited. Does not implicitly {@link NTentaclesApi.TIncident.verify|verify} messages.
         * @param message TIncident message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITIncident, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TIncident message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TIncident
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TIncident;

        /**
         * Decodes a TIncident message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TIncident
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TIncident;

        /**
         * Verifies a TIncident message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TIncident message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TIncident
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TIncident;

        /**
         * Creates a plain object from a TIncident message. Also converts values to other types if specified.
         * @param message TIncident
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TIncident, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TIncident to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TIncidentFilter. */
    interface ITIncidentFilter {

        /** TIncidentFilter started_after_ts */
        started_after_ts?: (number|null);

        /** TIncidentFilter ended_before_ts */
        ended_before_ts?: (number|null);

        /** TIncidentFilter allocation_zones */
        allocation_zones?: (string[]|null);

        /** TIncidentFilter slo_types */
        slo_types?: (NTentaclesApi.ESloType[]|null);

        /** TIncidentFilter assignees */
        assignees?: (string[]|null);

        /** TIncidentFilter startrek_ticket_ids */
        startrek_ticket_ids?: (string[]|null);
    }

    /** Represents a TIncidentFilter. */
    class TIncidentFilter implements ITIncidentFilter {

        /**
         * Constructs a new TIncidentFilter.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITIncidentFilter);

        /** TIncidentFilter started_after_ts. */
        public started_after_ts: number;

        /** TIncidentFilter ended_before_ts. */
        public ended_before_ts: number;

        /** TIncidentFilter allocation_zones. */
        public allocation_zones: string[];

        /** TIncidentFilter slo_types. */
        public slo_types: NTentaclesApi.ESloType[];

        /** TIncidentFilter assignees. */
        public assignees: string[];

        /** TIncidentFilter startrek_ticket_ids. */
        public startrek_ticket_ids: string[];

        /**
         * Creates a new TIncidentFilter instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TIncidentFilter instance
         */
        public static create(properties?: NTentaclesApi.ITIncidentFilter): NTentaclesApi.TIncidentFilter;

        /**
         * Encodes the specified TIncidentFilter message. Does not implicitly {@link NTentaclesApi.TIncidentFilter.verify|verify} messages.
         * @param message TIncidentFilter message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITIncidentFilter, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TIncidentFilter message, length delimited. Does not implicitly {@link NTentaclesApi.TIncidentFilter.verify|verify} messages.
         * @param message TIncidentFilter message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITIncidentFilter, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TIncidentFilter message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TIncidentFilter
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TIncidentFilter;

        /**
         * Decodes a TIncidentFilter message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TIncidentFilter
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TIncidentFilter;

        /**
         * Verifies a TIncidentFilter message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TIncidentFilter message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TIncidentFilter
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TIncidentFilter;

        /**
         * Creates a plain object from a TIncidentFilter message. Also converts values to other types if specified.
         * @param message TIncidentFilter
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TIncidentFilter, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TIncidentFilter to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TIncidentFiltersList. */
    interface ITIncidentFiltersList {

        /** TIncidentFiltersList allocation_zones */
        allocation_zones?: (string[]|null);

        /** TIncidentFiltersList slo_types */
        slo_types?: (NTentaclesApi.ESloType[]|null);

        /** TIncidentFiltersList assignees */
        assignees?: (string[]|null);
    }

    /** Represents a TIncidentFiltersList. */
    class TIncidentFiltersList implements ITIncidentFiltersList {

        /**
         * Constructs a new TIncidentFiltersList.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITIncidentFiltersList);

        /** TIncidentFiltersList allocation_zones. */
        public allocation_zones: string[];

        /** TIncidentFiltersList slo_types. */
        public slo_types: NTentaclesApi.ESloType[];

        /** TIncidentFiltersList assignees. */
        public assignees: string[];

        /**
         * Creates a new TIncidentFiltersList instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TIncidentFiltersList instance
         */
        public static create(properties?: NTentaclesApi.ITIncidentFiltersList): NTentaclesApi.TIncidentFiltersList;

        /**
         * Encodes the specified TIncidentFiltersList message. Does not implicitly {@link NTentaclesApi.TIncidentFiltersList.verify|verify} messages.
         * @param message TIncidentFiltersList message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITIncidentFiltersList, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TIncidentFiltersList message, length delimited. Does not implicitly {@link NTentaclesApi.TIncidentFiltersList.verify|verify} messages.
         * @param message TIncidentFiltersList message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITIncidentFiltersList, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TIncidentFiltersList message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TIncidentFiltersList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TIncidentFiltersList;

        /**
         * Decodes a TIncidentFiltersList message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TIncidentFiltersList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TIncidentFiltersList;

        /**
         * Verifies a TIncidentFiltersList message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TIncidentFiltersList message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TIncidentFiltersList
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TIncidentFiltersList;

        /**
         * Creates a plain object from a TIncidentFiltersList message. Also converts values to other types if specified.
         * @param message TIncidentFiltersList
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TIncidentFiltersList, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TIncidentFiltersList to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TCreateIncidentRequest. */
    interface ITCreateIncidentRequest {

        /** TCreateIncidentRequest data */
        data?: (NTentaclesApi.ITIncident|null);
    }

    /** Represents a TCreateIncidentRequest. */
    class TCreateIncidentRequest implements ITCreateIncidentRequest {

        /**
         * Constructs a new TCreateIncidentRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITCreateIncidentRequest);

        /** TCreateIncidentRequest data. */
        public data?: (NTentaclesApi.ITIncident|null);

        /**
         * Creates a new TCreateIncidentRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TCreateIncidentRequest instance
         */
        public static create(properties?: NTentaclesApi.ITCreateIncidentRequest): NTentaclesApi.TCreateIncidentRequest;

        /**
         * Encodes the specified TCreateIncidentRequest message. Does not implicitly {@link NTentaclesApi.TCreateIncidentRequest.verify|verify} messages.
         * @param message TCreateIncidentRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITCreateIncidentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TCreateIncidentRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TCreateIncidentRequest.verify|verify} messages.
         * @param message TCreateIncidentRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITCreateIncidentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TCreateIncidentRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TCreateIncidentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TCreateIncidentRequest;

        /**
         * Decodes a TCreateIncidentRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TCreateIncidentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TCreateIncidentRequest;

        /**
         * Verifies a TCreateIncidentRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TCreateIncidentRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TCreateIncidentRequest
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TCreateIncidentRequest;

        /**
         * Creates a plain object from a TCreateIncidentRequest message. Also converts values to other types if specified.
         * @param message TCreateIncidentRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TCreateIncidentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TCreateIncidentRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TCreateIncidentResult. */
    interface ITCreateIncidentResult {

        /** TCreateIncidentResult id */
        id?: (string|null);
    }

    /** Represents a TCreateIncidentResult. */
    class TCreateIncidentResult implements ITCreateIncidentResult {

        /**
         * Constructs a new TCreateIncidentResult.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITCreateIncidentResult);

        /** TCreateIncidentResult id. */
        public id: string;

        /**
         * Creates a new TCreateIncidentResult instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TCreateIncidentResult instance
         */
        public static create(properties?: NTentaclesApi.ITCreateIncidentResult): NTentaclesApi.TCreateIncidentResult;

        /**
         * Encodes the specified TCreateIncidentResult message. Does not implicitly {@link NTentaclesApi.TCreateIncidentResult.verify|verify} messages.
         * @param message TCreateIncidentResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITCreateIncidentResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TCreateIncidentResult message, length delimited. Does not implicitly {@link NTentaclesApi.TCreateIncidentResult.verify|verify} messages.
         * @param message TCreateIncidentResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITCreateIncidentResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TCreateIncidentResult message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TCreateIncidentResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TCreateIncidentResult;

        /**
         * Decodes a TCreateIncidentResult message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TCreateIncidentResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TCreateIncidentResult;

        /**
         * Verifies a TCreateIncidentResult message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TCreateIncidentResult message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TCreateIncidentResult
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TCreateIncidentResult;

        /**
         * Creates a plain object from a TCreateIncidentResult message. Also converts values to other types if specified.
         * @param message TCreateIncidentResult
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TCreateIncidentResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TCreateIncidentResult to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TCreateIncidentResponse. */
    interface ITCreateIncidentResponse {

        /** TCreateIncidentResponse error */
        error?: (string|null);

        /** TCreateIncidentResponse result */
        result?: (NTentaclesApi.ITCreateIncidentResult|null);
    }

    /** Represents a TCreateIncidentResponse. */
    class TCreateIncidentResponse implements ITCreateIncidentResponse {

        /**
         * Constructs a new TCreateIncidentResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITCreateIncidentResponse);

        /** TCreateIncidentResponse error. */
        public error: string;

        /** TCreateIncidentResponse result. */
        public result?: (NTentaclesApi.ITCreateIncidentResult|null);

        /**
         * Creates a new TCreateIncidentResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TCreateIncidentResponse instance
         */
        public static create(properties?: NTentaclesApi.ITCreateIncidentResponse): NTentaclesApi.TCreateIncidentResponse;

        /**
         * Encodes the specified TCreateIncidentResponse message. Does not implicitly {@link NTentaclesApi.TCreateIncidentResponse.verify|verify} messages.
         * @param message TCreateIncidentResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITCreateIncidentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TCreateIncidentResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TCreateIncidentResponse.verify|verify} messages.
         * @param message TCreateIncidentResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITCreateIncidentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TCreateIncidentResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TCreateIncidentResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TCreateIncidentResponse;

        /**
         * Decodes a TCreateIncidentResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TCreateIncidentResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TCreateIncidentResponse;

        /**
         * Verifies a TCreateIncidentResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TCreateIncidentResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TCreateIncidentResponse
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TCreateIncidentResponse;

        /**
         * Creates a plain object from a TCreateIncidentResponse message. Also converts values to other types if specified.
         * @param message TCreateIncidentResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TCreateIncidentResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TCreateIncidentResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TDeleteIncidentRequest. */
    interface ITDeleteIncidentRequest {

        /** TDeleteIncidentRequest id */
        id?: (string|null);
    }

    /** Represents a TDeleteIncidentRequest. */
    class TDeleteIncidentRequest implements ITDeleteIncidentRequest {

        /**
         * Constructs a new TDeleteIncidentRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITDeleteIncidentRequest);

        /** TDeleteIncidentRequest id. */
        public id: string;

        /**
         * Creates a new TDeleteIncidentRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TDeleteIncidentRequest instance
         */
        public static create(properties?: NTentaclesApi.ITDeleteIncidentRequest): NTentaclesApi.TDeleteIncidentRequest;

        /**
         * Encodes the specified TDeleteIncidentRequest message. Does not implicitly {@link NTentaclesApi.TDeleteIncidentRequest.verify|verify} messages.
         * @param message TDeleteIncidentRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITDeleteIncidentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TDeleteIncidentRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TDeleteIncidentRequest.verify|verify} messages.
         * @param message TDeleteIncidentRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITDeleteIncidentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TDeleteIncidentRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TDeleteIncidentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TDeleteIncidentRequest;

        /**
         * Decodes a TDeleteIncidentRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TDeleteIncidentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TDeleteIncidentRequest;

        /**
         * Verifies a TDeleteIncidentRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TDeleteIncidentRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TDeleteIncidentRequest
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TDeleteIncidentRequest;

        /**
         * Creates a plain object from a TDeleteIncidentRequest message. Also converts values to other types if specified.
         * @param message TDeleteIncidentRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TDeleteIncidentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TDeleteIncidentRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TDeleteIncidentResponse. */
    interface ITDeleteIncidentResponse {

        /** TDeleteIncidentResponse error */
        error?: (string|null);
    }

    /** Represents a TDeleteIncidentResponse. */
    class TDeleteIncidentResponse implements ITDeleteIncidentResponse {

        /**
         * Constructs a new TDeleteIncidentResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITDeleteIncidentResponse);

        /** TDeleteIncidentResponse error. */
        public error: string;

        /**
         * Creates a new TDeleteIncidentResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TDeleteIncidentResponse instance
         */
        public static create(properties?: NTentaclesApi.ITDeleteIncidentResponse): NTentaclesApi.TDeleteIncidentResponse;

        /**
         * Encodes the specified TDeleteIncidentResponse message. Does not implicitly {@link NTentaclesApi.TDeleteIncidentResponse.verify|verify} messages.
         * @param message TDeleteIncidentResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITDeleteIncidentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TDeleteIncidentResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TDeleteIncidentResponse.verify|verify} messages.
         * @param message TDeleteIncidentResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITDeleteIncidentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TDeleteIncidentResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TDeleteIncidentResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TDeleteIncidentResponse;

        /**
         * Decodes a TDeleteIncidentResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TDeleteIncidentResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TDeleteIncidentResponse;

        /**
         * Verifies a TDeleteIncidentResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TDeleteIncidentResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TDeleteIncidentResponse
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TDeleteIncidentResponse;

        /**
         * Creates a plain object from a TDeleteIncidentResponse message. Also converts values to other types if specified.
         * @param message TDeleteIncidentResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TDeleteIncidentResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TDeleteIncidentResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TListIncidentFiltersRequest. */
    interface ITListIncidentFiltersRequest {
    }

    /** Represents a TListIncidentFiltersRequest. */
    class TListIncidentFiltersRequest implements ITListIncidentFiltersRequest {

        /**
         * Constructs a new TListIncidentFiltersRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITListIncidentFiltersRequest);

        /**
         * Creates a new TListIncidentFiltersRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TListIncidentFiltersRequest instance
         */
        public static create(properties?: NTentaclesApi.ITListIncidentFiltersRequest): NTentaclesApi.TListIncidentFiltersRequest;

        /**
         * Encodes the specified TListIncidentFiltersRequest message. Does not implicitly {@link NTentaclesApi.TListIncidentFiltersRequest.verify|verify} messages.
         * @param message TListIncidentFiltersRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITListIncidentFiltersRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TListIncidentFiltersRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TListIncidentFiltersRequest.verify|verify} messages.
         * @param message TListIncidentFiltersRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITListIncidentFiltersRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TListIncidentFiltersRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TListIncidentFiltersRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TListIncidentFiltersRequest;

        /**
         * Decodes a TListIncidentFiltersRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TListIncidentFiltersRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TListIncidentFiltersRequest;

        /**
         * Verifies a TListIncidentFiltersRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TListIncidentFiltersRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TListIncidentFiltersRequest
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TListIncidentFiltersRequest;

        /**
         * Creates a plain object from a TListIncidentFiltersRequest message. Also converts values to other types if specified.
         * @param message TListIncidentFiltersRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TListIncidentFiltersRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TListIncidentFiltersRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TListIncidentFiltersResult. */
    interface ITListIncidentFiltersResult {

        /** TListIncidentFiltersResult filters_list */
        filters_list?: (NTentaclesApi.ITIncidentFiltersList|null);
    }

    /** Represents a TListIncidentFiltersResult. */
    class TListIncidentFiltersResult implements ITListIncidentFiltersResult {

        /**
         * Constructs a new TListIncidentFiltersResult.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITListIncidentFiltersResult);

        /** TListIncidentFiltersResult filters_list. */
        public filters_list?: (NTentaclesApi.ITIncidentFiltersList|null);

        /**
         * Creates a new TListIncidentFiltersResult instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TListIncidentFiltersResult instance
         */
        public static create(properties?: NTentaclesApi.ITListIncidentFiltersResult): NTentaclesApi.TListIncidentFiltersResult;

        /**
         * Encodes the specified TListIncidentFiltersResult message. Does not implicitly {@link NTentaclesApi.TListIncidentFiltersResult.verify|verify} messages.
         * @param message TListIncidentFiltersResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITListIncidentFiltersResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TListIncidentFiltersResult message, length delimited. Does not implicitly {@link NTentaclesApi.TListIncidentFiltersResult.verify|verify} messages.
         * @param message TListIncidentFiltersResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITListIncidentFiltersResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TListIncidentFiltersResult message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TListIncidentFiltersResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TListIncidentFiltersResult;

        /**
         * Decodes a TListIncidentFiltersResult message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TListIncidentFiltersResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TListIncidentFiltersResult;

        /**
         * Verifies a TListIncidentFiltersResult message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TListIncidentFiltersResult message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TListIncidentFiltersResult
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TListIncidentFiltersResult;

        /**
         * Creates a plain object from a TListIncidentFiltersResult message. Also converts values to other types if specified.
         * @param message TListIncidentFiltersResult
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TListIncidentFiltersResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TListIncidentFiltersResult to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TListIncidentFiltersResponse. */
    interface ITListIncidentFiltersResponse {

        /** TListIncidentFiltersResponse error */
        error?: (string|null);

        /** TListIncidentFiltersResponse result */
        result?: (NTentaclesApi.ITListIncidentFiltersResult|null);
    }

    /** Represents a TListIncidentFiltersResponse. */
    class TListIncidentFiltersResponse implements ITListIncidentFiltersResponse {

        /**
         * Constructs a new TListIncidentFiltersResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITListIncidentFiltersResponse);

        /** TListIncidentFiltersResponse error. */
        public error: string;

        /** TListIncidentFiltersResponse result. */
        public result?: (NTentaclesApi.ITListIncidentFiltersResult|null);

        /**
         * Creates a new TListIncidentFiltersResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TListIncidentFiltersResponse instance
         */
        public static create(properties?: NTentaclesApi.ITListIncidentFiltersResponse): NTentaclesApi.TListIncidentFiltersResponse;

        /**
         * Encodes the specified TListIncidentFiltersResponse message. Does not implicitly {@link NTentaclesApi.TListIncidentFiltersResponse.verify|verify} messages.
         * @param message TListIncidentFiltersResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITListIncidentFiltersResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TListIncidentFiltersResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TListIncidentFiltersResponse.verify|verify} messages.
         * @param message TListIncidentFiltersResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITListIncidentFiltersResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TListIncidentFiltersResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TListIncidentFiltersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TListIncidentFiltersResponse;

        /**
         * Decodes a TListIncidentFiltersResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TListIncidentFiltersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TListIncidentFiltersResponse;

        /**
         * Verifies a TListIncidentFiltersResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TListIncidentFiltersResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TListIncidentFiltersResponse
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TListIncidentFiltersResponse;

        /**
         * Creates a plain object from a TListIncidentFiltersResponse message. Also converts values to other types if specified.
         * @param message TListIncidentFiltersResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TListIncidentFiltersResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TListIncidentFiltersResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TReadIncidentsRequest. */
    interface ITReadIncidentsRequest {

        /** TReadIncidentsRequest filter */
        filter?: (NTentaclesApi.ITIncidentFilter|null);

        /** TReadIncidentsRequest limit */
        limit?: (number|Long|null);

        /** TReadIncidentsRequest offset */
        offset?: (number|Long|null);
    }

    /** Represents a TReadIncidentsRequest. */
    class TReadIncidentsRequest implements ITReadIncidentsRequest {

        /**
         * Constructs a new TReadIncidentsRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITReadIncidentsRequest);

        /** TReadIncidentsRequest filter. */
        public filter?: (NTentaclesApi.ITIncidentFilter|null);

        /** TReadIncidentsRequest limit. */
        public limit: (number|Long);

        /** TReadIncidentsRequest offset. */
        public offset: (number|Long);

        /**
         * Creates a new TReadIncidentsRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TReadIncidentsRequest instance
         */
        public static create(properties?: NTentaclesApi.ITReadIncidentsRequest): NTentaclesApi.TReadIncidentsRequest;

        /**
         * Encodes the specified TReadIncidentsRequest message. Does not implicitly {@link NTentaclesApi.TReadIncidentsRequest.verify|verify} messages.
         * @param message TReadIncidentsRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITReadIncidentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TReadIncidentsRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TReadIncidentsRequest.verify|verify} messages.
         * @param message TReadIncidentsRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITReadIncidentsRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TReadIncidentsRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TReadIncidentsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TReadIncidentsRequest;

        /**
         * Decodes a TReadIncidentsRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TReadIncidentsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TReadIncidentsRequest;

        /**
         * Verifies a TReadIncidentsRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TReadIncidentsRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TReadIncidentsRequest
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TReadIncidentsRequest;

        /**
         * Creates a plain object from a TReadIncidentsRequest message. Also converts values to other types if specified.
         * @param message TReadIncidentsRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TReadIncidentsRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TReadIncidentsRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TReadIncidentsResult. */
    interface ITReadIncidentsResult {

        /** TReadIncidentsResult incidents */
        incidents?: (NTentaclesApi.ITIncident[]|null);

        /** TReadIncidentsResult total */
        total?: (number|null);

        /** TReadIncidentsResult total_minutes_out_of_slo */
        total_minutes_out_of_slo?: (number|null);
    }

    /** Represents a TReadIncidentsResult. */
    class TReadIncidentsResult implements ITReadIncidentsResult {

        /**
         * Constructs a new TReadIncidentsResult.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITReadIncidentsResult);

        /** TReadIncidentsResult incidents. */
        public incidents: NTentaclesApi.ITIncident[];

        /** TReadIncidentsResult total. */
        public total: number;

        /** TReadIncidentsResult total_minutes_out_of_slo. */
        public total_minutes_out_of_slo: number;

        /**
         * Creates a new TReadIncidentsResult instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TReadIncidentsResult instance
         */
        public static create(properties?: NTentaclesApi.ITReadIncidentsResult): NTentaclesApi.TReadIncidentsResult;

        /**
         * Encodes the specified TReadIncidentsResult message. Does not implicitly {@link NTentaclesApi.TReadIncidentsResult.verify|verify} messages.
         * @param message TReadIncidentsResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITReadIncidentsResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TReadIncidentsResult message, length delimited. Does not implicitly {@link NTentaclesApi.TReadIncidentsResult.verify|verify} messages.
         * @param message TReadIncidentsResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITReadIncidentsResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TReadIncidentsResult message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TReadIncidentsResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TReadIncidentsResult;

        /**
         * Decodes a TReadIncidentsResult message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TReadIncidentsResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TReadIncidentsResult;

        /**
         * Verifies a TReadIncidentsResult message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TReadIncidentsResult message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TReadIncidentsResult
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TReadIncidentsResult;

        /**
         * Creates a plain object from a TReadIncidentsResult message. Also converts values to other types if specified.
         * @param message TReadIncidentsResult
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TReadIncidentsResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TReadIncidentsResult to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TReadIncidentsResponse. */
    interface ITReadIncidentsResponse {

        /** TReadIncidentsResponse error */
        error?: (string|null);

        /** TReadIncidentsResponse result */
        result?: (NTentaclesApi.ITReadIncidentsResult|null);
    }

    /** Represents a TReadIncidentsResponse. */
    class TReadIncidentsResponse implements ITReadIncidentsResponse {

        /**
         * Constructs a new TReadIncidentsResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITReadIncidentsResponse);

        /** TReadIncidentsResponse error. */
        public error: string;

        /** TReadIncidentsResponse result. */
        public result?: (NTentaclesApi.ITReadIncidentsResult|null);

        /**
         * Creates a new TReadIncidentsResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TReadIncidentsResponse instance
         */
        public static create(properties?: NTentaclesApi.ITReadIncidentsResponse): NTentaclesApi.TReadIncidentsResponse;

        /**
         * Encodes the specified TReadIncidentsResponse message. Does not implicitly {@link NTentaclesApi.TReadIncidentsResponse.verify|verify} messages.
         * @param message TReadIncidentsResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITReadIncidentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TReadIncidentsResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TReadIncidentsResponse.verify|verify} messages.
         * @param message TReadIncidentsResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITReadIncidentsResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TReadIncidentsResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TReadIncidentsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TReadIncidentsResponse;

        /**
         * Decodes a TReadIncidentsResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TReadIncidentsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TReadIncidentsResponse;

        /**
         * Verifies a TReadIncidentsResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TReadIncidentsResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TReadIncidentsResponse
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TReadIncidentsResponse;

        /**
         * Creates a plain object from a TReadIncidentsResponse message. Also converts values to other types if specified.
         * @param message TReadIncidentsResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TReadIncidentsResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TReadIncidentsResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TReadIncidentDataRequest. */
    interface ITReadIncidentDataRequest {

        /** TReadIncidentDataRequest id */
        id?: (string|null);
    }

    /** Represents a TReadIncidentDataRequest. */
    class TReadIncidentDataRequest implements ITReadIncidentDataRequest {

        /**
         * Constructs a new TReadIncidentDataRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITReadIncidentDataRequest);

        /** TReadIncidentDataRequest id. */
        public id: string;

        /**
         * Creates a new TReadIncidentDataRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TReadIncidentDataRequest instance
         */
        public static create(properties?: NTentaclesApi.ITReadIncidentDataRequest): NTentaclesApi.TReadIncidentDataRequest;

        /**
         * Encodes the specified TReadIncidentDataRequest message. Does not implicitly {@link NTentaclesApi.TReadIncidentDataRequest.verify|verify} messages.
         * @param message TReadIncidentDataRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITReadIncidentDataRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TReadIncidentDataRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TReadIncidentDataRequest.verify|verify} messages.
         * @param message TReadIncidentDataRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITReadIncidentDataRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TReadIncidentDataRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TReadIncidentDataRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TReadIncidentDataRequest;

        /**
         * Decodes a TReadIncidentDataRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TReadIncidentDataRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TReadIncidentDataRequest;

        /**
         * Verifies a TReadIncidentDataRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TReadIncidentDataRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TReadIncidentDataRequest
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TReadIncidentDataRequest;

        /**
         * Creates a plain object from a TReadIncidentDataRequest message. Also converts values to other types if specified.
         * @param message TReadIncidentDataRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TReadIncidentDataRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TReadIncidentDataRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TReadIncidentDataResult. */
    interface ITReadIncidentDataResult {

        /** TReadIncidentDataResult data */
        data?: (NTentaclesApi.ITIncident|null);
    }

    /** Represents a TReadIncidentDataResult. */
    class TReadIncidentDataResult implements ITReadIncidentDataResult {

        /**
         * Constructs a new TReadIncidentDataResult.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITReadIncidentDataResult);

        /** TReadIncidentDataResult data. */
        public data?: (NTentaclesApi.ITIncident|null);

        /**
         * Creates a new TReadIncidentDataResult instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TReadIncidentDataResult instance
         */
        public static create(properties?: NTentaclesApi.ITReadIncidentDataResult): NTentaclesApi.TReadIncidentDataResult;

        /**
         * Encodes the specified TReadIncidentDataResult message. Does not implicitly {@link NTentaclesApi.TReadIncidentDataResult.verify|verify} messages.
         * @param message TReadIncidentDataResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITReadIncidentDataResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TReadIncidentDataResult message, length delimited. Does not implicitly {@link NTentaclesApi.TReadIncidentDataResult.verify|verify} messages.
         * @param message TReadIncidentDataResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITReadIncidentDataResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TReadIncidentDataResult message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TReadIncidentDataResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TReadIncidentDataResult;

        /**
         * Decodes a TReadIncidentDataResult message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TReadIncidentDataResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TReadIncidentDataResult;

        /**
         * Verifies a TReadIncidentDataResult message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TReadIncidentDataResult message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TReadIncidentDataResult
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TReadIncidentDataResult;

        /**
         * Creates a plain object from a TReadIncidentDataResult message. Also converts values to other types if specified.
         * @param message TReadIncidentDataResult
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TReadIncidentDataResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TReadIncidentDataResult to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TReadIncidentDataResponse. */
    interface ITReadIncidentDataResponse {

        /** TReadIncidentDataResponse error */
        error?: (string|null);

        /** TReadIncidentDataResponse result */
        result?: (NTentaclesApi.ITReadIncidentDataResult|null);
    }

    /** Represents a TReadIncidentDataResponse. */
    class TReadIncidentDataResponse implements ITReadIncidentDataResponse {

        /**
         * Constructs a new TReadIncidentDataResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITReadIncidentDataResponse);

        /** TReadIncidentDataResponse error. */
        public error: string;

        /** TReadIncidentDataResponse result. */
        public result?: (NTentaclesApi.ITReadIncidentDataResult|null);

        /**
         * Creates a new TReadIncidentDataResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TReadIncidentDataResponse instance
         */
        public static create(properties?: NTentaclesApi.ITReadIncidentDataResponse): NTentaclesApi.TReadIncidentDataResponse;

        /**
         * Encodes the specified TReadIncidentDataResponse message. Does not implicitly {@link NTentaclesApi.TReadIncidentDataResponse.verify|verify} messages.
         * @param message TReadIncidentDataResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITReadIncidentDataResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TReadIncidentDataResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TReadIncidentDataResponse.verify|verify} messages.
         * @param message TReadIncidentDataResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITReadIncidentDataResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TReadIncidentDataResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TReadIncidentDataResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TReadIncidentDataResponse;

        /**
         * Decodes a TReadIncidentDataResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TReadIncidentDataResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TReadIncidentDataResponse;

        /**
         * Verifies a TReadIncidentDataResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TReadIncidentDataResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TReadIncidentDataResponse
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TReadIncidentDataResponse;

        /**
         * Creates a plain object from a TReadIncidentDataResponse message. Also converts values to other types if specified.
         * @param message TReadIncidentDataResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TReadIncidentDataResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TReadIncidentDataResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TUpdateIncidentRequest. */
    interface ITUpdateIncidentRequest {

        /** TUpdateIncidentRequest data */
        data?: (NTentaclesApi.ITIncident|null);
    }

    /** Represents a TUpdateIncidentRequest. */
    class TUpdateIncidentRequest implements ITUpdateIncidentRequest {

        /**
         * Constructs a new TUpdateIncidentRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITUpdateIncidentRequest);

        /** TUpdateIncidentRequest data. */
        public data?: (NTentaclesApi.ITIncident|null);

        /**
         * Creates a new TUpdateIncidentRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TUpdateIncidentRequest instance
         */
        public static create(properties?: NTentaclesApi.ITUpdateIncidentRequest): NTentaclesApi.TUpdateIncidentRequest;

        /**
         * Encodes the specified TUpdateIncidentRequest message. Does not implicitly {@link NTentaclesApi.TUpdateIncidentRequest.verify|verify} messages.
         * @param message TUpdateIncidentRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITUpdateIncidentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TUpdateIncidentRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TUpdateIncidentRequest.verify|verify} messages.
         * @param message TUpdateIncidentRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITUpdateIncidentRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TUpdateIncidentRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TUpdateIncidentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TUpdateIncidentRequest;

        /**
         * Decodes a TUpdateIncidentRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TUpdateIncidentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TUpdateIncidentRequest;

        /**
         * Verifies a TUpdateIncidentRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TUpdateIncidentRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TUpdateIncidentRequest
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TUpdateIncidentRequest;

        /**
         * Creates a plain object from a TUpdateIncidentRequest message. Also converts values to other types if specified.
         * @param message TUpdateIncidentRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TUpdateIncidentRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TUpdateIncidentRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TUpdateIncidentResponse. */
    interface ITUpdateIncidentResponse {

        /** TUpdateIncidentResponse error */
        error?: (string|null);
    }

    /** Represents a TUpdateIncidentResponse. */
    class TUpdateIncidentResponse implements ITUpdateIncidentResponse {

        /**
         * Constructs a new TUpdateIncidentResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITUpdateIncidentResponse);

        /** TUpdateIncidentResponse error. */
        public error: string;

        /**
         * Creates a new TUpdateIncidentResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TUpdateIncidentResponse instance
         */
        public static create(properties?: NTentaclesApi.ITUpdateIncidentResponse): NTentaclesApi.TUpdateIncidentResponse;

        /**
         * Encodes the specified TUpdateIncidentResponse message. Does not implicitly {@link NTentaclesApi.TUpdateIncidentResponse.verify|verify} messages.
         * @param message TUpdateIncidentResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITUpdateIncidentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TUpdateIncidentResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TUpdateIncidentResponse.verify|verify} messages.
         * @param message TUpdateIncidentResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITUpdateIncidentResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TUpdateIncidentResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TUpdateIncidentResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TUpdateIncidentResponse;

        /**
         * Decodes a TUpdateIncidentResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TUpdateIncidentResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TUpdateIncidentResponse;

        /**
         * Verifies a TUpdateIncidentResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TUpdateIncidentResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TUpdateIncidentResponse
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TUpdateIncidentResponse;

        /**
         * Creates a plain object from a TUpdateIncidentResponse message. Also converts values to other types if specified.
         * @param message TUpdateIncidentResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TUpdateIncidentResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TUpdateIncidentResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TDataOverviewResult. */
    interface ITDataOverviewResult {

        /** TDataOverviewResult allocation_zones */
        allocation_zones?: (NTentaclesApi.ITAllocationZoneFeatures[]|null);
    }

    /** Represents a TDataOverviewResult. */
    class TDataOverviewResult implements ITDataOverviewResult {

        /**
         * Constructs a new TDataOverviewResult.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITDataOverviewResult);

        /** TDataOverviewResult allocation_zones. */
        public allocation_zones: NTentaclesApi.ITAllocationZoneFeatures[];

        /**
         * Creates a new TDataOverviewResult instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TDataOverviewResult instance
         */
        public static create(properties?: NTentaclesApi.ITDataOverviewResult): NTentaclesApi.TDataOverviewResult;

        /**
         * Encodes the specified TDataOverviewResult message. Does not implicitly {@link NTentaclesApi.TDataOverviewResult.verify|verify} messages.
         * @param message TDataOverviewResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITDataOverviewResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TDataOverviewResult message, length delimited. Does not implicitly {@link NTentaclesApi.TDataOverviewResult.verify|verify} messages.
         * @param message TDataOverviewResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITDataOverviewResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TDataOverviewResult message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TDataOverviewResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TDataOverviewResult;

        /**
         * Decodes a TDataOverviewResult message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TDataOverviewResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TDataOverviewResult;

        /**
         * Verifies a TDataOverviewResult message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TDataOverviewResult message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TDataOverviewResult
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TDataOverviewResult;

        /**
         * Creates a plain object from a TDataOverviewResult message. Also converts values to other types if specified.
         * @param message TDataOverviewResult
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TDataOverviewResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TDataOverviewResult to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TDataOverviewResponse. */
    interface ITDataOverviewResponse {

        /** TDataOverviewResponse result */
        result?: (NTentaclesApi.ITDataOverviewResult|null);
    }

    /** Represents a TDataOverviewResponse. */
    class TDataOverviewResponse implements ITDataOverviewResponse {

        /**
         * Constructs a new TDataOverviewResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITDataOverviewResponse);

        /** TDataOverviewResponse result. */
        public result?: (NTentaclesApi.ITDataOverviewResult|null);

        /**
         * Creates a new TDataOverviewResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TDataOverviewResponse instance
         */
        public static create(properties?: NTentaclesApi.ITDataOverviewResponse): NTentaclesApi.TDataOverviewResponse;

        /**
         * Encodes the specified TDataOverviewResponse message. Does not implicitly {@link NTentaclesApi.TDataOverviewResponse.verify|verify} messages.
         * @param message TDataOverviewResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITDataOverviewResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TDataOverviewResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TDataOverviewResponse.verify|verify} messages.
         * @param message TDataOverviewResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITDataOverviewResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TDataOverviewResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TDataOverviewResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TDataOverviewResponse;

        /**
         * Decodes a TDataOverviewResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TDataOverviewResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TDataOverviewResponse;

        /**
         * Verifies a TDataOverviewResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TDataOverviewResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TDataOverviewResponse
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TDataOverviewResponse;

        /**
         * Creates a plain object from a TDataOverviewResponse message. Also converts values to other types if specified.
         * @param message TDataOverviewResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TDataOverviewResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TDataOverviewResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TTentacles. */
    interface ITTentacles {

        /** TTentacles pod_id */
        pod_id?: (string|null);

        /** TTentacles fqdn */
        fqdn?: (string|null);

        /** TTentacles tentacles_location */
        tentacles_location?: (string|null);

        /** TTentacles rtc_stage */
        rtc_stage?: (string|null);

        /** TTentacles yp_scheduling_error */
        yp_scheduling_error?: (string|null);

        /** TTentacles yp_node_hfsm_state */
        yp_node_hfsm_state?: (string|null);

        /** TTentacles is_juggler_data_present */
        is_juggler_data_present?: (boolean|null);

        /** TTentacles juggler_status */
        juggler_status?: (string|null);

        /** TTentacles juggler_state_kind */
        juggler_state_kind?: (string|null);

        /** TTentacles juggler_description */
        juggler_description?: (string|null);

        /** TTentacles nanny_service_name */
        nanny_service_name?: (string|null);

        /** TTentacles hq_id */
        hq_id?: (string|null);

        /** TTentacles hq_hostname */
        hq_hostname?: (string|null);

        /** TTentacles is_hq_data_present */
        is_hq_data_present?: (boolean|null);

        /** TTentacles excluded_from_slo_by_walle */
        excluded_from_slo_by_walle?: (boolean|null);

        /** TTentacles walle_project */
        walle_project?: (string|null);

        /** TTentacles walle_location_short_datacenter_name */
        walle_location_short_datacenter_name?: (string|null);

        /** TTentacles walle_operation_state */
        walle_operation_state?: (string|null);

        /** TTentacles walle_state */
        walle_state?: (string|null);

        /** TTentacles walle_status */
        walle_status?: (string|null);

        /** TTentacles walle_health_status */
        walle_health_status?: (string|null);

        /** TTentacles walle_health_fail_reasons */
        walle_health_fail_reasons?: (string[]|null);

        /** TTentacles walle_scenario_id */
        walle_scenario_id?: (number|null);

        /** TTentacles walle_ticket */
        walle_ticket?: (string|null);

        /** TTentacles monitoring_timestamp_age_present */
        monitoring_timestamp_age_present?: (boolean|null);

        /** TTentacles monitoring_timestamp_age_visible */
        monitoring_timestamp_age_visible?: (boolean|null);

        /** TTentacles monitoring_timestamp_age_reachable */
        monitoring_timestamp_age_reachable?: (boolean|null);

        /** TTentacles monitoring_timestamp_age_fresh_ts_resource */
        monitoring_timestamp_age_fresh_ts_resource?: (boolean|null);

        /** TTentacles slo_availablilty_excluded */
        slo_availablilty_excluded?: (boolean|null);

        /** TTentacles slo_availablilty_available */
        slo_availablilty_available?: (boolean|null);

        /** TTentacles slo_redeployment_excluded */
        slo_redeployment_excluded?: (boolean|null);

        /** TTentacles slo_redeployment_fresh_ts_resource */
        slo_redeployment_fresh_ts_resource?: (boolean|null);
    }

    /** Represents a TTentacles. */
    class TTentacles implements ITTentacles {

        /**
         * Constructs a new TTentacles.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITTentacles);

        /** TTentacles pod_id. */
        public pod_id: string;

        /** TTentacles fqdn. */
        public fqdn: string;

        /** TTentacles tentacles_location. */
        public tentacles_location: string;

        /** TTentacles rtc_stage. */
        public rtc_stage: string;

        /** TTentacles yp_scheduling_error. */
        public yp_scheduling_error: string;

        /** TTentacles yp_node_hfsm_state. */
        public yp_node_hfsm_state: string;

        /** TTentacles is_juggler_data_present. */
        public is_juggler_data_present: boolean;

        /** TTentacles juggler_status. */
        public juggler_status: string;

        /** TTentacles juggler_state_kind. */
        public juggler_state_kind: string;

        /** TTentacles juggler_description. */
        public juggler_description: string;

        /** TTentacles nanny_service_name. */
        public nanny_service_name: string;

        /** TTentacles hq_id. */
        public hq_id: string;

        /** TTentacles hq_hostname. */
        public hq_hostname: string;

        /** TTentacles is_hq_data_present. */
        public is_hq_data_present: boolean;

        /** TTentacles excluded_from_slo_by_walle. */
        public excluded_from_slo_by_walle: boolean;

        /** TTentacles walle_project. */
        public walle_project: string;

        /** TTentacles walle_location_short_datacenter_name. */
        public walle_location_short_datacenter_name: string;

        /** TTentacles walle_operation_state. */
        public walle_operation_state: string;

        /** TTentacles walle_state. */
        public walle_state: string;

        /** TTentacles walle_status. */
        public walle_status: string;

        /** TTentacles walle_health_status. */
        public walle_health_status: string;

        /** TTentacles walle_health_fail_reasons. */
        public walle_health_fail_reasons: string[];

        /** TTentacles walle_scenario_id. */
        public walle_scenario_id: number;

        /** TTentacles walle_ticket. */
        public walle_ticket: string;

        /** TTentacles monitoring_timestamp_age_present. */
        public monitoring_timestamp_age_present: boolean;

        /** TTentacles monitoring_timestamp_age_visible. */
        public monitoring_timestamp_age_visible: boolean;

        /** TTentacles monitoring_timestamp_age_reachable. */
        public monitoring_timestamp_age_reachable: boolean;

        /** TTentacles monitoring_timestamp_age_fresh_ts_resource. */
        public monitoring_timestamp_age_fresh_ts_resource: boolean;

        /** TTentacles slo_availablilty_excluded. */
        public slo_availablilty_excluded: boolean;

        /** TTentacles slo_availablilty_available. */
        public slo_availablilty_available: boolean;

        /** TTentacles slo_redeployment_excluded. */
        public slo_redeployment_excluded: boolean;

        /** TTentacles slo_redeployment_fresh_ts_resource. */
        public slo_redeployment_fresh_ts_resource: boolean;

        /**
         * Creates a new TTentacles instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TTentacles instance
         */
        public static create(properties?: NTentaclesApi.ITTentacles): NTentaclesApi.TTentacles;

        /**
         * Encodes the specified TTentacles message. Does not implicitly {@link NTentaclesApi.TTentacles.verify|verify} messages.
         * @param message TTentacles message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITTentacles, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TTentacles message, length delimited. Does not implicitly {@link NTentaclesApi.TTentacles.verify|verify} messages.
         * @param message TTentacles message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITTentacles, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TTentacles message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TTentacles
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TTentacles;

        /**
         * Decodes a TTentacles message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TTentacles
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TTentacles;

        /**
         * Verifies a TTentacles message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TTentacles message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TTentacles
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TTentacles;

        /**
         * Creates a plain object from a TTentacles message. Also converts values to other types if specified.
         * @param message TTentacles
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TTentacles, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TTentacles to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TPodsListResult. */
    interface ITPodsListResult {

        /** TPodsListResult tentacles */
        tentacles?: (NTentaclesApi.ITTentacles[]|null);

        /** TPodsListResult total_count */
        total_count?: (number|Long|null);
    }

    /** Represents a TPodsListResult. */
    class TPodsListResult implements ITPodsListResult {

        /**
         * Constructs a new TPodsListResult.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITPodsListResult);

        /** TPodsListResult tentacles. */
        public tentacles: NTentaclesApi.ITTentacles[];

        /** TPodsListResult total_count. */
        public total_count: (number|Long);

        /**
         * Creates a new TPodsListResult instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TPodsListResult instance
         */
        public static create(properties?: NTentaclesApi.ITPodsListResult): NTentaclesApi.TPodsListResult;

        /**
         * Encodes the specified TPodsListResult message. Does not implicitly {@link NTentaclesApi.TPodsListResult.verify|verify} messages.
         * @param message TPodsListResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITPodsListResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TPodsListResult message, length delimited. Does not implicitly {@link NTentaclesApi.TPodsListResult.verify|verify} messages.
         * @param message TPodsListResult message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITPodsListResult, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TPodsListResult message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TPodsListResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TPodsListResult;

        /**
         * Decodes a TPodsListResult message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TPodsListResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TPodsListResult;

        /**
         * Verifies a TPodsListResult message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TPodsListResult message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TPodsListResult
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TPodsListResult;

        /**
         * Creates a plain object from a TPodsListResult message. Also converts values to other types if specified.
         * @param message TPodsListResult
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TPodsListResult, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TPodsListResult to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TPodsListResponse. */
    interface ITPodsListResponse {

        /** TPodsListResponse result */
        result?: (NTentaclesApi.ITPodsListResult|null);
    }

    /** Represents a TPodsListResponse. */
    class TPodsListResponse implements ITPodsListResponse {

        /**
         * Constructs a new TPodsListResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITPodsListResponse);

        /** TPodsListResponse result. */
        public result?: (NTentaclesApi.ITPodsListResult|null);

        /**
         * Creates a new TPodsListResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TPodsListResponse instance
         */
        public static create(properties?: NTentaclesApi.ITPodsListResponse): NTentaclesApi.TPodsListResponse;

        /**
         * Encodes the specified TPodsListResponse message. Does not implicitly {@link NTentaclesApi.TPodsListResponse.verify|verify} messages.
         * @param message TPodsListResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITPodsListResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TPodsListResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TPodsListResponse.verify|verify} messages.
         * @param message TPodsListResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITPodsListResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TPodsListResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TPodsListResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TPodsListResponse;

        /**
         * Decodes a TPodsListResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TPodsListResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TPodsListResponse;

        /**
         * Verifies a TPodsListResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TPodsListResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TPodsListResponse
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TPodsListResponse;

        /**
         * Creates a plain object from a TPodsListResponse message. Also converts values to other types if specified.
         * @param message TPodsListResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TPodsListResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TPodsListResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }

    /** Properties of a TPodsListRequest. */
    interface ITPodsListRequest {

        /** TPodsListRequest allocation_zone_id */
        allocation_zone_id?: (string|null);

        /** TPodsListRequest columns */
        columns?: (string[]|null);

        /** TPodsListRequest filter */
        filter?: (NTentaclesApi.EPodFilter|null);

        /** TPodsListRequest limit */
        limit?: (number|Long|null);

        /** TPodsListRequest offset */
        offset?: (number|Long|null);

        /** TPodsListRequest ts */
        ts?: (number|Long|null);
    }

    /** Represents a TPodsListRequest. */
    class TPodsListRequest implements ITPodsListRequest {

        /**
         * Constructs a new TPodsListRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: NTentaclesApi.ITPodsListRequest);

        /** TPodsListRequest allocation_zone_id. */
        public allocation_zone_id: string;

        /** TPodsListRequest columns. */
        public columns: string[];

        /** TPodsListRequest filter. */
        public filter: NTentaclesApi.EPodFilter;

        /** TPodsListRequest limit. */
        public limit: (number|Long);

        /** TPodsListRequest offset. */
        public offset: (number|Long);

        /** TPodsListRequest ts. */
        public ts: (number|Long);

        /**
         * Creates a new TPodsListRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns TPodsListRequest instance
         */
        public static create(properties?: NTentaclesApi.ITPodsListRequest): NTentaclesApi.TPodsListRequest;

        /**
         * Encodes the specified TPodsListRequest message. Does not implicitly {@link NTentaclesApi.TPodsListRequest.verify|verify} messages.
         * @param message TPodsListRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: NTentaclesApi.ITPodsListRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified TPodsListRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TPodsListRequest.verify|verify} messages.
         * @param message TPodsListRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: NTentaclesApi.ITPodsListRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a TPodsListRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns TPodsListRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): NTentaclesApi.TPodsListRequest;

        /**
         * Decodes a TPodsListRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns TPodsListRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): NTentaclesApi.TPodsListRequest;

        /**
         * Verifies a TPodsListRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a TPodsListRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns TPodsListRequest
         */
        public static fromObject(object: { [k: string]: any }): NTentaclesApi.TPodsListRequest;

        /**
         * Creates a plain object from a TPodsListRequest message. Also converts values to other types if specified.
         * @param message TPodsListRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: NTentaclesApi.TPodsListRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this TPodsListRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };
    }
}
