/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
import * as $protobuf from "protobufjs/minimal";

// Common aliases
const $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
const $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

export const NTentaclesApi = $root.NTentaclesApi = (() => {

    /**
     * Namespace NTentaclesApi.
     * @exports NTentaclesApi
     * @namespace
     */
    const NTentaclesApi = {};

    NTentaclesApi.TFreshness = (function() {

        /**
         * Properties of a TFreshness.
         * @memberof NTentaclesApi
         * @interface ITFreshness
         * @property {number|null} [walle_ts] TFreshness walle_ts
         * @property {number|null} [juggler_ts] TFreshness juggler_ts
         * @property {number|null} [hq_ts] TFreshness hq_ts
         * @property {number|null} [yp_ts] TFreshness yp_ts
         */

        /**
         * Constructs a new TFreshness.
         * @memberof NTentaclesApi
         * @classdesc Represents a TFreshness.
         * @implements ITFreshness
         * @constructor
         * @param {NTentaclesApi.ITFreshness=} [properties] Properties to set
         */
        function TFreshness(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TFreshness walle_ts.
         * @member {number} walle_ts
         * @memberof NTentaclesApi.TFreshness
         * @instance
         */
        TFreshness.prototype.walle_ts = 0;

        /**
         * TFreshness juggler_ts.
         * @member {number} juggler_ts
         * @memberof NTentaclesApi.TFreshness
         * @instance
         */
        TFreshness.prototype.juggler_ts = 0;

        /**
         * TFreshness hq_ts.
         * @member {number} hq_ts
         * @memberof NTentaclesApi.TFreshness
         * @instance
         */
        TFreshness.prototype.hq_ts = 0;

        /**
         * TFreshness yp_ts.
         * @member {number} yp_ts
         * @memberof NTentaclesApi.TFreshness
         * @instance
         */
        TFreshness.prototype.yp_ts = 0;

        /**
         * Creates a new TFreshness instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TFreshness
         * @static
         * @param {NTentaclesApi.ITFreshness=} [properties] Properties to set
         * @returns {NTentaclesApi.TFreshness} TFreshness instance
         */
        TFreshness.create = function create(properties) {
            return new TFreshness(properties);
        };

        /**
         * Encodes the specified TFreshness message. Does not implicitly {@link NTentaclesApi.TFreshness.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TFreshness
         * @static
         * @param {NTentaclesApi.ITFreshness} message TFreshness message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TFreshness.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.walle_ts != null && Object.hasOwnProperty.call(message, "walle_ts"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.walle_ts);
            if (message.juggler_ts != null && Object.hasOwnProperty.call(message, "juggler_ts"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.juggler_ts);
            if (message.hq_ts != null && Object.hasOwnProperty.call(message, "hq_ts"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.hq_ts);
            if (message.yp_ts != null && Object.hasOwnProperty.call(message, "yp_ts"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.yp_ts);
            return writer;
        };

        /**
         * Encodes the specified TFreshness message, length delimited. Does not implicitly {@link NTentaclesApi.TFreshness.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TFreshness
         * @static
         * @param {NTentaclesApi.ITFreshness} message TFreshness message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TFreshness.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TFreshness message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TFreshness
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TFreshness} TFreshness
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TFreshness.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TFreshness();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.walle_ts = reader.uint32();
                    break;
                case 2:
                    message.juggler_ts = reader.uint32();
                    break;
                case 3:
                    message.hq_ts = reader.uint32();
                    break;
                case 4:
                    message.yp_ts = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TFreshness message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TFreshness
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TFreshness} TFreshness
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TFreshness.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TFreshness message.
         * @function verify
         * @memberof NTentaclesApi.TFreshness
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TFreshness.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.walle_ts != null && message.hasOwnProperty("walle_ts"))
                if (!$util.isInteger(message.walle_ts))
                    return "walle_ts: integer expected";
            if (message.juggler_ts != null && message.hasOwnProperty("juggler_ts"))
                if (!$util.isInteger(message.juggler_ts))
                    return "juggler_ts: integer expected";
            if (message.hq_ts != null && message.hasOwnProperty("hq_ts"))
                if (!$util.isInteger(message.hq_ts))
                    return "hq_ts: integer expected";
            if (message.yp_ts != null && message.hasOwnProperty("yp_ts"))
                if (!$util.isInteger(message.yp_ts))
                    return "yp_ts: integer expected";
            return null;
        };

        /**
         * Creates a TFreshness message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TFreshness
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TFreshness} TFreshness
         */
        TFreshness.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TFreshness)
                return object;
            let message = new $root.NTentaclesApi.TFreshness();
            if (object.walle_ts != null)
                message.walle_ts = object.walle_ts >>> 0;
            if (object.juggler_ts != null)
                message.juggler_ts = object.juggler_ts >>> 0;
            if (object.hq_ts != null)
                message.hq_ts = object.hq_ts >>> 0;
            if (object.yp_ts != null)
                message.yp_ts = object.yp_ts >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a TFreshness message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TFreshness
         * @static
         * @param {NTentaclesApi.TFreshness} message TFreshness
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TFreshness.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.walle_ts = 0;
                object.juggler_ts = 0;
                object.hq_ts = 0;
                object.yp_ts = 0;
            }
            if (message.walle_ts != null && message.hasOwnProperty("walle_ts"))
                object.walle_ts = message.walle_ts;
            if (message.juggler_ts != null && message.hasOwnProperty("juggler_ts"))
                object.juggler_ts = message.juggler_ts;
            if (message.hq_ts != null && message.hasOwnProperty("hq_ts"))
                object.hq_ts = message.hq_ts;
            if (message.yp_ts != null && message.hasOwnProperty("yp_ts"))
                object.yp_ts = message.yp_ts;
            return object;
        };

        /**
         * Converts this TFreshness to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TFreshness
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TFreshness.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TFreshness;
    })();

    NTentaclesApi.TSlice = (function() {

        /**
         * Properties of a TSlice.
         * @memberof NTentaclesApi
         * @interface ITSlice
         * @property {NTentaclesApi.EPodFilter|null} [filter] TSlice filter
         * @property {Array.<string>|null} [columns] TSlice columns
         */

        /**
         * Constructs a new TSlice.
         * @memberof NTentaclesApi
         * @classdesc Represents a TSlice.
         * @implements ITSlice
         * @constructor
         * @param {NTentaclesApi.ITSlice=} [properties] Properties to set
         */
        function TSlice(properties) {
            this.columns = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TSlice filter.
         * @member {NTentaclesApi.EPodFilter} filter
         * @memberof NTentaclesApi.TSlice
         * @instance
         */
        TSlice.prototype.filter = 0;

        /**
         * TSlice columns.
         * @member {Array.<string>} columns
         * @memberof NTentaclesApi.TSlice
         * @instance
         */
        TSlice.prototype.columns = $util.emptyArray;

        /**
         * Creates a new TSlice instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TSlice
         * @static
         * @param {NTentaclesApi.ITSlice=} [properties] Properties to set
         * @returns {NTentaclesApi.TSlice} TSlice instance
         */
        TSlice.create = function create(properties) {
            return new TSlice(properties);
        };

        /**
         * Encodes the specified TSlice message. Does not implicitly {@link NTentaclesApi.TSlice.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TSlice
         * @static
         * @param {NTentaclesApi.ITSlice} message TSlice message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TSlice.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.filter);
            if (message.columns != null && message.columns.length)
                for (let i = 0; i < message.columns.length; ++i)
                    writer.uint32(/* id 99, wireType 2 =*/794).string(message.columns[i]);
            return writer;
        };

        /**
         * Encodes the specified TSlice message, length delimited. Does not implicitly {@link NTentaclesApi.TSlice.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TSlice
         * @static
         * @param {NTentaclesApi.ITSlice} message TSlice message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TSlice.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TSlice message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TSlice
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TSlice} TSlice
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TSlice.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TSlice();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.filter = reader.int32();
                    break;
                case 99:
                    if (!(message.columns && message.columns.length))
                        message.columns = [];
                    message.columns.push(reader.string());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TSlice message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TSlice
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TSlice} TSlice
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TSlice.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TSlice message.
         * @function verify
         * @memberof NTentaclesApi.TSlice
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TSlice.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.filter != null && message.hasOwnProperty("filter"))
                switch (message.filter) {
                default:
                    return "filter: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                    break;
                }
            if (message.columns != null && message.hasOwnProperty("columns")) {
                if (!Array.isArray(message.columns))
                    return "columns: array expected";
                for (let i = 0; i < message.columns.length; ++i)
                    if (!$util.isString(message.columns[i]))
                        return "columns: string[] expected";
            }
            return null;
        };

        /**
         * Creates a TSlice message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TSlice
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TSlice} TSlice
         */
        TSlice.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TSlice)
                return object;
            let message = new $root.NTentaclesApi.TSlice();
            switch (object.filter) {
            case "NONE":
            case 0:
                message.filter = 0;
                break;
            case "EXCLUDED_DECOMMISSIONED_NODES":
            case 1:
                message.filter = 1;
                break;
            case "EXCLUDED_PROBATION_OR_FREE_NODES":
            case 2:
                message.filter = 2;
                break;
            case "PODS_SCHEDULING_ERRORS":
            case 3:
                message.filter = 3;
                break;
            case "UNUSED_YP_NODES":
            case 4:
                message.filter = 4;
                break;
            case "EXCLUDED_NOT_PRESENT":
            case 5:
                message.filter = 5;
                break;
            case "EXCLUDED_NOT_VISIBLE":
            case 6:
                message.filter = 6;
                break;
            case "EXCLUDED_NOT_REACHABLE":
            case 7:
                message.filter = 7;
                break;
            }
            if (object.columns) {
                if (!Array.isArray(object.columns))
                    throw TypeError(".NTentaclesApi.TSlice.columns: array expected");
                message.columns = [];
                for (let i = 0; i < object.columns.length; ++i)
                    message.columns[i] = String(object.columns[i]);
            }
            return message;
        };

        /**
         * Creates a plain object from a TSlice message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TSlice
         * @static
         * @param {NTentaclesApi.TSlice} message TSlice
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TSlice.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.columns = [];
            if (options.defaults)
                object.filter = options.enums === String ? "NONE" : 0;
            if (message.filter != null && message.hasOwnProperty("filter"))
                object.filter = options.enums === String ? $root.NTentaclesApi.EPodFilter[message.filter] : message.filter;
            if (message.columns && message.columns.length) {
                object.columns = [];
                for (let j = 0; j < message.columns.length; ++j)
                    object.columns[j] = message.columns[j];
            }
            return object;
        };

        /**
         * Converts this TSlice to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TSlice
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TSlice.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TSlice;
    })();

    NTentaclesApi.TWallePipelineNode = (function() {

        /**
         * Properties of a TWallePipelineNode.
         * @memberof NTentaclesApi
         * @interface ITWallePipelineNode
         * @property {number|null} [excluded_decommissioned_nodes_count] TWallePipelineNode excluded_decommissioned_nodes_count
         * @property {number|null} [excluded_probation_or_free_nodes_count] TWallePipelineNode excluded_probation_or_free_nodes_count
         * @property {Array.<NTentaclesApi.ITSlice>|null} [slices] TWallePipelineNode slices
         */

        /**
         * Constructs a new TWallePipelineNode.
         * @memberof NTentaclesApi
         * @classdesc Represents a TWallePipelineNode.
         * @implements ITWallePipelineNode
         * @constructor
         * @param {NTentaclesApi.ITWallePipelineNode=} [properties] Properties to set
         */
        function TWallePipelineNode(properties) {
            this.slices = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TWallePipelineNode excluded_decommissioned_nodes_count.
         * @member {number} excluded_decommissioned_nodes_count
         * @memberof NTentaclesApi.TWallePipelineNode
         * @instance
         */
        TWallePipelineNode.prototype.excluded_decommissioned_nodes_count = 0;

        /**
         * TWallePipelineNode excluded_probation_or_free_nodes_count.
         * @member {number} excluded_probation_or_free_nodes_count
         * @memberof NTentaclesApi.TWallePipelineNode
         * @instance
         */
        TWallePipelineNode.prototype.excluded_probation_or_free_nodes_count = 0;

        /**
         * TWallePipelineNode slices.
         * @member {Array.<NTentaclesApi.ITSlice>} slices
         * @memberof NTentaclesApi.TWallePipelineNode
         * @instance
         */
        TWallePipelineNode.prototype.slices = $util.emptyArray;

        /**
         * Creates a new TWallePipelineNode instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TWallePipelineNode
         * @static
         * @param {NTentaclesApi.ITWallePipelineNode=} [properties] Properties to set
         * @returns {NTentaclesApi.TWallePipelineNode} TWallePipelineNode instance
         */
        TWallePipelineNode.create = function create(properties) {
            return new TWallePipelineNode(properties);
        };

        /**
         * Encodes the specified TWallePipelineNode message. Does not implicitly {@link NTentaclesApi.TWallePipelineNode.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TWallePipelineNode
         * @static
         * @param {NTentaclesApi.ITWallePipelineNode} message TWallePipelineNode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TWallePipelineNode.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.excluded_decommissioned_nodes_count != null && Object.hasOwnProperty.call(message, "excluded_decommissioned_nodes_count"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.excluded_decommissioned_nodes_count);
            if (message.excluded_probation_or_free_nodes_count != null && Object.hasOwnProperty.call(message, "excluded_probation_or_free_nodes_count"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.excluded_probation_or_free_nodes_count);
            if (message.slices != null && message.slices.length)
                for (let i = 0; i < message.slices.length; ++i)
                    $root.NTentaclesApi.TSlice.encode(message.slices[i], writer.uint32(/* id 99, wireType 2 =*/794).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TWallePipelineNode message, length delimited. Does not implicitly {@link NTentaclesApi.TWallePipelineNode.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TWallePipelineNode
         * @static
         * @param {NTentaclesApi.ITWallePipelineNode} message TWallePipelineNode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TWallePipelineNode.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TWallePipelineNode message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TWallePipelineNode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TWallePipelineNode} TWallePipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TWallePipelineNode.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TWallePipelineNode();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.excluded_decommissioned_nodes_count = reader.uint32();
                    break;
                case 2:
                    message.excluded_probation_or_free_nodes_count = reader.uint32();
                    break;
                case 99:
                    if (!(message.slices && message.slices.length))
                        message.slices = [];
                    message.slices.push($root.NTentaclesApi.TSlice.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TWallePipelineNode message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TWallePipelineNode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TWallePipelineNode} TWallePipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TWallePipelineNode.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TWallePipelineNode message.
         * @function verify
         * @memberof NTentaclesApi.TWallePipelineNode
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TWallePipelineNode.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.excluded_decommissioned_nodes_count != null && message.hasOwnProperty("excluded_decommissioned_nodes_count"))
                if (!$util.isInteger(message.excluded_decommissioned_nodes_count))
                    return "excluded_decommissioned_nodes_count: integer expected";
            if (message.excluded_probation_or_free_nodes_count != null && message.hasOwnProperty("excluded_probation_or_free_nodes_count"))
                if (!$util.isInteger(message.excluded_probation_or_free_nodes_count))
                    return "excluded_probation_or_free_nodes_count: integer expected";
            if (message.slices != null && message.hasOwnProperty("slices")) {
                if (!Array.isArray(message.slices))
                    return "slices: array expected";
                for (let i = 0; i < message.slices.length; ++i) {
                    let error = $root.NTentaclesApi.TSlice.verify(message.slices[i]);
                    if (error)
                        return "slices." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TWallePipelineNode message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TWallePipelineNode
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TWallePipelineNode} TWallePipelineNode
         */
        TWallePipelineNode.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TWallePipelineNode)
                return object;
            let message = new $root.NTentaclesApi.TWallePipelineNode();
            if (object.excluded_decommissioned_nodes_count != null)
                message.excluded_decommissioned_nodes_count = object.excluded_decommissioned_nodes_count >>> 0;
            if (object.excluded_probation_or_free_nodes_count != null)
                message.excluded_probation_or_free_nodes_count = object.excluded_probation_or_free_nodes_count >>> 0;
            if (object.slices) {
                if (!Array.isArray(object.slices))
                    throw TypeError(".NTentaclesApi.TWallePipelineNode.slices: array expected");
                message.slices = [];
                for (let i = 0; i < object.slices.length; ++i) {
                    if (typeof object.slices[i] !== "object")
                        throw TypeError(".NTentaclesApi.TWallePipelineNode.slices: object expected");
                    message.slices[i] = $root.NTentaclesApi.TSlice.fromObject(object.slices[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TWallePipelineNode message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TWallePipelineNode
         * @static
         * @param {NTentaclesApi.TWallePipelineNode} message TWallePipelineNode
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TWallePipelineNode.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.slices = [];
            if (options.defaults) {
                object.excluded_decommissioned_nodes_count = 0;
                object.excluded_probation_or_free_nodes_count = 0;
            }
            if (message.excluded_decommissioned_nodes_count != null && message.hasOwnProperty("excluded_decommissioned_nodes_count"))
                object.excluded_decommissioned_nodes_count = message.excluded_decommissioned_nodes_count;
            if (message.excluded_probation_or_free_nodes_count != null && message.hasOwnProperty("excluded_probation_or_free_nodes_count"))
                object.excluded_probation_or_free_nodes_count = message.excluded_probation_or_free_nodes_count;
            if (message.slices && message.slices.length) {
                object.slices = [];
                for (let j = 0; j < message.slices.length; ++j)
                    object.slices[j] = $root.NTentaclesApi.TSlice.toObject(message.slices[j], options);
            }
            return object;
        };

        /**
         * Converts this TWallePipelineNode to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TWallePipelineNode
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TWallePipelineNode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TWallePipelineNode;
    })();

    NTentaclesApi.TAllocatorPipelineNode = (function() {

        /**
         * Properties of a TAllocatorPipelineNode.
         * @memberof NTentaclesApi
         * @interface ITAllocatorPipelineNode
         * @property {number|null} [total_nodes_count] TAllocatorPipelineNode total_nodes_count
         * @property {number|null} [total_pods_count] TAllocatorPipelineNode total_pods_count
         * @property {number|null} [pods_scheduling_errors] TAllocatorPipelineNode pods_scheduling_errors
         * @property {number|null} [unused_nodes_count] TAllocatorPipelineNode unused_nodes_count
         * @property {Array.<NTentaclesApi.ITSlice>|null} [slices] TAllocatorPipelineNode slices
         */

        /**
         * Constructs a new TAllocatorPipelineNode.
         * @memberof NTentaclesApi
         * @classdesc Represents a TAllocatorPipelineNode.
         * @implements ITAllocatorPipelineNode
         * @constructor
         * @param {NTentaclesApi.ITAllocatorPipelineNode=} [properties] Properties to set
         */
        function TAllocatorPipelineNode(properties) {
            this.slices = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TAllocatorPipelineNode total_nodes_count.
         * @member {number} total_nodes_count
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @instance
         */
        TAllocatorPipelineNode.prototype.total_nodes_count = 0;

        /**
         * TAllocatorPipelineNode total_pods_count.
         * @member {number} total_pods_count
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @instance
         */
        TAllocatorPipelineNode.prototype.total_pods_count = 0;

        /**
         * TAllocatorPipelineNode pods_scheduling_errors.
         * @member {number} pods_scheduling_errors
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @instance
         */
        TAllocatorPipelineNode.prototype.pods_scheduling_errors = 0;

        /**
         * TAllocatorPipelineNode unused_nodes_count.
         * @member {number} unused_nodes_count
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @instance
         */
        TAllocatorPipelineNode.prototype.unused_nodes_count = 0;

        /**
         * TAllocatorPipelineNode slices.
         * @member {Array.<NTentaclesApi.ITSlice>} slices
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @instance
         */
        TAllocatorPipelineNode.prototype.slices = $util.emptyArray;

        /**
         * Creates a new TAllocatorPipelineNode instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @static
         * @param {NTentaclesApi.ITAllocatorPipelineNode=} [properties] Properties to set
         * @returns {NTentaclesApi.TAllocatorPipelineNode} TAllocatorPipelineNode instance
         */
        TAllocatorPipelineNode.create = function create(properties) {
            return new TAllocatorPipelineNode(properties);
        };

        /**
         * Encodes the specified TAllocatorPipelineNode message. Does not implicitly {@link NTentaclesApi.TAllocatorPipelineNode.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @static
         * @param {NTentaclesApi.ITAllocatorPipelineNode} message TAllocatorPipelineNode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAllocatorPipelineNode.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.total_nodes_count != null && Object.hasOwnProperty.call(message, "total_nodes_count"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.total_nodes_count);
            if (message.total_pods_count != null && Object.hasOwnProperty.call(message, "total_pods_count"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.total_pods_count);
            if (message.pods_scheduling_errors != null && Object.hasOwnProperty.call(message, "pods_scheduling_errors"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.pods_scheduling_errors);
            if (message.unused_nodes_count != null && Object.hasOwnProperty.call(message, "unused_nodes_count"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.unused_nodes_count);
            if (message.slices != null && message.slices.length)
                for (let i = 0; i < message.slices.length; ++i)
                    $root.NTentaclesApi.TSlice.encode(message.slices[i], writer.uint32(/* id 99, wireType 2 =*/794).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TAllocatorPipelineNode message, length delimited. Does not implicitly {@link NTentaclesApi.TAllocatorPipelineNode.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @static
         * @param {NTentaclesApi.ITAllocatorPipelineNode} message TAllocatorPipelineNode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAllocatorPipelineNode.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TAllocatorPipelineNode message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TAllocatorPipelineNode} TAllocatorPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAllocatorPipelineNode.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TAllocatorPipelineNode();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.total_nodes_count = reader.uint32();
                    break;
                case 2:
                    message.total_pods_count = reader.uint32();
                    break;
                case 3:
                    message.pods_scheduling_errors = reader.uint32();
                    break;
                case 4:
                    message.unused_nodes_count = reader.uint32();
                    break;
                case 99:
                    if (!(message.slices && message.slices.length))
                        message.slices = [];
                    message.slices.push($root.NTentaclesApi.TSlice.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TAllocatorPipelineNode message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TAllocatorPipelineNode} TAllocatorPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAllocatorPipelineNode.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TAllocatorPipelineNode message.
         * @function verify
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TAllocatorPipelineNode.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.total_nodes_count != null && message.hasOwnProperty("total_nodes_count"))
                if (!$util.isInteger(message.total_nodes_count))
                    return "total_nodes_count: integer expected";
            if (message.total_pods_count != null && message.hasOwnProperty("total_pods_count"))
                if (!$util.isInteger(message.total_pods_count))
                    return "total_pods_count: integer expected";
            if (message.pods_scheduling_errors != null && message.hasOwnProperty("pods_scheduling_errors"))
                if (!$util.isInteger(message.pods_scheduling_errors))
                    return "pods_scheduling_errors: integer expected";
            if (message.unused_nodes_count != null && message.hasOwnProperty("unused_nodes_count"))
                if (!$util.isInteger(message.unused_nodes_count))
                    return "unused_nodes_count: integer expected";
            if (message.slices != null && message.hasOwnProperty("slices")) {
                if (!Array.isArray(message.slices))
                    return "slices: array expected";
                for (let i = 0; i < message.slices.length; ++i) {
                    let error = $root.NTentaclesApi.TSlice.verify(message.slices[i]);
                    if (error)
                        return "slices." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TAllocatorPipelineNode message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TAllocatorPipelineNode} TAllocatorPipelineNode
         */
        TAllocatorPipelineNode.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TAllocatorPipelineNode)
                return object;
            let message = new $root.NTentaclesApi.TAllocatorPipelineNode();
            if (object.total_nodes_count != null)
                message.total_nodes_count = object.total_nodes_count >>> 0;
            if (object.total_pods_count != null)
                message.total_pods_count = object.total_pods_count >>> 0;
            if (object.pods_scheduling_errors != null)
                message.pods_scheduling_errors = object.pods_scheduling_errors >>> 0;
            if (object.unused_nodes_count != null)
                message.unused_nodes_count = object.unused_nodes_count >>> 0;
            if (object.slices) {
                if (!Array.isArray(object.slices))
                    throw TypeError(".NTentaclesApi.TAllocatorPipelineNode.slices: array expected");
                message.slices = [];
                for (let i = 0; i < object.slices.length; ++i) {
                    if (typeof object.slices[i] !== "object")
                        throw TypeError(".NTentaclesApi.TAllocatorPipelineNode.slices: object expected");
                    message.slices[i] = $root.NTentaclesApi.TSlice.fromObject(object.slices[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TAllocatorPipelineNode message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @static
         * @param {NTentaclesApi.TAllocatorPipelineNode} message TAllocatorPipelineNode
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TAllocatorPipelineNode.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.slices = [];
            if (options.defaults) {
                object.total_nodes_count = 0;
                object.total_pods_count = 0;
                object.pods_scheduling_errors = 0;
                object.unused_nodes_count = 0;
            }
            if (message.total_nodes_count != null && message.hasOwnProperty("total_nodes_count"))
                object.total_nodes_count = message.total_nodes_count;
            if (message.total_pods_count != null && message.hasOwnProperty("total_pods_count"))
                object.total_pods_count = message.total_pods_count;
            if (message.pods_scheduling_errors != null && message.hasOwnProperty("pods_scheduling_errors"))
                object.pods_scheduling_errors = message.pods_scheduling_errors;
            if (message.unused_nodes_count != null && message.hasOwnProperty("unused_nodes_count"))
                object.unused_nodes_count = message.unused_nodes_count;
            if (message.slices && message.slices.length) {
                object.slices = [];
                for (let j = 0; j < message.slices.length; ++j)
                    object.slices[j] = $root.NTentaclesApi.TSlice.toObject(message.slices[j], options);
            }
            return object;
        };

        /**
         * Converts this TAllocatorPipelineNode to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TAllocatorPipelineNode
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TAllocatorPipelineNode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TAllocatorPipelineNode;
    })();

    NTentaclesApi.THqPipelineNode = (function() {

        /**
         * Properties of a THqPipelineNode.
         * @memberof NTentaclesApi
         * @interface ITHqPipelineNode
         * @property {number|null} [total_pods] THqPipelineNode total_pods
         * @property {Array.<NTentaclesApi.ITSlice>|null} [slices] THqPipelineNode slices
         */

        /**
         * Constructs a new THqPipelineNode.
         * @memberof NTentaclesApi
         * @classdesc Represents a THqPipelineNode.
         * @implements ITHqPipelineNode
         * @constructor
         * @param {NTentaclesApi.ITHqPipelineNode=} [properties] Properties to set
         */
        function THqPipelineNode(properties) {
            this.slices = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * THqPipelineNode total_pods.
         * @member {number} total_pods
         * @memberof NTentaclesApi.THqPipelineNode
         * @instance
         */
        THqPipelineNode.prototype.total_pods = 0;

        /**
         * THqPipelineNode slices.
         * @member {Array.<NTentaclesApi.ITSlice>} slices
         * @memberof NTentaclesApi.THqPipelineNode
         * @instance
         */
        THqPipelineNode.prototype.slices = $util.emptyArray;

        /**
         * Creates a new THqPipelineNode instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.THqPipelineNode
         * @static
         * @param {NTentaclesApi.ITHqPipelineNode=} [properties] Properties to set
         * @returns {NTentaclesApi.THqPipelineNode} THqPipelineNode instance
         */
        THqPipelineNode.create = function create(properties) {
            return new THqPipelineNode(properties);
        };

        /**
         * Encodes the specified THqPipelineNode message. Does not implicitly {@link NTentaclesApi.THqPipelineNode.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.THqPipelineNode
         * @static
         * @param {NTentaclesApi.ITHqPipelineNode} message THqPipelineNode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        THqPipelineNode.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.total_pods != null && Object.hasOwnProperty.call(message, "total_pods"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.total_pods);
            if (message.slices != null && message.slices.length)
                for (let i = 0; i < message.slices.length; ++i)
                    $root.NTentaclesApi.TSlice.encode(message.slices[i], writer.uint32(/* id 99, wireType 2 =*/794).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified THqPipelineNode message, length delimited. Does not implicitly {@link NTentaclesApi.THqPipelineNode.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.THqPipelineNode
         * @static
         * @param {NTentaclesApi.ITHqPipelineNode} message THqPipelineNode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        THqPipelineNode.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a THqPipelineNode message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.THqPipelineNode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.THqPipelineNode} THqPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        THqPipelineNode.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.THqPipelineNode();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.total_pods = reader.uint32();
                    break;
                case 99:
                    if (!(message.slices && message.slices.length))
                        message.slices = [];
                    message.slices.push($root.NTentaclesApi.TSlice.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a THqPipelineNode message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.THqPipelineNode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.THqPipelineNode} THqPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        THqPipelineNode.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a THqPipelineNode message.
         * @function verify
         * @memberof NTentaclesApi.THqPipelineNode
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        THqPipelineNode.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.total_pods != null && message.hasOwnProperty("total_pods"))
                if (!$util.isInteger(message.total_pods))
                    return "total_pods: integer expected";
            if (message.slices != null && message.hasOwnProperty("slices")) {
                if (!Array.isArray(message.slices))
                    return "slices: array expected";
                for (let i = 0; i < message.slices.length; ++i) {
                    let error = $root.NTentaclesApi.TSlice.verify(message.slices[i]);
                    if (error)
                        return "slices." + error;
                }
            }
            return null;
        };

        /**
         * Creates a THqPipelineNode message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.THqPipelineNode
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.THqPipelineNode} THqPipelineNode
         */
        THqPipelineNode.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.THqPipelineNode)
                return object;
            let message = new $root.NTentaclesApi.THqPipelineNode();
            if (object.total_pods != null)
                message.total_pods = object.total_pods >>> 0;
            if (object.slices) {
                if (!Array.isArray(object.slices))
                    throw TypeError(".NTentaclesApi.THqPipelineNode.slices: array expected");
                message.slices = [];
                for (let i = 0; i < object.slices.length; ++i) {
                    if (typeof object.slices[i] !== "object")
                        throw TypeError(".NTentaclesApi.THqPipelineNode.slices: object expected");
                    message.slices[i] = $root.NTentaclesApi.TSlice.fromObject(object.slices[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a THqPipelineNode message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.THqPipelineNode
         * @static
         * @param {NTentaclesApi.THqPipelineNode} message THqPipelineNode
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        THqPipelineNode.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.slices = [];
            if (options.defaults)
                object.total_pods = 0;
            if (message.total_pods != null && message.hasOwnProperty("total_pods"))
                object.total_pods = message.total_pods;
            if (message.slices && message.slices.length) {
                object.slices = [];
                for (let j = 0; j < message.slices.length; ++j)
                    object.slices[j] = $root.NTentaclesApi.TSlice.toObject(message.slices[j], options);
            }
            return object;
        };

        /**
         * Converts this THqPipelineNode to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.THqPipelineNode
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        THqPipelineNode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return THqPipelineNode;
    })();

    NTentaclesApi.TJugglerPipelineNode = (function() {

        /**
         * Properties of a TJugglerPipelineNode.
         * @memberof NTentaclesApi
         * @interface ITJugglerPipelineNode
         * @property {number|null} [total_pods] TJugglerPipelineNode total_pods
         * @property {number|null} [excluded_not_present] TJugglerPipelineNode excluded_not_present
         * @property {number|null} [excluded_not_visible] TJugglerPipelineNode excluded_not_visible
         * @property {Array.<NTentaclesApi.ITSlice>|null} [slices] TJugglerPipelineNode slices
         */

        /**
         * Constructs a new TJugglerPipelineNode.
         * @memberof NTentaclesApi
         * @classdesc Represents a TJugglerPipelineNode.
         * @implements ITJugglerPipelineNode
         * @constructor
         * @param {NTentaclesApi.ITJugglerPipelineNode=} [properties] Properties to set
         */
        function TJugglerPipelineNode(properties) {
            this.slices = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TJugglerPipelineNode total_pods.
         * @member {number} total_pods
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @instance
         */
        TJugglerPipelineNode.prototype.total_pods = 0;

        /**
         * TJugglerPipelineNode excluded_not_present.
         * @member {number} excluded_not_present
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @instance
         */
        TJugglerPipelineNode.prototype.excluded_not_present = 0;

        /**
         * TJugglerPipelineNode excluded_not_visible.
         * @member {number} excluded_not_visible
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @instance
         */
        TJugglerPipelineNode.prototype.excluded_not_visible = 0;

        /**
         * TJugglerPipelineNode slices.
         * @member {Array.<NTentaclesApi.ITSlice>} slices
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @instance
         */
        TJugglerPipelineNode.prototype.slices = $util.emptyArray;

        /**
         * Creates a new TJugglerPipelineNode instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @static
         * @param {NTentaclesApi.ITJugglerPipelineNode=} [properties] Properties to set
         * @returns {NTentaclesApi.TJugglerPipelineNode} TJugglerPipelineNode instance
         */
        TJugglerPipelineNode.create = function create(properties) {
            return new TJugglerPipelineNode(properties);
        };

        /**
         * Encodes the specified TJugglerPipelineNode message. Does not implicitly {@link NTentaclesApi.TJugglerPipelineNode.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @static
         * @param {NTentaclesApi.ITJugglerPipelineNode} message TJugglerPipelineNode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TJugglerPipelineNode.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.total_pods != null && Object.hasOwnProperty.call(message, "total_pods"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.total_pods);
            if (message.excluded_not_present != null && Object.hasOwnProperty.call(message, "excluded_not_present"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.excluded_not_present);
            if (message.excluded_not_visible != null && Object.hasOwnProperty.call(message, "excluded_not_visible"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.excluded_not_visible);
            if (message.slices != null && message.slices.length)
                for (let i = 0; i < message.slices.length; ++i)
                    $root.NTentaclesApi.TSlice.encode(message.slices[i], writer.uint32(/* id 99, wireType 2 =*/794).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TJugglerPipelineNode message, length delimited. Does not implicitly {@link NTentaclesApi.TJugglerPipelineNode.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @static
         * @param {NTentaclesApi.ITJugglerPipelineNode} message TJugglerPipelineNode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TJugglerPipelineNode.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TJugglerPipelineNode message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TJugglerPipelineNode} TJugglerPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TJugglerPipelineNode.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TJugglerPipelineNode();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.total_pods = reader.uint32();
                    break;
                case 2:
                    message.excluded_not_present = reader.uint32();
                    break;
                case 3:
                    message.excluded_not_visible = reader.uint32();
                    break;
                case 99:
                    if (!(message.slices && message.slices.length))
                        message.slices = [];
                    message.slices.push($root.NTentaclesApi.TSlice.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TJugglerPipelineNode message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TJugglerPipelineNode} TJugglerPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TJugglerPipelineNode.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TJugglerPipelineNode message.
         * @function verify
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TJugglerPipelineNode.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.total_pods != null && message.hasOwnProperty("total_pods"))
                if (!$util.isInteger(message.total_pods))
                    return "total_pods: integer expected";
            if (message.excluded_not_present != null && message.hasOwnProperty("excluded_not_present"))
                if (!$util.isInteger(message.excluded_not_present))
                    return "excluded_not_present: integer expected";
            if (message.excluded_not_visible != null && message.hasOwnProperty("excluded_not_visible"))
                if (!$util.isInteger(message.excluded_not_visible))
                    return "excluded_not_visible: integer expected";
            if (message.slices != null && message.hasOwnProperty("slices")) {
                if (!Array.isArray(message.slices))
                    return "slices: array expected";
                for (let i = 0; i < message.slices.length; ++i) {
                    let error = $root.NTentaclesApi.TSlice.verify(message.slices[i]);
                    if (error)
                        return "slices." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TJugglerPipelineNode message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TJugglerPipelineNode} TJugglerPipelineNode
         */
        TJugglerPipelineNode.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TJugglerPipelineNode)
                return object;
            let message = new $root.NTentaclesApi.TJugglerPipelineNode();
            if (object.total_pods != null)
                message.total_pods = object.total_pods >>> 0;
            if (object.excluded_not_present != null)
                message.excluded_not_present = object.excluded_not_present >>> 0;
            if (object.excluded_not_visible != null)
                message.excluded_not_visible = object.excluded_not_visible >>> 0;
            if (object.slices) {
                if (!Array.isArray(object.slices))
                    throw TypeError(".NTentaclesApi.TJugglerPipelineNode.slices: array expected");
                message.slices = [];
                for (let i = 0; i < object.slices.length; ++i) {
                    if (typeof object.slices[i] !== "object")
                        throw TypeError(".NTentaclesApi.TJugglerPipelineNode.slices: object expected");
                    message.slices[i] = $root.NTentaclesApi.TSlice.fromObject(object.slices[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TJugglerPipelineNode message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @static
         * @param {NTentaclesApi.TJugglerPipelineNode} message TJugglerPipelineNode
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TJugglerPipelineNode.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.slices = [];
            if (options.defaults) {
                object.total_pods = 0;
                object.excluded_not_present = 0;
                object.excluded_not_visible = 0;
            }
            if (message.total_pods != null && message.hasOwnProperty("total_pods"))
                object.total_pods = message.total_pods;
            if (message.excluded_not_present != null && message.hasOwnProperty("excluded_not_present"))
                object.excluded_not_present = message.excluded_not_present;
            if (message.excluded_not_visible != null && message.hasOwnProperty("excluded_not_visible"))
                object.excluded_not_visible = message.excluded_not_visible;
            if (message.slices && message.slices.length) {
                object.slices = [];
                for (let j = 0; j < message.slices.length; ++j)
                    object.slices[j] = $root.NTentaclesApi.TSlice.toObject(message.slices[j], options);
            }
            return object;
        };

        /**
         * Converts this TJugglerPipelineNode to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TJugglerPipelineNode
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TJugglerPipelineNode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TJugglerPipelineNode;
    })();

    NTentaclesApi.TAvailabilityPipelineNode = (function() {

        /**
         * Properties of a TAvailabilityPipelineNode.
         * @memberof NTentaclesApi
         * @interface ITAvailabilityPipelineNode
         * @property {number|null} [total_count] TAvailabilityPipelineNode total_count
         * @property {number|null} [ok_count] TAvailabilityPipelineNode ok_count
         * @property {number|null} [excluded_not_reachable] TAvailabilityPipelineNode excluded_not_reachable
         * @property {Array.<NTentaclesApi.ITSlice>|null} [slices] TAvailabilityPipelineNode slices
         */

        /**
         * Constructs a new TAvailabilityPipelineNode.
         * @memberof NTentaclesApi
         * @classdesc Represents a TAvailabilityPipelineNode.
         * @implements ITAvailabilityPipelineNode
         * @constructor
         * @param {NTentaclesApi.ITAvailabilityPipelineNode=} [properties] Properties to set
         */
        function TAvailabilityPipelineNode(properties) {
            this.slices = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TAvailabilityPipelineNode total_count.
         * @member {number} total_count
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @instance
         */
        TAvailabilityPipelineNode.prototype.total_count = 0;

        /**
         * TAvailabilityPipelineNode ok_count.
         * @member {number} ok_count
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @instance
         */
        TAvailabilityPipelineNode.prototype.ok_count = 0;

        /**
         * TAvailabilityPipelineNode excluded_not_reachable.
         * @member {number} excluded_not_reachable
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @instance
         */
        TAvailabilityPipelineNode.prototype.excluded_not_reachable = 0;

        /**
         * TAvailabilityPipelineNode slices.
         * @member {Array.<NTentaclesApi.ITSlice>} slices
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @instance
         */
        TAvailabilityPipelineNode.prototype.slices = $util.emptyArray;

        /**
         * Creates a new TAvailabilityPipelineNode instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @static
         * @param {NTentaclesApi.ITAvailabilityPipelineNode=} [properties] Properties to set
         * @returns {NTentaclesApi.TAvailabilityPipelineNode} TAvailabilityPipelineNode instance
         */
        TAvailabilityPipelineNode.create = function create(properties) {
            return new TAvailabilityPipelineNode(properties);
        };

        /**
         * Encodes the specified TAvailabilityPipelineNode message. Does not implicitly {@link NTentaclesApi.TAvailabilityPipelineNode.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @static
         * @param {NTentaclesApi.ITAvailabilityPipelineNode} message TAvailabilityPipelineNode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAvailabilityPipelineNode.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.total_count != null && Object.hasOwnProperty.call(message, "total_count"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.total_count);
            if (message.ok_count != null && Object.hasOwnProperty.call(message, "ok_count"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.ok_count);
            if (message.excluded_not_reachable != null && Object.hasOwnProperty.call(message, "excluded_not_reachable"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.excluded_not_reachable);
            if (message.slices != null && message.slices.length)
                for (let i = 0; i < message.slices.length; ++i)
                    $root.NTentaclesApi.TSlice.encode(message.slices[i], writer.uint32(/* id 99, wireType 2 =*/794).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TAvailabilityPipelineNode message, length delimited. Does not implicitly {@link NTentaclesApi.TAvailabilityPipelineNode.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @static
         * @param {NTentaclesApi.ITAvailabilityPipelineNode} message TAvailabilityPipelineNode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAvailabilityPipelineNode.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TAvailabilityPipelineNode message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TAvailabilityPipelineNode} TAvailabilityPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAvailabilityPipelineNode.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TAvailabilityPipelineNode();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.total_count = reader.uint32();
                    break;
                case 2:
                    message.ok_count = reader.uint32();
                    break;
                case 3:
                    message.excluded_not_reachable = reader.uint32();
                    break;
                case 99:
                    if (!(message.slices && message.slices.length))
                        message.slices = [];
                    message.slices.push($root.NTentaclesApi.TSlice.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TAvailabilityPipelineNode message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TAvailabilityPipelineNode} TAvailabilityPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAvailabilityPipelineNode.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TAvailabilityPipelineNode message.
         * @function verify
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TAvailabilityPipelineNode.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.total_count != null && message.hasOwnProperty("total_count"))
                if (!$util.isInteger(message.total_count))
                    return "total_count: integer expected";
            if (message.ok_count != null && message.hasOwnProperty("ok_count"))
                if (!$util.isInteger(message.ok_count))
                    return "ok_count: integer expected";
            if (message.excluded_not_reachable != null && message.hasOwnProperty("excluded_not_reachable"))
                if (!$util.isInteger(message.excluded_not_reachable))
                    return "excluded_not_reachable: integer expected";
            if (message.slices != null && message.hasOwnProperty("slices")) {
                if (!Array.isArray(message.slices))
                    return "slices: array expected";
                for (let i = 0; i < message.slices.length; ++i) {
                    let error = $root.NTentaclesApi.TSlice.verify(message.slices[i]);
                    if (error)
                        return "slices." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TAvailabilityPipelineNode message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TAvailabilityPipelineNode} TAvailabilityPipelineNode
         */
        TAvailabilityPipelineNode.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TAvailabilityPipelineNode)
                return object;
            let message = new $root.NTentaclesApi.TAvailabilityPipelineNode();
            if (object.total_count != null)
                message.total_count = object.total_count >>> 0;
            if (object.ok_count != null)
                message.ok_count = object.ok_count >>> 0;
            if (object.excluded_not_reachable != null)
                message.excluded_not_reachable = object.excluded_not_reachable >>> 0;
            if (object.slices) {
                if (!Array.isArray(object.slices))
                    throw TypeError(".NTentaclesApi.TAvailabilityPipelineNode.slices: array expected");
                message.slices = [];
                for (let i = 0; i < object.slices.length; ++i) {
                    if (typeof object.slices[i] !== "object")
                        throw TypeError(".NTentaclesApi.TAvailabilityPipelineNode.slices: object expected");
                    message.slices[i] = $root.NTentaclesApi.TSlice.fromObject(object.slices[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TAvailabilityPipelineNode message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @static
         * @param {NTentaclesApi.TAvailabilityPipelineNode} message TAvailabilityPipelineNode
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TAvailabilityPipelineNode.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.slices = [];
            if (options.defaults) {
                object.total_count = 0;
                object.ok_count = 0;
                object.excluded_not_reachable = 0;
            }
            if (message.total_count != null && message.hasOwnProperty("total_count"))
                object.total_count = message.total_count;
            if (message.ok_count != null && message.hasOwnProperty("ok_count"))
                object.ok_count = message.ok_count;
            if (message.excluded_not_reachable != null && message.hasOwnProperty("excluded_not_reachable"))
                object.excluded_not_reachable = message.excluded_not_reachable;
            if (message.slices && message.slices.length) {
                object.slices = [];
                for (let j = 0; j < message.slices.length; ++j)
                    object.slices[j] = $root.NTentaclesApi.TSlice.toObject(message.slices[j], options);
            }
            return object;
        };

        /**
         * Converts this TAvailabilityPipelineNode to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TAvailabilityPipelineNode
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TAvailabilityPipelineNode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TAvailabilityPipelineNode;
    })();

    NTentaclesApi.TRedeploymentPipelineNode = (function() {

        /**
         * Properties of a TRedeploymentPipelineNode.
         * @memberof NTentaclesApi
         * @interface ITRedeploymentPipelineNode
         * @property {number|null} [total_count] TRedeploymentPipelineNode total_count
         * @property {number|null} [ok_count] TRedeploymentPipelineNode ok_count
         * @property {Array.<NTentaclesApi.ITSlice>|null} [slices] TRedeploymentPipelineNode slices
         */

        /**
         * Constructs a new TRedeploymentPipelineNode.
         * @memberof NTentaclesApi
         * @classdesc Represents a TRedeploymentPipelineNode.
         * @implements ITRedeploymentPipelineNode
         * @constructor
         * @param {NTentaclesApi.ITRedeploymentPipelineNode=} [properties] Properties to set
         */
        function TRedeploymentPipelineNode(properties) {
            this.slices = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TRedeploymentPipelineNode total_count.
         * @member {number} total_count
         * @memberof NTentaclesApi.TRedeploymentPipelineNode
         * @instance
         */
        TRedeploymentPipelineNode.prototype.total_count = 0;

        /**
         * TRedeploymentPipelineNode ok_count.
         * @member {number} ok_count
         * @memberof NTentaclesApi.TRedeploymentPipelineNode
         * @instance
         */
        TRedeploymentPipelineNode.prototype.ok_count = 0;

        /**
         * TRedeploymentPipelineNode slices.
         * @member {Array.<NTentaclesApi.ITSlice>} slices
         * @memberof NTentaclesApi.TRedeploymentPipelineNode
         * @instance
         */
        TRedeploymentPipelineNode.prototype.slices = $util.emptyArray;

        /**
         * Creates a new TRedeploymentPipelineNode instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TRedeploymentPipelineNode
         * @static
         * @param {NTentaclesApi.ITRedeploymentPipelineNode=} [properties] Properties to set
         * @returns {NTentaclesApi.TRedeploymentPipelineNode} TRedeploymentPipelineNode instance
         */
        TRedeploymentPipelineNode.create = function create(properties) {
            return new TRedeploymentPipelineNode(properties);
        };

        /**
         * Encodes the specified TRedeploymentPipelineNode message. Does not implicitly {@link NTentaclesApi.TRedeploymentPipelineNode.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TRedeploymentPipelineNode
         * @static
         * @param {NTentaclesApi.ITRedeploymentPipelineNode} message TRedeploymentPipelineNode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TRedeploymentPipelineNode.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.total_count != null && Object.hasOwnProperty.call(message, "total_count"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.total_count);
            if (message.ok_count != null && Object.hasOwnProperty.call(message, "ok_count"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.ok_count);
            if (message.slices != null && message.slices.length)
                for (let i = 0; i < message.slices.length; ++i)
                    $root.NTentaclesApi.TSlice.encode(message.slices[i], writer.uint32(/* id 99, wireType 2 =*/794).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TRedeploymentPipelineNode message, length delimited. Does not implicitly {@link NTentaclesApi.TRedeploymentPipelineNode.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TRedeploymentPipelineNode
         * @static
         * @param {NTentaclesApi.ITRedeploymentPipelineNode} message TRedeploymentPipelineNode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TRedeploymentPipelineNode.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TRedeploymentPipelineNode message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TRedeploymentPipelineNode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TRedeploymentPipelineNode} TRedeploymentPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TRedeploymentPipelineNode.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TRedeploymentPipelineNode();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.total_count = reader.uint32();
                    break;
                case 2:
                    message.ok_count = reader.uint32();
                    break;
                case 99:
                    if (!(message.slices && message.slices.length))
                        message.slices = [];
                    message.slices.push($root.NTentaclesApi.TSlice.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TRedeploymentPipelineNode message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TRedeploymentPipelineNode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TRedeploymentPipelineNode} TRedeploymentPipelineNode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TRedeploymentPipelineNode.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TRedeploymentPipelineNode message.
         * @function verify
         * @memberof NTentaclesApi.TRedeploymentPipelineNode
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TRedeploymentPipelineNode.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.total_count != null && message.hasOwnProperty("total_count"))
                if (!$util.isInteger(message.total_count))
                    return "total_count: integer expected";
            if (message.ok_count != null && message.hasOwnProperty("ok_count"))
                if (!$util.isInteger(message.ok_count))
                    return "ok_count: integer expected";
            if (message.slices != null && message.hasOwnProperty("slices")) {
                if (!Array.isArray(message.slices))
                    return "slices: array expected";
                for (let i = 0; i < message.slices.length; ++i) {
                    let error = $root.NTentaclesApi.TSlice.verify(message.slices[i]);
                    if (error)
                        return "slices." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TRedeploymentPipelineNode message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TRedeploymentPipelineNode
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TRedeploymentPipelineNode} TRedeploymentPipelineNode
         */
        TRedeploymentPipelineNode.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TRedeploymentPipelineNode)
                return object;
            let message = new $root.NTentaclesApi.TRedeploymentPipelineNode();
            if (object.total_count != null)
                message.total_count = object.total_count >>> 0;
            if (object.ok_count != null)
                message.ok_count = object.ok_count >>> 0;
            if (object.slices) {
                if (!Array.isArray(object.slices))
                    throw TypeError(".NTentaclesApi.TRedeploymentPipelineNode.slices: array expected");
                message.slices = [];
                for (let i = 0; i < object.slices.length; ++i) {
                    if (typeof object.slices[i] !== "object")
                        throw TypeError(".NTentaclesApi.TRedeploymentPipelineNode.slices: object expected");
                    message.slices[i] = $root.NTentaclesApi.TSlice.fromObject(object.slices[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TRedeploymentPipelineNode message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TRedeploymentPipelineNode
         * @static
         * @param {NTentaclesApi.TRedeploymentPipelineNode} message TRedeploymentPipelineNode
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TRedeploymentPipelineNode.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.slices = [];
            if (options.defaults) {
                object.total_count = 0;
                object.ok_count = 0;
            }
            if (message.total_count != null && message.hasOwnProperty("total_count"))
                object.total_count = message.total_count;
            if (message.ok_count != null && message.hasOwnProperty("ok_count"))
                object.ok_count = message.ok_count;
            if (message.slices && message.slices.length) {
                object.slices = [];
                for (let j = 0; j < message.slices.length; ++j)
                    object.slices[j] = $root.NTentaclesApi.TSlice.toObject(message.slices[j], options);
            }
            return object;
        };

        /**
         * Converts this TRedeploymentPipelineNode to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TRedeploymentPipelineNode
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TRedeploymentPipelineNode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TRedeploymentPipelineNode;
    })();

    NTentaclesApi.TPipeline = (function() {

        /**
         * Properties of a TPipeline.
         * @memberof NTentaclesApi
         * @interface ITPipeline
         * @property {NTentaclesApi.ITWallePipelineNode|null} [walle_node] TPipeline walle_node
         * @property {NTentaclesApi.ITAllocatorPipelineNode|null} [allocator_node] TPipeline allocator_node
         * @property {NTentaclesApi.ITHqPipelineNode|null} [hq_node] TPipeline hq_node
         * @property {NTentaclesApi.ITJugglerPipelineNode|null} [juggler_node] TPipeline juggler_node
         * @property {NTentaclesApi.ITAvailabilityPipelineNode|null} [availability_node] TPipeline availability_node
         * @property {NTentaclesApi.ITRedeploymentPipelineNode|null} [redeployment_node] TPipeline redeployment_node
         */

        /**
         * Constructs a new TPipeline.
         * @memberof NTentaclesApi
         * @classdesc Represents a TPipeline.
         * @implements ITPipeline
         * @constructor
         * @param {NTentaclesApi.ITPipeline=} [properties] Properties to set
         */
        function TPipeline(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TPipeline walle_node.
         * @member {NTentaclesApi.ITWallePipelineNode|null|undefined} walle_node
         * @memberof NTentaclesApi.TPipeline
         * @instance
         */
        TPipeline.prototype.walle_node = null;

        /**
         * TPipeline allocator_node.
         * @member {NTentaclesApi.ITAllocatorPipelineNode|null|undefined} allocator_node
         * @memberof NTentaclesApi.TPipeline
         * @instance
         */
        TPipeline.prototype.allocator_node = null;

        /**
         * TPipeline hq_node.
         * @member {NTentaclesApi.ITHqPipelineNode|null|undefined} hq_node
         * @memberof NTentaclesApi.TPipeline
         * @instance
         */
        TPipeline.prototype.hq_node = null;

        /**
         * TPipeline juggler_node.
         * @member {NTentaclesApi.ITJugglerPipelineNode|null|undefined} juggler_node
         * @memberof NTentaclesApi.TPipeline
         * @instance
         */
        TPipeline.prototype.juggler_node = null;

        /**
         * TPipeline availability_node.
         * @member {NTentaclesApi.ITAvailabilityPipelineNode|null|undefined} availability_node
         * @memberof NTentaclesApi.TPipeline
         * @instance
         */
        TPipeline.prototype.availability_node = null;

        /**
         * TPipeline redeployment_node.
         * @member {NTentaclesApi.ITRedeploymentPipelineNode|null|undefined} redeployment_node
         * @memberof NTentaclesApi.TPipeline
         * @instance
         */
        TPipeline.prototype.redeployment_node = null;

        /**
         * Creates a new TPipeline instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TPipeline
         * @static
         * @param {NTentaclesApi.ITPipeline=} [properties] Properties to set
         * @returns {NTentaclesApi.TPipeline} TPipeline instance
         */
        TPipeline.create = function create(properties) {
            return new TPipeline(properties);
        };

        /**
         * Encodes the specified TPipeline message. Does not implicitly {@link NTentaclesApi.TPipeline.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TPipeline
         * @static
         * @param {NTentaclesApi.ITPipeline} message TPipeline message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TPipeline.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.walle_node != null && Object.hasOwnProperty.call(message, "walle_node"))
                $root.NTentaclesApi.TWallePipelineNode.encode(message.walle_node, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.allocator_node != null && Object.hasOwnProperty.call(message, "allocator_node"))
                $root.NTentaclesApi.TAllocatorPipelineNode.encode(message.allocator_node, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.hq_node != null && Object.hasOwnProperty.call(message, "hq_node"))
                $root.NTentaclesApi.THqPipelineNode.encode(message.hq_node, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.juggler_node != null && Object.hasOwnProperty.call(message, "juggler_node"))
                $root.NTentaclesApi.TJugglerPipelineNode.encode(message.juggler_node, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.availability_node != null && Object.hasOwnProperty.call(message, "availability_node"))
                $root.NTentaclesApi.TAvailabilityPipelineNode.encode(message.availability_node, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.redeployment_node != null && Object.hasOwnProperty.call(message, "redeployment_node"))
                $root.NTentaclesApi.TRedeploymentPipelineNode.encode(message.redeployment_node, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TPipeline message, length delimited. Does not implicitly {@link NTentaclesApi.TPipeline.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TPipeline
         * @static
         * @param {NTentaclesApi.ITPipeline} message TPipeline message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TPipeline.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TPipeline message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TPipeline
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TPipeline} TPipeline
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TPipeline.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TPipeline();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.walle_node = $root.NTentaclesApi.TWallePipelineNode.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.allocator_node = $root.NTentaclesApi.TAllocatorPipelineNode.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.hq_node = $root.NTentaclesApi.THqPipelineNode.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.juggler_node = $root.NTentaclesApi.TJugglerPipelineNode.decode(reader, reader.uint32());
                    break;
                case 5:
                    message.availability_node = $root.NTentaclesApi.TAvailabilityPipelineNode.decode(reader, reader.uint32());
                    break;
                case 6:
                    message.redeployment_node = $root.NTentaclesApi.TRedeploymentPipelineNode.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TPipeline message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TPipeline
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TPipeline} TPipeline
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TPipeline.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TPipeline message.
         * @function verify
         * @memberof NTentaclesApi.TPipeline
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TPipeline.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.walle_node != null && message.hasOwnProperty("walle_node")) {
                let error = $root.NTentaclesApi.TWallePipelineNode.verify(message.walle_node);
                if (error)
                    return "walle_node." + error;
            }
            if (message.allocator_node != null && message.hasOwnProperty("allocator_node")) {
                let error = $root.NTentaclesApi.TAllocatorPipelineNode.verify(message.allocator_node);
                if (error)
                    return "allocator_node." + error;
            }
            if (message.hq_node != null && message.hasOwnProperty("hq_node")) {
                let error = $root.NTentaclesApi.THqPipelineNode.verify(message.hq_node);
                if (error)
                    return "hq_node." + error;
            }
            if (message.juggler_node != null && message.hasOwnProperty("juggler_node")) {
                let error = $root.NTentaclesApi.TJugglerPipelineNode.verify(message.juggler_node);
                if (error)
                    return "juggler_node." + error;
            }
            if (message.availability_node != null && message.hasOwnProperty("availability_node")) {
                let error = $root.NTentaclesApi.TAvailabilityPipelineNode.verify(message.availability_node);
                if (error)
                    return "availability_node." + error;
            }
            if (message.redeployment_node != null && message.hasOwnProperty("redeployment_node")) {
                let error = $root.NTentaclesApi.TRedeploymentPipelineNode.verify(message.redeployment_node);
                if (error)
                    return "redeployment_node." + error;
            }
            return null;
        };

        /**
         * Creates a TPipeline message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TPipeline
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TPipeline} TPipeline
         */
        TPipeline.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TPipeline)
                return object;
            let message = new $root.NTentaclesApi.TPipeline();
            if (object.walle_node != null) {
                if (typeof object.walle_node !== "object")
                    throw TypeError(".NTentaclesApi.TPipeline.walle_node: object expected");
                message.walle_node = $root.NTentaclesApi.TWallePipelineNode.fromObject(object.walle_node);
            }
            if (object.allocator_node != null) {
                if (typeof object.allocator_node !== "object")
                    throw TypeError(".NTentaclesApi.TPipeline.allocator_node: object expected");
                message.allocator_node = $root.NTentaclesApi.TAllocatorPipelineNode.fromObject(object.allocator_node);
            }
            if (object.hq_node != null) {
                if (typeof object.hq_node !== "object")
                    throw TypeError(".NTentaclesApi.TPipeline.hq_node: object expected");
                message.hq_node = $root.NTentaclesApi.THqPipelineNode.fromObject(object.hq_node);
            }
            if (object.juggler_node != null) {
                if (typeof object.juggler_node !== "object")
                    throw TypeError(".NTentaclesApi.TPipeline.juggler_node: object expected");
                message.juggler_node = $root.NTentaclesApi.TJugglerPipelineNode.fromObject(object.juggler_node);
            }
            if (object.availability_node != null) {
                if (typeof object.availability_node !== "object")
                    throw TypeError(".NTentaclesApi.TPipeline.availability_node: object expected");
                message.availability_node = $root.NTentaclesApi.TAvailabilityPipelineNode.fromObject(object.availability_node);
            }
            if (object.redeployment_node != null) {
                if (typeof object.redeployment_node !== "object")
                    throw TypeError(".NTentaclesApi.TPipeline.redeployment_node: object expected");
                message.redeployment_node = $root.NTentaclesApi.TRedeploymentPipelineNode.fromObject(object.redeployment_node);
            }
            return message;
        };

        /**
         * Creates a plain object from a TPipeline message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TPipeline
         * @static
         * @param {NTentaclesApi.TPipeline} message TPipeline
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TPipeline.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.walle_node = null;
                object.allocator_node = null;
                object.hq_node = null;
                object.juggler_node = null;
                object.availability_node = null;
                object.redeployment_node = null;
            }
            if (message.walle_node != null && message.hasOwnProperty("walle_node"))
                object.walle_node = $root.NTentaclesApi.TWallePipelineNode.toObject(message.walle_node, options);
            if (message.allocator_node != null && message.hasOwnProperty("allocator_node"))
                object.allocator_node = $root.NTentaclesApi.TAllocatorPipelineNode.toObject(message.allocator_node, options);
            if (message.hq_node != null && message.hasOwnProperty("hq_node"))
                object.hq_node = $root.NTentaclesApi.THqPipelineNode.toObject(message.hq_node, options);
            if (message.juggler_node != null && message.hasOwnProperty("juggler_node"))
                object.juggler_node = $root.NTentaclesApi.TJugglerPipelineNode.toObject(message.juggler_node, options);
            if (message.availability_node != null && message.hasOwnProperty("availability_node"))
                object.availability_node = $root.NTentaclesApi.TAvailabilityPipelineNode.toObject(message.availability_node, options);
            if (message.redeployment_node != null && message.hasOwnProperty("redeployment_node"))
                object.redeployment_node = $root.NTentaclesApi.TRedeploymentPipelineNode.toObject(message.redeployment_node, options);
            return object;
        };

        /**
         * Converts this TPipeline to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TPipeline
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TPipeline.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TPipeline;
    })();

    NTentaclesApi.TManageSession = (function() {

        /**
         * Properties of a TManageSession.
         * @memberof NTentaclesApi
         * @interface ITManageSession
         * @property {number|null} [start_ts] TManageSession start_ts
         * @property {number|null} [end_ts] TManageSession end_ts
         * @property {Array.<string>|null} [nanny_links] TManageSession nanny_links
         * @property {Array.<string>|null} [taskgroups_ids] TManageSession taskgroups_ids
         * @property {Array.<string>|null} [snapshot_ids] TManageSession snapshot_ids
         * @property {boolean|null} [is_in_progress] TManageSession is_in_progress
         */

        /**
         * Constructs a new TManageSession.
         * @memberof NTentaclesApi
         * @classdesc Represents a TManageSession.
         * @implements ITManageSession
         * @constructor
         * @param {NTentaclesApi.ITManageSession=} [properties] Properties to set
         */
        function TManageSession(properties) {
            this.nanny_links = [];
            this.taskgroups_ids = [];
            this.snapshot_ids = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TManageSession start_ts.
         * @member {number} start_ts
         * @memberof NTentaclesApi.TManageSession
         * @instance
         */
        TManageSession.prototype.start_ts = 0;

        /**
         * TManageSession end_ts.
         * @member {number} end_ts
         * @memberof NTentaclesApi.TManageSession
         * @instance
         */
        TManageSession.prototype.end_ts = 0;

        /**
         * TManageSession nanny_links.
         * @member {Array.<string>} nanny_links
         * @memberof NTentaclesApi.TManageSession
         * @instance
         */
        TManageSession.prototype.nanny_links = $util.emptyArray;

        /**
         * TManageSession taskgroups_ids.
         * @member {Array.<string>} taskgroups_ids
         * @memberof NTentaclesApi.TManageSession
         * @instance
         */
        TManageSession.prototype.taskgroups_ids = $util.emptyArray;

        /**
         * TManageSession snapshot_ids.
         * @member {Array.<string>} snapshot_ids
         * @memberof NTentaclesApi.TManageSession
         * @instance
         */
        TManageSession.prototype.snapshot_ids = $util.emptyArray;

        /**
         * TManageSession is_in_progress.
         * @member {boolean} is_in_progress
         * @memberof NTentaclesApi.TManageSession
         * @instance
         */
        TManageSession.prototype.is_in_progress = false;

        /**
         * Creates a new TManageSession instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TManageSession
         * @static
         * @param {NTentaclesApi.ITManageSession=} [properties] Properties to set
         * @returns {NTentaclesApi.TManageSession} TManageSession instance
         */
        TManageSession.create = function create(properties) {
            return new TManageSession(properties);
        };

        /**
         * Encodes the specified TManageSession message. Does not implicitly {@link NTentaclesApi.TManageSession.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TManageSession
         * @static
         * @param {NTentaclesApi.ITManageSession} message TManageSession message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TManageSession.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.start_ts != null && Object.hasOwnProperty.call(message, "start_ts"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.start_ts);
            if (message.end_ts != null && Object.hasOwnProperty.call(message, "end_ts"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.end_ts);
            if (message.nanny_links != null && message.nanny_links.length)
                for (let i = 0; i < message.nanny_links.length; ++i)
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.nanny_links[i]);
            if (message.taskgroups_ids != null && message.taskgroups_ids.length)
                for (let i = 0; i < message.taskgroups_ids.length; ++i)
                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.taskgroups_ids[i]);
            if (message.snapshot_ids != null && message.snapshot_ids.length)
                for (let i = 0; i < message.snapshot_ids.length; ++i)
                    writer.uint32(/* id 5, wireType 2 =*/42).string(message.snapshot_ids[i]);
            if (message.is_in_progress != null && Object.hasOwnProperty.call(message, "is_in_progress"))
                writer.uint32(/* id 6, wireType 0 =*/48).bool(message.is_in_progress);
            return writer;
        };

        /**
         * Encodes the specified TManageSession message, length delimited. Does not implicitly {@link NTentaclesApi.TManageSession.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TManageSession
         * @static
         * @param {NTentaclesApi.ITManageSession} message TManageSession message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TManageSession.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TManageSession message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TManageSession
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TManageSession} TManageSession
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TManageSession.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TManageSession();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.start_ts = reader.uint32();
                    break;
                case 2:
                    message.end_ts = reader.uint32();
                    break;
                case 3:
                    if (!(message.nanny_links && message.nanny_links.length))
                        message.nanny_links = [];
                    message.nanny_links.push(reader.string());
                    break;
                case 4:
                    if (!(message.taskgroups_ids && message.taskgroups_ids.length))
                        message.taskgroups_ids = [];
                    message.taskgroups_ids.push(reader.string());
                    break;
                case 5:
                    if (!(message.snapshot_ids && message.snapshot_ids.length))
                        message.snapshot_ids = [];
                    message.snapshot_ids.push(reader.string());
                    break;
                case 6:
                    message.is_in_progress = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TManageSession message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TManageSession
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TManageSession} TManageSession
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TManageSession.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TManageSession message.
         * @function verify
         * @memberof NTentaclesApi.TManageSession
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TManageSession.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.start_ts != null && message.hasOwnProperty("start_ts"))
                if (!$util.isInteger(message.start_ts))
                    return "start_ts: integer expected";
            if (message.end_ts != null && message.hasOwnProperty("end_ts"))
                if (!$util.isInteger(message.end_ts))
                    return "end_ts: integer expected";
            if (message.nanny_links != null && message.hasOwnProperty("nanny_links")) {
                if (!Array.isArray(message.nanny_links))
                    return "nanny_links: array expected";
                for (let i = 0; i < message.nanny_links.length; ++i)
                    if (!$util.isString(message.nanny_links[i]))
                        return "nanny_links: string[] expected";
            }
            if (message.taskgroups_ids != null && message.hasOwnProperty("taskgroups_ids")) {
                if (!Array.isArray(message.taskgroups_ids))
                    return "taskgroups_ids: array expected";
                for (let i = 0; i < message.taskgroups_ids.length; ++i)
                    if (!$util.isString(message.taskgroups_ids[i]))
                        return "taskgroups_ids: string[] expected";
            }
            if (message.snapshot_ids != null && message.hasOwnProperty("snapshot_ids")) {
                if (!Array.isArray(message.snapshot_ids))
                    return "snapshot_ids: array expected";
                for (let i = 0; i < message.snapshot_ids.length; ++i)
                    if (!$util.isString(message.snapshot_ids[i]))
                        return "snapshot_ids: string[] expected";
            }
            if (message.is_in_progress != null && message.hasOwnProperty("is_in_progress"))
                if (typeof message.is_in_progress !== "boolean")
                    return "is_in_progress: boolean expected";
            return null;
        };

        /**
         * Creates a TManageSession message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TManageSession
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TManageSession} TManageSession
         */
        TManageSession.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TManageSession)
                return object;
            let message = new $root.NTentaclesApi.TManageSession();
            if (object.start_ts != null)
                message.start_ts = object.start_ts >>> 0;
            if (object.end_ts != null)
                message.end_ts = object.end_ts >>> 0;
            if (object.nanny_links) {
                if (!Array.isArray(object.nanny_links))
                    throw TypeError(".NTentaclesApi.TManageSession.nanny_links: array expected");
                message.nanny_links = [];
                for (let i = 0; i < object.nanny_links.length; ++i)
                    message.nanny_links[i] = String(object.nanny_links[i]);
            }
            if (object.taskgroups_ids) {
                if (!Array.isArray(object.taskgroups_ids))
                    throw TypeError(".NTentaclesApi.TManageSession.taskgroups_ids: array expected");
                message.taskgroups_ids = [];
                for (let i = 0; i < object.taskgroups_ids.length; ++i)
                    message.taskgroups_ids[i] = String(object.taskgroups_ids[i]);
            }
            if (object.snapshot_ids) {
                if (!Array.isArray(object.snapshot_ids))
                    throw TypeError(".NTentaclesApi.TManageSession.snapshot_ids: array expected");
                message.snapshot_ids = [];
                for (let i = 0; i < object.snapshot_ids.length; ++i)
                    message.snapshot_ids[i] = String(object.snapshot_ids[i]);
            }
            if (object.is_in_progress != null)
                message.is_in_progress = Boolean(object.is_in_progress);
            return message;
        };

        /**
         * Creates a plain object from a TManageSession message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TManageSession
         * @static
         * @param {NTentaclesApi.TManageSession} message TManageSession
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TManageSession.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults) {
                object.nanny_links = [];
                object.taskgroups_ids = [];
                object.snapshot_ids = [];
            }
            if (options.defaults) {
                object.start_ts = 0;
                object.end_ts = 0;
                object.is_in_progress = false;
            }
            if (message.start_ts != null && message.hasOwnProperty("start_ts"))
                object.start_ts = message.start_ts;
            if (message.end_ts != null && message.hasOwnProperty("end_ts"))
                object.end_ts = message.end_ts;
            if (message.nanny_links && message.nanny_links.length) {
                object.nanny_links = [];
                for (let j = 0; j < message.nanny_links.length; ++j)
                    object.nanny_links[j] = message.nanny_links[j];
            }
            if (message.taskgroups_ids && message.taskgroups_ids.length) {
                object.taskgroups_ids = [];
                for (let j = 0; j < message.taskgroups_ids.length; ++j)
                    object.taskgroups_ids[j] = message.taskgroups_ids[j];
            }
            if (message.snapshot_ids && message.snapshot_ids.length) {
                object.snapshot_ids = [];
                for (let j = 0; j < message.snapshot_ids.length; ++j)
                    object.snapshot_ids[j] = message.snapshot_ids[j];
            }
            if (message.is_in_progress != null && message.hasOwnProperty("is_in_progress"))
                object.is_in_progress = message.is_in_progress;
            return object;
        };

        /**
         * Converts this TManageSession to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TManageSession
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TManageSession.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TManageSession;
    })();

    NTentaclesApi.TManageProcessInfo = (function() {

        /**
         * Properties of a TManageProcessInfo.
         * @memberof NTentaclesApi
         * @interface ITManageProcessInfo
         * @property {NTentaclesApi.ITManageSession|null} [last_success_process] TManageProcessInfo last_success_process
         * @property {NTentaclesApi.ITManageSession|null} [current_process] TManageProcessInfo current_process
         * @property {number|null} [last_success_end_border_config] TManageProcessInfo last_success_end_border_config
         * @property {number|null} [current_length_border_config] TManageProcessInfo current_length_border_config
         * @property {number|null} [cooldown_config] TManageProcessInfo cooldown_config
         * @property {Array.<NTentaclesApi.ITManageSession>|null} [sessions] TManageProcessInfo sessions
         */

        /**
         * Constructs a new TManageProcessInfo.
         * @memberof NTentaclesApi
         * @classdesc Represents a TManageProcessInfo.
         * @implements ITManageProcessInfo
         * @constructor
         * @param {NTentaclesApi.ITManageProcessInfo=} [properties] Properties to set
         */
        function TManageProcessInfo(properties) {
            this.sessions = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TManageProcessInfo last_success_process.
         * @member {NTentaclesApi.ITManageSession|null|undefined} last_success_process
         * @memberof NTentaclesApi.TManageProcessInfo
         * @instance
         */
        TManageProcessInfo.prototype.last_success_process = null;

        /**
         * TManageProcessInfo current_process.
         * @member {NTentaclesApi.ITManageSession|null|undefined} current_process
         * @memberof NTentaclesApi.TManageProcessInfo
         * @instance
         */
        TManageProcessInfo.prototype.current_process = null;

        /**
         * TManageProcessInfo last_success_end_border_config.
         * @member {number} last_success_end_border_config
         * @memberof NTentaclesApi.TManageProcessInfo
         * @instance
         */
        TManageProcessInfo.prototype.last_success_end_border_config = 0;

        /**
         * TManageProcessInfo current_length_border_config.
         * @member {number} current_length_border_config
         * @memberof NTentaclesApi.TManageProcessInfo
         * @instance
         */
        TManageProcessInfo.prototype.current_length_border_config = 0;

        /**
         * TManageProcessInfo cooldown_config.
         * @member {number} cooldown_config
         * @memberof NTentaclesApi.TManageProcessInfo
         * @instance
         */
        TManageProcessInfo.prototype.cooldown_config = 0;

        /**
         * TManageProcessInfo sessions.
         * @member {Array.<NTentaclesApi.ITManageSession>} sessions
         * @memberof NTentaclesApi.TManageProcessInfo
         * @instance
         */
        TManageProcessInfo.prototype.sessions = $util.emptyArray;

        /**
         * Creates a new TManageProcessInfo instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TManageProcessInfo
         * @static
         * @param {NTentaclesApi.ITManageProcessInfo=} [properties] Properties to set
         * @returns {NTentaclesApi.TManageProcessInfo} TManageProcessInfo instance
         */
        TManageProcessInfo.create = function create(properties) {
            return new TManageProcessInfo(properties);
        };

        /**
         * Encodes the specified TManageProcessInfo message. Does not implicitly {@link NTentaclesApi.TManageProcessInfo.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TManageProcessInfo
         * @static
         * @param {NTentaclesApi.ITManageProcessInfo} message TManageProcessInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TManageProcessInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.last_success_process != null && Object.hasOwnProperty.call(message, "last_success_process"))
                $root.NTentaclesApi.TManageSession.encode(message.last_success_process, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.current_process != null && Object.hasOwnProperty.call(message, "current_process"))
                $root.NTentaclesApi.TManageSession.encode(message.current_process, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.last_success_end_border_config != null && Object.hasOwnProperty.call(message, "last_success_end_border_config"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.last_success_end_border_config);
            if (message.current_length_border_config != null && Object.hasOwnProperty.call(message, "current_length_border_config"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.current_length_border_config);
            if (message.cooldown_config != null && Object.hasOwnProperty.call(message, "cooldown_config"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.cooldown_config);
            if (message.sessions != null && message.sessions.length)
                for (let i = 0; i < message.sessions.length; ++i)
                    $root.NTentaclesApi.TManageSession.encode(message.sessions[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TManageProcessInfo message, length delimited. Does not implicitly {@link NTentaclesApi.TManageProcessInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TManageProcessInfo
         * @static
         * @param {NTentaclesApi.ITManageProcessInfo} message TManageProcessInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TManageProcessInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TManageProcessInfo message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TManageProcessInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TManageProcessInfo} TManageProcessInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TManageProcessInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TManageProcessInfo();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.last_success_process = $root.NTentaclesApi.TManageSession.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.current_process = $root.NTentaclesApi.TManageSession.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.last_success_end_border_config = reader.uint32();
                    break;
                case 4:
                    message.current_length_border_config = reader.uint32();
                    break;
                case 5:
                    message.cooldown_config = reader.uint32();
                    break;
                case 6:
                    if (!(message.sessions && message.sessions.length))
                        message.sessions = [];
                    message.sessions.push($root.NTentaclesApi.TManageSession.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TManageProcessInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TManageProcessInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TManageProcessInfo} TManageProcessInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TManageProcessInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TManageProcessInfo message.
         * @function verify
         * @memberof NTentaclesApi.TManageProcessInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TManageProcessInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.last_success_process != null && message.hasOwnProperty("last_success_process")) {
                let error = $root.NTentaclesApi.TManageSession.verify(message.last_success_process);
                if (error)
                    return "last_success_process." + error;
            }
            if (message.current_process != null && message.hasOwnProperty("current_process")) {
                let error = $root.NTentaclesApi.TManageSession.verify(message.current_process);
                if (error)
                    return "current_process." + error;
            }
            if (message.last_success_end_border_config != null && message.hasOwnProperty("last_success_end_border_config"))
                if (!$util.isInteger(message.last_success_end_border_config))
                    return "last_success_end_border_config: integer expected";
            if (message.current_length_border_config != null && message.hasOwnProperty("current_length_border_config"))
                if (!$util.isInteger(message.current_length_border_config))
                    return "current_length_border_config: integer expected";
            if (message.cooldown_config != null && message.hasOwnProperty("cooldown_config"))
                if (!$util.isInteger(message.cooldown_config))
                    return "cooldown_config: integer expected";
            if (message.sessions != null && message.hasOwnProperty("sessions")) {
                if (!Array.isArray(message.sessions))
                    return "sessions: array expected";
                for (let i = 0; i < message.sessions.length; ++i) {
                    let error = $root.NTentaclesApi.TManageSession.verify(message.sessions[i]);
                    if (error)
                        return "sessions." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TManageProcessInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TManageProcessInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TManageProcessInfo} TManageProcessInfo
         */
        TManageProcessInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TManageProcessInfo)
                return object;
            let message = new $root.NTentaclesApi.TManageProcessInfo();
            if (object.last_success_process != null) {
                if (typeof object.last_success_process !== "object")
                    throw TypeError(".NTentaclesApi.TManageProcessInfo.last_success_process: object expected");
                message.last_success_process = $root.NTentaclesApi.TManageSession.fromObject(object.last_success_process);
            }
            if (object.current_process != null) {
                if (typeof object.current_process !== "object")
                    throw TypeError(".NTentaclesApi.TManageProcessInfo.current_process: object expected");
                message.current_process = $root.NTentaclesApi.TManageSession.fromObject(object.current_process);
            }
            if (object.last_success_end_border_config != null)
                message.last_success_end_border_config = object.last_success_end_border_config >>> 0;
            if (object.current_length_border_config != null)
                message.current_length_border_config = object.current_length_border_config >>> 0;
            if (object.cooldown_config != null)
                message.cooldown_config = object.cooldown_config >>> 0;
            if (object.sessions) {
                if (!Array.isArray(object.sessions))
                    throw TypeError(".NTentaclesApi.TManageProcessInfo.sessions: array expected");
                message.sessions = [];
                for (let i = 0; i < object.sessions.length; ++i) {
                    if (typeof object.sessions[i] !== "object")
                        throw TypeError(".NTentaclesApi.TManageProcessInfo.sessions: object expected");
                    message.sessions[i] = $root.NTentaclesApi.TManageSession.fromObject(object.sessions[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TManageProcessInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TManageProcessInfo
         * @static
         * @param {NTentaclesApi.TManageProcessInfo} message TManageProcessInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TManageProcessInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.sessions = [];
            if (options.defaults) {
                object.last_success_process = null;
                object.current_process = null;
                object.last_success_end_border_config = 0;
                object.current_length_border_config = 0;
                object.cooldown_config = 0;
            }
            if (message.last_success_process != null && message.hasOwnProperty("last_success_process"))
                object.last_success_process = $root.NTentaclesApi.TManageSession.toObject(message.last_success_process, options);
            if (message.current_process != null && message.hasOwnProperty("current_process"))
                object.current_process = $root.NTentaclesApi.TManageSession.toObject(message.current_process, options);
            if (message.last_success_end_border_config != null && message.hasOwnProperty("last_success_end_border_config"))
                object.last_success_end_border_config = message.last_success_end_border_config;
            if (message.current_length_border_config != null && message.hasOwnProperty("current_length_border_config"))
                object.current_length_border_config = message.current_length_border_config;
            if (message.cooldown_config != null && message.hasOwnProperty("cooldown_config"))
                object.cooldown_config = message.cooldown_config;
            if (message.sessions && message.sessions.length) {
                object.sessions = [];
                for (let j = 0; j < message.sessions.length; ++j)
                    object.sessions[j] = $root.NTentaclesApi.TManageSession.toObject(message.sessions[j], options);
            }
            return object;
        };

        /**
         * Converts this TManageProcessInfo to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TManageProcessInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TManageProcessInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TManageProcessInfo;
    })();

    NTentaclesApi.TManageProcesses = (function() {

        /**
         * Properties of a TManageProcesses.
         * @memberof NTentaclesApi
         * @interface ITManageProcesses
         * @property {NTentaclesApi.ITManageProcessInfo|null} [redeployment] TManageProcesses redeployment
         * @property {NTentaclesApi.ITManageProcessInfo|null} [reallocation] TManageProcesses reallocation
         */

        /**
         * Constructs a new TManageProcesses.
         * @memberof NTentaclesApi
         * @classdesc Represents a TManageProcesses.
         * @implements ITManageProcesses
         * @constructor
         * @param {NTentaclesApi.ITManageProcesses=} [properties] Properties to set
         */
        function TManageProcesses(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TManageProcesses redeployment.
         * @member {NTentaclesApi.ITManageProcessInfo|null|undefined} redeployment
         * @memberof NTentaclesApi.TManageProcesses
         * @instance
         */
        TManageProcesses.prototype.redeployment = null;

        /**
         * TManageProcesses reallocation.
         * @member {NTentaclesApi.ITManageProcessInfo|null|undefined} reallocation
         * @memberof NTentaclesApi.TManageProcesses
         * @instance
         */
        TManageProcesses.prototype.reallocation = null;

        /**
         * Creates a new TManageProcesses instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TManageProcesses
         * @static
         * @param {NTentaclesApi.ITManageProcesses=} [properties] Properties to set
         * @returns {NTentaclesApi.TManageProcesses} TManageProcesses instance
         */
        TManageProcesses.create = function create(properties) {
            return new TManageProcesses(properties);
        };

        /**
         * Encodes the specified TManageProcesses message. Does not implicitly {@link NTentaclesApi.TManageProcesses.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TManageProcesses
         * @static
         * @param {NTentaclesApi.ITManageProcesses} message TManageProcesses message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TManageProcesses.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.redeployment != null && Object.hasOwnProperty.call(message, "redeployment"))
                $root.NTentaclesApi.TManageProcessInfo.encode(message.redeployment, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.reallocation != null && Object.hasOwnProperty.call(message, "reallocation"))
                $root.NTentaclesApi.TManageProcessInfo.encode(message.reallocation, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TManageProcesses message, length delimited. Does not implicitly {@link NTentaclesApi.TManageProcesses.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TManageProcesses
         * @static
         * @param {NTentaclesApi.ITManageProcesses} message TManageProcesses message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TManageProcesses.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TManageProcesses message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TManageProcesses
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TManageProcesses} TManageProcesses
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TManageProcesses.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TManageProcesses();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.redeployment = $root.NTentaclesApi.TManageProcessInfo.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.reallocation = $root.NTentaclesApi.TManageProcessInfo.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TManageProcesses message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TManageProcesses
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TManageProcesses} TManageProcesses
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TManageProcesses.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TManageProcesses message.
         * @function verify
         * @memberof NTentaclesApi.TManageProcesses
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TManageProcesses.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.redeployment != null && message.hasOwnProperty("redeployment")) {
                let error = $root.NTentaclesApi.TManageProcessInfo.verify(message.redeployment);
                if (error)
                    return "redeployment." + error;
            }
            if (message.reallocation != null && message.hasOwnProperty("reallocation")) {
                let error = $root.NTentaclesApi.TManageProcessInfo.verify(message.reallocation);
                if (error)
                    return "reallocation." + error;
            }
            return null;
        };

        /**
         * Creates a TManageProcesses message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TManageProcesses
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TManageProcesses} TManageProcesses
         */
        TManageProcesses.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TManageProcesses)
                return object;
            let message = new $root.NTentaclesApi.TManageProcesses();
            if (object.redeployment != null) {
                if (typeof object.redeployment !== "object")
                    throw TypeError(".NTentaclesApi.TManageProcesses.redeployment: object expected");
                message.redeployment = $root.NTentaclesApi.TManageProcessInfo.fromObject(object.redeployment);
            }
            if (object.reallocation != null) {
                if (typeof object.reallocation !== "object")
                    throw TypeError(".NTentaclesApi.TManageProcesses.reallocation: object expected");
                message.reallocation = $root.NTentaclesApi.TManageProcessInfo.fromObject(object.reallocation);
            }
            return message;
        };

        /**
         * Creates a plain object from a TManageProcesses message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TManageProcesses
         * @static
         * @param {NTentaclesApi.TManageProcesses} message TManageProcesses
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TManageProcesses.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.redeployment = null;
                object.reallocation = null;
            }
            if (message.redeployment != null && message.hasOwnProperty("redeployment"))
                object.redeployment = $root.NTentaclesApi.TManageProcessInfo.toObject(message.redeployment, options);
            if (message.reallocation != null && message.hasOwnProperty("reallocation"))
                object.reallocation = $root.NTentaclesApi.TManageProcessInfo.toObject(message.reallocation, options);
            return object;
        };

        /**
         * Converts this TManageProcesses to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TManageProcesses
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TManageProcesses.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TManageProcesses;
    })();

    NTentaclesApi.TAllocationZoneDetailsResult = (function() {

        /**
         * Properties of a TAllocationZoneDetailsResult.
         * @memberof NTentaclesApi
         * @interface ITAllocationZoneDetailsResult
         * @property {NTentaclesApi.ITAllocationZoneFeatures|null} [features] TAllocationZoneDetailsResult features
         * @property {NTentaclesApi.ITFreshness|null} [freshness] TAllocationZoneDetailsResult freshness
         * @property {NTentaclesApi.ITPipeline|null} [pipeline] TAllocationZoneDetailsResult pipeline
         * @property {NTentaclesApi.ITManageProcesses|null} [manage_processes] TAllocationZoneDetailsResult manage_processes
         */

        /**
         * Constructs a new TAllocationZoneDetailsResult.
         * @memberof NTentaclesApi
         * @classdesc Represents a TAllocationZoneDetailsResult.
         * @implements ITAllocationZoneDetailsResult
         * @constructor
         * @param {NTentaclesApi.ITAllocationZoneDetailsResult=} [properties] Properties to set
         */
        function TAllocationZoneDetailsResult(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TAllocationZoneDetailsResult features.
         * @member {NTentaclesApi.ITAllocationZoneFeatures|null|undefined} features
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @instance
         */
        TAllocationZoneDetailsResult.prototype.features = null;

        /**
         * TAllocationZoneDetailsResult freshness.
         * @member {NTentaclesApi.ITFreshness|null|undefined} freshness
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @instance
         */
        TAllocationZoneDetailsResult.prototype.freshness = null;

        /**
         * TAllocationZoneDetailsResult pipeline.
         * @member {NTentaclesApi.ITPipeline|null|undefined} pipeline
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @instance
         */
        TAllocationZoneDetailsResult.prototype.pipeline = null;

        /**
         * TAllocationZoneDetailsResult manage_processes.
         * @member {NTentaclesApi.ITManageProcesses|null|undefined} manage_processes
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @instance
         */
        TAllocationZoneDetailsResult.prototype.manage_processes = null;

        /**
         * Creates a new TAllocationZoneDetailsResult instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @static
         * @param {NTentaclesApi.ITAllocationZoneDetailsResult=} [properties] Properties to set
         * @returns {NTentaclesApi.TAllocationZoneDetailsResult} TAllocationZoneDetailsResult instance
         */
        TAllocationZoneDetailsResult.create = function create(properties) {
            return new TAllocationZoneDetailsResult(properties);
        };

        /**
         * Encodes the specified TAllocationZoneDetailsResult message. Does not implicitly {@link NTentaclesApi.TAllocationZoneDetailsResult.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @static
         * @param {NTentaclesApi.ITAllocationZoneDetailsResult} message TAllocationZoneDetailsResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAllocationZoneDetailsResult.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.features != null && Object.hasOwnProperty.call(message, "features"))
                $root.NTentaclesApi.TAllocationZoneFeatures.encode(message.features, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.freshness != null && Object.hasOwnProperty.call(message, "freshness"))
                $root.NTentaclesApi.TFreshness.encode(message.freshness, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.pipeline != null && Object.hasOwnProperty.call(message, "pipeline"))
                $root.NTentaclesApi.TPipeline.encode(message.pipeline, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.manage_processes != null && Object.hasOwnProperty.call(message, "manage_processes"))
                $root.NTentaclesApi.TManageProcesses.encode(message.manage_processes, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TAllocationZoneDetailsResult message, length delimited. Does not implicitly {@link NTentaclesApi.TAllocationZoneDetailsResult.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @static
         * @param {NTentaclesApi.ITAllocationZoneDetailsResult} message TAllocationZoneDetailsResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAllocationZoneDetailsResult.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TAllocationZoneDetailsResult message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TAllocationZoneDetailsResult} TAllocationZoneDetailsResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAllocationZoneDetailsResult.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TAllocationZoneDetailsResult();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.features = $root.NTentaclesApi.TAllocationZoneFeatures.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.freshness = $root.NTentaclesApi.TFreshness.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.pipeline = $root.NTentaclesApi.TPipeline.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.manage_processes = $root.NTentaclesApi.TManageProcesses.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TAllocationZoneDetailsResult message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TAllocationZoneDetailsResult} TAllocationZoneDetailsResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAllocationZoneDetailsResult.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TAllocationZoneDetailsResult message.
         * @function verify
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TAllocationZoneDetailsResult.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.features != null && message.hasOwnProperty("features")) {
                let error = $root.NTentaclesApi.TAllocationZoneFeatures.verify(message.features);
                if (error)
                    return "features." + error;
            }
            if (message.freshness != null && message.hasOwnProperty("freshness")) {
                let error = $root.NTentaclesApi.TFreshness.verify(message.freshness);
                if (error)
                    return "freshness." + error;
            }
            if (message.pipeline != null && message.hasOwnProperty("pipeline")) {
                let error = $root.NTentaclesApi.TPipeline.verify(message.pipeline);
                if (error)
                    return "pipeline." + error;
            }
            if (message.manage_processes != null && message.hasOwnProperty("manage_processes")) {
                let error = $root.NTentaclesApi.TManageProcesses.verify(message.manage_processes);
                if (error)
                    return "manage_processes." + error;
            }
            return null;
        };

        /**
         * Creates a TAllocationZoneDetailsResult message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TAllocationZoneDetailsResult} TAllocationZoneDetailsResult
         */
        TAllocationZoneDetailsResult.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TAllocationZoneDetailsResult)
                return object;
            let message = new $root.NTentaclesApi.TAllocationZoneDetailsResult();
            if (object.features != null) {
                if (typeof object.features !== "object")
                    throw TypeError(".NTentaclesApi.TAllocationZoneDetailsResult.features: object expected");
                message.features = $root.NTentaclesApi.TAllocationZoneFeatures.fromObject(object.features);
            }
            if (object.freshness != null) {
                if (typeof object.freshness !== "object")
                    throw TypeError(".NTentaclesApi.TAllocationZoneDetailsResult.freshness: object expected");
                message.freshness = $root.NTentaclesApi.TFreshness.fromObject(object.freshness);
            }
            if (object.pipeline != null) {
                if (typeof object.pipeline !== "object")
                    throw TypeError(".NTentaclesApi.TAllocationZoneDetailsResult.pipeline: object expected");
                message.pipeline = $root.NTentaclesApi.TPipeline.fromObject(object.pipeline);
            }
            if (object.manage_processes != null) {
                if (typeof object.manage_processes !== "object")
                    throw TypeError(".NTentaclesApi.TAllocationZoneDetailsResult.manage_processes: object expected");
                message.manage_processes = $root.NTentaclesApi.TManageProcesses.fromObject(object.manage_processes);
            }
            return message;
        };

        /**
         * Creates a plain object from a TAllocationZoneDetailsResult message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @static
         * @param {NTentaclesApi.TAllocationZoneDetailsResult} message TAllocationZoneDetailsResult
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TAllocationZoneDetailsResult.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.features = null;
                object.freshness = null;
                object.pipeline = null;
                object.manage_processes = null;
            }
            if (message.features != null && message.hasOwnProperty("features"))
                object.features = $root.NTentaclesApi.TAllocationZoneFeatures.toObject(message.features, options);
            if (message.freshness != null && message.hasOwnProperty("freshness"))
                object.freshness = $root.NTentaclesApi.TFreshness.toObject(message.freshness, options);
            if (message.pipeline != null && message.hasOwnProperty("pipeline"))
                object.pipeline = $root.NTentaclesApi.TPipeline.toObject(message.pipeline, options);
            if (message.manage_processes != null && message.hasOwnProperty("manage_processes"))
                object.manage_processes = $root.NTentaclesApi.TManageProcesses.toObject(message.manage_processes, options);
            return object;
        };

        /**
         * Converts this TAllocationZoneDetailsResult to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TAllocationZoneDetailsResult
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TAllocationZoneDetailsResult.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TAllocationZoneDetailsResult;
    })();

    NTentaclesApi.TAllocationZoneDetailsResponse = (function() {

        /**
         * Properties of a TAllocationZoneDetailsResponse.
         * @memberof NTentaclesApi
         * @interface ITAllocationZoneDetailsResponse
         * @property {NTentaclesApi.ITAllocationZoneDetailsResult|null} [result] TAllocationZoneDetailsResponse result
         */

        /**
         * Constructs a new TAllocationZoneDetailsResponse.
         * @memberof NTentaclesApi
         * @classdesc Represents a TAllocationZoneDetailsResponse.
         * @implements ITAllocationZoneDetailsResponse
         * @constructor
         * @param {NTentaclesApi.ITAllocationZoneDetailsResponse=} [properties] Properties to set
         */
        function TAllocationZoneDetailsResponse(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TAllocationZoneDetailsResponse result.
         * @member {NTentaclesApi.ITAllocationZoneDetailsResult|null|undefined} result
         * @memberof NTentaclesApi.TAllocationZoneDetailsResponse
         * @instance
         */
        TAllocationZoneDetailsResponse.prototype.result = null;

        /**
         * Creates a new TAllocationZoneDetailsResponse instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TAllocationZoneDetailsResponse
         * @static
         * @param {NTentaclesApi.ITAllocationZoneDetailsResponse=} [properties] Properties to set
         * @returns {NTentaclesApi.TAllocationZoneDetailsResponse} TAllocationZoneDetailsResponse instance
         */
        TAllocationZoneDetailsResponse.create = function create(properties) {
            return new TAllocationZoneDetailsResponse(properties);
        };

        /**
         * Encodes the specified TAllocationZoneDetailsResponse message. Does not implicitly {@link NTentaclesApi.TAllocationZoneDetailsResponse.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TAllocationZoneDetailsResponse
         * @static
         * @param {NTentaclesApi.ITAllocationZoneDetailsResponse} message TAllocationZoneDetailsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAllocationZoneDetailsResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.result != null && Object.hasOwnProperty.call(message, "result"))
                $root.NTentaclesApi.TAllocationZoneDetailsResult.encode(message.result, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TAllocationZoneDetailsResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TAllocationZoneDetailsResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TAllocationZoneDetailsResponse
         * @static
         * @param {NTentaclesApi.ITAllocationZoneDetailsResponse} message TAllocationZoneDetailsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAllocationZoneDetailsResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TAllocationZoneDetailsResponse message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TAllocationZoneDetailsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TAllocationZoneDetailsResponse} TAllocationZoneDetailsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAllocationZoneDetailsResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TAllocationZoneDetailsResponse();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.result = $root.NTentaclesApi.TAllocationZoneDetailsResult.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TAllocationZoneDetailsResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TAllocationZoneDetailsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TAllocationZoneDetailsResponse} TAllocationZoneDetailsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAllocationZoneDetailsResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TAllocationZoneDetailsResponse message.
         * @function verify
         * @memberof NTentaclesApi.TAllocationZoneDetailsResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TAllocationZoneDetailsResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.result != null && message.hasOwnProperty("result")) {
                let error = $root.NTentaclesApi.TAllocationZoneDetailsResult.verify(message.result);
                if (error)
                    return "result." + error;
            }
            return null;
        };

        /**
         * Creates a TAllocationZoneDetailsResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TAllocationZoneDetailsResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TAllocationZoneDetailsResponse} TAllocationZoneDetailsResponse
         */
        TAllocationZoneDetailsResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TAllocationZoneDetailsResponse)
                return object;
            let message = new $root.NTentaclesApi.TAllocationZoneDetailsResponse();
            if (object.result != null) {
                if (typeof object.result !== "object")
                    throw TypeError(".NTentaclesApi.TAllocationZoneDetailsResponse.result: object expected");
                message.result = $root.NTentaclesApi.TAllocationZoneDetailsResult.fromObject(object.result);
            }
            return message;
        };

        /**
         * Creates a plain object from a TAllocationZoneDetailsResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TAllocationZoneDetailsResponse
         * @static
         * @param {NTentaclesApi.TAllocationZoneDetailsResponse} message TAllocationZoneDetailsResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TAllocationZoneDetailsResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.result = null;
            if (message.result != null && message.hasOwnProperty("result"))
                object.result = $root.NTentaclesApi.TAllocationZoneDetailsResult.toObject(message.result, options);
            return object;
        };

        /**
         * Converts this TAllocationZoneDetailsResponse to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TAllocationZoneDetailsResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TAllocationZoneDetailsResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TAllocationZoneDetailsResponse;
    })();

    NTentaclesApi.TAllocationZoneDetailsRequest = (function() {

        /**
         * Properties of a TAllocationZoneDetailsRequest.
         * @memberof NTentaclesApi
         * @interface ITAllocationZoneDetailsRequest
         * @property {string|null} [allocation_zone_id] TAllocationZoneDetailsRequest allocation_zone_id
         */

        /**
         * Constructs a new TAllocationZoneDetailsRequest.
         * @memberof NTentaclesApi
         * @classdesc Represents a TAllocationZoneDetailsRequest.
         * @implements ITAllocationZoneDetailsRequest
         * @constructor
         * @param {NTentaclesApi.ITAllocationZoneDetailsRequest=} [properties] Properties to set
         */
        function TAllocationZoneDetailsRequest(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TAllocationZoneDetailsRequest allocation_zone_id.
         * @member {string} allocation_zone_id
         * @memberof NTentaclesApi.TAllocationZoneDetailsRequest
         * @instance
         */
        TAllocationZoneDetailsRequest.prototype.allocation_zone_id = "";

        /**
         * Creates a new TAllocationZoneDetailsRequest instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TAllocationZoneDetailsRequest
         * @static
         * @param {NTentaclesApi.ITAllocationZoneDetailsRequest=} [properties] Properties to set
         * @returns {NTentaclesApi.TAllocationZoneDetailsRequest} TAllocationZoneDetailsRequest instance
         */
        TAllocationZoneDetailsRequest.create = function create(properties) {
            return new TAllocationZoneDetailsRequest(properties);
        };

        /**
         * Encodes the specified TAllocationZoneDetailsRequest message. Does not implicitly {@link NTentaclesApi.TAllocationZoneDetailsRequest.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TAllocationZoneDetailsRequest
         * @static
         * @param {NTentaclesApi.ITAllocationZoneDetailsRequest} message TAllocationZoneDetailsRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAllocationZoneDetailsRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.allocation_zone_id != null && Object.hasOwnProperty.call(message, "allocation_zone_id"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.allocation_zone_id);
            return writer;
        };

        /**
         * Encodes the specified TAllocationZoneDetailsRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TAllocationZoneDetailsRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TAllocationZoneDetailsRequest
         * @static
         * @param {NTentaclesApi.ITAllocationZoneDetailsRequest} message TAllocationZoneDetailsRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAllocationZoneDetailsRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TAllocationZoneDetailsRequest message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TAllocationZoneDetailsRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TAllocationZoneDetailsRequest} TAllocationZoneDetailsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAllocationZoneDetailsRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TAllocationZoneDetailsRequest();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.allocation_zone_id = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TAllocationZoneDetailsRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TAllocationZoneDetailsRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TAllocationZoneDetailsRequest} TAllocationZoneDetailsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAllocationZoneDetailsRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TAllocationZoneDetailsRequest message.
         * @function verify
         * @memberof NTentaclesApi.TAllocationZoneDetailsRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TAllocationZoneDetailsRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.allocation_zone_id != null && message.hasOwnProperty("allocation_zone_id"))
                if (!$util.isString(message.allocation_zone_id))
                    return "allocation_zone_id: string expected";
            return null;
        };

        /**
         * Creates a TAllocationZoneDetailsRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TAllocationZoneDetailsRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TAllocationZoneDetailsRequest} TAllocationZoneDetailsRequest
         */
        TAllocationZoneDetailsRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TAllocationZoneDetailsRequest)
                return object;
            let message = new $root.NTentaclesApi.TAllocationZoneDetailsRequest();
            if (object.allocation_zone_id != null)
                message.allocation_zone_id = String(object.allocation_zone_id);
            return message;
        };

        /**
         * Creates a plain object from a TAllocationZoneDetailsRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TAllocationZoneDetailsRequest
         * @static
         * @param {NTentaclesApi.TAllocationZoneDetailsRequest} message TAllocationZoneDetailsRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TAllocationZoneDetailsRequest.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.allocation_zone_id = "";
            if (message.allocation_zone_id != null && message.hasOwnProperty("allocation_zone_id"))
                object.allocation_zone_id = message.allocation_zone_id;
            return object;
        };

        /**
         * Converts this TAllocationZoneDetailsRequest to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TAllocationZoneDetailsRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TAllocationZoneDetailsRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TAllocationZoneDetailsRequest;
    })();

    /**
     * EFeatureStatus enum.
     * @name NTentaclesApi.EFeatureStatus
     * @enum {number}
     * @property {number} UNKNOWN=0 UNKNOWN value
     * @property {number} BROKEN=1 BROKEN value
     * @property {number} OK=2 OK value
     */
    NTentaclesApi.EFeatureStatus = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "UNKNOWN"] = 0;
        values[valuesById[1] = "BROKEN"] = 1;
        values[valuesById[2] = "OK"] = 2;
        return values;
    })();

    NTentaclesApi.TDataFreshnessFeature = (function() {

        /**
         * Properties of a TDataFreshnessFeature.
         * @memberof NTentaclesApi
         * @interface ITDataFreshnessFeature
         * @property {NTentaclesApi.EFeatureStatus|null} [status] TDataFreshnessFeature status
         * @property {number|null} [data_timestamp] TDataFreshnessFeature data_timestamp
         */

        /**
         * Constructs a new TDataFreshnessFeature.
         * @memberof NTentaclesApi
         * @classdesc Represents a TDataFreshnessFeature.
         * @implements ITDataFreshnessFeature
         * @constructor
         * @param {NTentaclesApi.ITDataFreshnessFeature=} [properties] Properties to set
         */
        function TDataFreshnessFeature(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TDataFreshnessFeature status.
         * @member {NTentaclesApi.EFeatureStatus} status
         * @memberof NTentaclesApi.TDataFreshnessFeature
         * @instance
         */
        TDataFreshnessFeature.prototype.status = 0;

        /**
         * TDataFreshnessFeature data_timestamp.
         * @member {number} data_timestamp
         * @memberof NTentaclesApi.TDataFreshnessFeature
         * @instance
         */
        TDataFreshnessFeature.prototype.data_timestamp = 0;

        /**
         * Creates a new TDataFreshnessFeature instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TDataFreshnessFeature
         * @static
         * @param {NTentaclesApi.ITDataFreshnessFeature=} [properties] Properties to set
         * @returns {NTentaclesApi.TDataFreshnessFeature} TDataFreshnessFeature instance
         */
        TDataFreshnessFeature.create = function create(properties) {
            return new TDataFreshnessFeature(properties);
        };

        /**
         * Encodes the specified TDataFreshnessFeature message. Does not implicitly {@link NTentaclesApi.TDataFreshnessFeature.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TDataFreshnessFeature
         * @static
         * @param {NTentaclesApi.ITDataFreshnessFeature} message TDataFreshnessFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TDataFreshnessFeature.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.status != null && Object.hasOwnProperty.call(message, "status"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.status);
            if (message.data_timestamp != null && Object.hasOwnProperty.call(message, "data_timestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.data_timestamp);
            return writer;
        };

        /**
         * Encodes the specified TDataFreshnessFeature message, length delimited. Does not implicitly {@link NTentaclesApi.TDataFreshnessFeature.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TDataFreshnessFeature
         * @static
         * @param {NTentaclesApi.ITDataFreshnessFeature} message TDataFreshnessFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TDataFreshnessFeature.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TDataFreshnessFeature message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TDataFreshnessFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TDataFreshnessFeature} TDataFreshnessFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TDataFreshnessFeature.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TDataFreshnessFeature();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.status = reader.int32();
                    break;
                case 2:
                    message.data_timestamp = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TDataFreshnessFeature message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TDataFreshnessFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TDataFreshnessFeature} TDataFreshnessFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TDataFreshnessFeature.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TDataFreshnessFeature message.
         * @function verify
         * @memberof NTentaclesApi.TDataFreshnessFeature
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TDataFreshnessFeature.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.status != null && message.hasOwnProperty("status"))
                switch (message.status) {
                default:
                    return "status: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.data_timestamp != null && message.hasOwnProperty("data_timestamp"))
                if (!$util.isInteger(message.data_timestamp))
                    return "data_timestamp: integer expected";
            return null;
        };

        /**
         * Creates a TDataFreshnessFeature message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TDataFreshnessFeature
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TDataFreshnessFeature} TDataFreshnessFeature
         */
        TDataFreshnessFeature.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TDataFreshnessFeature)
                return object;
            let message = new $root.NTentaclesApi.TDataFreshnessFeature();
            switch (object.status) {
            case "UNKNOWN":
            case 0:
                message.status = 0;
                break;
            case "BROKEN":
            case 1:
                message.status = 1;
                break;
            case "OK":
            case 2:
                message.status = 2;
                break;
            }
            if (object.data_timestamp != null)
                message.data_timestamp = object.data_timestamp >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a TDataFreshnessFeature message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TDataFreshnessFeature
         * @static
         * @param {NTentaclesApi.TDataFreshnessFeature} message TDataFreshnessFeature
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TDataFreshnessFeature.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.status = options.enums === String ? "UNKNOWN" : 0;
                object.data_timestamp = 0;
            }
            if (message.status != null && message.hasOwnProperty("status"))
                object.status = options.enums === String ? $root.NTentaclesApi.EFeatureStatus[message.status] : message.status;
            if (message.data_timestamp != null && message.hasOwnProperty("data_timestamp"))
                object.data_timestamp = message.data_timestamp;
            return object;
        };

        /**
         * Converts this TDataFreshnessFeature to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TDataFreshnessFeature
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TDataFreshnessFeature.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TDataFreshnessFeature;
    })();

    NTentaclesApi.TAvailabilityFeature = (function() {

        /**
         * Properties of a TAvailabilityFeature.
         * @memberof NTentaclesApi
         * @interface ITAvailabilityFeature
         * @property {NTentaclesApi.EFeatureStatus|null} [status] TAvailabilityFeature status
         * @property {number|null} [ok_count] TAvailabilityFeature ok_count
         * @property {number|null} [total_count] TAvailabilityFeature total_count
         */

        /**
         * Constructs a new TAvailabilityFeature.
         * @memberof NTentaclesApi
         * @classdesc Represents a TAvailabilityFeature.
         * @implements ITAvailabilityFeature
         * @constructor
         * @param {NTentaclesApi.ITAvailabilityFeature=} [properties] Properties to set
         */
        function TAvailabilityFeature(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TAvailabilityFeature status.
         * @member {NTentaclesApi.EFeatureStatus} status
         * @memberof NTentaclesApi.TAvailabilityFeature
         * @instance
         */
        TAvailabilityFeature.prototype.status = 0;

        /**
         * TAvailabilityFeature ok_count.
         * @member {number} ok_count
         * @memberof NTentaclesApi.TAvailabilityFeature
         * @instance
         */
        TAvailabilityFeature.prototype.ok_count = 0;

        /**
         * TAvailabilityFeature total_count.
         * @member {number} total_count
         * @memberof NTentaclesApi.TAvailabilityFeature
         * @instance
         */
        TAvailabilityFeature.prototype.total_count = 0;

        /**
         * Creates a new TAvailabilityFeature instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TAvailabilityFeature
         * @static
         * @param {NTentaclesApi.ITAvailabilityFeature=} [properties] Properties to set
         * @returns {NTentaclesApi.TAvailabilityFeature} TAvailabilityFeature instance
         */
        TAvailabilityFeature.create = function create(properties) {
            return new TAvailabilityFeature(properties);
        };

        /**
         * Encodes the specified TAvailabilityFeature message. Does not implicitly {@link NTentaclesApi.TAvailabilityFeature.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TAvailabilityFeature
         * @static
         * @param {NTentaclesApi.ITAvailabilityFeature} message TAvailabilityFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAvailabilityFeature.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.status != null && Object.hasOwnProperty.call(message, "status"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.status);
            if (message.ok_count != null && Object.hasOwnProperty.call(message, "ok_count"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.ok_count);
            if (message.total_count != null && Object.hasOwnProperty.call(message, "total_count"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.total_count);
            return writer;
        };

        /**
         * Encodes the specified TAvailabilityFeature message, length delimited. Does not implicitly {@link NTentaclesApi.TAvailabilityFeature.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TAvailabilityFeature
         * @static
         * @param {NTentaclesApi.ITAvailabilityFeature} message TAvailabilityFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAvailabilityFeature.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TAvailabilityFeature message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TAvailabilityFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TAvailabilityFeature} TAvailabilityFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAvailabilityFeature.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TAvailabilityFeature();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.status = reader.int32();
                    break;
                case 2:
                    message.ok_count = reader.uint32();
                    break;
                case 3:
                    message.total_count = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TAvailabilityFeature message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TAvailabilityFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TAvailabilityFeature} TAvailabilityFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAvailabilityFeature.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TAvailabilityFeature message.
         * @function verify
         * @memberof NTentaclesApi.TAvailabilityFeature
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TAvailabilityFeature.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.status != null && message.hasOwnProperty("status"))
                switch (message.status) {
                default:
                    return "status: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.ok_count != null && message.hasOwnProperty("ok_count"))
                if (!$util.isInteger(message.ok_count))
                    return "ok_count: integer expected";
            if (message.total_count != null && message.hasOwnProperty("total_count"))
                if (!$util.isInteger(message.total_count))
                    return "total_count: integer expected";
            return null;
        };

        /**
         * Creates a TAvailabilityFeature message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TAvailabilityFeature
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TAvailabilityFeature} TAvailabilityFeature
         */
        TAvailabilityFeature.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TAvailabilityFeature)
                return object;
            let message = new $root.NTentaclesApi.TAvailabilityFeature();
            switch (object.status) {
            case "UNKNOWN":
            case 0:
                message.status = 0;
                break;
            case "BROKEN":
            case 1:
                message.status = 1;
                break;
            case "OK":
            case 2:
                message.status = 2;
                break;
            }
            if (object.ok_count != null)
                message.ok_count = object.ok_count >>> 0;
            if (object.total_count != null)
                message.total_count = object.total_count >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a TAvailabilityFeature message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TAvailabilityFeature
         * @static
         * @param {NTentaclesApi.TAvailabilityFeature} message TAvailabilityFeature
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TAvailabilityFeature.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.status = options.enums === String ? "UNKNOWN" : 0;
                object.ok_count = 0;
                object.total_count = 0;
            }
            if (message.status != null && message.hasOwnProperty("status"))
                object.status = options.enums === String ? $root.NTentaclesApi.EFeatureStatus[message.status] : message.status;
            if (message.ok_count != null && message.hasOwnProperty("ok_count"))
                object.ok_count = message.ok_count;
            if (message.total_count != null && message.hasOwnProperty("total_count"))
                object.total_count = message.total_count;
            return object;
        };

        /**
         * Converts this TAvailabilityFeature to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TAvailabilityFeature
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TAvailabilityFeature.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TAvailabilityFeature;
    })();

    NTentaclesApi.TRedeployFeature = (function() {

        /**
         * Properties of a TRedeployFeature.
         * @memberof NTentaclesApi
         * @interface ITRedeployFeature
         * @property {NTentaclesApi.EFeatureStatus|null} [status] TRedeployFeature status
         * @property {number|null} [ok_count] TRedeployFeature ok_count
         * @property {number|null} [total_count] TRedeployFeature total_count
         * @property {number|null} [last_success_redeploy_timestamp] TRedeployFeature last_success_redeploy_timestamp
         * @property {number|null} [current_redeploy_timestamp] TRedeployFeature current_redeploy_timestamp
         */

        /**
         * Constructs a new TRedeployFeature.
         * @memberof NTentaclesApi
         * @classdesc Represents a TRedeployFeature.
         * @implements ITRedeployFeature
         * @constructor
         * @param {NTentaclesApi.ITRedeployFeature=} [properties] Properties to set
         */
        function TRedeployFeature(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TRedeployFeature status.
         * @member {NTentaclesApi.EFeatureStatus} status
         * @memberof NTentaclesApi.TRedeployFeature
         * @instance
         */
        TRedeployFeature.prototype.status = 0;

        /**
         * TRedeployFeature ok_count.
         * @member {number} ok_count
         * @memberof NTentaclesApi.TRedeployFeature
         * @instance
         */
        TRedeployFeature.prototype.ok_count = 0;

        /**
         * TRedeployFeature total_count.
         * @member {number} total_count
         * @memberof NTentaclesApi.TRedeployFeature
         * @instance
         */
        TRedeployFeature.prototype.total_count = 0;

        /**
         * TRedeployFeature last_success_redeploy_timestamp.
         * @member {number} last_success_redeploy_timestamp
         * @memberof NTentaclesApi.TRedeployFeature
         * @instance
         */
        TRedeployFeature.prototype.last_success_redeploy_timestamp = 0;

        /**
         * TRedeployFeature current_redeploy_timestamp.
         * @member {number} current_redeploy_timestamp
         * @memberof NTentaclesApi.TRedeployFeature
         * @instance
         */
        TRedeployFeature.prototype.current_redeploy_timestamp = 0;

        /**
         * Creates a new TRedeployFeature instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TRedeployFeature
         * @static
         * @param {NTentaclesApi.ITRedeployFeature=} [properties] Properties to set
         * @returns {NTentaclesApi.TRedeployFeature} TRedeployFeature instance
         */
        TRedeployFeature.create = function create(properties) {
            return new TRedeployFeature(properties);
        };

        /**
         * Encodes the specified TRedeployFeature message. Does not implicitly {@link NTentaclesApi.TRedeployFeature.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TRedeployFeature
         * @static
         * @param {NTentaclesApi.ITRedeployFeature} message TRedeployFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TRedeployFeature.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.status != null && Object.hasOwnProperty.call(message, "status"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.status);
            if (message.ok_count != null && Object.hasOwnProperty.call(message, "ok_count"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.ok_count);
            if (message.total_count != null && Object.hasOwnProperty.call(message, "total_count"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.total_count);
            if (message.last_success_redeploy_timestamp != null && Object.hasOwnProperty.call(message, "last_success_redeploy_timestamp"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.last_success_redeploy_timestamp);
            if (message.current_redeploy_timestamp != null && Object.hasOwnProperty.call(message, "current_redeploy_timestamp"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.current_redeploy_timestamp);
            return writer;
        };

        /**
         * Encodes the specified TRedeployFeature message, length delimited. Does not implicitly {@link NTentaclesApi.TRedeployFeature.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TRedeployFeature
         * @static
         * @param {NTentaclesApi.ITRedeployFeature} message TRedeployFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TRedeployFeature.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TRedeployFeature message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TRedeployFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TRedeployFeature} TRedeployFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TRedeployFeature.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TRedeployFeature();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.status = reader.int32();
                    break;
                case 2:
                    message.ok_count = reader.uint32();
                    break;
                case 3:
                    message.total_count = reader.uint32();
                    break;
                case 4:
                    message.last_success_redeploy_timestamp = reader.uint32();
                    break;
                case 5:
                    message.current_redeploy_timestamp = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TRedeployFeature message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TRedeployFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TRedeployFeature} TRedeployFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TRedeployFeature.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TRedeployFeature message.
         * @function verify
         * @memberof NTentaclesApi.TRedeployFeature
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TRedeployFeature.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.status != null && message.hasOwnProperty("status"))
                switch (message.status) {
                default:
                    return "status: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.ok_count != null && message.hasOwnProperty("ok_count"))
                if (!$util.isInteger(message.ok_count))
                    return "ok_count: integer expected";
            if (message.total_count != null && message.hasOwnProperty("total_count"))
                if (!$util.isInteger(message.total_count))
                    return "total_count: integer expected";
            if (message.last_success_redeploy_timestamp != null && message.hasOwnProperty("last_success_redeploy_timestamp"))
                if (!$util.isInteger(message.last_success_redeploy_timestamp))
                    return "last_success_redeploy_timestamp: integer expected";
            if (message.current_redeploy_timestamp != null && message.hasOwnProperty("current_redeploy_timestamp"))
                if (!$util.isInteger(message.current_redeploy_timestamp))
                    return "current_redeploy_timestamp: integer expected";
            return null;
        };

        /**
         * Creates a TRedeployFeature message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TRedeployFeature
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TRedeployFeature} TRedeployFeature
         */
        TRedeployFeature.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TRedeployFeature)
                return object;
            let message = new $root.NTentaclesApi.TRedeployFeature();
            switch (object.status) {
            case "UNKNOWN":
            case 0:
                message.status = 0;
                break;
            case "BROKEN":
            case 1:
                message.status = 1;
                break;
            case "OK":
            case 2:
                message.status = 2;
                break;
            }
            if (object.ok_count != null)
                message.ok_count = object.ok_count >>> 0;
            if (object.total_count != null)
                message.total_count = object.total_count >>> 0;
            if (object.last_success_redeploy_timestamp != null)
                message.last_success_redeploy_timestamp = object.last_success_redeploy_timestamp >>> 0;
            if (object.current_redeploy_timestamp != null)
                message.current_redeploy_timestamp = object.current_redeploy_timestamp >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a TRedeployFeature message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TRedeployFeature
         * @static
         * @param {NTentaclesApi.TRedeployFeature} message TRedeployFeature
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TRedeployFeature.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.status = options.enums === String ? "UNKNOWN" : 0;
                object.ok_count = 0;
                object.total_count = 0;
                object.last_success_redeploy_timestamp = 0;
                object.current_redeploy_timestamp = 0;
            }
            if (message.status != null && message.hasOwnProperty("status"))
                object.status = options.enums === String ? $root.NTentaclesApi.EFeatureStatus[message.status] : message.status;
            if (message.ok_count != null && message.hasOwnProperty("ok_count"))
                object.ok_count = message.ok_count;
            if (message.total_count != null && message.hasOwnProperty("total_count"))
                object.total_count = message.total_count;
            if (message.last_success_redeploy_timestamp != null && message.hasOwnProperty("last_success_redeploy_timestamp"))
                object.last_success_redeploy_timestamp = message.last_success_redeploy_timestamp;
            if (message.current_redeploy_timestamp != null && message.hasOwnProperty("current_redeploy_timestamp"))
                object.current_redeploy_timestamp = message.current_redeploy_timestamp;
            return object;
        };

        /**
         * Converts this TRedeployFeature to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TRedeployFeature
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TRedeployFeature.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TRedeployFeature;
    })();

    NTentaclesApi.TReallocationFeature = (function() {

        /**
         * Properties of a TReallocationFeature.
         * @memberof NTentaclesApi
         * @interface ITReallocationFeature
         * @property {boolean|null} [enable] TReallocationFeature enable
         * @property {NTentaclesApi.EFeatureStatus|null} [status] TReallocationFeature status
         * @property {number|null} [last_success_reallocation_timestamp] TReallocationFeature last_success_reallocation_timestamp
         * @property {number|null} [current_reallocation_timestamp] TReallocationFeature current_reallocation_timestamp
         */

        /**
         * Constructs a new TReallocationFeature.
         * @memberof NTentaclesApi
         * @classdesc Represents a TReallocationFeature.
         * @implements ITReallocationFeature
         * @constructor
         * @param {NTentaclesApi.ITReallocationFeature=} [properties] Properties to set
         */
        function TReallocationFeature(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TReallocationFeature enable.
         * @member {boolean} enable
         * @memberof NTentaclesApi.TReallocationFeature
         * @instance
         */
        TReallocationFeature.prototype.enable = false;

        /**
         * TReallocationFeature status.
         * @member {NTentaclesApi.EFeatureStatus} status
         * @memberof NTentaclesApi.TReallocationFeature
         * @instance
         */
        TReallocationFeature.prototype.status = 0;

        /**
         * TReallocationFeature last_success_reallocation_timestamp.
         * @member {number} last_success_reallocation_timestamp
         * @memberof NTentaclesApi.TReallocationFeature
         * @instance
         */
        TReallocationFeature.prototype.last_success_reallocation_timestamp = 0;

        /**
         * TReallocationFeature current_reallocation_timestamp.
         * @member {number} current_reallocation_timestamp
         * @memberof NTentaclesApi.TReallocationFeature
         * @instance
         */
        TReallocationFeature.prototype.current_reallocation_timestamp = 0;

        /**
         * Creates a new TReallocationFeature instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TReallocationFeature
         * @static
         * @param {NTentaclesApi.ITReallocationFeature=} [properties] Properties to set
         * @returns {NTentaclesApi.TReallocationFeature} TReallocationFeature instance
         */
        TReallocationFeature.create = function create(properties) {
            return new TReallocationFeature(properties);
        };

        /**
         * Encodes the specified TReallocationFeature message. Does not implicitly {@link NTentaclesApi.TReallocationFeature.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TReallocationFeature
         * @static
         * @param {NTentaclesApi.ITReallocationFeature} message TReallocationFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReallocationFeature.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.enable != null && Object.hasOwnProperty.call(message, "enable"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.enable);
            if (message.status != null && Object.hasOwnProperty.call(message, "status"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.status);
            if (message.last_success_reallocation_timestamp != null && Object.hasOwnProperty.call(message, "last_success_reallocation_timestamp"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.last_success_reallocation_timestamp);
            if (message.current_reallocation_timestamp != null && Object.hasOwnProperty.call(message, "current_reallocation_timestamp"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.current_reallocation_timestamp);
            return writer;
        };

        /**
         * Encodes the specified TReallocationFeature message, length delimited. Does not implicitly {@link NTentaclesApi.TReallocationFeature.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TReallocationFeature
         * @static
         * @param {NTentaclesApi.ITReallocationFeature} message TReallocationFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReallocationFeature.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TReallocationFeature message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TReallocationFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TReallocationFeature} TReallocationFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReallocationFeature.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TReallocationFeature();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.enable = reader.bool();
                    break;
                case 2:
                    message.status = reader.int32();
                    break;
                case 3:
                    message.last_success_reallocation_timestamp = reader.uint32();
                    break;
                case 4:
                    message.current_reallocation_timestamp = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TReallocationFeature message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TReallocationFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TReallocationFeature} TReallocationFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReallocationFeature.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TReallocationFeature message.
         * @function verify
         * @memberof NTentaclesApi.TReallocationFeature
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TReallocationFeature.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.enable != null && message.hasOwnProperty("enable"))
                if (typeof message.enable !== "boolean")
                    return "enable: boolean expected";
            if (message.status != null && message.hasOwnProperty("status"))
                switch (message.status) {
                default:
                    return "status: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.last_success_reallocation_timestamp != null && message.hasOwnProperty("last_success_reallocation_timestamp"))
                if (!$util.isInteger(message.last_success_reallocation_timestamp))
                    return "last_success_reallocation_timestamp: integer expected";
            if (message.current_reallocation_timestamp != null && message.hasOwnProperty("current_reallocation_timestamp"))
                if (!$util.isInteger(message.current_reallocation_timestamp))
                    return "current_reallocation_timestamp: integer expected";
            return null;
        };

        /**
         * Creates a TReallocationFeature message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TReallocationFeature
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TReallocationFeature} TReallocationFeature
         */
        TReallocationFeature.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TReallocationFeature)
                return object;
            let message = new $root.NTentaclesApi.TReallocationFeature();
            if (object.enable != null)
                message.enable = Boolean(object.enable);
            switch (object.status) {
            case "UNKNOWN":
            case 0:
                message.status = 0;
                break;
            case "BROKEN":
            case 1:
                message.status = 1;
                break;
            case "OK":
            case 2:
                message.status = 2;
                break;
            }
            if (object.last_success_reallocation_timestamp != null)
                message.last_success_reallocation_timestamp = object.last_success_reallocation_timestamp >>> 0;
            if (object.current_reallocation_timestamp != null)
                message.current_reallocation_timestamp = object.current_reallocation_timestamp >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a TReallocationFeature message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TReallocationFeature
         * @static
         * @param {NTentaclesApi.TReallocationFeature} message TReallocationFeature
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TReallocationFeature.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.enable = false;
                object.status = options.enums === String ? "UNKNOWN" : 0;
                object.last_success_reallocation_timestamp = 0;
                object.current_reallocation_timestamp = 0;
            }
            if (message.enable != null && message.hasOwnProperty("enable"))
                object.enable = message.enable;
            if (message.status != null && message.hasOwnProperty("status"))
                object.status = options.enums === String ? $root.NTentaclesApi.EFeatureStatus[message.status] : message.status;
            if (message.last_success_reallocation_timestamp != null && message.hasOwnProperty("last_success_reallocation_timestamp"))
                object.last_success_reallocation_timestamp = message.last_success_reallocation_timestamp;
            if (message.current_reallocation_timestamp != null && message.hasOwnProperty("current_reallocation_timestamp"))
                object.current_reallocation_timestamp = message.current_reallocation_timestamp;
            return object;
        };

        /**
         * Converts this TReallocationFeature to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TReallocationFeature
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TReallocationFeature.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TReallocationFeature;
    })();

    NTentaclesApi.TUnusedNodesFeature = (function() {

        /**
         * Properties of a TUnusedNodesFeature.
         * @memberof NTentaclesApi
         * @interface ITUnusedNodesFeature
         * @property {boolean|null} [enable] TUnusedNodesFeature enable
         * @property {NTentaclesApi.EFeatureStatus|null} [status] TUnusedNodesFeature status
         * @property {number|null} [unused_count] TUnusedNodesFeature unused_count
         * @property {number|null} [total_count] TUnusedNodesFeature total_count
         */

        /**
         * Constructs a new TUnusedNodesFeature.
         * @memberof NTentaclesApi
         * @classdesc Represents a TUnusedNodesFeature.
         * @implements ITUnusedNodesFeature
         * @constructor
         * @param {NTentaclesApi.ITUnusedNodesFeature=} [properties] Properties to set
         */
        function TUnusedNodesFeature(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TUnusedNodesFeature enable.
         * @member {boolean} enable
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @instance
         */
        TUnusedNodesFeature.prototype.enable = false;

        /**
         * TUnusedNodesFeature status.
         * @member {NTentaclesApi.EFeatureStatus} status
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @instance
         */
        TUnusedNodesFeature.prototype.status = 0;

        /**
         * TUnusedNodesFeature unused_count.
         * @member {number} unused_count
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @instance
         */
        TUnusedNodesFeature.prototype.unused_count = 0;

        /**
         * TUnusedNodesFeature total_count.
         * @member {number} total_count
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @instance
         */
        TUnusedNodesFeature.prototype.total_count = 0;

        /**
         * Creates a new TUnusedNodesFeature instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @static
         * @param {NTentaclesApi.ITUnusedNodesFeature=} [properties] Properties to set
         * @returns {NTentaclesApi.TUnusedNodesFeature} TUnusedNodesFeature instance
         */
        TUnusedNodesFeature.create = function create(properties) {
            return new TUnusedNodesFeature(properties);
        };

        /**
         * Encodes the specified TUnusedNodesFeature message. Does not implicitly {@link NTentaclesApi.TUnusedNodesFeature.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @static
         * @param {NTentaclesApi.ITUnusedNodesFeature} message TUnusedNodesFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TUnusedNodesFeature.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.enable != null && Object.hasOwnProperty.call(message, "enable"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.enable);
            if (message.status != null && Object.hasOwnProperty.call(message, "status"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.status);
            if (message.unused_count != null && Object.hasOwnProperty.call(message, "unused_count"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.unused_count);
            if (message.total_count != null && Object.hasOwnProperty.call(message, "total_count"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.total_count);
            return writer;
        };

        /**
         * Encodes the specified TUnusedNodesFeature message, length delimited. Does not implicitly {@link NTentaclesApi.TUnusedNodesFeature.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @static
         * @param {NTentaclesApi.ITUnusedNodesFeature} message TUnusedNodesFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TUnusedNodesFeature.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TUnusedNodesFeature message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TUnusedNodesFeature} TUnusedNodesFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TUnusedNodesFeature.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TUnusedNodesFeature();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.enable = reader.bool();
                    break;
                case 2:
                    message.status = reader.int32();
                    break;
                case 3:
                    message.unused_count = reader.uint32();
                    break;
                case 4:
                    message.total_count = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TUnusedNodesFeature message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TUnusedNodesFeature} TUnusedNodesFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TUnusedNodesFeature.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TUnusedNodesFeature message.
         * @function verify
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TUnusedNodesFeature.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.enable != null && message.hasOwnProperty("enable"))
                if (typeof message.enable !== "boolean")
                    return "enable: boolean expected";
            if (message.status != null && message.hasOwnProperty("status"))
                switch (message.status) {
                default:
                    return "status: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.unused_count != null && message.hasOwnProperty("unused_count"))
                if (!$util.isInteger(message.unused_count))
                    return "unused_count: integer expected";
            if (message.total_count != null && message.hasOwnProperty("total_count"))
                if (!$util.isInteger(message.total_count))
                    return "total_count: integer expected";
            return null;
        };

        /**
         * Creates a TUnusedNodesFeature message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TUnusedNodesFeature} TUnusedNodesFeature
         */
        TUnusedNodesFeature.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TUnusedNodesFeature)
                return object;
            let message = new $root.NTentaclesApi.TUnusedNodesFeature();
            if (object.enable != null)
                message.enable = Boolean(object.enable);
            switch (object.status) {
            case "UNKNOWN":
            case 0:
                message.status = 0;
                break;
            case "BROKEN":
            case 1:
                message.status = 1;
                break;
            case "OK":
            case 2:
                message.status = 2;
                break;
            }
            if (object.unused_count != null)
                message.unused_count = object.unused_count >>> 0;
            if (object.total_count != null)
                message.total_count = object.total_count >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a TUnusedNodesFeature message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @static
         * @param {NTentaclesApi.TUnusedNodesFeature} message TUnusedNodesFeature
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TUnusedNodesFeature.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.enable = false;
                object.status = options.enums === String ? "UNKNOWN" : 0;
                object.unused_count = 0;
                object.total_count = 0;
            }
            if (message.enable != null && message.hasOwnProperty("enable"))
                object.enable = message.enable;
            if (message.status != null && message.hasOwnProperty("status"))
                object.status = options.enums === String ? $root.NTentaclesApi.EFeatureStatus[message.status] : message.status;
            if (message.unused_count != null && message.hasOwnProperty("unused_count"))
                object.unused_count = message.unused_count;
            if (message.total_count != null && message.hasOwnProperty("total_count"))
                object.total_count = message.total_count;
            return object;
        };

        /**
         * Converts this TUnusedNodesFeature to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TUnusedNodesFeature
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TUnusedNodesFeature.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TUnusedNodesFeature;
    })();

    NTentaclesApi.TSchedulingErrorsFeature = (function() {

        /**
         * Properties of a TSchedulingErrorsFeature.
         * @memberof NTentaclesApi
         * @interface ITSchedulingErrorsFeature
         * @property {boolean|null} [enable] TSchedulingErrorsFeature enable
         * @property {NTentaclesApi.EFeatureStatus|null} [status] TSchedulingErrorsFeature status
         * @property {number|null} [scheduling_errors_on_up_nodes_count] TSchedulingErrorsFeature scheduling_errors_on_up_nodes_count
         * @property {number|null} [total_up_nodes_count] TSchedulingErrorsFeature total_up_nodes_count
         */

        /**
         * Constructs a new TSchedulingErrorsFeature.
         * @memberof NTentaclesApi
         * @classdesc Represents a TSchedulingErrorsFeature.
         * @implements ITSchedulingErrorsFeature
         * @constructor
         * @param {NTentaclesApi.ITSchedulingErrorsFeature=} [properties] Properties to set
         */
        function TSchedulingErrorsFeature(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TSchedulingErrorsFeature enable.
         * @member {boolean} enable
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @instance
         */
        TSchedulingErrorsFeature.prototype.enable = false;

        /**
         * TSchedulingErrorsFeature status.
         * @member {NTentaclesApi.EFeatureStatus} status
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @instance
         */
        TSchedulingErrorsFeature.prototype.status = 0;

        /**
         * TSchedulingErrorsFeature scheduling_errors_on_up_nodes_count.
         * @member {number} scheduling_errors_on_up_nodes_count
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @instance
         */
        TSchedulingErrorsFeature.prototype.scheduling_errors_on_up_nodes_count = 0;

        /**
         * TSchedulingErrorsFeature total_up_nodes_count.
         * @member {number} total_up_nodes_count
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @instance
         */
        TSchedulingErrorsFeature.prototype.total_up_nodes_count = 0;

        /**
         * Creates a new TSchedulingErrorsFeature instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @static
         * @param {NTentaclesApi.ITSchedulingErrorsFeature=} [properties] Properties to set
         * @returns {NTentaclesApi.TSchedulingErrorsFeature} TSchedulingErrorsFeature instance
         */
        TSchedulingErrorsFeature.create = function create(properties) {
            return new TSchedulingErrorsFeature(properties);
        };

        /**
         * Encodes the specified TSchedulingErrorsFeature message. Does not implicitly {@link NTentaclesApi.TSchedulingErrorsFeature.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @static
         * @param {NTentaclesApi.ITSchedulingErrorsFeature} message TSchedulingErrorsFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TSchedulingErrorsFeature.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.enable != null && Object.hasOwnProperty.call(message, "enable"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.enable);
            if (message.status != null && Object.hasOwnProperty.call(message, "status"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.status);
            if (message.scheduling_errors_on_up_nodes_count != null && Object.hasOwnProperty.call(message, "scheduling_errors_on_up_nodes_count"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.scheduling_errors_on_up_nodes_count);
            if (message.total_up_nodes_count != null && Object.hasOwnProperty.call(message, "total_up_nodes_count"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.total_up_nodes_count);
            return writer;
        };

        /**
         * Encodes the specified TSchedulingErrorsFeature message, length delimited. Does not implicitly {@link NTentaclesApi.TSchedulingErrorsFeature.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @static
         * @param {NTentaclesApi.ITSchedulingErrorsFeature} message TSchedulingErrorsFeature message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TSchedulingErrorsFeature.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TSchedulingErrorsFeature message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TSchedulingErrorsFeature} TSchedulingErrorsFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TSchedulingErrorsFeature.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TSchedulingErrorsFeature();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.enable = reader.bool();
                    break;
                case 2:
                    message.status = reader.int32();
                    break;
                case 3:
                    message.scheduling_errors_on_up_nodes_count = reader.uint32();
                    break;
                case 4:
                    message.total_up_nodes_count = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TSchedulingErrorsFeature message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TSchedulingErrorsFeature} TSchedulingErrorsFeature
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TSchedulingErrorsFeature.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TSchedulingErrorsFeature message.
         * @function verify
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TSchedulingErrorsFeature.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.enable != null && message.hasOwnProperty("enable"))
                if (typeof message.enable !== "boolean")
                    return "enable: boolean expected";
            if (message.status != null && message.hasOwnProperty("status"))
                switch (message.status) {
                default:
                    return "status: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.scheduling_errors_on_up_nodes_count != null && message.hasOwnProperty("scheduling_errors_on_up_nodes_count"))
                if (!$util.isInteger(message.scheduling_errors_on_up_nodes_count))
                    return "scheduling_errors_on_up_nodes_count: integer expected";
            if (message.total_up_nodes_count != null && message.hasOwnProperty("total_up_nodes_count"))
                if (!$util.isInteger(message.total_up_nodes_count))
                    return "total_up_nodes_count: integer expected";
            return null;
        };

        /**
         * Creates a TSchedulingErrorsFeature message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TSchedulingErrorsFeature} TSchedulingErrorsFeature
         */
        TSchedulingErrorsFeature.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TSchedulingErrorsFeature)
                return object;
            let message = new $root.NTentaclesApi.TSchedulingErrorsFeature();
            if (object.enable != null)
                message.enable = Boolean(object.enable);
            switch (object.status) {
            case "UNKNOWN":
            case 0:
                message.status = 0;
                break;
            case "BROKEN":
            case 1:
                message.status = 1;
                break;
            case "OK":
            case 2:
                message.status = 2;
                break;
            }
            if (object.scheduling_errors_on_up_nodes_count != null)
                message.scheduling_errors_on_up_nodes_count = object.scheduling_errors_on_up_nodes_count >>> 0;
            if (object.total_up_nodes_count != null)
                message.total_up_nodes_count = object.total_up_nodes_count >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a TSchedulingErrorsFeature message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @static
         * @param {NTentaclesApi.TSchedulingErrorsFeature} message TSchedulingErrorsFeature
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TSchedulingErrorsFeature.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.enable = false;
                object.status = options.enums === String ? "UNKNOWN" : 0;
                object.scheduling_errors_on_up_nodes_count = 0;
                object.total_up_nodes_count = 0;
            }
            if (message.enable != null && message.hasOwnProperty("enable"))
                object.enable = message.enable;
            if (message.status != null && message.hasOwnProperty("status"))
                object.status = options.enums === String ? $root.NTentaclesApi.EFeatureStatus[message.status] : message.status;
            if (message.scheduling_errors_on_up_nodes_count != null && message.hasOwnProperty("scheduling_errors_on_up_nodes_count"))
                object.scheduling_errors_on_up_nodes_count = message.scheduling_errors_on_up_nodes_count;
            if (message.total_up_nodes_count != null && message.hasOwnProperty("total_up_nodes_count"))
                object.total_up_nodes_count = message.total_up_nodes_count;
            return object;
        };

        /**
         * Converts this TSchedulingErrorsFeature to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TSchedulingErrorsFeature
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TSchedulingErrorsFeature.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TSchedulingErrorsFeature;
    })();

    NTentaclesApi.TTags = (function() {

        /**
         * Properties of a TTags.
         * @memberof NTentaclesApi
         * @interface ITTags
         * @property {string|null} [location] TTags location
         * @property {string|null} [deploy_engine] TTags deploy_engine
         */

        /**
         * Constructs a new TTags.
         * @memberof NTentaclesApi
         * @classdesc Represents a TTags.
         * @implements ITTags
         * @constructor
         * @param {NTentaclesApi.ITTags=} [properties] Properties to set
         */
        function TTags(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TTags location.
         * @member {string} location
         * @memberof NTentaclesApi.TTags
         * @instance
         */
        TTags.prototype.location = "";

        /**
         * TTags deploy_engine.
         * @member {string} deploy_engine
         * @memberof NTentaclesApi.TTags
         * @instance
         */
        TTags.prototype.deploy_engine = "";

        /**
         * Creates a new TTags instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TTags
         * @static
         * @param {NTentaclesApi.ITTags=} [properties] Properties to set
         * @returns {NTentaclesApi.TTags} TTags instance
         */
        TTags.create = function create(properties) {
            return new TTags(properties);
        };

        /**
         * Encodes the specified TTags message. Does not implicitly {@link NTentaclesApi.TTags.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TTags
         * @static
         * @param {NTentaclesApi.ITTags} message TTags message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TTags.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.location != null && Object.hasOwnProperty.call(message, "location"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.location);
            if (message.deploy_engine != null && Object.hasOwnProperty.call(message, "deploy_engine"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.deploy_engine);
            return writer;
        };

        /**
         * Encodes the specified TTags message, length delimited. Does not implicitly {@link NTentaclesApi.TTags.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TTags
         * @static
         * @param {NTentaclesApi.ITTags} message TTags message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TTags.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TTags message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TTags
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TTags} TTags
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TTags.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TTags();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.location = reader.string();
                    break;
                case 2:
                    message.deploy_engine = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TTags message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TTags
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TTags} TTags
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TTags.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TTags message.
         * @function verify
         * @memberof NTentaclesApi.TTags
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TTags.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.location != null && message.hasOwnProperty("location"))
                if (!$util.isString(message.location))
                    return "location: string expected";
            if (message.deploy_engine != null && message.hasOwnProperty("deploy_engine"))
                if (!$util.isString(message.deploy_engine))
                    return "deploy_engine: string expected";
            return null;
        };

        /**
         * Creates a TTags message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TTags
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TTags} TTags
         */
        TTags.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TTags)
                return object;
            let message = new $root.NTentaclesApi.TTags();
            if (object.location != null)
                message.location = String(object.location);
            if (object.deploy_engine != null)
                message.deploy_engine = String(object.deploy_engine);
            return message;
        };

        /**
         * Creates a plain object from a TTags message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TTags
         * @static
         * @param {NTentaclesApi.TTags} message TTags
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TTags.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.location = "";
                object.deploy_engine = "";
            }
            if (message.location != null && message.hasOwnProperty("location"))
                object.location = message.location;
            if (message.deploy_engine != null && message.hasOwnProperty("deploy_engine"))
                object.deploy_engine = message.deploy_engine;
            return object;
        };

        /**
         * Converts this TTags to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TTags
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TTags.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TTags;
    })();

    NTentaclesApi.TAllocationZoneFeatures = (function() {

        /**
         * Properties of a TAllocationZoneFeatures.
         * @memberof NTentaclesApi
         * @interface ITAllocationZoneFeatures
         * @property {string|null} [allocation_zone] TAllocationZoneFeatures allocation_zone
         * @property {NTentaclesApi.ITDataFreshnessFeature|null} [data_freshness] TAllocationZoneFeatures data_freshness
         * @property {NTentaclesApi.ITAvailabilityFeature|null} [availability] TAllocationZoneFeatures availability
         * @property {NTentaclesApi.ITRedeployFeature|null} [redeploy] TAllocationZoneFeatures redeploy
         * @property {NTentaclesApi.ITReallocationFeature|null} [reallocation] TAllocationZoneFeatures reallocation
         * @property {NTentaclesApi.ITUnusedNodesFeature|null} [unused_nodes] TAllocationZoneFeatures unused_nodes
         * @property {NTentaclesApi.ITSchedulingErrorsFeature|null} [scheduling_errors] TAllocationZoneFeatures scheduling_errors
         * @property {NTentaclesApi.ITTags|null} [tags] TAllocationZoneFeatures tags
         */

        /**
         * Constructs a new TAllocationZoneFeatures.
         * @memberof NTentaclesApi
         * @classdesc Represents a TAllocationZoneFeatures.
         * @implements ITAllocationZoneFeatures
         * @constructor
         * @param {NTentaclesApi.ITAllocationZoneFeatures=} [properties] Properties to set
         */
        function TAllocationZoneFeatures(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TAllocationZoneFeatures allocation_zone.
         * @member {string} allocation_zone
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @instance
         */
        TAllocationZoneFeatures.prototype.allocation_zone = "";

        /**
         * TAllocationZoneFeatures data_freshness.
         * @member {NTentaclesApi.ITDataFreshnessFeature|null|undefined} data_freshness
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @instance
         */
        TAllocationZoneFeatures.prototype.data_freshness = null;

        /**
         * TAllocationZoneFeatures availability.
         * @member {NTentaclesApi.ITAvailabilityFeature|null|undefined} availability
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @instance
         */
        TAllocationZoneFeatures.prototype.availability = null;

        /**
         * TAllocationZoneFeatures redeploy.
         * @member {NTentaclesApi.ITRedeployFeature|null|undefined} redeploy
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @instance
         */
        TAllocationZoneFeatures.prototype.redeploy = null;

        /**
         * TAllocationZoneFeatures reallocation.
         * @member {NTentaclesApi.ITReallocationFeature|null|undefined} reallocation
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @instance
         */
        TAllocationZoneFeatures.prototype.reallocation = null;

        /**
         * TAllocationZoneFeatures unused_nodes.
         * @member {NTentaclesApi.ITUnusedNodesFeature|null|undefined} unused_nodes
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @instance
         */
        TAllocationZoneFeatures.prototype.unused_nodes = null;

        /**
         * TAllocationZoneFeatures scheduling_errors.
         * @member {NTentaclesApi.ITSchedulingErrorsFeature|null|undefined} scheduling_errors
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @instance
         */
        TAllocationZoneFeatures.prototype.scheduling_errors = null;

        /**
         * TAllocationZoneFeatures tags.
         * @member {NTentaclesApi.ITTags|null|undefined} tags
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @instance
         */
        TAllocationZoneFeatures.prototype.tags = null;

        /**
         * Creates a new TAllocationZoneFeatures instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @static
         * @param {NTentaclesApi.ITAllocationZoneFeatures=} [properties] Properties to set
         * @returns {NTentaclesApi.TAllocationZoneFeatures} TAllocationZoneFeatures instance
         */
        TAllocationZoneFeatures.create = function create(properties) {
            return new TAllocationZoneFeatures(properties);
        };

        /**
         * Encodes the specified TAllocationZoneFeatures message. Does not implicitly {@link NTentaclesApi.TAllocationZoneFeatures.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @static
         * @param {NTentaclesApi.ITAllocationZoneFeatures} message TAllocationZoneFeatures message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAllocationZoneFeatures.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.allocation_zone != null && Object.hasOwnProperty.call(message, "allocation_zone"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.allocation_zone);
            if (message.data_freshness != null && Object.hasOwnProperty.call(message, "data_freshness"))
                $root.NTentaclesApi.TDataFreshnessFeature.encode(message.data_freshness, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.availability != null && Object.hasOwnProperty.call(message, "availability"))
                $root.NTentaclesApi.TAvailabilityFeature.encode(message.availability, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.redeploy != null && Object.hasOwnProperty.call(message, "redeploy"))
                $root.NTentaclesApi.TRedeployFeature.encode(message.redeploy, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.reallocation != null && Object.hasOwnProperty.call(message, "reallocation"))
                $root.NTentaclesApi.TReallocationFeature.encode(message.reallocation, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.unused_nodes != null && Object.hasOwnProperty.call(message, "unused_nodes"))
                $root.NTentaclesApi.TUnusedNodesFeature.encode(message.unused_nodes, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.scheduling_errors != null && Object.hasOwnProperty.call(message, "scheduling_errors"))
                $root.NTentaclesApi.TSchedulingErrorsFeature.encode(message.scheduling_errors, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            if (message.tags != null && Object.hasOwnProperty.call(message, "tags"))
                $root.NTentaclesApi.TTags.encode(message.tags, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TAllocationZoneFeatures message, length delimited. Does not implicitly {@link NTentaclesApi.TAllocationZoneFeatures.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @static
         * @param {NTentaclesApi.ITAllocationZoneFeatures} message TAllocationZoneFeatures message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TAllocationZoneFeatures.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TAllocationZoneFeatures message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TAllocationZoneFeatures} TAllocationZoneFeatures
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAllocationZoneFeatures.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TAllocationZoneFeatures();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.allocation_zone = reader.string();
                    break;
                case 2:
                    message.data_freshness = $root.NTentaclesApi.TDataFreshnessFeature.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.availability = $root.NTentaclesApi.TAvailabilityFeature.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.redeploy = $root.NTentaclesApi.TRedeployFeature.decode(reader, reader.uint32());
                    break;
                case 5:
                    message.reallocation = $root.NTentaclesApi.TReallocationFeature.decode(reader, reader.uint32());
                    break;
                case 6:
                    message.unused_nodes = $root.NTentaclesApi.TUnusedNodesFeature.decode(reader, reader.uint32());
                    break;
                case 7:
                    message.scheduling_errors = $root.NTentaclesApi.TSchedulingErrorsFeature.decode(reader, reader.uint32());
                    break;
                case 8:
                    message.tags = $root.NTentaclesApi.TTags.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TAllocationZoneFeatures message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TAllocationZoneFeatures} TAllocationZoneFeatures
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TAllocationZoneFeatures.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TAllocationZoneFeatures message.
         * @function verify
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TAllocationZoneFeatures.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.allocation_zone != null && message.hasOwnProperty("allocation_zone"))
                if (!$util.isString(message.allocation_zone))
                    return "allocation_zone: string expected";
            if (message.data_freshness != null && message.hasOwnProperty("data_freshness")) {
                let error = $root.NTentaclesApi.TDataFreshnessFeature.verify(message.data_freshness);
                if (error)
                    return "data_freshness." + error;
            }
            if (message.availability != null && message.hasOwnProperty("availability")) {
                let error = $root.NTentaclesApi.TAvailabilityFeature.verify(message.availability);
                if (error)
                    return "availability." + error;
            }
            if (message.redeploy != null && message.hasOwnProperty("redeploy")) {
                let error = $root.NTentaclesApi.TRedeployFeature.verify(message.redeploy);
                if (error)
                    return "redeploy." + error;
            }
            if (message.reallocation != null && message.hasOwnProperty("reallocation")) {
                let error = $root.NTentaclesApi.TReallocationFeature.verify(message.reallocation);
                if (error)
                    return "reallocation." + error;
            }
            if (message.unused_nodes != null && message.hasOwnProperty("unused_nodes")) {
                let error = $root.NTentaclesApi.TUnusedNodesFeature.verify(message.unused_nodes);
                if (error)
                    return "unused_nodes." + error;
            }
            if (message.scheduling_errors != null && message.hasOwnProperty("scheduling_errors")) {
                let error = $root.NTentaclesApi.TSchedulingErrorsFeature.verify(message.scheduling_errors);
                if (error)
                    return "scheduling_errors." + error;
            }
            if (message.tags != null && message.hasOwnProperty("tags")) {
                let error = $root.NTentaclesApi.TTags.verify(message.tags);
                if (error)
                    return "tags." + error;
            }
            return null;
        };

        /**
         * Creates a TAllocationZoneFeatures message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TAllocationZoneFeatures} TAllocationZoneFeatures
         */
        TAllocationZoneFeatures.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TAllocationZoneFeatures)
                return object;
            let message = new $root.NTentaclesApi.TAllocationZoneFeatures();
            if (object.allocation_zone != null)
                message.allocation_zone = String(object.allocation_zone);
            if (object.data_freshness != null) {
                if (typeof object.data_freshness !== "object")
                    throw TypeError(".NTentaclesApi.TAllocationZoneFeatures.data_freshness: object expected");
                message.data_freshness = $root.NTentaclesApi.TDataFreshnessFeature.fromObject(object.data_freshness);
            }
            if (object.availability != null) {
                if (typeof object.availability !== "object")
                    throw TypeError(".NTentaclesApi.TAllocationZoneFeatures.availability: object expected");
                message.availability = $root.NTentaclesApi.TAvailabilityFeature.fromObject(object.availability);
            }
            if (object.redeploy != null) {
                if (typeof object.redeploy !== "object")
                    throw TypeError(".NTentaclesApi.TAllocationZoneFeatures.redeploy: object expected");
                message.redeploy = $root.NTentaclesApi.TRedeployFeature.fromObject(object.redeploy);
            }
            if (object.reallocation != null) {
                if (typeof object.reallocation !== "object")
                    throw TypeError(".NTentaclesApi.TAllocationZoneFeatures.reallocation: object expected");
                message.reallocation = $root.NTentaclesApi.TReallocationFeature.fromObject(object.reallocation);
            }
            if (object.unused_nodes != null) {
                if (typeof object.unused_nodes !== "object")
                    throw TypeError(".NTentaclesApi.TAllocationZoneFeatures.unused_nodes: object expected");
                message.unused_nodes = $root.NTentaclesApi.TUnusedNodesFeature.fromObject(object.unused_nodes);
            }
            if (object.scheduling_errors != null) {
                if (typeof object.scheduling_errors !== "object")
                    throw TypeError(".NTentaclesApi.TAllocationZoneFeatures.scheduling_errors: object expected");
                message.scheduling_errors = $root.NTentaclesApi.TSchedulingErrorsFeature.fromObject(object.scheduling_errors);
            }
            if (object.tags != null) {
                if (typeof object.tags !== "object")
                    throw TypeError(".NTentaclesApi.TAllocationZoneFeatures.tags: object expected");
                message.tags = $root.NTentaclesApi.TTags.fromObject(object.tags);
            }
            return message;
        };

        /**
         * Creates a plain object from a TAllocationZoneFeatures message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @static
         * @param {NTentaclesApi.TAllocationZoneFeatures} message TAllocationZoneFeatures
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TAllocationZoneFeatures.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.allocation_zone = "";
                object.data_freshness = null;
                object.availability = null;
                object.redeploy = null;
                object.reallocation = null;
                object.unused_nodes = null;
                object.scheduling_errors = null;
                object.tags = null;
            }
            if (message.allocation_zone != null && message.hasOwnProperty("allocation_zone"))
                object.allocation_zone = message.allocation_zone;
            if (message.data_freshness != null && message.hasOwnProperty("data_freshness"))
                object.data_freshness = $root.NTentaclesApi.TDataFreshnessFeature.toObject(message.data_freshness, options);
            if (message.availability != null && message.hasOwnProperty("availability"))
                object.availability = $root.NTentaclesApi.TAvailabilityFeature.toObject(message.availability, options);
            if (message.redeploy != null && message.hasOwnProperty("redeploy"))
                object.redeploy = $root.NTentaclesApi.TRedeployFeature.toObject(message.redeploy, options);
            if (message.reallocation != null && message.hasOwnProperty("reallocation"))
                object.reallocation = $root.NTentaclesApi.TReallocationFeature.toObject(message.reallocation, options);
            if (message.unused_nodes != null && message.hasOwnProperty("unused_nodes"))
                object.unused_nodes = $root.NTentaclesApi.TUnusedNodesFeature.toObject(message.unused_nodes, options);
            if (message.scheduling_errors != null && message.hasOwnProperty("scheduling_errors"))
                object.scheduling_errors = $root.NTentaclesApi.TSchedulingErrorsFeature.toObject(message.scheduling_errors, options);
            if (message.tags != null && message.hasOwnProperty("tags"))
                object.tags = $root.NTentaclesApi.TTags.toObject(message.tags, options);
            return object;
        };

        /**
         * Converts this TAllocationZoneFeatures to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TAllocationZoneFeatures
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TAllocationZoneFeatures.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TAllocationZoneFeatures;
    })();

    /**
     * EPodFilter enum.
     * @name NTentaclesApi.EPodFilter
     * @enum {number}
     * @property {number} NONE=0 NONE value
     * @property {number} EXCLUDED_DECOMMISSIONED_NODES=1 EXCLUDED_DECOMMISSIONED_NODES value
     * @property {number} EXCLUDED_PROBATION_OR_FREE_NODES=2 EXCLUDED_PROBATION_OR_FREE_NODES value
     * @property {number} PODS_SCHEDULING_ERRORS=3 PODS_SCHEDULING_ERRORS value
     * @property {number} UNUSED_YP_NODES=4 UNUSED_YP_NODES value
     * @property {number} EXCLUDED_NOT_PRESENT=5 EXCLUDED_NOT_PRESENT value
     * @property {number} EXCLUDED_NOT_VISIBLE=6 EXCLUDED_NOT_VISIBLE value
     * @property {number} EXCLUDED_NOT_REACHABLE=7 EXCLUDED_NOT_REACHABLE value
     */
    NTentaclesApi.EPodFilter = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "NONE"] = 0;
        values[valuesById[1] = "EXCLUDED_DECOMMISSIONED_NODES"] = 1;
        values[valuesById[2] = "EXCLUDED_PROBATION_OR_FREE_NODES"] = 2;
        values[valuesById[3] = "PODS_SCHEDULING_ERRORS"] = 3;
        values[valuesById[4] = "UNUSED_YP_NODES"] = 4;
        values[valuesById[5] = "EXCLUDED_NOT_PRESENT"] = 5;
        values[valuesById[6] = "EXCLUDED_NOT_VISIBLE"] = 6;
        values[valuesById[7] = "EXCLUDED_NOT_REACHABLE"] = 7;
        return values;
    })();

    /**
     * ESloType enum.
     * @name NTentaclesApi.ESloType
     * @enum {number}
     * @property {number} AVAILABILITY=0 AVAILABILITY value
     * @property {number} REDEPLOYED_ON_TIME=1 REDEPLOYED_ON_TIME value
     * @property {number} REALLOCATION=2 REALLOCATION value
     * @property {number} UNUSED_NODES=3 UNUSED_NODES value
     */
    NTentaclesApi.ESloType = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "AVAILABILITY"] = 0;
        values[valuesById[1] = "REDEPLOYED_ON_TIME"] = 1;
        values[valuesById[2] = "REALLOCATION"] = 2;
        values[valuesById[3] = "UNUSED_NODES"] = 3;
        return values;
    })();

    NTentaclesApi.TIncident = (function() {

        /**
         * Properties of a TIncident.
         * @memberof NTentaclesApi
         * @interface ITIncident
         * @property {string|null} [id] TIncident id
         * @property {number|null} [start_time_ts] TIncident start_time_ts
         * @property {number|null} [end_time_ts] TIncident end_time_ts
         * @property {string|null} [allocation_zone] TIncident allocation_zone
         * @property {NTentaclesApi.ESloType|null} [slo_type] TIncident slo_type
         * @property {string|null} [assignee] TIncident assignee
         * @property {number|null} [minutes_out_of_slo] TIncident minutes_out_of_slo
         * @property {string|null} [startrek_ticket_id] TIncident startrek_ticket_id
         */

        /**
         * Constructs a new TIncident.
         * @memberof NTentaclesApi
         * @classdesc Represents a TIncident.
         * @implements ITIncident
         * @constructor
         * @param {NTentaclesApi.ITIncident=} [properties] Properties to set
         */
        function TIncident(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TIncident id.
         * @member {string} id
         * @memberof NTentaclesApi.TIncident
         * @instance
         */
        TIncident.prototype.id = "";

        /**
         * TIncident start_time_ts.
         * @member {number} start_time_ts
         * @memberof NTentaclesApi.TIncident
         * @instance
         */
        TIncident.prototype.start_time_ts = 0;

        /**
         * TIncident end_time_ts.
         * @member {number} end_time_ts
         * @memberof NTentaclesApi.TIncident
         * @instance
         */
        TIncident.prototype.end_time_ts = 0;

        /**
         * TIncident allocation_zone.
         * @member {string} allocation_zone
         * @memberof NTentaclesApi.TIncident
         * @instance
         */
        TIncident.prototype.allocation_zone = "";

        /**
         * TIncident slo_type.
         * @member {NTentaclesApi.ESloType} slo_type
         * @memberof NTentaclesApi.TIncident
         * @instance
         */
        TIncident.prototype.slo_type = 0;

        /**
         * TIncident assignee.
         * @member {string} assignee
         * @memberof NTentaclesApi.TIncident
         * @instance
         */
        TIncident.prototype.assignee = "";

        /**
         * TIncident minutes_out_of_slo.
         * @member {number} minutes_out_of_slo
         * @memberof NTentaclesApi.TIncident
         * @instance
         */
        TIncident.prototype.minutes_out_of_slo = 0;

        /**
         * TIncident startrek_ticket_id.
         * @member {string} startrek_ticket_id
         * @memberof NTentaclesApi.TIncident
         * @instance
         */
        TIncident.prototype.startrek_ticket_id = "";

        /**
         * Creates a new TIncident instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TIncident
         * @static
         * @param {NTentaclesApi.ITIncident=} [properties] Properties to set
         * @returns {NTentaclesApi.TIncident} TIncident instance
         */
        TIncident.create = function create(properties) {
            return new TIncident(properties);
        };

        /**
         * Encodes the specified TIncident message. Does not implicitly {@link NTentaclesApi.TIncident.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TIncident
         * @static
         * @param {NTentaclesApi.ITIncident} message TIncident message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TIncident.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
            if (message.start_time_ts != null && Object.hasOwnProperty.call(message, "start_time_ts"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.start_time_ts);
            if (message.end_time_ts != null && Object.hasOwnProperty.call(message, "end_time_ts"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.end_time_ts);
            if (message.allocation_zone != null && Object.hasOwnProperty.call(message, "allocation_zone"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.allocation_zone);
            if (message.slo_type != null && Object.hasOwnProperty.call(message, "slo_type"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.slo_type);
            if (message.assignee != null && Object.hasOwnProperty.call(message, "assignee"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.assignee);
            if (message.minutes_out_of_slo != null && Object.hasOwnProperty.call(message, "minutes_out_of_slo"))
                writer.uint32(/* id 7, wireType 0 =*/56).uint32(message.minutes_out_of_slo);
            if (message.startrek_ticket_id != null && Object.hasOwnProperty.call(message, "startrek_ticket_id"))
                writer.uint32(/* id 8, wireType 2 =*/66).string(message.startrek_ticket_id);
            return writer;
        };

        /**
         * Encodes the specified TIncident message, length delimited. Does not implicitly {@link NTentaclesApi.TIncident.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TIncident
         * @static
         * @param {NTentaclesApi.ITIncident} message TIncident message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TIncident.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TIncident message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TIncident
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TIncident} TIncident
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TIncident.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TIncident();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.string();
                    break;
                case 2:
                    message.start_time_ts = reader.uint32();
                    break;
                case 3:
                    message.end_time_ts = reader.uint32();
                    break;
                case 4:
                    message.allocation_zone = reader.string();
                    break;
                case 5:
                    message.slo_type = reader.int32();
                    break;
                case 6:
                    message.assignee = reader.string();
                    break;
                case 7:
                    message.minutes_out_of_slo = reader.uint32();
                    break;
                case 8:
                    message.startrek_ticket_id = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TIncident message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TIncident
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TIncident} TIncident
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TIncident.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TIncident message.
         * @function verify
         * @memberof NTentaclesApi.TIncident
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TIncident.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            if (message.start_time_ts != null && message.hasOwnProperty("start_time_ts"))
                if (!$util.isInteger(message.start_time_ts))
                    return "start_time_ts: integer expected";
            if (message.end_time_ts != null && message.hasOwnProperty("end_time_ts"))
                if (!$util.isInteger(message.end_time_ts))
                    return "end_time_ts: integer expected";
            if (message.allocation_zone != null && message.hasOwnProperty("allocation_zone"))
                if (!$util.isString(message.allocation_zone))
                    return "allocation_zone: string expected";
            if (message.slo_type != null && message.hasOwnProperty("slo_type"))
                switch (message.slo_type) {
                default:
                    return "slo_type: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                    break;
                }
            if (message.assignee != null && message.hasOwnProperty("assignee"))
                if (!$util.isString(message.assignee))
                    return "assignee: string expected";
            if (message.minutes_out_of_slo != null && message.hasOwnProperty("minutes_out_of_slo"))
                if (!$util.isInteger(message.minutes_out_of_slo))
                    return "minutes_out_of_slo: integer expected";
            if (message.startrek_ticket_id != null && message.hasOwnProperty("startrek_ticket_id"))
                if (!$util.isString(message.startrek_ticket_id))
                    return "startrek_ticket_id: string expected";
            return null;
        };

        /**
         * Creates a TIncident message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TIncident
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TIncident} TIncident
         */
        TIncident.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TIncident)
                return object;
            let message = new $root.NTentaclesApi.TIncident();
            if (object.id != null)
                message.id = String(object.id);
            if (object.start_time_ts != null)
                message.start_time_ts = object.start_time_ts >>> 0;
            if (object.end_time_ts != null)
                message.end_time_ts = object.end_time_ts >>> 0;
            if (object.allocation_zone != null)
                message.allocation_zone = String(object.allocation_zone);
            switch (object.slo_type) {
            case "AVAILABILITY":
            case 0:
                message.slo_type = 0;
                break;
            case "REDEPLOYED_ON_TIME":
            case 1:
                message.slo_type = 1;
                break;
            case "REALLOCATION":
            case 2:
                message.slo_type = 2;
                break;
            case "UNUSED_NODES":
            case 3:
                message.slo_type = 3;
                break;
            }
            if (object.assignee != null)
                message.assignee = String(object.assignee);
            if (object.minutes_out_of_slo != null)
                message.minutes_out_of_slo = object.minutes_out_of_slo >>> 0;
            if (object.startrek_ticket_id != null)
                message.startrek_ticket_id = String(object.startrek_ticket_id);
            return message;
        };

        /**
         * Creates a plain object from a TIncident message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TIncident
         * @static
         * @param {NTentaclesApi.TIncident} message TIncident
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TIncident.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.id = "";
                object.start_time_ts = 0;
                object.end_time_ts = 0;
                object.allocation_zone = "";
                object.slo_type = options.enums === String ? "AVAILABILITY" : 0;
                object.assignee = "";
                object.minutes_out_of_slo = 0;
                object.startrek_ticket_id = "";
            }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            if (message.start_time_ts != null && message.hasOwnProperty("start_time_ts"))
                object.start_time_ts = message.start_time_ts;
            if (message.end_time_ts != null && message.hasOwnProperty("end_time_ts"))
                object.end_time_ts = message.end_time_ts;
            if (message.allocation_zone != null && message.hasOwnProperty("allocation_zone"))
                object.allocation_zone = message.allocation_zone;
            if (message.slo_type != null && message.hasOwnProperty("slo_type"))
                object.slo_type = options.enums === String ? $root.NTentaclesApi.ESloType[message.slo_type] : message.slo_type;
            if (message.assignee != null && message.hasOwnProperty("assignee"))
                object.assignee = message.assignee;
            if (message.minutes_out_of_slo != null && message.hasOwnProperty("minutes_out_of_slo"))
                object.minutes_out_of_slo = message.minutes_out_of_slo;
            if (message.startrek_ticket_id != null && message.hasOwnProperty("startrek_ticket_id"))
                object.startrek_ticket_id = message.startrek_ticket_id;
            return object;
        };

        /**
         * Converts this TIncident to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TIncident
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TIncident.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TIncident;
    })();

    NTentaclesApi.TIncidentFilter = (function() {

        /**
         * Properties of a TIncidentFilter.
         * @memberof NTentaclesApi
         * @interface ITIncidentFilter
         * @property {number|null} [started_after_ts] TIncidentFilter started_after_ts
         * @property {number|null} [ended_before_ts] TIncidentFilter ended_before_ts
         * @property {Array.<string>|null} [allocation_zones] TIncidentFilter allocation_zones
         * @property {Array.<NTentaclesApi.ESloType>|null} [slo_types] TIncidentFilter slo_types
         * @property {Array.<string>|null} [assignees] TIncidentFilter assignees
         * @property {Array.<string>|null} [startrek_ticket_ids] TIncidentFilter startrek_ticket_ids
         */

        /**
         * Constructs a new TIncidentFilter.
         * @memberof NTentaclesApi
         * @classdesc Represents a TIncidentFilter.
         * @implements ITIncidentFilter
         * @constructor
         * @param {NTentaclesApi.ITIncidentFilter=} [properties] Properties to set
         */
        function TIncidentFilter(properties) {
            this.allocation_zones = [];
            this.slo_types = [];
            this.assignees = [];
            this.startrek_ticket_ids = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TIncidentFilter started_after_ts.
         * @member {number} started_after_ts
         * @memberof NTentaclesApi.TIncidentFilter
         * @instance
         */
        TIncidentFilter.prototype.started_after_ts = 0;

        /**
         * TIncidentFilter ended_before_ts.
         * @member {number} ended_before_ts
         * @memberof NTentaclesApi.TIncidentFilter
         * @instance
         */
        TIncidentFilter.prototype.ended_before_ts = 0;

        /**
         * TIncidentFilter allocation_zones.
         * @member {Array.<string>} allocation_zones
         * @memberof NTentaclesApi.TIncidentFilter
         * @instance
         */
        TIncidentFilter.prototype.allocation_zones = $util.emptyArray;

        /**
         * TIncidentFilter slo_types.
         * @member {Array.<NTentaclesApi.ESloType>} slo_types
         * @memberof NTentaclesApi.TIncidentFilter
         * @instance
         */
        TIncidentFilter.prototype.slo_types = $util.emptyArray;

        /**
         * TIncidentFilter assignees.
         * @member {Array.<string>} assignees
         * @memberof NTentaclesApi.TIncidentFilter
         * @instance
         */
        TIncidentFilter.prototype.assignees = $util.emptyArray;

        /**
         * TIncidentFilter startrek_ticket_ids.
         * @member {Array.<string>} startrek_ticket_ids
         * @memberof NTentaclesApi.TIncidentFilter
         * @instance
         */
        TIncidentFilter.prototype.startrek_ticket_ids = $util.emptyArray;

        /**
         * Creates a new TIncidentFilter instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TIncidentFilter
         * @static
         * @param {NTentaclesApi.ITIncidentFilter=} [properties] Properties to set
         * @returns {NTentaclesApi.TIncidentFilter} TIncidentFilter instance
         */
        TIncidentFilter.create = function create(properties) {
            return new TIncidentFilter(properties);
        };

        /**
         * Encodes the specified TIncidentFilter message. Does not implicitly {@link NTentaclesApi.TIncidentFilter.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TIncidentFilter
         * @static
         * @param {NTentaclesApi.ITIncidentFilter} message TIncidentFilter message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TIncidentFilter.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.started_after_ts != null && Object.hasOwnProperty.call(message, "started_after_ts"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.started_after_ts);
            if (message.ended_before_ts != null && Object.hasOwnProperty.call(message, "ended_before_ts"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.ended_before_ts);
            if (message.allocation_zones != null && message.allocation_zones.length)
                for (let i = 0; i < message.allocation_zones.length; ++i)
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.allocation_zones[i]);
            if (message.slo_types != null && message.slo_types.length) {
                writer.uint32(/* id 4, wireType 2 =*/34).fork();
                for (let i = 0; i < message.slo_types.length; ++i)
                    writer.int32(message.slo_types[i]);
                writer.ldelim();
            }
            if (message.assignees != null && message.assignees.length)
                for (let i = 0; i < message.assignees.length; ++i)
                    writer.uint32(/* id 5, wireType 2 =*/42).string(message.assignees[i]);
            if (message.startrek_ticket_ids != null && message.startrek_ticket_ids.length)
                for (let i = 0; i < message.startrek_ticket_ids.length; ++i)
                    writer.uint32(/* id 6, wireType 2 =*/50).string(message.startrek_ticket_ids[i]);
            return writer;
        };

        /**
         * Encodes the specified TIncidentFilter message, length delimited. Does not implicitly {@link NTentaclesApi.TIncidentFilter.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TIncidentFilter
         * @static
         * @param {NTentaclesApi.ITIncidentFilter} message TIncidentFilter message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TIncidentFilter.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TIncidentFilter message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TIncidentFilter
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TIncidentFilter} TIncidentFilter
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TIncidentFilter.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TIncidentFilter();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.started_after_ts = reader.uint32();
                    break;
                case 2:
                    message.ended_before_ts = reader.uint32();
                    break;
                case 3:
                    if (!(message.allocation_zones && message.allocation_zones.length))
                        message.allocation_zones = [];
                    message.allocation_zones.push(reader.string());
                    break;
                case 4:
                    if (!(message.slo_types && message.slo_types.length))
                        message.slo_types = [];
                    if ((tag & 7) === 2) {
                        let end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.slo_types.push(reader.int32());
                    } else
                        message.slo_types.push(reader.int32());
                    break;
                case 5:
                    if (!(message.assignees && message.assignees.length))
                        message.assignees = [];
                    message.assignees.push(reader.string());
                    break;
                case 6:
                    if (!(message.startrek_ticket_ids && message.startrek_ticket_ids.length))
                        message.startrek_ticket_ids = [];
                    message.startrek_ticket_ids.push(reader.string());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TIncidentFilter message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TIncidentFilter
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TIncidentFilter} TIncidentFilter
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TIncidentFilter.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TIncidentFilter message.
         * @function verify
         * @memberof NTentaclesApi.TIncidentFilter
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TIncidentFilter.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.started_after_ts != null && message.hasOwnProperty("started_after_ts"))
                if (!$util.isInteger(message.started_after_ts))
                    return "started_after_ts: integer expected";
            if (message.ended_before_ts != null && message.hasOwnProperty("ended_before_ts"))
                if (!$util.isInteger(message.ended_before_ts))
                    return "ended_before_ts: integer expected";
            if (message.allocation_zones != null && message.hasOwnProperty("allocation_zones")) {
                if (!Array.isArray(message.allocation_zones))
                    return "allocation_zones: array expected";
                for (let i = 0; i < message.allocation_zones.length; ++i)
                    if (!$util.isString(message.allocation_zones[i]))
                        return "allocation_zones: string[] expected";
            }
            if (message.slo_types != null && message.hasOwnProperty("slo_types")) {
                if (!Array.isArray(message.slo_types))
                    return "slo_types: array expected";
                for (let i = 0; i < message.slo_types.length; ++i)
                    switch (message.slo_types[i]) {
                    default:
                        return "slo_types: enum value[] expected";
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                        break;
                    }
            }
            if (message.assignees != null && message.hasOwnProperty("assignees")) {
                if (!Array.isArray(message.assignees))
                    return "assignees: array expected";
                for (let i = 0; i < message.assignees.length; ++i)
                    if (!$util.isString(message.assignees[i]))
                        return "assignees: string[] expected";
            }
            if (message.startrek_ticket_ids != null && message.hasOwnProperty("startrek_ticket_ids")) {
                if (!Array.isArray(message.startrek_ticket_ids))
                    return "startrek_ticket_ids: array expected";
                for (let i = 0; i < message.startrek_ticket_ids.length; ++i)
                    if (!$util.isString(message.startrek_ticket_ids[i]))
                        return "startrek_ticket_ids: string[] expected";
            }
            return null;
        };

        /**
         * Creates a TIncidentFilter message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TIncidentFilter
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TIncidentFilter} TIncidentFilter
         */
        TIncidentFilter.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TIncidentFilter)
                return object;
            let message = new $root.NTentaclesApi.TIncidentFilter();
            if (object.started_after_ts != null)
                message.started_after_ts = object.started_after_ts >>> 0;
            if (object.ended_before_ts != null)
                message.ended_before_ts = object.ended_before_ts >>> 0;
            if (object.allocation_zones) {
                if (!Array.isArray(object.allocation_zones))
                    throw TypeError(".NTentaclesApi.TIncidentFilter.allocation_zones: array expected");
                message.allocation_zones = [];
                for (let i = 0; i < object.allocation_zones.length; ++i)
                    message.allocation_zones[i] = String(object.allocation_zones[i]);
            }
            if (object.slo_types) {
                if (!Array.isArray(object.slo_types))
                    throw TypeError(".NTentaclesApi.TIncidentFilter.slo_types: array expected");
                message.slo_types = [];
                for (let i = 0; i < object.slo_types.length; ++i)
                    switch (object.slo_types[i]) {
                    default:
                    case "AVAILABILITY":
                    case 0:
                        message.slo_types[i] = 0;
                        break;
                    case "REDEPLOYED_ON_TIME":
                    case 1:
                        message.slo_types[i] = 1;
                        break;
                    case "REALLOCATION":
                    case 2:
                        message.slo_types[i] = 2;
                        break;
                    case "UNUSED_NODES":
                    case 3:
                        message.slo_types[i] = 3;
                        break;
                    }
            }
            if (object.assignees) {
                if (!Array.isArray(object.assignees))
                    throw TypeError(".NTentaclesApi.TIncidentFilter.assignees: array expected");
                message.assignees = [];
                for (let i = 0; i < object.assignees.length; ++i)
                    message.assignees[i] = String(object.assignees[i]);
            }
            if (object.startrek_ticket_ids) {
                if (!Array.isArray(object.startrek_ticket_ids))
                    throw TypeError(".NTentaclesApi.TIncidentFilter.startrek_ticket_ids: array expected");
                message.startrek_ticket_ids = [];
                for (let i = 0; i < object.startrek_ticket_ids.length; ++i)
                    message.startrek_ticket_ids[i] = String(object.startrek_ticket_ids[i]);
            }
            return message;
        };

        /**
         * Creates a plain object from a TIncidentFilter message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TIncidentFilter
         * @static
         * @param {NTentaclesApi.TIncidentFilter} message TIncidentFilter
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TIncidentFilter.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults) {
                object.allocation_zones = [];
                object.slo_types = [];
                object.assignees = [];
                object.startrek_ticket_ids = [];
            }
            if (options.defaults) {
                object.started_after_ts = 0;
                object.ended_before_ts = 0;
            }
            if (message.started_after_ts != null && message.hasOwnProperty("started_after_ts"))
                object.started_after_ts = message.started_after_ts;
            if (message.ended_before_ts != null && message.hasOwnProperty("ended_before_ts"))
                object.ended_before_ts = message.ended_before_ts;
            if (message.allocation_zones && message.allocation_zones.length) {
                object.allocation_zones = [];
                for (let j = 0; j < message.allocation_zones.length; ++j)
                    object.allocation_zones[j] = message.allocation_zones[j];
            }
            if (message.slo_types && message.slo_types.length) {
                object.slo_types = [];
                for (let j = 0; j < message.slo_types.length; ++j)
                    object.slo_types[j] = options.enums === String ? $root.NTentaclesApi.ESloType[message.slo_types[j]] : message.slo_types[j];
            }
            if (message.assignees && message.assignees.length) {
                object.assignees = [];
                for (let j = 0; j < message.assignees.length; ++j)
                    object.assignees[j] = message.assignees[j];
            }
            if (message.startrek_ticket_ids && message.startrek_ticket_ids.length) {
                object.startrek_ticket_ids = [];
                for (let j = 0; j < message.startrek_ticket_ids.length; ++j)
                    object.startrek_ticket_ids[j] = message.startrek_ticket_ids[j];
            }
            return object;
        };

        /**
         * Converts this TIncidentFilter to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TIncidentFilter
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TIncidentFilter.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TIncidentFilter;
    })();

    NTentaclesApi.TIncidentFiltersList = (function() {

        /**
         * Properties of a TIncidentFiltersList.
         * @memberof NTentaclesApi
         * @interface ITIncidentFiltersList
         * @property {Array.<string>|null} [allocation_zones] TIncidentFiltersList allocation_zones
         * @property {Array.<NTentaclesApi.ESloType>|null} [slo_types] TIncidentFiltersList slo_types
         * @property {Array.<string>|null} [assignees] TIncidentFiltersList assignees
         */

        /**
         * Constructs a new TIncidentFiltersList.
         * @memberof NTentaclesApi
         * @classdesc Represents a TIncidentFiltersList.
         * @implements ITIncidentFiltersList
         * @constructor
         * @param {NTentaclesApi.ITIncidentFiltersList=} [properties] Properties to set
         */
        function TIncidentFiltersList(properties) {
            this.allocation_zones = [];
            this.slo_types = [];
            this.assignees = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TIncidentFiltersList allocation_zones.
         * @member {Array.<string>} allocation_zones
         * @memberof NTentaclesApi.TIncidentFiltersList
         * @instance
         */
        TIncidentFiltersList.prototype.allocation_zones = $util.emptyArray;

        /**
         * TIncidentFiltersList slo_types.
         * @member {Array.<NTentaclesApi.ESloType>} slo_types
         * @memberof NTentaclesApi.TIncidentFiltersList
         * @instance
         */
        TIncidentFiltersList.prototype.slo_types = $util.emptyArray;

        /**
         * TIncidentFiltersList assignees.
         * @member {Array.<string>} assignees
         * @memberof NTentaclesApi.TIncidentFiltersList
         * @instance
         */
        TIncidentFiltersList.prototype.assignees = $util.emptyArray;

        /**
         * Creates a new TIncidentFiltersList instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TIncidentFiltersList
         * @static
         * @param {NTentaclesApi.ITIncidentFiltersList=} [properties] Properties to set
         * @returns {NTentaclesApi.TIncidentFiltersList} TIncidentFiltersList instance
         */
        TIncidentFiltersList.create = function create(properties) {
            return new TIncidentFiltersList(properties);
        };

        /**
         * Encodes the specified TIncidentFiltersList message. Does not implicitly {@link NTentaclesApi.TIncidentFiltersList.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TIncidentFiltersList
         * @static
         * @param {NTentaclesApi.ITIncidentFiltersList} message TIncidentFiltersList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TIncidentFiltersList.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.allocation_zones != null && message.allocation_zones.length)
                for (let i = 0; i < message.allocation_zones.length; ++i)
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.allocation_zones[i]);
            if (message.slo_types != null && message.slo_types.length) {
                writer.uint32(/* id 2, wireType 2 =*/18).fork();
                for (let i = 0; i < message.slo_types.length; ++i)
                    writer.int32(message.slo_types[i]);
                writer.ldelim();
            }
            if (message.assignees != null && message.assignees.length)
                for (let i = 0; i < message.assignees.length; ++i)
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.assignees[i]);
            return writer;
        };

        /**
         * Encodes the specified TIncidentFiltersList message, length delimited. Does not implicitly {@link NTentaclesApi.TIncidentFiltersList.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TIncidentFiltersList
         * @static
         * @param {NTentaclesApi.ITIncidentFiltersList} message TIncidentFiltersList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TIncidentFiltersList.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TIncidentFiltersList message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TIncidentFiltersList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TIncidentFiltersList} TIncidentFiltersList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TIncidentFiltersList.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TIncidentFiltersList();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.allocation_zones && message.allocation_zones.length))
                        message.allocation_zones = [];
                    message.allocation_zones.push(reader.string());
                    break;
                case 2:
                    if (!(message.slo_types && message.slo_types.length))
                        message.slo_types = [];
                    if ((tag & 7) === 2) {
                        let end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.slo_types.push(reader.int32());
                    } else
                        message.slo_types.push(reader.int32());
                    break;
                case 3:
                    if (!(message.assignees && message.assignees.length))
                        message.assignees = [];
                    message.assignees.push(reader.string());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TIncidentFiltersList message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TIncidentFiltersList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TIncidentFiltersList} TIncidentFiltersList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TIncidentFiltersList.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TIncidentFiltersList message.
         * @function verify
         * @memberof NTentaclesApi.TIncidentFiltersList
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TIncidentFiltersList.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.allocation_zones != null && message.hasOwnProperty("allocation_zones")) {
                if (!Array.isArray(message.allocation_zones))
                    return "allocation_zones: array expected";
                for (let i = 0; i < message.allocation_zones.length; ++i)
                    if (!$util.isString(message.allocation_zones[i]))
                        return "allocation_zones: string[] expected";
            }
            if (message.slo_types != null && message.hasOwnProperty("slo_types")) {
                if (!Array.isArray(message.slo_types))
                    return "slo_types: array expected";
                for (let i = 0; i < message.slo_types.length; ++i)
                    switch (message.slo_types[i]) {
                    default:
                        return "slo_types: enum value[] expected";
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                        break;
                    }
            }
            if (message.assignees != null && message.hasOwnProperty("assignees")) {
                if (!Array.isArray(message.assignees))
                    return "assignees: array expected";
                for (let i = 0; i < message.assignees.length; ++i)
                    if (!$util.isString(message.assignees[i]))
                        return "assignees: string[] expected";
            }
            return null;
        };

        /**
         * Creates a TIncidentFiltersList message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TIncidentFiltersList
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TIncidentFiltersList} TIncidentFiltersList
         */
        TIncidentFiltersList.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TIncidentFiltersList)
                return object;
            let message = new $root.NTentaclesApi.TIncidentFiltersList();
            if (object.allocation_zones) {
                if (!Array.isArray(object.allocation_zones))
                    throw TypeError(".NTentaclesApi.TIncidentFiltersList.allocation_zones: array expected");
                message.allocation_zones = [];
                for (let i = 0; i < object.allocation_zones.length; ++i)
                    message.allocation_zones[i] = String(object.allocation_zones[i]);
            }
            if (object.slo_types) {
                if (!Array.isArray(object.slo_types))
                    throw TypeError(".NTentaclesApi.TIncidentFiltersList.slo_types: array expected");
                message.slo_types = [];
                for (let i = 0; i < object.slo_types.length; ++i)
                    switch (object.slo_types[i]) {
                    default:
                    case "AVAILABILITY":
                    case 0:
                        message.slo_types[i] = 0;
                        break;
                    case "REDEPLOYED_ON_TIME":
                    case 1:
                        message.slo_types[i] = 1;
                        break;
                    case "REALLOCATION":
                    case 2:
                        message.slo_types[i] = 2;
                        break;
                    case "UNUSED_NODES":
                    case 3:
                        message.slo_types[i] = 3;
                        break;
                    }
            }
            if (object.assignees) {
                if (!Array.isArray(object.assignees))
                    throw TypeError(".NTentaclesApi.TIncidentFiltersList.assignees: array expected");
                message.assignees = [];
                for (let i = 0; i < object.assignees.length; ++i)
                    message.assignees[i] = String(object.assignees[i]);
            }
            return message;
        };

        /**
         * Creates a plain object from a TIncidentFiltersList message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TIncidentFiltersList
         * @static
         * @param {NTentaclesApi.TIncidentFiltersList} message TIncidentFiltersList
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TIncidentFiltersList.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults) {
                object.allocation_zones = [];
                object.slo_types = [];
                object.assignees = [];
            }
            if (message.allocation_zones && message.allocation_zones.length) {
                object.allocation_zones = [];
                for (let j = 0; j < message.allocation_zones.length; ++j)
                    object.allocation_zones[j] = message.allocation_zones[j];
            }
            if (message.slo_types && message.slo_types.length) {
                object.slo_types = [];
                for (let j = 0; j < message.slo_types.length; ++j)
                    object.slo_types[j] = options.enums === String ? $root.NTentaclesApi.ESloType[message.slo_types[j]] : message.slo_types[j];
            }
            if (message.assignees && message.assignees.length) {
                object.assignees = [];
                for (let j = 0; j < message.assignees.length; ++j)
                    object.assignees[j] = message.assignees[j];
            }
            return object;
        };

        /**
         * Converts this TIncidentFiltersList to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TIncidentFiltersList
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TIncidentFiltersList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TIncidentFiltersList;
    })();

    NTentaclesApi.TCreateIncidentRequest = (function() {

        /**
         * Properties of a TCreateIncidentRequest.
         * @memberof NTentaclesApi
         * @interface ITCreateIncidentRequest
         * @property {NTentaclesApi.ITIncident|null} [data] TCreateIncidentRequest data
         */

        /**
         * Constructs a new TCreateIncidentRequest.
         * @memberof NTentaclesApi
         * @classdesc Represents a TCreateIncidentRequest.
         * @implements ITCreateIncidentRequest
         * @constructor
         * @param {NTentaclesApi.ITCreateIncidentRequest=} [properties] Properties to set
         */
        function TCreateIncidentRequest(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TCreateIncidentRequest data.
         * @member {NTentaclesApi.ITIncident|null|undefined} data
         * @memberof NTentaclesApi.TCreateIncidentRequest
         * @instance
         */
        TCreateIncidentRequest.prototype.data = null;

        /**
         * Creates a new TCreateIncidentRequest instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TCreateIncidentRequest
         * @static
         * @param {NTentaclesApi.ITCreateIncidentRequest=} [properties] Properties to set
         * @returns {NTentaclesApi.TCreateIncidentRequest} TCreateIncidentRequest instance
         */
        TCreateIncidentRequest.create = function create(properties) {
            return new TCreateIncidentRequest(properties);
        };

        /**
         * Encodes the specified TCreateIncidentRequest message. Does not implicitly {@link NTentaclesApi.TCreateIncidentRequest.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TCreateIncidentRequest
         * @static
         * @param {NTentaclesApi.ITCreateIncidentRequest} message TCreateIncidentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TCreateIncidentRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                $root.NTentaclesApi.TIncident.encode(message.data, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TCreateIncidentRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TCreateIncidentRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TCreateIncidentRequest
         * @static
         * @param {NTentaclesApi.ITCreateIncidentRequest} message TCreateIncidentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TCreateIncidentRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TCreateIncidentRequest message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TCreateIncidentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TCreateIncidentRequest} TCreateIncidentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TCreateIncidentRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TCreateIncidentRequest();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.data = $root.NTentaclesApi.TIncident.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TCreateIncidentRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TCreateIncidentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TCreateIncidentRequest} TCreateIncidentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TCreateIncidentRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TCreateIncidentRequest message.
         * @function verify
         * @memberof NTentaclesApi.TCreateIncidentRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TCreateIncidentRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.data != null && message.hasOwnProperty("data")) {
                let error = $root.NTentaclesApi.TIncident.verify(message.data);
                if (error)
                    return "data." + error;
            }
            return null;
        };

        /**
         * Creates a TCreateIncidentRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TCreateIncidentRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TCreateIncidentRequest} TCreateIncidentRequest
         */
        TCreateIncidentRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TCreateIncidentRequest)
                return object;
            let message = new $root.NTentaclesApi.TCreateIncidentRequest();
            if (object.data != null) {
                if (typeof object.data !== "object")
                    throw TypeError(".NTentaclesApi.TCreateIncidentRequest.data: object expected");
                message.data = $root.NTentaclesApi.TIncident.fromObject(object.data);
            }
            return message;
        };

        /**
         * Creates a plain object from a TCreateIncidentRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TCreateIncidentRequest
         * @static
         * @param {NTentaclesApi.TCreateIncidentRequest} message TCreateIncidentRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TCreateIncidentRequest.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.data = null;
            if (message.data != null && message.hasOwnProperty("data"))
                object.data = $root.NTentaclesApi.TIncident.toObject(message.data, options);
            return object;
        };

        /**
         * Converts this TCreateIncidentRequest to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TCreateIncidentRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TCreateIncidentRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TCreateIncidentRequest;
    })();

    NTentaclesApi.TCreateIncidentResult = (function() {

        /**
         * Properties of a TCreateIncidentResult.
         * @memberof NTentaclesApi
         * @interface ITCreateIncidentResult
         * @property {string|null} [id] TCreateIncidentResult id
         */

        /**
         * Constructs a new TCreateIncidentResult.
         * @memberof NTentaclesApi
         * @classdesc Represents a TCreateIncidentResult.
         * @implements ITCreateIncidentResult
         * @constructor
         * @param {NTentaclesApi.ITCreateIncidentResult=} [properties] Properties to set
         */
        function TCreateIncidentResult(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TCreateIncidentResult id.
         * @member {string} id
         * @memberof NTentaclesApi.TCreateIncidentResult
         * @instance
         */
        TCreateIncidentResult.prototype.id = "";

        /**
         * Creates a new TCreateIncidentResult instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TCreateIncidentResult
         * @static
         * @param {NTentaclesApi.ITCreateIncidentResult=} [properties] Properties to set
         * @returns {NTentaclesApi.TCreateIncidentResult} TCreateIncidentResult instance
         */
        TCreateIncidentResult.create = function create(properties) {
            return new TCreateIncidentResult(properties);
        };

        /**
         * Encodes the specified TCreateIncidentResult message. Does not implicitly {@link NTentaclesApi.TCreateIncidentResult.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TCreateIncidentResult
         * @static
         * @param {NTentaclesApi.ITCreateIncidentResult} message TCreateIncidentResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TCreateIncidentResult.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
            return writer;
        };

        /**
         * Encodes the specified TCreateIncidentResult message, length delimited. Does not implicitly {@link NTentaclesApi.TCreateIncidentResult.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TCreateIncidentResult
         * @static
         * @param {NTentaclesApi.ITCreateIncidentResult} message TCreateIncidentResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TCreateIncidentResult.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TCreateIncidentResult message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TCreateIncidentResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TCreateIncidentResult} TCreateIncidentResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TCreateIncidentResult.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TCreateIncidentResult();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TCreateIncidentResult message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TCreateIncidentResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TCreateIncidentResult} TCreateIncidentResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TCreateIncidentResult.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TCreateIncidentResult message.
         * @function verify
         * @memberof NTentaclesApi.TCreateIncidentResult
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TCreateIncidentResult.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            return null;
        };

        /**
         * Creates a TCreateIncidentResult message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TCreateIncidentResult
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TCreateIncidentResult} TCreateIncidentResult
         */
        TCreateIncidentResult.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TCreateIncidentResult)
                return object;
            let message = new $root.NTentaclesApi.TCreateIncidentResult();
            if (object.id != null)
                message.id = String(object.id);
            return message;
        };

        /**
         * Creates a plain object from a TCreateIncidentResult message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TCreateIncidentResult
         * @static
         * @param {NTentaclesApi.TCreateIncidentResult} message TCreateIncidentResult
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TCreateIncidentResult.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.id = "";
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            return object;
        };

        /**
         * Converts this TCreateIncidentResult to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TCreateIncidentResult
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TCreateIncidentResult.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TCreateIncidentResult;
    })();

    NTentaclesApi.TCreateIncidentResponse = (function() {

        /**
         * Properties of a TCreateIncidentResponse.
         * @memberof NTentaclesApi
         * @interface ITCreateIncidentResponse
         * @property {string|null} [error] TCreateIncidentResponse error
         * @property {NTentaclesApi.ITCreateIncidentResult|null} [result] TCreateIncidentResponse result
         */

        /**
         * Constructs a new TCreateIncidentResponse.
         * @memberof NTentaclesApi
         * @classdesc Represents a TCreateIncidentResponse.
         * @implements ITCreateIncidentResponse
         * @constructor
         * @param {NTentaclesApi.ITCreateIncidentResponse=} [properties] Properties to set
         */
        function TCreateIncidentResponse(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TCreateIncidentResponse error.
         * @member {string} error
         * @memberof NTentaclesApi.TCreateIncidentResponse
         * @instance
         */
        TCreateIncidentResponse.prototype.error = "";

        /**
         * TCreateIncidentResponse result.
         * @member {NTentaclesApi.ITCreateIncidentResult|null|undefined} result
         * @memberof NTentaclesApi.TCreateIncidentResponse
         * @instance
         */
        TCreateIncidentResponse.prototype.result = null;

        /**
         * Creates a new TCreateIncidentResponse instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TCreateIncidentResponse
         * @static
         * @param {NTentaclesApi.ITCreateIncidentResponse=} [properties] Properties to set
         * @returns {NTentaclesApi.TCreateIncidentResponse} TCreateIncidentResponse instance
         */
        TCreateIncidentResponse.create = function create(properties) {
            return new TCreateIncidentResponse(properties);
        };

        /**
         * Encodes the specified TCreateIncidentResponse message. Does not implicitly {@link NTentaclesApi.TCreateIncidentResponse.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TCreateIncidentResponse
         * @static
         * @param {NTentaclesApi.ITCreateIncidentResponse} message TCreateIncidentResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TCreateIncidentResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.error != null && Object.hasOwnProperty.call(message, "error"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.error);
            if (message.result != null && Object.hasOwnProperty.call(message, "result"))
                $root.NTentaclesApi.TCreateIncidentResult.encode(message.result, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TCreateIncidentResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TCreateIncidentResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TCreateIncidentResponse
         * @static
         * @param {NTentaclesApi.ITCreateIncidentResponse} message TCreateIncidentResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TCreateIncidentResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TCreateIncidentResponse message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TCreateIncidentResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TCreateIncidentResponse} TCreateIncidentResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TCreateIncidentResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TCreateIncidentResponse();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.error = reader.string();
                    break;
                case 2:
                    message.result = $root.NTentaclesApi.TCreateIncidentResult.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TCreateIncidentResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TCreateIncidentResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TCreateIncidentResponse} TCreateIncidentResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TCreateIncidentResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TCreateIncidentResponse message.
         * @function verify
         * @memberof NTentaclesApi.TCreateIncidentResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TCreateIncidentResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.error != null && message.hasOwnProperty("error"))
                if (!$util.isString(message.error))
                    return "error: string expected";
            if (message.result != null && message.hasOwnProperty("result")) {
                let error = $root.NTentaclesApi.TCreateIncidentResult.verify(message.result);
                if (error)
                    return "result." + error;
            }
            return null;
        };

        /**
         * Creates a TCreateIncidentResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TCreateIncidentResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TCreateIncidentResponse} TCreateIncidentResponse
         */
        TCreateIncidentResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TCreateIncidentResponse)
                return object;
            let message = new $root.NTentaclesApi.TCreateIncidentResponse();
            if (object.error != null)
                message.error = String(object.error);
            if (object.result != null) {
                if (typeof object.result !== "object")
                    throw TypeError(".NTentaclesApi.TCreateIncidentResponse.result: object expected");
                message.result = $root.NTentaclesApi.TCreateIncidentResult.fromObject(object.result);
            }
            return message;
        };

        /**
         * Creates a plain object from a TCreateIncidentResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TCreateIncidentResponse
         * @static
         * @param {NTentaclesApi.TCreateIncidentResponse} message TCreateIncidentResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TCreateIncidentResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.error = "";
                object.result = null;
            }
            if (message.error != null && message.hasOwnProperty("error"))
                object.error = message.error;
            if (message.result != null && message.hasOwnProperty("result"))
                object.result = $root.NTentaclesApi.TCreateIncidentResult.toObject(message.result, options);
            return object;
        };

        /**
         * Converts this TCreateIncidentResponse to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TCreateIncidentResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TCreateIncidentResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TCreateIncidentResponse;
    })();

    NTentaclesApi.TDeleteIncidentRequest = (function() {

        /**
         * Properties of a TDeleteIncidentRequest.
         * @memberof NTentaclesApi
         * @interface ITDeleteIncidentRequest
         * @property {string|null} [id] TDeleteIncidentRequest id
         */

        /**
         * Constructs a new TDeleteIncidentRequest.
         * @memberof NTentaclesApi
         * @classdesc Represents a TDeleteIncidentRequest.
         * @implements ITDeleteIncidentRequest
         * @constructor
         * @param {NTentaclesApi.ITDeleteIncidentRequest=} [properties] Properties to set
         */
        function TDeleteIncidentRequest(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TDeleteIncidentRequest id.
         * @member {string} id
         * @memberof NTentaclesApi.TDeleteIncidentRequest
         * @instance
         */
        TDeleteIncidentRequest.prototype.id = "";

        /**
         * Creates a new TDeleteIncidentRequest instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TDeleteIncidentRequest
         * @static
         * @param {NTentaclesApi.ITDeleteIncidentRequest=} [properties] Properties to set
         * @returns {NTentaclesApi.TDeleteIncidentRequest} TDeleteIncidentRequest instance
         */
        TDeleteIncidentRequest.create = function create(properties) {
            return new TDeleteIncidentRequest(properties);
        };

        /**
         * Encodes the specified TDeleteIncidentRequest message. Does not implicitly {@link NTentaclesApi.TDeleteIncidentRequest.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TDeleteIncidentRequest
         * @static
         * @param {NTentaclesApi.ITDeleteIncidentRequest} message TDeleteIncidentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TDeleteIncidentRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
            return writer;
        };

        /**
         * Encodes the specified TDeleteIncidentRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TDeleteIncidentRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TDeleteIncidentRequest
         * @static
         * @param {NTentaclesApi.ITDeleteIncidentRequest} message TDeleteIncidentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TDeleteIncidentRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TDeleteIncidentRequest message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TDeleteIncidentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TDeleteIncidentRequest} TDeleteIncidentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TDeleteIncidentRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TDeleteIncidentRequest();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TDeleteIncidentRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TDeleteIncidentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TDeleteIncidentRequest} TDeleteIncidentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TDeleteIncidentRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TDeleteIncidentRequest message.
         * @function verify
         * @memberof NTentaclesApi.TDeleteIncidentRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TDeleteIncidentRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            return null;
        };

        /**
         * Creates a TDeleteIncidentRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TDeleteIncidentRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TDeleteIncidentRequest} TDeleteIncidentRequest
         */
        TDeleteIncidentRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TDeleteIncidentRequest)
                return object;
            let message = new $root.NTentaclesApi.TDeleteIncidentRequest();
            if (object.id != null)
                message.id = String(object.id);
            return message;
        };

        /**
         * Creates a plain object from a TDeleteIncidentRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TDeleteIncidentRequest
         * @static
         * @param {NTentaclesApi.TDeleteIncidentRequest} message TDeleteIncidentRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TDeleteIncidentRequest.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.id = "";
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            return object;
        };

        /**
         * Converts this TDeleteIncidentRequest to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TDeleteIncidentRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TDeleteIncidentRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TDeleteIncidentRequest;
    })();

    NTentaclesApi.TDeleteIncidentResponse = (function() {

        /**
         * Properties of a TDeleteIncidentResponse.
         * @memberof NTentaclesApi
         * @interface ITDeleteIncidentResponse
         * @property {string|null} [error] TDeleteIncidentResponse error
         */

        /**
         * Constructs a new TDeleteIncidentResponse.
         * @memberof NTentaclesApi
         * @classdesc Represents a TDeleteIncidentResponse.
         * @implements ITDeleteIncidentResponse
         * @constructor
         * @param {NTentaclesApi.ITDeleteIncidentResponse=} [properties] Properties to set
         */
        function TDeleteIncidentResponse(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TDeleteIncidentResponse error.
         * @member {string} error
         * @memberof NTentaclesApi.TDeleteIncidentResponse
         * @instance
         */
        TDeleteIncidentResponse.prototype.error = "";

        /**
         * Creates a new TDeleteIncidentResponse instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TDeleteIncidentResponse
         * @static
         * @param {NTentaclesApi.ITDeleteIncidentResponse=} [properties] Properties to set
         * @returns {NTentaclesApi.TDeleteIncidentResponse} TDeleteIncidentResponse instance
         */
        TDeleteIncidentResponse.create = function create(properties) {
            return new TDeleteIncidentResponse(properties);
        };

        /**
         * Encodes the specified TDeleteIncidentResponse message. Does not implicitly {@link NTentaclesApi.TDeleteIncidentResponse.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TDeleteIncidentResponse
         * @static
         * @param {NTentaclesApi.ITDeleteIncidentResponse} message TDeleteIncidentResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TDeleteIncidentResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.error != null && Object.hasOwnProperty.call(message, "error"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.error);
            return writer;
        };

        /**
         * Encodes the specified TDeleteIncidentResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TDeleteIncidentResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TDeleteIncidentResponse
         * @static
         * @param {NTentaclesApi.ITDeleteIncidentResponse} message TDeleteIncidentResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TDeleteIncidentResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TDeleteIncidentResponse message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TDeleteIncidentResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TDeleteIncidentResponse} TDeleteIncidentResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TDeleteIncidentResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TDeleteIncidentResponse();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.error = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TDeleteIncidentResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TDeleteIncidentResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TDeleteIncidentResponse} TDeleteIncidentResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TDeleteIncidentResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TDeleteIncidentResponse message.
         * @function verify
         * @memberof NTentaclesApi.TDeleteIncidentResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TDeleteIncidentResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.error != null && message.hasOwnProperty("error"))
                if (!$util.isString(message.error))
                    return "error: string expected";
            return null;
        };

        /**
         * Creates a TDeleteIncidentResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TDeleteIncidentResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TDeleteIncidentResponse} TDeleteIncidentResponse
         */
        TDeleteIncidentResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TDeleteIncidentResponse)
                return object;
            let message = new $root.NTentaclesApi.TDeleteIncidentResponse();
            if (object.error != null)
                message.error = String(object.error);
            return message;
        };

        /**
         * Creates a plain object from a TDeleteIncidentResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TDeleteIncidentResponse
         * @static
         * @param {NTentaclesApi.TDeleteIncidentResponse} message TDeleteIncidentResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TDeleteIncidentResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.error = "";
            if (message.error != null && message.hasOwnProperty("error"))
                object.error = message.error;
            return object;
        };

        /**
         * Converts this TDeleteIncidentResponse to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TDeleteIncidentResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TDeleteIncidentResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TDeleteIncidentResponse;
    })();

    NTentaclesApi.TListIncidentFiltersRequest = (function() {

        /**
         * Properties of a TListIncidentFiltersRequest.
         * @memberof NTentaclesApi
         * @interface ITListIncidentFiltersRequest
         */

        /**
         * Constructs a new TListIncidentFiltersRequest.
         * @memberof NTentaclesApi
         * @classdesc Represents a TListIncidentFiltersRequest.
         * @implements ITListIncidentFiltersRequest
         * @constructor
         * @param {NTentaclesApi.ITListIncidentFiltersRequest=} [properties] Properties to set
         */
        function TListIncidentFiltersRequest(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Creates a new TListIncidentFiltersRequest instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TListIncidentFiltersRequest
         * @static
         * @param {NTentaclesApi.ITListIncidentFiltersRequest=} [properties] Properties to set
         * @returns {NTentaclesApi.TListIncidentFiltersRequest} TListIncidentFiltersRequest instance
         */
        TListIncidentFiltersRequest.create = function create(properties) {
            return new TListIncidentFiltersRequest(properties);
        };

        /**
         * Encodes the specified TListIncidentFiltersRequest message. Does not implicitly {@link NTentaclesApi.TListIncidentFiltersRequest.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TListIncidentFiltersRequest
         * @static
         * @param {NTentaclesApi.ITListIncidentFiltersRequest} message TListIncidentFiltersRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TListIncidentFiltersRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            return writer;
        };

        /**
         * Encodes the specified TListIncidentFiltersRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TListIncidentFiltersRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TListIncidentFiltersRequest
         * @static
         * @param {NTentaclesApi.ITListIncidentFiltersRequest} message TListIncidentFiltersRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TListIncidentFiltersRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TListIncidentFiltersRequest message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TListIncidentFiltersRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TListIncidentFiltersRequest} TListIncidentFiltersRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TListIncidentFiltersRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TListIncidentFiltersRequest();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TListIncidentFiltersRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TListIncidentFiltersRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TListIncidentFiltersRequest} TListIncidentFiltersRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TListIncidentFiltersRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TListIncidentFiltersRequest message.
         * @function verify
         * @memberof NTentaclesApi.TListIncidentFiltersRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TListIncidentFiltersRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            return null;
        };

        /**
         * Creates a TListIncidentFiltersRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TListIncidentFiltersRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TListIncidentFiltersRequest} TListIncidentFiltersRequest
         */
        TListIncidentFiltersRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TListIncidentFiltersRequest)
                return object;
            return new $root.NTentaclesApi.TListIncidentFiltersRequest();
        };

        /**
         * Creates a plain object from a TListIncidentFiltersRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TListIncidentFiltersRequest
         * @static
         * @param {NTentaclesApi.TListIncidentFiltersRequest} message TListIncidentFiltersRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TListIncidentFiltersRequest.toObject = function toObject() {
            return {};
        };

        /**
         * Converts this TListIncidentFiltersRequest to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TListIncidentFiltersRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TListIncidentFiltersRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TListIncidentFiltersRequest;
    })();

    NTentaclesApi.TListIncidentFiltersResult = (function() {

        /**
         * Properties of a TListIncidentFiltersResult.
         * @memberof NTentaclesApi
         * @interface ITListIncidentFiltersResult
         * @property {NTentaclesApi.ITIncidentFiltersList|null} [filters_list] TListIncidentFiltersResult filters_list
         */

        /**
         * Constructs a new TListIncidentFiltersResult.
         * @memberof NTentaclesApi
         * @classdesc Represents a TListIncidentFiltersResult.
         * @implements ITListIncidentFiltersResult
         * @constructor
         * @param {NTentaclesApi.ITListIncidentFiltersResult=} [properties] Properties to set
         */
        function TListIncidentFiltersResult(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TListIncidentFiltersResult filters_list.
         * @member {NTentaclesApi.ITIncidentFiltersList|null|undefined} filters_list
         * @memberof NTentaclesApi.TListIncidentFiltersResult
         * @instance
         */
        TListIncidentFiltersResult.prototype.filters_list = null;

        /**
         * Creates a new TListIncidentFiltersResult instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TListIncidentFiltersResult
         * @static
         * @param {NTentaclesApi.ITListIncidentFiltersResult=} [properties] Properties to set
         * @returns {NTentaclesApi.TListIncidentFiltersResult} TListIncidentFiltersResult instance
         */
        TListIncidentFiltersResult.create = function create(properties) {
            return new TListIncidentFiltersResult(properties);
        };

        /**
         * Encodes the specified TListIncidentFiltersResult message. Does not implicitly {@link NTentaclesApi.TListIncidentFiltersResult.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TListIncidentFiltersResult
         * @static
         * @param {NTentaclesApi.ITListIncidentFiltersResult} message TListIncidentFiltersResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TListIncidentFiltersResult.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.filters_list != null && Object.hasOwnProperty.call(message, "filters_list"))
                $root.NTentaclesApi.TIncidentFiltersList.encode(message.filters_list, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TListIncidentFiltersResult message, length delimited. Does not implicitly {@link NTentaclesApi.TListIncidentFiltersResult.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TListIncidentFiltersResult
         * @static
         * @param {NTentaclesApi.ITListIncidentFiltersResult} message TListIncidentFiltersResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TListIncidentFiltersResult.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TListIncidentFiltersResult message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TListIncidentFiltersResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TListIncidentFiltersResult} TListIncidentFiltersResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TListIncidentFiltersResult.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TListIncidentFiltersResult();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.filters_list = $root.NTentaclesApi.TIncidentFiltersList.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TListIncidentFiltersResult message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TListIncidentFiltersResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TListIncidentFiltersResult} TListIncidentFiltersResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TListIncidentFiltersResult.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TListIncidentFiltersResult message.
         * @function verify
         * @memberof NTentaclesApi.TListIncidentFiltersResult
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TListIncidentFiltersResult.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.filters_list != null && message.hasOwnProperty("filters_list")) {
                let error = $root.NTentaclesApi.TIncidentFiltersList.verify(message.filters_list);
                if (error)
                    return "filters_list." + error;
            }
            return null;
        };

        /**
         * Creates a TListIncidentFiltersResult message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TListIncidentFiltersResult
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TListIncidentFiltersResult} TListIncidentFiltersResult
         */
        TListIncidentFiltersResult.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TListIncidentFiltersResult)
                return object;
            let message = new $root.NTentaclesApi.TListIncidentFiltersResult();
            if (object.filters_list != null) {
                if (typeof object.filters_list !== "object")
                    throw TypeError(".NTentaclesApi.TListIncidentFiltersResult.filters_list: object expected");
                message.filters_list = $root.NTentaclesApi.TIncidentFiltersList.fromObject(object.filters_list);
            }
            return message;
        };

        /**
         * Creates a plain object from a TListIncidentFiltersResult message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TListIncidentFiltersResult
         * @static
         * @param {NTentaclesApi.TListIncidentFiltersResult} message TListIncidentFiltersResult
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TListIncidentFiltersResult.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.filters_list = null;
            if (message.filters_list != null && message.hasOwnProperty("filters_list"))
                object.filters_list = $root.NTentaclesApi.TIncidentFiltersList.toObject(message.filters_list, options);
            return object;
        };

        /**
         * Converts this TListIncidentFiltersResult to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TListIncidentFiltersResult
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TListIncidentFiltersResult.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TListIncidentFiltersResult;
    })();

    NTentaclesApi.TListIncidentFiltersResponse = (function() {

        /**
         * Properties of a TListIncidentFiltersResponse.
         * @memberof NTentaclesApi
         * @interface ITListIncidentFiltersResponse
         * @property {string|null} [error] TListIncidentFiltersResponse error
         * @property {NTentaclesApi.ITListIncidentFiltersResult|null} [result] TListIncidentFiltersResponse result
         */

        /**
         * Constructs a new TListIncidentFiltersResponse.
         * @memberof NTentaclesApi
         * @classdesc Represents a TListIncidentFiltersResponse.
         * @implements ITListIncidentFiltersResponse
         * @constructor
         * @param {NTentaclesApi.ITListIncidentFiltersResponse=} [properties] Properties to set
         */
        function TListIncidentFiltersResponse(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TListIncidentFiltersResponse error.
         * @member {string} error
         * @memberof NTentaclesApi.TListIncidentFiltersResponse
         * @instance
         */
        TListIncidentFiltersResponse.prototype.error = "";

        /**
         * TListIncidentFiltersResponse result.
         * @member {NTentaclesApi.ITListIncidentFiltersResult|null|undefined} result
         * @memberof NTentaclesApi.TListIncidentFiltersResponse
         * @instance
         */
        TListIncidentFiltersResponse.prototype.result = null;

        /**
         * Creates a new TListIncidentFiltersResponse instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TListIncidentFiltersResponse
         * @static
         * @param {NTentaclesApi.ITListIncidentFiltersResponse=} [properties] Properties to set
         * @returns {NTentaclesApi.TListIncidentFiltersResponse} TListIncidentFiltersResponse instance
         */
        TListIncidentFiltersResponse.create = function create(properties) {
            return new TListIncidentFiltersResponse(properties);
        };

        /**
         * Encodes the specified TListIncidentFiltersResponse message. Does not implicitly {@link NTentaclesApi.TListIncidentFiltersResponse.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TListIncidentFiltersResponse
         * @static
         * @param {NTentaclesApi.ITListIncidentFiltersResponse} message TListIncidentFiltersResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TListIncidentFiltersResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.error != null && Object.hasOwnProperty.call(message, "error"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.error);
            if (message.result != null && Object.hasOwnProperty.call(message, "result"))
                $root.NTentaclesApi.TListIncidentFiltersResult.encode(message.result, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TListIncidentFiltersResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TListIncidentFiltersResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TListIncidentFiltersResponse
         * @static
         * @param {NTentaclesApi.ITListIncidentFiltersResponse} message TListIncidentFiltersResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TListIncidentFiltersResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TListIncidentFiltersResponse message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TListIncidentFiltersResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TListIncidentFiltersResponse} TListIncidentFiltersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TListIncidentFiltersResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TListIncidentFiltersResponse();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.error = reader.string();
                    break;
                case 2:
                    message.result = $root.NTentaclesApi.TListIncidentFiltersResult.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TListIncidentFiltersResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TListIncidentFiltersResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TListIncidentFiltersResponse} TListIncidentFiltersResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TListIncidentFiltersResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TListIncidentFiltersResponse message.
         * @function verify
         * @memberof NTentaclesApi.TListIncidentFiltersResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TListIncidentFiltersResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.error != null && message.hasOwnProperty("error"))
                if (!$util.isString(message.error))
                    return "error: string expected";
            if (message.result != null && message.hasOwnProperty("result")) {
                let error = $root.NTentaclesApi.TListIncidentFiltersResult.verify(message.result);
                if (error)
                    return "result." + error;
            }
            return null;
        };

        /**
         * Creates a TListIncidentFiltersResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TListIncidentFiltersResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TListIncidentFiltersResponse} TListIncidentFiltersResponse
         */
        TListIncidentFiltersResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TListIncidentFiltersResponse)
                return object;
            let message = new $root.NTentaclesApi.TListIncidentFiltersResponse();
            if (object.error != null)
                message.error = String(object.error);
            if (object.result != null) {
                if (typeof object.result !== "object")
                    throw TypeError(".NTentaclesApi.TListIncidentFiltersResponse.result: object expected");
                message.result = $root.NTentaclesApi.TListIncidentFiltersResult.fromObject(object.result);
            }
            return message;
        };

        /**
         * Creates a plain object from a TListIncidentFiltersResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TListIncidentFiltersResponse
         * @static
         * @param {NTentaclesApi.TListIncidentFiltersResponse} message TListIncidentFiltersResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TListIncidentFiltersResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.error = "";
                object.result = null;
            }
            if (message.error != null && message.hasOwnProperty("error"))
                object.error = message.error;
            if (message.result != null && message.hasOwnProperty("result"))
                object.result = $root.NTentaclesApi.TListIncidentFiltersResult.toObject(message.result, options);
            return object;
        };

        /**
         * Converts this TListIncidentFiltersResponse to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TListIncidentFiltersResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TListIncidentFiltersResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TListIncidentFiltersResponse;
    })();

    NTentaclesApi.TReadIncidentsRequest = (function() {

        /**
         * Properties of a TReadIncidentsRequest.
         * @memberof NTentaclesApi
         * @interface ITReadIncidentsRequest
         * @property {NTentaclesApi.ITIncidentFilter|null} [filter] TReadIncidentsRequest filter
         * @property {number|Long|null} [limit] TReadIncidentsRequest limit
         * @property {number|Long|null} [offset] TReadIncidentsRequest offset
         */

        /**
         * Constructs a new TReadIncidentsRequest.
         * @memberof NTentaclesApi
         * @classdesc Represents a TReadIncidentsRequest.
         * @implements ITReadIncidentsRequest
         * @constructor
         * @param {NTentaclesApi.ITReadIncidentsRequest=} [properties] Properties to set
         */
        function TReadIncidentsRequest(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TReadIncidentsRequest filter.
         * @member {NTentaclesApi.ITIncidentFilter|null|undefined} filter
         * @memberof NTentaclesApi.TReadIncidentsRequest
         * @instance
         */
        TReadIncidentsRequest.prototype.filter = null;

        /**
         * TReadIncidentsRequest limit.
         * @member {number|Long} limit
         * @memberof NTentaclesApi.TReadIncidentsRequest
         * @instance
         */
        TReadIncidentsRequest.prototype.limit = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TReadIncidentsRequest offset.
         * @member {number|Long} offset
         * @memberof NTentaclesApi.TReadIncidentsRequest
         * @instance
         */
        TReadIncidentsRequest.prototype.offset = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Creates a new TReadIncidentsRequest instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TReadIncidentsRequest
         * @static
         * @param {NTentaclesApi.ITReadIncidentsRequest=} [properties] Properties to set
         * @returns {NTentaclesApi.TReadIncidentsRequest} TReadIncidentsRequest instance
         */
        TReadIncidentsRequest.create = function create(properties) {
            return new TReadIncidentsRequest(properties);
        };

        /**
         * Encodes the specified TReadIncidentsRequest message. Does not implicitly {@link NTentaclesApi.TReadIncidentsRequest.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TReadIncidentsRequest
         * @static
         * @param {NTentaclesApi.ITReadIncidentsRequest} message TReadIncidentsRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReadIncidentsRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                $root.NTentaclesApi.TIncidentFilter.encode(message.filter, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.limit != null && Object.hasOwnProperty.call(message, "limit"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.limit);
            if (message.offset != null && Object.hasOwnProperty.call(message, "offset"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint64(message.offset);
            return writer;
        };

        /**
         * Encodes the specified TReadIncidentsRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TReadIncidentsRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TReadIncidentsRequest
         * @static
         * @param {NTentaclesApi.ITReadIncidentsRequest} message TReadIncidentsRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReadIncidentsRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TReadIncidentsRequest message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TReadIncidentsRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TReadIncidentsRequest} TReadIncidentsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReadIncidentsRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TReadIncidentsRequest();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.filter = $root.NTentaclesApi.TIncidentFilter.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.limit = reader.uint64();
                    break;
                case 3:
                    message.offset = reader.uint64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TReadIncidentsRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TReadIncidentsRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TReadIncidentsRequest} TReadIncidentsRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReadIncidentsRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TReadIncidentsRequest message.
         * @function verify
         * @memberof NTentaclesApi.TReadIncidentsRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TReadIncidentsRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.filter != null && message.hasOwnProperty("filter")) {
                let error = $root.NTentaclesApi.TIncidentFilter.verify(message.filter);
                if (error)
                    return "filter." + error;
            }
            if (message.limit != null && message.hasOwnProperty("limit"))
                if (!$util.isInteger(message.limit) && !(message.limit && $util.isInteger(message.limit.low) && $util.isInteger(message.limit.high)))
                    return "limit: integer|Long expected";
            if (message.offset != null && message.hasOwnProperty("offset"))
                if (!$util.isInteger(message.offset) && !(message.offset && $util.isInteger(message.offset.low) && $util.isInteger(message.offset.high)))
                    return "offset: integer|Long expected";
            return null;
        };

        /**
         * Creates a TReadIncidentsRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TReadIncidentsRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TReadIncidentsRequest} TReadIncidentsRequest
         */
        TReadIncidentsRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TReadIncidentsRequest)
                return object;
            let message = new $root.NTentaclesApi.TReadIncidentsRequest();
            if (object.filter != null) {
                if (typeof object.filter !== "object")
                    throw TypeError(".NTentaclesApi.TReadIncidentsRequest.filter: object expected");
                message.filter = $root.NTentaclesApi.TIncidentFilter.fromObject(object.filter);
            }
            if (object.limit != null)
                if ($util.Long)
                    (message.limit = $util.Long.fromValue(object.limit)).unsigned = true;
                else if (typeof object.limit === "string")
                    message.limit = parseInt(object.limit, 10);
                else if (typeof object.limit === "number")
                    message.limit = object.limit;
                else if (typeof object.limit === "object")
                    message.limit = new $util.LongBits(object.limit.low >>> 0, object.limit.high >>> 0).toNumber(true);
            if (object.offset != null)
                if ($util.Long)
                    (message.offset = $util.Long.fromValue(object.offset)).unsigned = true;
                else if (typeof object.offset === "string")
                    message.offset = parseInt(object.offset, 10);
                else if (typeof object.offset === "number")
                    message.offset = object.offset;
                else if (typeof object.offset === "object")
                    message.offset = new $util.LongBits(object.offset.low >>> 0, object.offset.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a TReadIncidentsRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TReadIncidentsRequest
         * @static
         * @param {NTentaclesApi.TReadIncidentsRequest} message TReadIncidentsRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TReadIncidentsRequest.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.filter = null;
                if ($util.Long) {
                    let long = new $util.Long(0, 0, true);
                    object.limit = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.limit = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    let long = new $util.Long(0, 0, true);
                    object.offset = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.offset = options.longs === String ? "0" : 0;
            }
            if (message.filter != null && message.hasOwnProperty("filter"))
                object.filter = $root.NTentaclesApi.TIncidentFilter.toObject(message.filter, options);
            if (message.limit != null && message.hasOwnProperty("limit"))
                if (typeof message.limit === "number")
                    object.limit = options.longs === String ? String(message.limit) : message.limit;
                else
                    object.limit = options.longs === String ? $util.Long.prototype.toString.call(message.limit) : options.longs === Number ? new $util.LongBits(message.limit.low >>> 0, message.limit.high >>> 0).toNumber(true) : message.limit;
            if (message.offset != null && message.hasOwnProperty("offset"))
                if (typeof message.offset === "number")
                    object.offset = options.longs === String ? String(message.offset) : message.offset;
                else
                    object.offset = options.longs === String ? $util.Long.prototype.toString.call(message.offset) : options.longs === Number ? new $util.LongBits(message.offset.low >>> 0, message.offset.high >>> 0).toNumber(true) : message.offset;
            return object;
        };

        /**
         * Converts this TReadIncidentsRequest to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TReadIncidentsRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TReadIncidentsRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TReadIncidentsRequest;
    })();

    NTentaclesApi.TReadIncidentsResult = (function() {

        /**
         * Properties of a TReadIncidentsResult.
         * @memberof NTentaclesApi
         * @interface ITReadIncidentsResult
         * @property {Array.<NTentaclesApi.ITIncident>|null} [incidents] TReadIncidentsResult incidents
         * @property {number|null} [total] TReadIncidentsResult total
         * @property {number|null} [total_minutes_out_of_slo] TReadIncidentsResult total_minutes_out_of_slo
         */

        /**
         * Constructs a new TReadIncidentsResult.
         * @memberof NTentaclesApi
         * @classdesc Represents a TReadIncidentsResult.
         * @implements ITReadIncidentsResult
         * @constructor
         * @param {NTentaclesApi.ITReadIncidentsResult=} [properties] Properties to set
         */
        function TReadIncidentsResult(properties) {
            this.incidents = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TReadIncidentsResult incidents.
         * @member {Array.<NTentaclesApi.ITIncident>} incidents
         * @memberof NTentaclesApi.TReadIncidentsResult
         * @instance
         */
        TReadIncidentsResult.prototype.incidents = $util.emptyArray;

        /**
         * TReadIncidentsResult total.
         * @member {number} total
         * @memberof NTentaclesApi.TReadIncidentsResult
         * @instance
         */
        TReadIncidentsResult.prototype.total = 0;

        /**
         * TReadIncidentsResult total_minutes_out_of_slo.
         * @member {number} total_minutes_out_of_slo
         * @memberof NTentaclesApi.TReadIncidentsResult
         * @instance
         */
        TReadIncidentsResult.prototype.total_minutes_out_of_slo = 0;

        /**
         * Creates a new TReadIncidentsResult instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TReadIncidentsResult
         * @static
         * @param {NTentaclesApi.ITReadIncidentsResult=} [properties] Properties to set
         * @returns {NTentaclesApi.TReadIncidentsResult} TReadIncidentsResult instance
         */
        TReadIncidentsResult.create = function create(properties) {
            return new TReadIncidentsResult(properties);
        };

        /**
         * Encodes the specified TReadIncidentsResult message. Does not implicitly {@link NTentaclesApi.TReadIncidentsResult.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TReadIncidentsResult
         * @static
         * @param {NTentaclesApi.ITReadIncidentsResult} message TReadIncidentsResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReadIncidentsResult.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.incidents != null && message.incidents.length)
                for (let i = 0; i < message.incidents.length; ++i)
                    $root.NTentaclesApi.TIncident.encode(message.incidents[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.total != null && Object.hasOwnProperty.call(message, "total"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.total);
            if (message.total_minutes_out_of_slo != null && Object.hasOwnProperty.call(message, "total_minutes_out_of_slo"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.total_minutes_out_of_slo);
            return writer;
        };

        /**
         * Encodes the specified TReadIncidentsResult message, length delimited. Does not implicitly {@link NTentaclesApi.TReadIncidentsResult.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TReadIncidentsResult
         * @static
         * @param {NTentaclesApi.ITReadIncidentsResult} message TReadIncidentsResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReadIncidentsResult.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TReadIncidentsResult message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TReadIncidentsResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TReadIncidentsResult} TReadIncidentsResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReadIncidentsResult.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TReadIncidentsResult();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.incidents && message.incidents.length))
                        message.incidents = [];
                    message.incidents.push($root.NTentaclesApi.TIncident.decode(reader, reader.uint32()));
                    break;
                case 2:
                    message.total = reader.uint32();
                    break;
                case 3:
                    message.total_minutes_out_of_slo = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TReadIncidentsResult message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TReadIncidentsResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TReadIncidentsResult} TReadIncidentsResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReadIncidentsResult.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TReadIncidentsResult message.
         * @function verify
         * @memberof NTentaclesApi.TReadIncidentsResult
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TReadIncidentsResult.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.incidents != null && message.hasOwnProperty("incidents")) {
                if (!Array.isArray(message.incidents))
                    return "incidents: array expected";
                for (let i = 0; i < message.incidents.length; ++i) {
                    let error = $root.NTentaclesApi.TIncident.verify(message.incidents[i]);
                    if (error)
                        return "incidents." + error;
                }
            }
            if (message.total != null && message.hasOwnProperty("total"))
                if (!$util.isInteger(message.total))
                    return "total: integer expected";
            if (message.total_minutes_out_of_slo != null && message.hasOwnProperty("total_minutes_out_of_slo"))
                if (!$util.isInteger(message.total_minutes_out_of_slo))
                    return "total_minutes_out_of_slo: integer expected";
            return null;
        };

        /**
         * Creates a TReadIncidentsResult message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TReadIncidentsResult
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TReadIncidentsResult} TReadIncidentsResult
         */
        TReadIncidentsResult.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TReadIncidentsResult)
                return object;
            let message = new $root.NTentaclesApi.TReadIncidentsResult();
            if (object.incidents) {
                if (!Array.isArray(object.incidents))
                    throw TypeError(".NTentaclesApi.TReadIncidentsResult.incidents: array expected");
                message.incidents = [];
                for (let i = 0; i < object.incidents.length; ++i) {
                    if (typeof object.incidents[i] !== "object")
                        throw TypeError(".NTentaclesApi.TReadIncidentsResult.incidents: object expected");
                    message.incidents[i] = $root.NTentaclesApi.TIncident.fromObject(object.incidents[i]);
                }
            }
            if (object.total != null)
                message.total = object.total >>> 0;
            if (object.total_minutes_out_of_slo != null)
                message.total_minutes_out_of_slo = object.total_minutes_out_of_slo >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a TReadIncidentsResult message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TReadIncidentsResult
         * @static
         * @param {NTentaclesApi.TReadIncidentsResult} message TReadIncidentsResult
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TReadIncidentsResult.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.incidents = [];
            if (options.defaults) {
                object.total = 0;
                object.total_minutes_out_of_slo = 0;
            }
            if (message.incidents && message.incidents.length) {
                object.incidents = [];
                for (let j = 0; j < message.incidents.length; ++j)
                    object.incidents[j] = $root.NTentaclesApi.TIncident.toObject(message.incidents[j], options);
            }
            if (message.total != null && message.hasOwnProperty("total"))
                object.total = message.total;
            if (message.total_minutes_out_of_slo != null && message.hasOwnProperty("total_minutes_out_of_slo"))
                object.total_minutes_out_of_slo = message.total_minutes_out_of_slo;
            return object;
        };

        /**
         * Converts this TReadIncidentsResult to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TReadIncidentsResult
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TReadIncidentsResult.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TReadIncidentsResult;
    })();

    NTentaclesApi.TReadIncidentsResponse = (function() {

        /**
         * Properties of a TReadIncidentsResponse.
         * @memberof NTentaclesApi
         * @interface ITReadIncidentsResponse
         * @property {string|null} [error] TReadIncidentsResponse error
         * @property {NTentaclesApi.ITReadIncidentsResult|null} [result] TReadIncidentsResponse result
         */

        /**
         * Constructs a new TReadIncidentsResponse.
         * @memberof NTentaclesApi
         * @classdesc Represents a TReadIncidentsResponse.
         * @implements ITReadIncidentsResponse
         * @constructor
         * @param {NTentaclesApi.ITReadIncidentsResponse=} [properties] Properties to set
         */
        function TReadIncidentsResponse(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TReadIncidentsResponse error.
         * @member {string} error
         * @memberof NTentaclesApi.TReadIncidentsResponse
         * @instance
         */
        TReadIncidentsResponse.prototype.error = "";

        /**
         * TReadIncidentsResponse result.
         * @member {NTentaclesApi.ITReadIncidentsResult|null|undefined} result
         * @memberof NTentaclesApi.TReadIncidentsResponse
         * @instance
         */
        TReadIncidentsResponse.prototype.result = null;

        /**
         * Creates a new TReadIncidentsResponse instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TReadIncidentsResponse
         * @static
         * @param {NTentaclesApi.ITReadIncidentsResponse=} [properties] Properties to set
         * @returns {NTentaclesApi.TReadIncidentsResponse} TReadIncidentsResponse instance
         */
        TReadIncidentsResponse.create = function create(properties) {
            return new TReadIncidentsResponse(properties);
        };

        /**
         * Encodes the specified TReadIncidentsResponse message. Does not implicitly {@link NTentaclesApi.TReadIncidentsResponse.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TReadIncidentsResponse
         * @static
         * @param {NTentaclesApi.ITReadIncidentsResponse} message TReadIncidentsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReadIncidentsResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.error != null && Object.hasOwnProperty.call(message, "error"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.error);
            if (message.result != null && Object.hasOwnProperty.call(message, "result"))
                $root.NTentaclesApi.TReadIncidentsResult.encode(message.result, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TReadIncidentsResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TReadIncidentsResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TReadIncidentsResponse
         * @static
         * @param {NTentaclesApi.ITReadIncidentsResponse} message TReadIncidentsResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReadIncidentsResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TReadIncidentsResponse message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TReadIncidentsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TReadIncidentsResponse} TReadIncidentsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReadIncidentsResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TReadIncidentsResponse();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.error = reader.string();
                    break;
                case 2:
                    message.result = $root.NTentaclesApi.TReadIncidentsResult.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TReadIncidentsResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TReadIncidentsResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TReadIncidentsResponse} TReadIncidentsResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReadIncidentsResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TReadIncidentsResponse message.
         * @function verify
         * @memberof NTentaclesApi.TReadIncidentsResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TReadIncidentsResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.error != null && message.hasOwnProperty("error"))
                if (!$util.isString(message.error))
                    return "error: string expected";
            if (message.result != null && message.hasOwnProperty("result")) {
                let error = $root.NTentaclesApi.TReadIncidentsResult.verify(message.result);
                if (error)
                    return "result." + error;
            }
            return null;
        };

        /**
         * Creates a TReadIncidentsResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TReadIncidentsResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TReadIncidentsResponse} TReadIncidentsResponse
         */
        TReadIncidentsResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TReadIncidentsResponse)
                return object;
            let message = new $root.NTentaclesApi.TReadIncidentsResponse();
            if (object.error != null)
                message.error = String(object.error);
            if (object.result != null) {
                if (typeof object.result !== "object")
                    throw TypeError(".NTentaclesApi.TReadIncidentsResponse.result: object expected");
                message.result = $root.NTentaclesApi.TReadIncidentsResult.fromObject(object.result);
            }
            return message;
        };

        /**
         * Creates a plain object from a TReadIncidentsResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TReadIncidentsResponse
         * @static
         * @param {NTentaclesApi.TReadIncidentsResponse} message TReadIncidentsResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TReadIncidentsResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.error = "";
                object.result = null;
            }
            if (message.error != null && message.hasOwnProperty("error"))
                object.error = message.error;
            if (message.result != null && message.hasOwnProperty("result"))
                object.result = $root.NTentaclesApi.TReadIncidentsResult.toObject(message.result, options);
            return object;
        };

        /**
         * Converts this TReadIncidentsResponse to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TReadIncidentsResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TReadIncidentsResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TReadIncidentsResponse;
    })();

    NTentaclesApi.TReadIncidentDataRequest = (function() {

        /**
         * Properties of a TReadIncidentDataRequest.
         * @memberof NTentaclesApi
         * @interface ITReadIncidentDataRequest
         * @property {string|null} [id] TReadIncidentDataRequest id
         */

        /**
         * Constructs a new TReadIncidentDataRequest.
         * @memberof NTentaclesApi
         * @classdesc Represents a TReadIncidentDataRequest.
         * @implements ITReadIncidentDataRequest
         * @constructor
         * @param {NTentaclesApi.ITReadIncidentDataRequest=} [properties] Properties to set
         */
        function TReadIncidentDataRequest(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TReadIncidentDataRequest id.
         * @member {string} id
         * @memberof NTentaclesApi.TReadIncidentDataRequest
         * @instance
         */
        TReadIncidentDataRequest.prototype.id = "";

        /**
         * Creates a new TReadIncidentDataRequest instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TReadIncidentDataRequest
         * @static
         * @param {NTentaclesApi.ITReadIncidentDataRequest=} [properties] Properties to set
         * @returns {NTentaclesApi.TReadIncidentDataRequest} TReadIncidentDataRequest instance
         */
        TReadIncidentDataRequest.create = function create(properties) {
            return new TReadIncidentDataRequest(properties);
        };

        /**
         * Encodes the specified TReadIncidentDataRequest message. Does not implicitly {@link NTentaclesApi.TReadIncidentDataRequest.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TReadIncidentDataRequest
         * @static
         * @param {NTentaclesApi.ITReadIncidentDataRequest} message TReadIncidentDataRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReadIncidentDataRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
            return writer;
        };

        /**
         * Encodes the specified TReadIncidentDataRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TReadIncidentDataRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TReadIncidentDataRequest
         * @static
         * @param {NTentaclesApi.ITReadIncidentDataRequest} message TReadIncidentDataRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReadIncidentDataRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TReadIncidentDataRequest message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TReadIncidentDataRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TReadIncidentDataRequest} TReadIncidentDataRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReadIncidentDataRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TReadIncidentDataRequest();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TReadIncidentDataRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TReadIncidentDataRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TReadIncidentDataRequest} TReadIncidentDataRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReadIncidentDataRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TReadIncidentDataRequest message.
         * @function verify
         * @memberof NTentaclesApi.TReadIncidentDataRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TReadIncidentDataRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            return null;
        };

        /**
         * Creates a TReadIncidentDataRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TReadIncidentDataRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TReadIncidentDataRequest} TReadIncidentDataRequest
         */
        TReadIncidentDataRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TReadIncidentDataRequest)
                return object;
            let message = new $root.NTentaclesApi.TReadIncidentDataRequest();
            if (object.id != null)
                message.id = String(object.id);
            return message;
        };

        /**
         * Creates a plain object from a TReadIncidentDataRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TReadIncidentDataRequest
         * @static
         * @param {NTentaclesApi.TReadIncidentDataRequest} message TReadIncidentDataRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TReadIncidentDataRequest.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.id = "";
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            return object;
        };

        /**
         * Converts this TReadIncidentDataRequest to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TReadIncidentDataRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TReadIncidentDataRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TReadIncidentDataRequest;
    })();

    NTentaclesApi.TReadIncidentDataResult = (function() {

        /**
         * Properties of a TReadIncidentDataResult.
         * @memberof NTentaclesApi
         * @interface ITReadIncidentDataResult
         * @property {NTentaclesApi.ITIncident|null} [data] TReadIncidentDataResult data
         */

        /**
         * Constructs a new TReadIncidentDataResult.
         * @memberof NTentaclesApi
         * @classdesc Represents a TReadIncidentDataResult.
         * @implements ITReadIncidentDataResult
         * @constructor
         * @param {NTentaclesApi.ITReadIncidentDataResult=} [properties] Properties to set
         */
        function TReadIncidentDataResult(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TReadIncidentDataResult data.
         * @member {NTentaclesApi.ITIncident|null|undefined} data
         * @memberof NTentaclesApi.TReadIncidentDataResult
         * @instance
         */
        TReadIncidentDataResult.prototype.data = null;

        /**
         * Creates a new TReadIncidentDataResult instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TReadIncidentDataResult
         * @static
         * @param {NTentaclesApi.ITReadIncidentDataResult=} [properties] Properties to set
         * @returns {NTentaclesApi.TReadIncidentDataResult} TReadIncidentDataResult instance
         */
        TReadIncidentDataResult.create = function create(properties) {
            return new TReadIncidentDataResult(properties);
        };

        /**
         * Encodes the specified TReadIncidentDataResult message. Does not implicitly {@link NTentaclesApi.TReadIncidentDataResult.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TReadIncidentDataResult
         * @static
         * @param {NTentaclesApi.ITReadIncidentDataResult} message TReadIncidentDataResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReadIncidentDataResult.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                $root.NTentaclesApi.TIncident.encode(message.data, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TReadIncidentDataResult message, length delimited. Does not implicitly {@link NTentaclesApi.TReadIncidentDataResult.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TReadIncidentDataResult
         * @static
         * @param {NTentaclesApi.ITReadIncidentDataResult} message TReadIncidentDataResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReadIncidentDataResult.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TReadIncidentDataResult message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TReadIncidentDataResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TReadIncidentDataResult} TReadIncidentDataResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReadIncidentDataResult.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TReadIncidentDataResult();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.data = $root.NTentaclesApi.TIncident.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TReadIncidentDataResult message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TReadIncidentDataResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TReadIncidentDataResult} TReadIncidentDataResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReadIncidentDataResult.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TReadIncidentDataResult message.
         * @function verify
         * @memberof NTentaclesApi.TReadIncidentDataResult
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TReadIncidentDataResult.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.data != null && message.hasOwnProperty("data")) {
                let error = $root.NTentaclesApi.TIncident.verify(message.data);
                if (error)
                    return "data." + error;
            }
            return null;
        };

        /**
         * Creates a TReadIncidentDataResult message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TReadIncidentDataResult
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TReadIncidentDataResult} TReadIncidentDataResult
         */
        TReadIncidentDataResult.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TReadIncidentDataResult)
                return object;
            let message = new $root.NTentaclesApi.TReadIncidentDataResult();
            if (object.data != null) {
                if (typeof object.data !== "object")
                    throw TypeError(".NTentaclesApi.TReadIncidentDataResult.data: object expected");
                message.data = $root.NTentaclesApi.TIncident.fromObject(object.data);
            }
            return message;
        };

        /**
         * Creates a plain object from a TReadIncidentDataResult message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TReadIncidentDataResult
         * @static
         * @param {NTentaclesApi.TReadIncidentDataResult} message TReadIncidentDataResult
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TReadIncidentDataResult.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.data = null;
            if (message.data != null && message.hasOwnProperty("data"))
                object.data = $root.NTentaclesApi.TIncident.toObject(message.data, options);
            return object;
        };

        /**
         * Converts this TReadIncidentDataResult to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TReadIncidentDataResult
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TReadIncidentDataResult.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TReadIncidentDataResult;
    })();

    NTentaclesApi.TReadIncidentDataResponse = (function() {

        /**
         * Properties of a TReadIncidentDataResponse.
         * @memberof NTentaclesApi
         * @interface ITReadIncidentDataResponse
         * @property {string|null} [error] TReadIncidentDataResponse error
         * @property {NTentaclesApi.ITReadIncidentDataResult|null} [result] TReadIncidentDataResponse result
         */

        /**
         * Constructs a new TReadIncidentDataResponse.
         * @memberof NTentaclesApi
         * @classdesc Represents a TReadIncidentDataResponse.
         * @implements ITReadIncidentDataResponse
         * @constructor
         * @param {NTentaclesApi.ITReadIncidentDataResponse=} [properties] Properties to set
         */
        function TReadIncidentDataResponse(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TReadIncidentDataResponse error.
         * @member {string} error
         * @memberof NTentaclesApi.TReadIncidentDataResponse
         * @instance
         */
        TReadIncidentDataResponse.prototype.error = "";

        /**
         * TReadIncidentDataResponse result.
         * @member {NTentaclesApi.ITReadIncidentDataResult|null|undefined} result
         * @memberof NTentaclesApi.TReadIncidentDataResponse
         * @instance
         */
        TReadIncidentDataResponse.prototype.result = null;

        /**
         * Creates a new TReadIncidentDataResponse instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TReadIncidentDataResponse
         * @static
         * @param {NTentaclesApi.ITReadIncidentDataResponse=} [properties] Properties to set
         * @returns {NTentaclesApi.TReadIncidentDataResponse} TReadIncidentDataResponse instance
         */
        TReadIncidentDataResponse.create = function create(properties) {
            return new TReadIncidentDataResponse(properties);
        };

        /**
         * Encodes the specified TReadIncidentDataResponse message. Does not implicitly {@link NTentaclesApi.TReadIncidentDataResponse.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TReadIncidentDataResponse
         * @static
         * @param {NTentaclesApi.ITReadIncidentDataResponse} message TReadIncidentDataResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReadIncidentDataResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.error != null && Object.hasOwnProperty.call(message, "error"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.error);
            if (message.result != null && Object.hasOwnProperty.call(message, "result"))
                $root.NTentaclesApi.TReadIncidentDataResult.encode(message.result, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TReadIncidentDataResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TReadIncidentDataResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TReadIncidentDataResponse
         * @static
         * @param {NTentaclesApi.ITReadIncidentDataResponse} message TReadIncidentDataResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TReadIncidentDataResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TReadIncidentDataResponse message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TReadIncidentDataResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TReadIncidentDataResponse} TReadIncidentDataResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReadIncidentDataResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TReadIncidentDataResponse();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.error = reader.string();
                    break;
                case 2:
                    message.result = $root.NTentaclesApi.TReadIncidentDataResult.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TReadIncidentDataResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TReadIncidentDataResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TReadIncidentDataResponse} TReadIncidentDataResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TReadIncidentDataResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TReadIncidentDataResponse message.
         * @function verify
         * @memberof NTentaclesApi.TReadIncidentDataResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TReadIncidentDataResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.error != null && message.hasOwnProperty("error"))
                if (!$util.isString(message.error))
                    return "error: string expected";
            if (message.result != null && message.hasOwnProperty("result")) {
                let error = $root.NTentaclesApi.TReadIncidentDataResult.verify(message.result);
                if (error)
                    return "result." + error;
            }
            return null;
        };

        /**
         * Creates a TReadIncidentDataResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TReadIncidentDataResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TReadIncidentDataResponse} TReadIncidentDataResponse
         */
        TReadIncidentDataResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TReadIncidentDataResponse)
                return object;
            let message = new $root.NTentaclesApi.TReadIncidentDataResponse();
            if (object.error != null)
                message.error = String(object.error);
            if (object.result != null) {
                if (typeof object.result !== "object")
                    throw TypeError(".NTentaclesApi.TReadIncidentDataResponse.result: object expected");
                message.result = $root.NTentaclesApi.TReadIncidentDataResult.fromObject(object.result);
            }
            return message;
        };

        /**
         * Creates a plain object from a TReadIncidentDataResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TReadIncidentDataResponse
         * @static
         * @param {NTentaclesApi.TReadIncidentDataResponse} message TReadIncidentDataResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TReadIncidentDataResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults) {
                object.error = "";
                object.result = null;
            }
            if (message.error != null && message.hasOwnProperty("error"))
                object.error = message.error;
            if (message.result != null && message.hasOwnProperty("result"))
                object.result = $root.NTentaclesApi.TReadIncidentDataResult.toObject(message.result, options);
            return object;
        };

        /**
         * Converts this TReadIncidentDataResponse to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TReadIncidentDataResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TReadIncidentDataResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TReadIncidentDataResponse;
    })();

    NTentaclesApi.TUpdateIncidentRequest = (function() {

        /**
         * Properties of a TUpdateIncidentRequest.
         * @memberof NTentaclesApi
         * @interface ITUpdateIncidentRequest
         * @property {NTentaclesApi.ITIncident|null} [data] TUpdateIncidentRequest data
         */

        /**
         * Constructs a new TUpdateIncidentRequest.
         * @memberof NTentaclesApi
         * @classdesc Represents a TUpdateIncidentRequest.
         * @implements ITUpdateIncidentRequest
         * @constructor
         * @param {NTentaclesApi.ITUpdateIncidentRequest=} [properties] Properties to set
         */
        function TUpdateIncidentRequest(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TUpdateIncidentRequest data.
         * @member {NTentaclesApi.ITIncident|null|undefined} data
         * @memberof NTentaclesApi.TUpdateIncidentRequest
         * @instance
         */
        TUpdateIncidentRequest.prototype.data = null;

        /**
         * Creates a new TUpdateIncidentRequest instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TUpdateIncidentRequest
         * @static
         * @param {NTentaclesApi.ITUpdateIncidentRequest=} [properties] Properties to set
         * @returns {NTentaclesApi.TUpdateIncidentRequest} TUpdateIncidentRequest instance
         */
        TUpdateIncidentRequest.create = function create(properties) {
            return new TUpdateIncidentRequest(properties);
        };

        /**
         * Encodes the specified TUpdateIncidentRequest message. Does not implicitly {@link NTentaclesApi.TUpdateIncidentRequest.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TUpdateIncidentRequest
         * @static
         * @param {NTentaclesApi.ITUpdateIncidentRequest} message TUpdateIncidentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TUpdateIncidentRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                $root.NTentaclesApi.TIncident.encode(message.data, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TUpdateIncidentRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TUpdateIncidentRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TUpdateIncidentRequest
         * @static
         * @param {NTentaclesApi.ITUpdateIncidentRequest} message TUpdateIncidentRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TUpdateIncidentRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TUpdateIncidentRequest message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TUpdateIncidentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TUpdateIncidentRequest} TUpdateIncidentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TUpdateIncidentRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TUpdateIncidentRequest();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.data = $root.NTentaclesApi.TIncident.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TUpdateIncidentRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TUpdateIncidentRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TUpdateIncidentRequest} TUpdateIncidentRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TUpdateIncidentRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TUpdateIncidentRequest message.
         * @function verify
         * @memberof NTentaclesApi.TUpdateIncidentRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TUpdateIncidentRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.data != null && message.hasOwnProperty("data")) {
                let error = $root.NTentaclesApi.TIncident.verify(message.data);
                if (error)
                    return "data." + error;
            }
            return null;
        };

        /**
         * Creates a TUpdateIncidentRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TUpdateIncidentRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TUpdateIncidentRequest} TUpdateIncidentRequest
         */
        TUpdateIncidentRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TUpdateIncidentRequest)
                return object;
            let message = new $root.NTentaclesApi.TUpdateIncidentRequest();
            if (object.data != null) {
                if (typeof object.data !== "object")
                    throw TypeError(".NTentaclesApi.TUpdateIncidentRequest.data: object expected");
                message.data = $root.NTentaclesApi.TIncident.fromObject(object.data);
            }
            return message;
        };

        /**
         * Creates a plain object from a TUpdateIncidentRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TUpdateIncidentRequest
         * @static
         * @param {NTentaclesApi.TUpdateIncidentRequest} message TUpdateIncidentRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TUpdateIncidentRequest.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.data = null;
            if (message.data != null && message.hasOwnProperty("data"))
                object.data = $root.NTentaclesApi.TIncident.toObject(message.data, options);
            return object;
        };

        /**
         * Converts this TUpdateIncidentRequest to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TUpdateIncidentRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TUpdateIncidentRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TUpdateIncidentRequest;
    })();

    NTentaclesApi.TUpdateIncidentResponse = (function() {

        /**
         * Properties of a TUpdateIncidentResponse.
         * @memberof NTentaclesApi
         * @interface ITUpdateIncidentResponse
         * @property {string|null} [error] TUpdateIncidentResponse error
         */

        /**
         * Constructs a new TUpdateIncidentResponse.
         * @memberof NTentaclesApi
         * @classdesc Represents a TUpdateIncidentResponse.
         * @implements ITUpdateIncidentResponse
         * @constructor
         * @param {NTentaclesApi.ITUpdateIncidentResponse=} [properties] Properties to set
         */
        function TUpdateIncidentResponse(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TUpdateIncidentResponse error.
         * @member {string} error
         * @memberof NTentaclesApi.TUpdateIncidentResponse
         * @instance
         */
        TUpdateIncidentResponse.prototype.error = "";

        /**
         * Creates a new TUpdateIncidentResponse instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TUpdateIncidentResponse
         * @static
         * @param {NTentaclesApi.ITUpdateIncidentResponse=} [properties] Properties to set
         * @returns {NTentaclesApi.TUpdateIncidentResponse} TUpdateIncidentResponse instance
         */
        TUpdateIncidentResponse.create = function create(properties) {
            return new TUpdateIncidentResponse(properties);
        };

        /**
         * Encodes the specified TUpdateIncidentResponse message. Does not implicitly {@link NTentaclesApi.TUpdateIncidentResponse.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TUpdateIncidentResponse
         * @static
         * @param {NTentaclesApi.ITUpdateIncidentResponse} message TUpdateIncidentResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TUpdateIncidentResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.error != null && Object.hasOwnProperty.call(message, "error"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.error);
            return writer;
        };

        /**
         * Encodes the specified TUpdateIncidentResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TUpdateIncidentResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TUpdateIncidentResponse
         * @static
         * @param {NTentaclesApi.ITUpdateIncidentResponse} message TUpdateIncidentResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TUpdateIncidentResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TUpdateIncidentResponse message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TUpdateIncidentResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TUpdateIncidentResponse} TUpdateIncidentResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TUpdateIncidentResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TUpdateIncidentResponse();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.error = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TUpdateIncidentResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TUpdateIncidentResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TUpdateIncidentResponse} TUpdateIncidentResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TUpdateIncidentResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TUpdateIncidentResponse message.
         * @function verify
         * @memberof NTentaclesApi.TUpdateIncidentResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TUpdateIncidentResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.error != null && message.hasOwnProperty("error"))
                if (!$util.isString(message.error))
                    return "error: string expected";
            return null;
        };

        /**
         * Creates a TUpdateIncidentResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TUpdateIncidentResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TUpdateIncidentResponse} TUpdateIncidentResponse
         */
        TUpdateIncidentResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TUpdateIncidentResponse)
                return object;
            let message = new $root.NTentaclesApi.TUpdateIncidentResponse();
            if (object.error != null)
                message.error = String(object.error);
            return message;
        };

        /**
         * Creates a plain object from a TUpdateIncidentResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TUpdateIncidentResponse
         * @static
         * @param {NTentaclesApi.TUpdateIncidentResponse} message TUpdateIncidentResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TUpdateIncidentResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.error = "";
            if (message.error != null && message.hasOwnProperty("error"))
                object.error = message.error;
            return object;
        };

        /**
         * Converts this TUpdateIncidentResponse to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TUpdateIncidentResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TUpdateIncidentResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TUpdateIncidentResponse;
    })();

    NTentaclesApi.TDataOverviewResult = (function() {

        /**
         * Properties of a TDataOverviewResult.
         * @memberof NTentaclesApi
         * @interface ITDataOverviewResult
         * @property {Array.<NTentaclesApi.ITAllocationZoneFeatures>|null} [allocation_zones] TDataOverviewResult allocation_zones
         */

        /**
         * Constructs a new TDataOverviewResult.
         * @memberof NTentaclesApi
         * @classdesc Represents a TDataOverviewResult.
         * @implements ITDataOverviewResult
         * @constructor
         * @param {NTentaclesApi.ITDataOverviewResult=} [properties] Properties to set
         */
        function TDataOverviewResult(properties) {
            this.allocation_zones = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TDataOverviewResult allocation_zones.
         * @member {Array.<NTentaclesApi.ITAllocationZoneFeatures>} allocation_zones
         * @memberof NTentaclesApi.TDataOverviewResult
         * @instance
         */
        TDataOverviewResult.prototype.allocation_zones = $util.emptyArray;

        /**
         * Creates a new TDataOverviewResult instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TDataOverviewResult
         * @static
         * @param {NTentaclesApi.ITDataOverviewResult=} [properties] Properties to set
         * @returns {NTentaclesApi.TDataOverviewResult} TDataOverviewResult instance
         */
        TDataOverviewResult.create = function create(properties) {
            return new TDataOverviewResult(properties);
        };

        /**
         * Encodes the specified TDataOverviewResult message. Does not implicitly {@link NTentaclesApi.TDataOverviewResult.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TDataOverviewResult
         * @static
         * @param {NTentaclesApi.ITDataOverviewResult} message TDataOverviewResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TDataOverviewResult.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.allocation_zones != null && message.allocation_zones.length)
                for (let i = 0; i < message.allocation_zones.length; ++i)
                    $root.NTentaclesApi.TAllocationZoneFeatures.encode(message.allocation_zones[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TDataOverviewResult message, length delimited. Does not implicitly {@link NTentaclesApi.TDataOverviewResult.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TDataOverviewResult
         * @static
         * @param {NTentaclesApi.ITDataOverviewResult} message TDataOverviewResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TDataOverviewResult.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TDataOverviewResult message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TDataOverviewResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TDataOverviewResult} TDataOverviewResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TDataOverviewResult.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TDataOverviewResult();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.allocation_zones && message.allocation_zones.length))
                        message.allocation_zones = [];
                    message.allocation_zones.push($root.NTentaclesApi.TAllocationZoneFeatures.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TDataOverviewResult message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TDataOverviewResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TDataOverviewResult} TDataOverviewResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TDataOverviewResult.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TDataOverviewResult message.
         * @function verify
         * @memberof NTentaclesApi.TDataOverviewResult
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TDataOverviewResult.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.allocation_zones != null && message.hasOwnProperty("allocation_zones")) {
                if (!Array.isArray(message.allocation_zones))
                    return "allocation_zones: array expected";
                for (let i = 0; i < message.allocation_zones.length; ++i) {
                    let error = $root.NTentaclesApi.TAllocationZoneFeatures.verify(message.allocation_zones[i]);
                    if (error)
                        return "allocation_zones." + error;
                }
            }
            return null;
        };

        /**
         * Creates a TDataOverviewResult message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TDataOverviewResult
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TDataOverviewResult} TDataOverviewResult
         */
        TDataOverviewResult.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TDataOverviewResult)
                return object;
            let message = new $root.NTentaclesApi.TDataOverviewResult();
            if (object.allocation_zones) {
                if (!Array.isArray(object.allocation_zones))
                    throw TypeError(".NTentaclesApi.TDataOverviewResult.allocation_zones: array expected");
                message.allocation_zones = [];
                for (let i = 0; i < object.allocation_zones.length; ++i) {
                    if (typeof object.allocation_zones[i] !== "object")
                        throw TypeError(".NTentaclesApi.TDataOverviewResult.allocation_zones: object expected");
                    message.allocation_zones[i] = $root.NTentaclesApi.TAllocationZoneFeatures.fromObject(object.allocation_zones[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a TDataOverviewResult message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TDataOverviewResult
         * @static
         * @param {NTentaclesApi.TDataOverviewResult} message TDataOverviewResult
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TDataOverviewResult.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.allocation_zones = [];
            if (message.allocation_zones && message.allocation_zones.length) {
                object.allocation_zones = [];
                for (let j = 0; j < message.allocation_zones.length; ++j)
                    object.allocation_zones[j] = $root.NTentaclesApi.TAllocationZoneFeatures.toObject(message.allocation_zones[j], options);
            }
            return object;
        };

        /**
         * Converts this TDataOverviewResult to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TDataOverviewResult
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TDataOverviewResult.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TDataOverviewResult;
    })();

    NTentaclesApi.TDataOverviewResponse = (function() {

        /**
         * Properties of a TDataOverviewResponse.
         * @memberof NTentaclesApi
         * @interface ITDataOverviewResponse
         * @property {NTentaclesApi.ITDataOverviewResult|null} [result] TDataOverviewResponse result
         */

        /**
         * Constructs a new TDataOverviewResponse.
         * @memberof NTentaclesApi
         * @classdesc Represents a TDataOverviewResponse.
         * @implements ITDataOverviewResponse
         * @constructor
         * @param {NTentaclesApi.ITDataOverviewResponse=} [properties] Properties to set
         */
        function TDataOverviewResponse(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TDataOverviewResponse result.
         * @member {NTentaclesApi.ITDataOverviewResult|null|undefined} result
         * @memberof NTentaclesApi.TDataOverviewResponse
         * @instance
         */
        TDataOverviewResponse.prototype.result = null;

        /**
         * Creates a new TDataOverviewResponse instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TDataOverviewResponse
         * @static
         * @param {NTentaclesApi.ITDataOverviewResponse=} [properties] Properties to set
         * @returns {NTentaclesApi.TDataOverviewResponse} TDataOverviewResponse instance
         */
        TDataOverviewResponse.create = function create(properties) {
            return new TDataOverviewResponse(properties);
        };

        /**
         * Encodes the specified TDataOverviewResponse message. Does not implicitly {@link NTentaclesApi.TDataOverviewResponse.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TDataOverviewResponse
         * @static
         * @param {NTentaclesApi.ITDataOverviewResponse} message TDataOverviewResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TDataOverviewResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.result != null && Object.hasOwnProperty.call(message, "result"))
                $root.NTentaclesApi.TDataOverviewResult.encode(message.result, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TDataOverviewResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TDataOverviewResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TDataOverviewResponse
         * @static
         * @param {NTentaclesApi.ITDataOverviewResponse} message TDataOverviewResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TDataOverviewResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TDataOverviewResponse message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TDataOverviewResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TDataOverviewResponse} TDataOverviewResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TDataOverviewResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TDataOverviewResponse();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.result = $root.NTentaclesApi.TDataOverviewResult.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TDataOverviewResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TDataOverviewResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TDataOverviewResponse} TDataOverviewResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TDataOverviewResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TDataOverviewResponse message.
         * @function verify
         * @memberof NTentaclesApi.TDataOverviewResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TDataOverviewResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.result != null && message.hasOwnProperty("result")) {
                let error = $root.NTentaclesApi.TDataOverviewResult.verify(message.result);
                if (error)
                    return "result." + error;
            }
            return null;
        };

        /**
         * Creates a TDataOverviewResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TDataOverviewResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TDataOverviewResponse} TDataOverviewResponse
         */
        TDataOverviewResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TDataOverviewResponse)
                return object;
            let message = new $root.NTentaclesApi.TDataOverviewResponse();
            if (object.result != null) {
                if (typeof object.result !== "object")
                    throw TypeError(".NTentaclesApi.TDataOverviewResponse.result: object expected");
                message.result = $root.NTentaclesApi.TDataOverviewResult.fromObject(object.result);
            }
            return message;
        };

        /**
         * Creates a plain object from a TDataOverviewResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TDataOverviewResponse
         * @static
         * @param {NTentaclesApi.TDataOverviewResponse} message TDataOverviewResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TDataOverviewResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.result = null;
            if (message.result != null && message.hasOwnProperty("result"))
                object.result = $root.NTentaclesApi.TDataOverviewResult.toObject(message.result, options);
            return object;
        };

        /**
         * Converts this TDataOverviewResponse to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TDataOverviewResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TDataOverviewResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TDataOverviewResponse;
    })();

    NTentaclesApi.TTentacles = (function() {

        /**
         * Properties of a TTentacles.
         * @memberof NTentaclesApi
         * @interface ITTentacles
         * @property {string|null} [pod_id] TTentacles pod_id
         * @property {string|null} [fqdn] TTentacles fqdn
         * @property {string|null} [tentacles_location] TTentacles tentacles_location
         * @property {string|null} [rtc_stage] TTentacles rtc_stage
         * @property {string|null} [yp_scheduling_error] TTentacles yp_scheduling_error
         * @property {string|null} [yp_node_hfsm_state] TTentacles yp_node_hfsm_state
         * @property {boolean|null} [is_juggler_data_present] TTentacles is_juggler_data_present
         * @property {string|null} [juggler_status] TTentacles juggler_status
         * @property {string|null} [juggler_state_kind] TTentacles juggler_state_kind
         * @property {string|null} [juggler_description] TTentacles juggler_description
         * @property {string|null} [nanny_service_name] TTentacles nanny_service_name
         * @property {string|null} [hq_id] TTentacles hq_id
         * @property {string|null} [hq_hostname] TTentacles hq_hostname
         * @property {boolean|null} [is_hq_data_present] TTentacles is_hq_data_present
         * @property {boolean|null} [excluded_from_slo_by_walle] TTentacles excluded_from_slo_by_walle
         * @property {string|null} [walle_project] TTentacles walle_project
         * @property {string|null} [walle_location_short_datacenter_name] TTentacles walle_location_short_datacenter_name
         * @property {string|null} [walle_operation_state] TTentacles walle_operation_state
         * @property {string|null} [walle_state] TTentacles walle_state
         * @property {string|null} [walle_status] TTentacles walle_status
         * @property {string|null} [walle_health_status] TTentacles walle_health_status
         * @property {Array.<string>|null} [walle_health_fail_reasons] TTentacles walle_health_fail_reasons
         * @property {number|null} [walle_scenario_id] TTentacles walle_scenario_id
         * @property {string|null} [walle_ticket] TTentacles walle_ticket
         * @property {boolean|null} [monitoring_timestamp_age_present] TTentacles monitoring_timestamp_age_present
         * @property {boolean|null} [monitoring_timestamp_age_visible] TTentacles monitoring_timestamp_age_visible
         * @property {boolean|null} [monitoring_timestamp_age_reachable] TTentacles monitoring_timestamp_age_reachable
         * @property {boolean|null} [monitoring_timestamp_age_fresh_ts_resource] TTentacles monitoring_timestamp_age_fresh_ts_resource
         * @property {boolean|null} [slo_availablilty_excluded] TTentacles slo_availablilty_excluded
         * @property {boolean|null} [slo_availablilty_available] TTentacles slo_availablilty_available
         * @property {boolean|null} [slo_redeployment_excluded] TTentacles slo_redeployment_excluded
         * @property {boolean|null} [slo_redeployment_fresh_ts_resource] TTentacles slo_redeployment_fresh_ts_resource
         */

        /**
         * Constructs a new TTentacles.
         * @memberof NTentaclesApi
         * @classdesc Represents a TTentacles.
         * @implements ITTentacles
         * @constructor
         * @param {NTentaclesApi.ITTentacles=} [properties] Properties to set
         */
        function TTentacles(properties) {
            this.walle_health_fail_reasons = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TTentacles pod_id.
         * @member {string} pod_id
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.pod_id = "";

        /**
         * TTentacles fqdn.
         * @member {string} fqdn
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.fqdn = "";

        /**
         * TTentacles tentacles_location.
         * @member {string} tentacles_location
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.tentacles_location = "";

        /**
         * TTentacles rtc_stage.
         * @member {string} rtc_stage
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.rtc_stage = "";

        /**
         * TTentacles yp_scheduling_error.
         * @member {string} yp_scheduling_error
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.yp_scheduling_error = "";

        /**
         * TTentacles yp_node_hfsm_state.
         * @member {string} yp_node_hfsm_state
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.yp_node_hfsm_state = "";

        /**
         * TTentacles is_juggler_data_present.
         * @member {boolean} is_juggler_data_present
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.is_juggler_data_present = false;

        /**
         * TTentacles juggler_status.
         * @member {string} juggler_status
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.juggler_status = "";

        /**
         * TTentacles juggler_state_kind.
         * @member {string} juggler_state_kind
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.juggler_state_kind = "";

        /**
         * TTentacles juggler_description.
         * @member {string} juggler_description
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.juggler_description = "";

        /**
         * TTentacles nanny_service_name.
         * @member {string} nanny_service_name
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.nanny_service_name = "";

        /**
         * TTentacles hq_id.
         * @member {string} hq_id
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.hq_id = "";

        /**
         * TTentacles hq_hostname.
         * @member {string} hq_hostname
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.hq_hostname = "";

        /**
         * TTentacles is_hq_data_present.
         * @member {boolean} is_hq_data_present
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.is_hq_data_present = false;

        /**
         * TTentacles excluded_from_slo_by_walle.
         * @member {boolean} excluded_from_slo_by_walle
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.excluded_from_slo_by_walle = false;

        /**
         * TTentacles walle_project.
         * @member {string} walle_project
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.walle_project = "";

        /**
         * TTentacles walle_location_short_datacenter_name.
         * @member {string} walle_location_short_datacenter_name
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.walle_location_short_datacenter_name = "";

        /**
         * TTentacles walle_operation_state.
         * @member {string} walle_operation_state
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.walle_operation_state = "";

        /**
         * TTentacles walle_state.
         * @member {string} walle_state
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.walle_state = "";

        /**
         * TTentacles walle_status.
         * @member {string} walle_status
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.walle_status = "";

        /**
         * TTentacles walle_health_status.
         * @member {string} walle_health_status
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.walle_health_status = "";

        /**
         * TTentacles walle_health_fail_reasons.
         * @member {Array.<string>} walle_health_fail_reasons
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.walle_health_fail_reasons = $util.emptyArray;

        /**
         * TTentacles walle_scenario_id.
         * @member {number} walle_scenario_id
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.walle_scenario_id = 0;

        /**
         * TTentacles walle_ticket.
         * @member {string} walle_ticket
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.walle_ticket = "";

        /**
         * TTentacles monitoring_timestamp_age_present.
         * @member {boolean} monitoring_timestamp_age_present
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.monitoring_timestamp_age_present = false;

        /**
         * TTentacles monitoring_timestamp_age_visible.
         * @member {boolean} monitoring_timestamp_age_visible
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.monitoring_timestamp_age_visible = false;

        /**
         * TTentacles monitoring_timestamp_age_reachable.
         * @member {boolean} monitoring_timestamp_age_reachable
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.monitoring_timestamp_age_reachable = false;

        /**
         * TTentacles monitoring_timestamp_age_fresh_ts_resource.
         * @member {boolean} monitoring_timestamp_age_fresh_ts_resource
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.monitoring_timestamp_age_fresh_ts_resource = false;

        /**
         * TTentacles slo_availablilty_excluded.
         * @member {boolean} slo_availablilty_excluded
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.slo_availablilty_excluded = false;

        /**
         * TTentacles slo_availablilty_available.
         * @member {boolean} slo_availablilty_available
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.slo_availablilty_available = false;

        /**
         * TTentacles slo_redeployment_excluded.
         * @member {boolean} slo_redeployment_excluded
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.slo_redeployment_excluded = false;

        /**
         * TTentacles slo_redeployment_fresh_ts_resource.
         * @member {boolean} slo_redeployment_fresh_ts_resource
         * @memberof NTentaclesApi.TTentacles
         * @instance
         */
        TTentacles.prototype.slo_redeployment_fresh_ts_resource = false;

        /**
         * Creates a new TTentacles instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TTentacles
         * @static
         * @param {NTentaclesApi.ITTentacles=} [properties] Properties to set
         * @returns {NTentaclesApi.TTentacles} TTentacles instance
         */
        TTentacles.create = function create(properties) {
            return new TTentacles(properties);
        };

        /**
         * Encodes the specified TTentacles message. Does not implicitly {@link NTentaclesApi.TTentacles.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TTentacles
         * @static
         * @param {NTentaclesApi.ITTentacles} message TTentacles message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TTentacles.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.pod_id != null && Object.hasOwnProperty.call(message, "pod_id"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.pod_id);
            if (message.fqdn != null && Object.hasOwnProperty.call(message, "fqdn"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.fqdn);
            if (message.tentacles_location != null && Object.hasOwnProperty.call(message, "tentacles_location"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.tentacles_location);
            if (message.rtc_stage != null && Object.hasOwnProperty.call(message, "rtc_stage"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.rtc_stage);
            if (message.yp_scheduling_error != null && Object.hasOwnProperty.call(message, "yp_scheduling_error"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.yp_scheduling_error);
            if (message.yp_node_hfsm_state != null && Object.hasOwnProperty.call(message, "yp_node_hfsm_state"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.yp_node_hfsm_state);
            if (message.is_juggler_data_present != null && Object.hasOwnProperty.call(message, "is_juggler_data_present"))
                writer.uint32(/* id 7, wireType 0 =*/56).bool(message.is_juggler_data_present);
            if (message.juggler_status != null && Object.hasOwnProperty.call(message, "juggler_status"))
                writer.uint32(/* id 8, wireType 2 =*/66).string(message.juggler_status);
            if (message.juggler_state_kind != null && Object.hasOwnProperty.call(message, "juggler_state_kind"))
                writer.uint32(/* id 9, wireType 2 =*/74).string(message.juggler_state_kind);
            if (message.juggler_description != null && Object.hasOwnProperty.call(message, "juggler_description"))
                writer.uint32(/* id 10, wireType 2 =*/82).string(message.juggler_description);
            if (message.nanny_service_name != null && Object.hasOwnProperty.call(message, "nanny_service_name"))
                writer.uint32(/* id 11, wireType 2 =*/90).string(message.nanny_service_name);
            if (message.hq_id != null && Object.hasOwnProperty.call(message, "hq_id"))
                writer.uint32(/* id 12, wireType 2 =*/98).string(message.hq_id);
            if (message.hq_hostname != null && Object.hasOwnProperty.call(message, "hq_hostname"))
                writer.uint32(/* id 13, wireType 2 =*/106).string(message.hq_hostname);
            if (message.is_hq_data_present != null && Object.hasOwnProperty.call(message, "is_hq_data_present"))
                writer.uint32(/* id 14, wireType 0 =*/112).bool(message.is_hq_data_present);
            if (message.excluded_from_slo_by_walle != null && Object.hasOwnProperty.call(message, "excluded_from_slo_by_walle"))
                writer.uint32(/* id 15, wireType 0 =*/120).bool(message.excluded_from_slo_by_walle);
            if (message.walle_project != null && Object.hasOwnProperty.call(message, "walle_project"))
                writer.uint32(/* id 16, wireType 2 =*/130).string(message.walle_project);
            if (message.walle_location_short_datacenter_name != null && Object.hasOwnProperty.call(message, "walle_location_short_datacenter_name"))
                writer.uint32(/* id 17, wireType 2 =*/138).string(message.walle_location_short_datacenter_name);
            if (message.walle_operation_state != null && Object.hasOwnProperty.call(message, "walle_operation_state"))
                writer.uint32(/* id 18, wireType 2 =*/146).string(message.walle_operation_state);
            if (message.walle_state != null && Object.hasOwnProperty.call(message, "walle_state"))
                writer.uint32(/* id 19, wireType 2 =*/154).string(message.walle_state);
            if (message.walle_status != null && Object.hasOwnProperty.call(message, "walle_status"))
                writer.uint32(/* id 20, wireType 2 =*/162).string(message.walle_status);
            if (message.walle_health_status != null && Object.hasOwnProperty.call(message, "walle_health_status"))
                writer.uint32(/* id 21, wireType 2 =*/170).string(message.walle_health_status);
            if (message.walle_health_fail_reasons != null && message.walle_health_fail_reasons.length)
                for (let i = 0; i < message.walle_health_fail_reasons.length; ++i)
                    writer.uint32(/* id 22, wireType 2 =*/178).string(message.walle_health_fail_reasons[i]);
            if (message.walle_scenario_id != null && Object.hasOwnProperty.call(message, "walle_scenario_id"))
                writer.uint32(/* id 23, wireType 0 =*/184).uint32(message.walle_scenario_id);
            if (message.walle_ticket != null && Object.hasOwnProperty.call(message, "walle_ticket"))
                writer.uint32(/* id 24, wireType 2 =*/194).string(message.walle_ticket);
            if (message.monitoring_timestamp_age_present != null && Object.hasOwnProperty.call(message, "monitoring_timestamp_age_present"))
                writer.uint32(/* id 25, wireType 0 =*/200).bool(message.monitoring_timestamp_age_present);
            if (message.monitoring_timestamp_age_visible != null && Object.hasOwnProperty.call(message, "monitoring_timestamp_age_visible"))
                writer.uint32(/* id 26, wireType 0 =*/208).bool(message.monitoring_timestamp_age_visible);
            if (message.monitoring_timestamp_age_reachable != null && Object.hasOwnProperty.call(message, "monitoring_timestamp_age_reachable"))
                writer.uint32(/* id 27, wireType 0 =*/216).bool(message.monitoring_timestamp_age_reachable);
            if (message.monitoring_timestamp_age_fresh_ts_resource != null && Object.hasOwnProperty.call(message, "monitoring_timestamp_age_fresh_ts_resource"))
                writer.uint32(/* id 28, wireType 0 =*/224).bool(message.monitoring_timestamp_age_fresh_ts_resource);
            if (message.slo_availablilty_excluded != null && Object.hasOwnProperty.call(message, "slo_availablilty_excluded"))
                writer.uint32(/* id 29, wireType 0 =*/232).bool(message.slo_availablilty_excluded);
            if (message.slo_availablilty_available != null && Object.hasOwnProperty.call(message, "slo_availablilty_available"))
                writer.uint32(/* id 30, wireType 0 =*/240).bool(message.slo_availablilty_available);
            if (message.slo_redeployment_excluded != null && Object.hasOwnProperty.call(message, "slo_redeployment_excluded"))
                writer.uint32(/* id 31, wireType 0 =*/248).bool(message.slo_redeployment_excluded);
            if (message.slo_redeployment_fresh_ts_resource != null && Object.hasOwnProperty.call(message, "slo_redeployment_fresh_ts_resource"))
                writer.uint32(/* id 32, wireType 0 =*/256).bool(message.slo_redeployment_fresh_ts_resource);
            return writer;
        };

        /**
         * Encodes the specified TTentacles message, length delimited. Does not implicitly {@link NTentaclesApi.TTentacles.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TTentacles
         * @static
         * @param {NTentaclesApi.ITTentacles} message TTentacles message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TTentacles.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TTentacles message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TTentacles
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TTentacles} TTentacles
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TTentacles.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TTentacles();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.pod_id = reader.string();
                    break;
                case 2:
                    message.fqdn = reader.string();
                    break;
                case 3:
                    message.tentacles_location = reader.string();
                    break;
                case 4:
                    message.rtc_stage = reader.string();
                    break;
                case 5:
                    message.yp_scheduling_error = reader.string();
                    break;
                case 6:
                    message.yp_node_hfsm_state = reader.string();
                    break;
                case 7:
                    message.is_juggler_data_present = reader.bool();
                    break;
                case 8:
                    message.juggler_status = reader.string();
                    break;
                case 9:
                    message.juggler_state_kind = reader.string();
                    break;
                case 10:
                    message.juggler_description = reader.string();
                    break;
                case 11:
                    message.nanny_service_name = reader.string();
                    break;
                case 12:
                    message.hq_id = reader.string();
                    break;
                case 13:
                    message.hq_hostname = reader.string();
                    break;
                case 14:
                    message.is_hq_data_present = reader.bool();
                    break;
                case 15:
                    message.excluded_from_slo_by_walle = reader.bool();
                    break;
                case 16:
                    message.walle_project = reader.string();
                    break;
                case 17:
                    message.walle_location_short_datacenter_name = reader.string();
                    break;
                case 18:
                    message.walle_operation_state = reader.string();
                    break;
                case 19:
                    message.walle_state = reader.string();
                    break;
                case 20:
                    message.walle_status = reader.string();
                    break;
                case 21:
                    message.walle_health_status = reader.string();
                    break;
                case 22:
                    if (!(message.walle_health_fail_reasons && message.walle_health_fail_reasons.length))
                        message.walle_health_fail_reasons = [];
                    message.walle_health_fail_reasons.push(reader.string());
                    break;
                case 23:
                    message.walle_scenario_id = reader.uint32();
                    break;
                case 24:
                    message.walle_ticket = reader.string();
                    break;
                case 25:
                    message.monitoring_timestamp_age_present = reader.bool();
                    break;
                case 26:
                    message.monitoring_timestamp_age_visible = reader.bool();
                    break;
                case 27:
                    message.monitoring_timestamp_age_reachable = reader.bool();
                    break;
                case 28:
                    message.monitoring_timestamp_age_fresh_ts_resource = reader.bool();
                    break;
                case 29:
                    message.slo_availablilty_excluded = reader.bool();
                    break;
                case 30:
                    message.slo_availablilty_available = reader.bool();
                    break;
                case 31:
                    message.slo_redeployment_excluded = reader.bool();
                    break;
                case 32:
                    message.slo_redeployment_fresh_ts_resource = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TTentacles message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TTentacles
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TTentacles} TTentacles
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TTentacles.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TTentacles message.
         * @function verify
         * @memberof NTentaclesApi.TTentacles
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TTentacles.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.pod_id != null && message.hasOwnProperty("pod_id"))
                if (!$util.isString(message.pod_id))
                    return "pod_id: string expected";
            if (message.fqdn != null && message.hasOwnProperty("fqdn"))
                if (!$util.isString(message.fqdn))
                    return "fqdn: string expected";
            if (message.tentacles_location != null && message.hasOwnProperty("tentacles_location"))
                if (!$util.isString(message.tentacles_location))
                    return "tentacles_location: string expected";
            if (message.rtc_stage != null && message.hasOwnProperty("rtc_stage"))
                if (!$util.isString(message.rtc_stage))
                    return "rtc_stage: string expected";
            if (message.yp_scheduling_error != null && message.hasOwnProperty("yp_scheduling_error"))
                if (!$util.isString(message.yp_scheduling_error))
                    return "yp_scheduling_error: string expected";
            if (message.yp_node_hfsm_state != null && message.hasOwnProperty("yp_node_hfsm_state"))
                if (!$util.isString(message.yp_node_hfsm_state))
                    return "yp_node_hfsm_state: string expected";
            if (message.is_juggler_data_present != null && message.hasOwnProperty("is_juggler_data_present"))
                if (typeof message.is_juggler_data_present !== "boolean")
                    return "is_juggler_data_present: boolean expected";
            if (message.juggler_status != null && message.hasOwnProperty("juggler_status"))
                if (!$util.isString(message.juggler_status))
                    return "juggler_status: string expected";
            if (message.juggler_state_kind != null && message.hasOwnProperty("juggler_state_kind"))
                if (!$util.isString(message.juggler_state_kind))
                    return "juggler_state_kind: string expected";
            if (message.juggler_description != null && message.hasOwnProperty("juggler_description"))
                if (!$util.isString(message.juggler_description))
                    return "juggler_description: string expected";
            if (message.nanny_service_name != null && message.hasOwnProperty("nanny_service_name"))
                if (!$util.isString(message.nanny_service_name))
                    return "nanny_service_name: string expected";
            if (message.hq_id != null && message.hasOwnProperty("hq_id"))
                if (!$util.isString(message.hq_id))
                    return "hq_id: string expected";
            if (message.hq_hostname != null && message.hasOwnProperty("hq_hostname"))
                if (!$util.isString(message.hq_hostname))
                    return "hq_hostname: string expected";
            if (message.is_hq_data_present != null && message.hasOwnProperty("is_hq_data_present"))
                if (typeof message.is_hq_data_present !== "boolean")
                    return "is_hq_data_present: boolean expected";
            if (message.excluded_from_slo_by_walle != null && message.hasOwnProperty("excluded_from_slo_by_walle"))
                if (typeof message.excluded_from_slo_by_walle !== "boolean")
                    return "excluded_from_slo_by_walle: boolean expected";
            if (message.walle_project != null && message.hasOwnProperty("walle_project"))
                if (!$util.isString(message.walle_project))
                    return "walle_project: string expected";
            if (message.walle_location_short_datacenter_name != null && message.hasOwnProperty("walle_location_short_datacenter_name"))
                if (!$util.isString(message.walle_location_short_datacenter_name))
                    return "walle_location_short_datacenter_name: string expected";
            if (message.walle_operation_state != null && message.hasOwnProperty("walle_operation_state"))
                if (!$util.isString(message.walle_operation_state))
                    return "walle_operation_state: string expected";
            if (message.walle_state != null && message.hasOwnProperty("walle_state"))
                if (!$util.isString(message.walle_state))
                    return "walle_state: string expected";
            if (message.walle_status != null && message.hasOwnProperty("walle_status"))
                if (!$util.isString(message.walle_status))
                    return "walle_status: string expected";
            if (message.walle_health_status != null && message.hasOwnProperty("walle_health_status"))
                if (!$util.isString(message.walle_health_status))
                    return "walle_health_status: string expected";
            if (message.walle_health_fail_reasons != null && message.hasOwnProperty("walle_health_fail_reasons")) {
                if (!Array.isArray(message.walle_health_fail_reasons))
                    return "walle_health_fail_reasons: array expected";
                for (let i = 0; i < message.walle_health_fail_reasons.length; ++i)
                    if (!$util.isString(message.walle_health_fail_reasons[i]))
                        return "walle_health_fail_reasons: string[] expected";
            }
            if (message.walle_scenario_id != null && message.hasOwnProperty("walle_scenario_id"))
                if (!$util.isInteger(message.walle_scenario_id))
                    return "walle_scenario_id: integer expected";
            if (message.walle_ticket != null && message.hasOwnProperty("walle_ticket"))
                if (!$util.isString(message.walle_ticket))
                    return "walle_ticket: string expected";
            if (message.monitoring_timestamp_age_present != null && message.hasOwnProperty("monitoring_timestamp_age_present"))
                if (typeof message.monitoring_timestamp_age_present !== "boolean")
                    return "monitoring_timestamp_age_present: boolean expected";
            if (message.monitoring_timestamp_age_visible != null && message.hasOwnProperty("monitoring_timestamp_age_visible"))
                if (typeof message.monitoring_timestamp_age_visible !== "boolean")
                    return "monitoring_timestamp_age_visible: boolean expected";
            if (message.monitoring_timestamp_age_reachable != null && message.hasOwnProperty("monitoring_timestamp_age_reachable"))
                if (typeof message.monitoring_timestamp_age_reachable !== "boolean")
                    return "monitoring_timestamp_age_reachable: boolean expected";
            if (message.monitoring_timestamp_age_fresh_ts_resource != null && message.hasOwnProperty("monitoring_timestamp_age_fresh_ts_resource"))
                if (typeof message.monitoring_timestamp_age_fresh_ts_resource !== "boolean")
                    return "monitoring_timestamp_age_fresh_ts_resource: boolean expected";
            if (message.slo_availablilty_excluded != null && message.hasOwnProperty("slo_availablilty_excluded"))
                if (typeof message.slo_availablilty_excluded !== "boolean")
                    return "slo_availablilty_excluded: boolean expected";
            if (message.slo_availablilty_available != null && message.hasOwnProperty("slo_availablilty_available"))
                if (typeof message.slo_availablilty_available !== "boolean")
                    return "slo_availablilty_available: boolean expected";
            if (message.slo_redeployment_excluded != null && message.hasOwnProperty("slo_redeployment_excluded"))
                if (typeof message.slo_redeployment_excluded !== "boolean")
                    return "slo_redeployment_excluded: boolean expected";
            if (message.slo_redeployment_fresh_ts_resource != null && message.hasOwnProperty("slo_redeployment_fresh_ts_resource"))
                if (typeof message.slo_redeployment_fresh_ts_resource !== "boolean")
                    return "slo_redeployment_fresh_ts_resource: boolean expected";
            return null;
        };

        /**
         * Creates a TTentacles message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TTentacles
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TTentacles} TTentacles
         */
        TTentacles.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TTentacles)
                return object;
            let message = new $root.NTentaclesApi.TTentacles();
            if (object.pod_id != null)
                message.pod_id = String(object.pod_id);
            if (object.fqdn != null)
                message.fqdn = String(object.fqdn);
            if (object.tentacles_location != null)
                message.tentacles_location = String(object.tentacles_location);
            if (object.rtc_stage != null)
                message.rtc_stage = String(object.rtc_stage);
            if (object.yp_scheduling_error != null)
                message.yp_scheduling_error = String(object.yp_scheduling_error);
            if (object.yp_node_hfsm_state != null)
                message.yp_node_hfsm_state = String(object.yp_node_hfsm_state);
            if (object.is_juggler_data_present != null)
                message.is_juggler_data_present = Boolean(object.is_juggler_data_present);
            if (object.juggler_status != null)
                message.juggler_status = String(object.juggler_status);
            if (object.juggler_state_kind != null)
                message.juggler_state_kind = String(object.juggler_state_kind);
            if (object.juggler_description != null)
                message.juggler_description = String(object.juggler_description);
            if (object.nanny_service_name != null)
                message.nanny_service_name = String(object.nanny_service_name);
            if (object.hq_id != null)
                message.hq_id = String(object.hq_id);
            if (object.hq_hostname != null)
                message.hq_hostname = String(object.hq_hostname);
            if (object.is_hq_data_present != null)
                message.is_hq_data_present = Boolean(object.is_hq_data_present);
            if (object.excluded_from_slo_by_walle != null)
                message.excluded_from_slo_by_walle = Boolean(object.excluded_from_slo_by_walle);
            if (object.walle_project != null)
                message.walle_project = String(object.walle_project);
            if (object.walle_location_short_datacenter_name != null)
                message.walle_location_short_datacenter_name = String(object.walle_location_short_datacenter_name);
            if (object.walle_operation_state != null)
                message.walle_operation_state = String(object.walle_operation_state);
            if (object.walle_state != null)
                message.walle_state = String(object.walle_state);
            if (object.walle_status != null)
                message.walle_status = String(object.walle_status);
            if (object.walle_health_status != null)
                message.walle_health_status = String(object.walle_health_status);
            if (object.walle_health_fail_reasons) {
                if (!Array.isArray(object.walle_health_fail_reasons))
                    throw TypeError(".NTentaclesApi.TTentacles.walle_health_fail_reasons: array expected");
                message.walle_health_fail_reasons = [];
                for (let i = 0; i < object.walle_health_fail_reasons.length; ++i)
                    message.walle_health_fail_reasons[i] = String(object.walle_health_fail_reasons[i]);
            }
            if (object.walle_scenario_id != null)
                message.walle_scenario_id = object.walle_scenario_id >>> 0;
            if (object.walle_ticket != null)
                message.walle_ticket = String(object.walle_ticket);
            if (object.monitoring_timestamp_age_present != null)
                message.monitoring_timestamp_age_present = Boolean(object.monitoring_timestamp_age_present);
            if (object.monitoring_timestamp_age_visible != null)
                message.monitoring_timestamp_age_visible = Boolean(object.monitoring_timestamp_age_visible);
            if (object.monitoring_timestamp_age_reachable != null)
                message.monitoring_timestamp_age_reachable = Boolean(object.monitoring_timestamp_age_reachable);
            if (object.monitoring_timestamp_age_fresh_ts_resource != null)
                message.monitoring_timestamp_age_fresh_ts_resource = Boolean(object.monitoring_timestamp_age_fresh_ts_resource);
            if (object.slo_availablilty_excluded != null)
                message.slo_availablilty_excluded = Boolean(object.slo_availablilty_excluded);
            if (object.slo_availablilty_available != null)
                message.slo_availablilty_available = Boolean(object.slo_availablilty_available);
            if (object.slo_redeployment_excluded != null)
                message.slo_redeployment_excluded = Boolean(object.slo_redeployment_excluded);
            if (object.slo_redeployment_fresh_ts_resource != null)
                message.slo_redeployment_fresh_ts_resource = Boolean(object.slo_redeployment_fresh_ts_resource);
            return message;
        };

        /**
         * Creates a plain object from a TTentacles message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TTentacles
         * @static
         * @param {NTentaclesApi.TTentacles} message TTentacles
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TTentacles.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.walle_health_fail_reasons = [];
            if (options.defaults) {
                object.pod_id = "";
                object.fqdn = "";
                object.tentacles_location = "";
                object.rtc_stage = "";
                object.yp_scheduling_error = "";
                object.yp_node_hfsm_state = "";
                object.is_juggler_data_present = false;
                object.juggler_status = "";
                object.juggler_state_kind = "";
                object.juggler_description = "";
                object.nanny_service_name = "";
                object.hq_id = "";
                object.hq_hostname = "";
                object.is_hq_data_present = false;
                object.excluded_from_slo_by_walle = false;
                object.walle_project = "";
                object.walle_location_short_datacenter_name = "";
                object.walle_operation_state = "";
                object.walle_state = "";
                object.walle_status = "";
                object.walle_health_status = "";
                object.walle_scenario_id = 0;
                object.walle_ticket = "";
                object.monitoring_timestamp_age_present = false;
                object.monitoring_timestamp_age_visible = false;
                object.monitoring_timestamp_age_reachable = false;
                object.monitoring_timestamp_age_fresh_ts_resource = false;
                object.slo_availablilty_excluded = false;
                object.slo_availablilty_available = false;
                object.slo_redeployment_excluded = false;
                object.slo_redeployment_fresh_ts_resource = false;
            }
            if (message.pod_id != null && message.hasOwnProperty("pod_id"))
                object.pod_id = message.pod_id;
            if (message.fqdn != null && message.hasOwnProperty("fqdn"))
                object.fqdn = message.fqdn;
            if (message.tentacles_location != null && message.hasOwnProperty("tentacles_location"))
                object.tentacles_location = message.tentacles_location;
            if (message.rtc_stage != null && message.hasOwnProperty("rtc_stage"))
                object.rtc_stage = message.rtc_stage;
            if (message.yp_scheduling_error != null && message.hasOwnProperty("yp_scheduling_error"))
                object.yp_scheduling_error = message.yp_scheduling_error;
            if (message.yp_node_hfsm_state != null && message.hasOwnProperty("yp_node_hfsm_state"))
                object.yp_node_hfsm_state = message.yp_node_hfsm_state;
            if (message.is_juggler_data_present != null && message.hasOwnProperty("is_juggler_data_present"))
                object.is_juggler_data_present = message.is_juggler_data_present;
            if (message.juggler_status != null && message.hasOwnProperty("juggler_status"))
                object.juggler_status = message.juggler_status;
            if (message.juggler_state_kind != null && message.hasOwnProperty("juggler_state_kind"))
                object.juggler_state_kind = message.juggler_state_kind;
            if (message.juggler_description != null && message.hasOwnProperty("juggler_description"))
                object.juggler_description = message.juggler_description;
            if (message.nanny_service_name != null && message.hasOwnProperty("nanny_service_name"))
                object.nanny_service_name = message.nanny_service_name;
            if (message.hq_id != null && message.hasOwnProperty("hq_id"))
                object.hq_id = message.hq_id;
            if (message.hq_hostname != null && message.hasOwnProperty("hq_hostname"))
                object.hq_hostname = message.hq_hostname;
            if (message.is_hq_data_present != null && message.hasOwnProperty("is_hq_data_present"))
                object.is_hq_data_present = message.is_hq_data_present;
            if (message.excluded_from_slo_by_walle != null && message.hasOwnProperty("excluded_from_slo_by_walle"))
                object.excluded_from_slo_by_walle = message.excluded_from_slo_by_walle;
            if (message.walle_project != null && message.hasOwnProperty("walle_project"))
                object.walle_project = message.walle_project;
            if (message.walle_location_short_datacenter_name != null && message.hasOwnProperty("walle_location_short_datacenter_name"))
                object.walle_location_short_datacenter_name = message.walle_location_short_datacenter_name;
            if (message.walle_operation_state != null && message.hasOwnProperty("walle_operation_state"))
                object.walle_operation_state = message.walle_operation_state;
            if (message.walle_state != null && message.hasOwnProperty("walle_state"))
                object.walle_state = message.walle_state;
            if (message.walle_status != null && message.hasOwnProperty("walle_status"))
                object.walle_status = message.walle_status;
            if (message.walle_health_status != null && message.hasOwnProperty("walle_health_status"))
                object.walle_health_status = message.walle_health_status;
            if (message.walle_health_fail_reasons && message.walle_health_fail_reasons.length) {
                object.walle_health_fail_reasons = [];
                for (let j = 0; j < message.walle_health_fail_reasons.length; ++j)
                    object.walle_health_fail_reasons[j] = message.walle_health_fail_reasons[j];
            }
            if (message.walle_scenario_id != null && message.hasOwnProperty("walle_scenario_id"))
                object.walle_scenario_id = message.walle_scenario_id;
            if (message.walle_ticket != null && message.hasOwnProperty("walle_ticket"))
                object.walle_ticket = message.walle_ticket;
            if (message.monitoring_timestamp_age_present != null && message.hasOwnProperty("monitoring_timestamp_age_present"))
                object.monitoring_timestamp_age_present = message.monitoring_timestamp_age_present;
            if (message.monitoring_timestamp_age_visible != null && message.hasOwnProperty("monitoring_timestamp_age_visible"))
                object.monitoring_timestamp_age_visible = message.monitoring_timestamp_age_visible;
            if (message.monitoring_timestamp_age_reachable != null && message.hasOwnProperty("monitoring_timestamp_age_reachable"))
                object.monitoring_timestamp_age_reachable = message.monitoring_timestamp_age_reachable;
            if (message.monitoring_timestamp_age_fresh_ts_resource != null && message.hasOwnProperty("monitoring_timestamp_age_fresh_ts_resource"))
                object.monitoring_timestamp_age_fresh_ts_resource = message.monitoring_timestamp_age_fresh_ts_resource;
            if (message.slo_availablilty_excluded != null && message.hasOwnProperty("slo_availablilty_excluded"))
                object.slo_availablilty_excluded = message.slo_availablilty_excluded;
            if (message.slo_availablilty_available != null && message.hasOwnProperty("slo_availablilty_available"))
                object.slo_availablilty_available = message.slo_availablilty_available;
            if (message.slo_redeployment_excluded != null && message.hasOwnProperty("slo_redeployment_excluded"))
                object.slo_redeployment_excluded = message.slo_redeployment_excluded;
            if (message.slo_redeployment_fresh_ts_resource != null && message.hasOwnProperty("slo_redeployment_fresh_ts_resource"))
                object.slo_redeployment_fresh_ts_resource = message.slo_redeployment_fresh_ts_resource;
            return object;
        };

        /**
         * Converts this TTentacles to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TTentacles
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TTentacles.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TTentacles;
    })();

    NTentaclesApi.TPodsListResult = (function() {

        /**
         * Properties of a TPodsListResult.
         * @memberof NTentaclesApi
         * @interface ITPodsListResult
         * @property {Array.<NTentaclesApi.ITTentacles>|null} [tentacles] TPodsListResult tentacles
         * @property {number|Long|null} [total_count] TPodsListResult total_count
         */

        /**
         * Constructs a new TPodsListResult.
         * @memberof NTentaclesApi
         * @classdesc Represents a TPodsListResult.
         * @implements ITPodsListResult
         * @constructor
         * @param {NTentaclesApi.ITPodsListResult=} [properties] Properties to set
         */
        function TPodsListResult(properties) {
            this.tentacles = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TPodsListResult tentacles.
         * @member {Array.<NTentaclesApi.ITTentacles>} tentacles
         * @memberof NTentaclesApi.TPodsListResult
         * @instance
         */
        TPodsListResult.prototype.tentacles = $util.emptyArray;

        /**
         * TPodsListResult total_count.
         * @member {number|Long} total_count
         * @memberof NTentaclesApi.TPodsListResult
         * @instance
         */
        TPodsListResult.prototype.total_count = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Creates a new TPodsListResult instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TPodsListResult
         * @static
         * @param {NTentaclesApi.ITPodsListResult=} [properties] Properties to set
         * @returns {NTentaclesApi.TPodsListResult} TPodsListResult instance
         */
        TPodsListResult.create = function create(properties) {
            return new TPodsListResult(properties);
        };

        /**
         * Encodes the specified TPodsListResult message. Does not implicitly {@link NTentaclesApi.TPodsListResult.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TPodsListResult
         * @static
         * @param {NTentaclesApi.ITPodsListResult} message TPodsListResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TPodsListResult.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.tentacles != null && message.tentacles.length)
                for (let i = 0; i < message.tentacles.length; ++i)
                    $root.NTentaclesApi.TTentacles.encode(message.tentacles[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.total_count != null && Object.hasOwnProperty.call(message, "total_count"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.total_count);
            return writer;
        };

        /**
         * Encodes the specified TPodsListResult message, length delimited. Does not implicitly {@link NTentaclesApi.TPodsListResult.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TPodsListResult
         * @static
         * @param {NTentaclesApi.ITPodsListResult} message TPodsListResult message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TPodsListResult.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TPodsListResult message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TPodsListResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TPodsListResult} TPodsListResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TPodsListResult.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TPodsListResult();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.tentacles && message.tentacles.length))
                        message.tentacles = [];
                    message.tentacles.push($root.NTentaclesApi.TTentacles.decode(reader, reader.uint32()));
                    break;
                case 2:
                    message.total_count = reader.uint64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TPodsListResult message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TPodsListResult
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TPodsListResult} TPodsListResult
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TPodsListResult.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TPodsListResult message.
         * @function verify
         * @memberof NTentaclesApi.TPodsListResult
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TPodsListResult.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.tentacles != null && message.hasOwnProperty("tentacles")) {
                if (!Array.isArray(message.tentacles))
                    return "tentacles: array expected";
                for (let i = 0; i < message.tentacles.length; ++i) {
                    let error = $root.NTentaclesApi.TTentacles.verify(message.tentacles[i]);
                    if (error)
                        return "tentacles." + error;
                }
            }
            if (message.total_count != null && message.hasOwnProperty("total_count"))
                if (!$util.isInteger(message.total_count) && !(message.total_count && $util.isInteger(message.total_count.low) && $util.isInteger(message.total_count.high)))
                    return "total_count: integer|Long expected";
            return null;
        };

        /**
         * Creates a TPodsListResult message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TPodsListResult
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TPodsListResult} TPodsListResult
         */
        TPodsListResult.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TPodsListResult)
                return object;
            let message = new $root.NTentaclesApi.TPodsListResult();
            if (object.tentacles) {
                if (!Array.isArray(object.tentacles))
                    throw TypeError(".NTentaclesApi.TPodsListResult.tentacles: array expected");
                message.tentacles = [];
                for (let i = 0; i < object.tentacles.length; ++i) {
                    if (typeof object.tentacles[i] !== "object")
                        throw TypeError(".NTentaclesApi.TPodsListResult.tentacles: object expected");
                    message.tentacles[i] = $root.NTentaclesApi.TTentacles.fromObject(object.tentacles[i]);
                }
            }
            if (object.total_count != null)
                if ($util.Long)
                    (message.total_count = $util.Long.fromValue(object.total_count)).unsigned = true;
                else if (typeof object.total_count === "string")
                    message.total_count = parseInt(object.total_count, 10);
                else if (typeof object.total_count === "number")
                    message.total_count = object.total_count;
                else if (typeof object.total_count === "object")
                    message.total_count = new $util.LongBits(object.total_count.low >>> 0, object.total_count.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a TPodsListResult message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TPodsListResult
         * @static
         * @param {NTentaclesApi.TPodsListResult} message TPodsListResult
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TPodsListResult.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.tentacles = [];
            if (options.defaults)
                if ($util.Long) {
                    let long = new $util.Long(0, 0, true);
                    object.total_count = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.total_count = options.longs === String ? "0" : 0;
            if (message.tentacles && message.tentacles.length) {
                object.tentacles = [];
                for (let j = 0; j < message.tentacles.length; ++j)
                    object.tentacles[j] = $root.NTentaclesApi.TTentacles.toObject(message.tentacles[j], options);
            }
            if (message.total_count != null && message.hasOwnProperty("total_count"))
                if (typeof message.total_count === "number")
                    object.total_count = options.longs === String ? String(message.total_count) : message.total_count;
                else
                    object.total_count = options.longs === String ? $util.Long.prototype.toString.call(message.total_count) : options.longs === Number ? new $util.LongBits(message.total_count.low >>> 0, message.total_count.high >>> 0).toNumber(true) : message.total_count;
            return object;
        };

        /**
         * Converts this TPodsListResult to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TPodsListResult
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TPodsListResult.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TPodsListResult;
    })();

    NTentaclesApi.TPodsListResponse = (function() {

        /**
         * Properties of a TPodsListResponse.
         * @memberof NTentaclesApi
         * @interface ITPodsListResponse
         * @property {NTentaclesApi.ITPodsListResult|null} [result] TPodsListResponse result
         */

        /**
         * Constructs a new TPodsListResponse.
         * @memberof NTentaclesApi
         * @classdesc Represents a TPodsListResponse.
         * @implements ITPodsListResponse
         * @constructor
         * @param {NTentaclesApi.ITPodsListResponse=} [properties] Properties to set
         */
        function TPodsListResponse(properties) {
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TPodsListResponse result.
         * @member {NTentaclesApi.ITPodsListResult|null|undefined} result
         * @memberof NTentaclesApi.TPodsListResponse
         * @instance
         */
        TPodsListResponse.prototype.result = null;

        /**
         * Creates a new TPodsListResponse instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TPodsListResponse
         * @static
         * @param {NTentaclesApi.ITPodsListResponse=} [properties] Properties to set
         * @returns {NTentaclesApi.TPodsListResponse} TPodsListResponse instance
         */
        TPodsListResponse.create = function create(properties) {
            return new TPodsListResponse(properties);
        };

        /**
         * Encodes the specified TPodsListResponse message. Does not implicitly {@link NTentaclesApi.TPodsListResponse.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TPodsListResponse
         * @static
         * @param {NTentaclesApi.ITPodsListResponse} message TPodsListResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TPodsListResponse.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.result != null && Object.hasOwnProperty.call(message, "result"))
                $root.NTentaclesApi.TPodsListResult.encode(message.result, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified TPodsListResponse message, length delimited. Does not implicitly {@link NTentaclesApi.TPodsListResponse.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TPodsListResponse
         * @static
         * @param {NTentaclesApi.ITPodsListResponse} message TPodsListResponse message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TPodsListResponse.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TPodsListResponse message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TPodsListResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TPodsListResponse} TPodsListResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TPodsListResponse.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TPodsListResponse();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.result = $root.NTentaclesApi.TPodsListResult.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TPodsListResponse message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TPodsListResponse
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TPodsListResponse} TPodsListResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TPodsListResponse.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TPodsListResponse message.
         * @function verify
         * @memberof NTentaclesApi.TPodsListResponse
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TPodsListResponse.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.result != null && message.hasOwnProperty("result")) {
                let error = $root.NTentaclesApi.TPodsListResult.verify(message.result);
                if (error)
                    return "result." + error;
            }
            return null;
        };

        /**
         * Creates a TPodsListResponse message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TPodsListResponse
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TPodsListResponse} TPodsListResponse
         */
        TPodsListResponse.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TPodsListResponse)
                return object;
            let message = new $root.NTentaclesApi.TPodsListResponse();
            if (object.result != null) {
                if (typeof object.result !== "object")
                    throw TypeError(".NTentaclesApi.TPodsListResponse.result: object expected");
                message.result = $root.NTentaclesApi.TPodsListResult.fromObject(object.result);
            }
            return message;
        };

        /**
         * Creates a plain object from a TPodsListResponse message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TPodsListResponse
         * @static
         * @param {NTentaclesApi.TPodsListResponse} message TPodsListResponse
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TPodsListResponse.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.defaults)
                object.result = null;
            if (message.result != null && message.hasOwnProperty("result"))
                object.result = $root.NTentaclesApi.TPodsListResult.toObject(message.result, options);
            return object;
        };

        /**
         * Converts this TPodsListResponse to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TPodsListResponse
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TPodsListResponse.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TPodsListResponse;
    })();

    NTentaclesApi.TPodsListRequest = (function() {

        /**
         * Properties of a TPodsListRequest.
         * @memberof NTentaclesApi
         * @interface ITPodsListRequest
         * @property {string|null} [allocation_zone_id] TPodsListRequest allocation_zone_id
         * @property {Array.<string>|null} [columns] TPodsListRequest columns
         * @property {NTentaclesApi.EPodFilter|null} [filter] TPodsListRequest filter
         * @property {number|Long|null} [limit] TPodsListRequest limit
         * @property {number|Long|null} [offset] TPodsListRequest offset
         * @property {number|Long|null} [ts] TPodsListRequest ts
         */

        /**
         * Constructs a new TPodsListRequest.
         * @memberof NTentaclesApi
         * @classdesc Represents a TPodsListRequest.
         * @implements ITPodsListRequest
         * @constructor
         * @param {NTentaclesApi.ITPodsListRequest=} [properties] Properties to set
         */
        function TPodsListRequest(properties) {
            this.columns = [];
            if (properties)
                for (let keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * TPodsListRequest allocation_zone_id.
         * @member {string} allocation_zone_id
         * @memberof NTentaclesApi.TPodsListRequest
         * @instance
         */
        TPodsListRequest.prototype.allocation_zone_id = "";

        /**
         * TPodsListRequest columns.
         * @member {Array.<string>} columns
         * @memberof NTentaclesApi.TPodsListRequest
         * @instance
         */
        TPodsListRequest.prototype.columns = $util.emptyArray;

        /**
         * TPodsListRequest filter.
         * @member {NTentaclesApi.EPodFilter} filter
         * @memberof NTentaclesApi.TPodsListRequest
         * @instance
         */
        TPodsListRequest.prototype.filter = 0;

        /**
         * TPodsListRequest limit.
         * @member {number|Long} limit
         * @memberof NTentaclesApi.TPodsListRequest
         * @instance
         */
        TPodsListRequest.prototype.limit = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TPodsListRequest offset.
         * @member {number|Long} offset
         * @memberof NTentaclesApi.TPodsListRequest
         * @instance
         */
        TPodsListRequest.prototype.offset = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * TPodsListRequest ts.
         * @member {number|Long} ts
         * @memberof NTentaclesApi.TPodsListRequest
         * @instance
         */
        TPodsListRequest.prototype.ts = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Creates a new TPodsListRequest instance using the specified properties.
         * @function create
         * @memberof NTentaclesApi.TPodsListRequest
         * @static
         * @param {NTentaclesApi.ITPodsListRequest=} [properties] Properties to set
         * @returns {NTentaclesApi.TPodsListRequest} TPodsListRequest instance
         */
        TPodsListRequest.create = function create(properties) {
            return new TPodsListRequest(properties);
        };

        /**
         * Encodes the specified TPodsListRequest message. Does not implicitly {@link NTentaclesApi.TPodsListRequest.verify|verify} messages.
         * @function encode
         * @memberof NTentaclesApi.TPodsListRequest
         * @static
         * @param {NTentaclesApi.ITPodsListRequest} message TPodsListRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TPodsListRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.allocation_zone_id != null && Object.hasOwnProperty.call(message, "allocation_zone_id"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.allocation_zone_id);
            if (message.columns != null && message.columns.length)
                for (let i = 0; i < message.columns.length; ++i)
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.columns[i]);
            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.filter);
            if (message.limit != null && Object.hasOwnProperty.call(message, "limit"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint64(message.limit);
            if (message.offset != null && Object.hasOwnProperty.call(message, "offset"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint64(message.offset);
            if (message.ts != null && Object.hasOwnProperty.call(message, "ts"))
                writer.uint32(/* id 6, wireType 0 =*/48).uint64(message.ts);
            return writer;
        };

        /**
         * Encodes the specified TPodsListRequest message, length delimited. Does not implicitly {@link NTentaclesApi.TPodsListRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof NTentaclesApi.TPodsListRequest
         * @static
         * @param {NTentaclesApi.ITPodsListRequest} message TPodsListRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        TPodsListRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a TPodsListRequest message from the specified reader or buffer.
         * @function decode
         * @memberof NTentaclesApi.TPodsListRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {NTentaclesApi.TPodsListRequest} TPodsListRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TPodsListRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            let end = length === undefined ? reader.len : reader.pos + length, message = new $root.NTentaclesApi.TPodsListRequest();
            while (reader.pos < end) {
                let tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.allocation_zone_id = reader.string();
                    break;
                case 2:
                    if (!(message.columns && message.columns.length))
                        message.columns = [];
                    message.columns.push(reader.string());
                    break;
                case 3:
                    message.filter = reader.int32();
                    break;
                case 4:
                    message.limit = reader.uint64();
                    break;
                case 5:
                    message.offset = reader.uint64();
                    break;
                case 6:
                    message.ts = reader.uint64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a TPodsListRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof NTentaclesApi.TPodsListRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {NTentaclesApi.TPodsListRequest} TPodsListRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        TPodsListRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a TPodsListRequest message.
         * @function verify
         * @memberof NTentaclesApi.TPodsListRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        TPodsListRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.allocation_zone_id != null && message.hasOwnProperty("allocation_zone_id"))
                if (!$util.isString(message.allocation_zone_id))
                    return "allocation_zone_id: string expected";
            if (message.columns != null && message.hasOwnProperty("columns")) {
                if (!Array.isArray(message.columns))
                    return "columns: array expected";
                for (let i = 0; i < message.columns.length; ++i)
                    if (!$util.isString(message.columns[i]))
                        return "columns: string[] expected";
            }
            if (message.filter != null && message.hasOwnProperty("filter"))
                switch (message.filter) {
                default:
                    return "filter: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                    break;
                }
            if (message.limit != null && message.hasOwnProperty("limit"))
                if (!$util.isInteger(message.limit) && !(message.limit && $util.isInteger(message.limit.low) && $util.isInteger(message.limit.high)))
                    return "limit: integer|Long expected";
            if (message.offset != null && message.hasOwnProperty("offset"))
                if (!$util.isInteger(message.offset) && !(message.offset && $util.isInteger(message.offset.low) && $util.isInteger(message.offset.high)))
                    return "offset: integer|Long expected";
            if (message.ts != null && message.hasOwnProperty("ts"))
                if (!$util.isInteger(message.ts) && !(message.ts && $util.isInteger(message.ts.low) && $util.isInteger(message.ts.high)))
                    return "ts: integer|Long expected";
            return null;
        };

        /**
         * Creates a TPodsListRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof NTentaclesApi.TPodsListRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {NTentaclesApi.TPodsListRequest} TPodsListRequest
         */
        TPodsListRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.NTentaclesApi.TPodsListRequest)
                return object;
            let message = new $root.NTentaclesApi.TPodsListRequest();
            if (object.allocation_zone_id != null)
                message.allocation_zone_id = String(object.allocation_zone_id);
            if (object.columns) {
                if (!Array.isArray(object.columns))
                    throw TypeError(".NTentaclesApi.TPodsListRequest.columns: array expected");
                message.columns = [];
                for (let i = 0; i < object.columns.length; ++i)
                    message.columns[i] = String(object.columns[i]);
            }
            switch (object.filter) {
            case "NONE":
            case 0:
                message.filter = 0;
                break;
            case "EXCLUDED_DECOMMISSIONED_NODES":
            case 1:
                message.filter = 1;
                break;
            case "EXCLUDED_PROBATION_OR_FREE_NODES":
            case 2:
                message.filter = 2;
                break;
            case "PODS_SCHEDULING_ERRORS":
            case 3:
                message.filter = 3;
                break;
            case "UNUSED_YP_NODES":
            case 4:
                message.filter = 4;
                break;
            case "EXCLUDED_NOT_PRESENT":
            case 5:
                message.filter = 5;
                break;
            case "EXCLUDED_NOT_VISIBLE":
            case 6:
                message.filter = 6;
                break;
            case "EXCLUDED_NOT_REACHABLE":
            case 7:
                message.filter = 7;
                break;
            }
            if (object.limit != null)
                if ($util.Long)
                    (message.limit = $util.Long.fromValue(object.limit)).unsigned = true;
                else if (typeof object.limit === "string")
                    message.limit = parseInt(object.limit, 10);
                else if (typeof object.limit === "number")
                    message.limit = object.limit;
                else if (typeof object.limit === "object")
                    message.limit = new $util.LongBits(object.limit.low >>> 0, object.limit.high >>> 0).toNumber(true);
            if (object.offset != null)
                if ($util.Long)
                    (message.offset = $util.Long.fromValue(object.offset)).unsigned = true;
                else if (typeof object.offset === "string")
                    message.offset = parseInt(object.offset, 10);
                else if (typeof object.offset === "number")
                    message.offset = object.offset;
                else if (typeof object.offset === "object")
                    message.offset = new $util.LongBits(object.offset.low >>> 0, object.offset.high >>> 0).toNumber(true);
            if (object.ts != null)
                if ($util.Long)
                    (message.ts = $util.Long.fromValue(object.ts)).unsigned = true;
                else if (typeof object.ts === "string")
                    message.ts = parseInt(object.ts, 10);
                else if (typeof object.ts === "number")
                    message.ts = object.ts;
                else if (typeof object.ts === "object")
                    message.ts = new $util.LongBits(object.ts.low >>> 0, object.ts.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a TPodsListRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof NTentaclesApi.TPodsListRequest
         * @static
         * @param {NTentaclesApi.TPodsListRequest} message TPodsListRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        TPodsListRequest.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            let object = {};
            if (options.arrays || options.defaults)
                object.columns = [];
            if (options.defaults) {
                object.allocation_zone_id = "";
                object.filter = options.enums === String ? "NONE" : 0;
                if ($util.Long) {
                    let long = new $util.Long(0, 0, true);
                    object.limit = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.limit = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    let long = new $util.Long(0, 0, true);
                    object.offset = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.offset = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    let long = new $util.Long(0, 0, true);
                    object.ts = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.ts = options.longs === String ? "0" : 0;
            }
            if (message.allocation_zone_id != null && message.hasOwnProperty("allocation_zone_id"))
                object.allocation_zone_id = message.allocation_zone_id;
            if (message.columns && message.columns.length) {
                object.columns = [];
                for (let j = 0; j < message.columns.length; ++j)
                    object.columns[j] = message.columns[j];
            }
            if (message.filter != null && message.hasOwnProperty("filter"))
                object.filter = options.enums === String ? $root.NTentaclesApi.EPodFilter[message.filter] : message.filter;
            if (message.limit != null && message.hasOwnProperty("limit"))
                if (typeof message.limit === "number")
                    object.limit = options.longs === String ? String(message.limit) : message.limit;
                else
                    object.limit = options.longs === String ? $util.Long.prototype.toString.call(message.limit) : options.longs === Number ? new $util.LongBits(message.limit.low >>> 0, message.limit.high >>> 0).toNumber(true) : message.limit;
            if (message.offset != null && message.hasOwnProperty("offset"))
                if (typeof message.offset === "number")
                    object.offset = options.longs === String ? String(message.offset) : message.offset;
                else
                    object.offset = options.longs === String ? $util.Long.prototype.toString.call(message.offset) : options.longs === Number ? new $util.LongBits(message.offset.low >>> 0, message.offset.high >>> 0).toNumber(true) : message.offset;
            if (message.ts != null && message.hasOwnProperty("ts"))
                if (typeof message.ts === "number")
                    object.ts = options.longs === String ? String(message.ts) : message.ts;
                else
                    object.ts = options.longs === String ? $util.Long.prototype.toString.call(message.ts) : options.longs === Number ? new $util.LongBits(message.ts.low >>> 0, message.ts.high >>> 0).toNumber(true) : message.ts;
            return object;
        };

        /**
         * Converts this TPodsListRequest to JSON.
         * @function toJSON
         * @memberof NTentaclesApi.TPodsListRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        TPodsListRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return TPodsListRequest;
    })();

    return NTentaclesApi;
})();

export { $root as default };
