import {NTentaclesApi} from './stubs/tentacles';
import {API} from './constants';

const {TUpdateIncidentRequest: Request} = NTentaclesApi;
const {TUpdateIncidentResponse: Response} = NTentaclesApi;

export async function updateIncident(requestData: NTentaclesApi.ITUpdateIncidentRequest, init?: RequestInit) {
    const request = Request.create(requestData);
    const response = await fetch(API + '/incidents/update', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(request.toJSON()),
        ...init,
    });

    const data = await response.json();
    return Response.fromObject(data);
}
