import I18n from './i18n';

const i18n = I18n.keyset('arcanum.heatmap');

export const MILLISECONDS_IN_ONE_DAY = 24 * 60 * 60 * 1000;

export const DAYS_IN_WEEK = 7;

export const MONTH_LABELS = [
    i18n('label_month-jan'),
    i18n('label_month-feb'),
    i18n('label_month-mar'),
    i18n('label_month-apr'),
    i18n('label_month-may'),
    i18n('label_month-jun'),
    i18n('label_month-jul'),
    i18n('label_month-aug'),
    i18n('label_month-sep'),
    i18n('label_month-oct'),
    i18n('label_month-nov'),
    i18n('label_month-dec'),
];

export const DAY_LABELS = [
    i18n('label_week-mon'),
    '',
    i18n('label_week-wed'),
    '',
    i18n('label_week-fri'),
    '',
    i18n('label_week-sun'),
];

export const WEEKDAY_LABEL_SIZE = 26;
export const OFFSET_FROM_TOP = 8;

export const LEGEND_COLORS = [
    {
        colorClass: 'scale-0',
        title: i18n('label_no-commits'),
    },
    {
        colorClass: 'scale-1',
        title: i18n('label_from-to-commits', {from: 1, to: 2}),
    },
    {
        colorClass: 'scale-2',
        title: i18n('label_from-to-commits', {from: 3, to: 5}),
    },
    {
        colorClass: 'scale-3',
        title: i18n('label_from-to-commits', {from: 6, to: 7}),
    },
    {
        colorClass: 'scale-4',
        title: i18n('label_more-commits', {from: 8}),
    },
];
