// Возвращает дату, сдвинутую на некоторое кол-во дней (может быть отрицательной)
export function shiftDate(date: Date | string | number, numDays: number): Date {
    const newDate = new Date(date);
    newDate.setDate(newDate.getDate() + numDays);

    return newDate;
}

export function getBeginningTimeForDate(date: Date): Date {
    return new Date(date.getFullYear(), date.getMonth(), date.getDate());
}

export function convertToDate(date: Date | string | number | undefined): Date {
    if (!date) return new Date();

    return date instanceof Date ? date : new Date(date);
}

export function dateNDaysAgo(numDaysAgo: number): Date {
    return shiftDate(new Date(), -numDaysAgo);
}

export function getRange(count: number): number[] {
    return Array.from({ length: count }, (_, i) => i);
}
