import React, {Component} from 'react';

export interface ErrorBoundaryFallbackProps {
    error: Error;
    resetErrorBoundary: () => void;
}

interface ErrorBoundaryProps {
    fallbackRender: React.ComponentType<ErrorBoundaryFallbackProps>;
    onReset: () => void;
}

interface ErrorBoundaryState {
    error: Error | null;
}

//@deprecated use react-error-boundary
export class ErrorBoundary extends Component<ErrorBoundaryProps, ErrorBoundaryState> {
    state = {
        error: null,
    };

    static getDerivedStateFromError(error: Error) {
        return {error};
    }

    resetError() {
        this.props.onReset();
        this.setState({error: null});
    }

    render() {
        if (this.state.error) {
            return <this.props.fallbackRender error={this.state.error!} resetErrorBoundary={() => this.resetError()} />;
        }

        return this.props.children;
    }
}
