import React from 'react';

import {ReactComponent as ErrorBanner} from './error-banner.svg';
import {Button} from 'lego-on-react';
import {FallbackProps} from 'react-error-boundary';

export const ContainerErrorFallback: React.FunctionComponent<FallbackProps> = ({error, resetErrorBoundary}) => {
    return (
        <div style={{display: 'flex', justifyContent: 'center', alignItems: 'center', height: '100%'}}>
            <div role="alert" style={{display: 'flex', alignItems: 'center'}}>
                <ErrorBanner style={{transform: 'scale(0.62)'}}/>
                <div>
                    <p>Something went wrong:</p>
                    <pre>{error.message}</pre>
                    <Button size={'s'} theme={'action'} view={'default'} tone={'default'} onClick={resetErrorBoundary}>
                        Try again
                    </Button>
                </div>
            </div>
        </div>
    );
};
