import React from 'react';
import {Label, Loader} from '@yandex-data-ui/common';
import {Panel} from "../Panel/Panel";


export interface ErrorPanelProps {
    loading: boolean;
    error?: string | React.ReactNode;
}

export const ErrorPanel: React.FunctionComponent<ErrorPanelProps> = (props) => {
    if (props.loading) {
        return <Panel><Loader /></Panel>
    }

    if (typeof props.error === 'string' && props.error !== '') {
        return <Label theme={'danger'}>{props.error}</Label>;
    }

    if (props.error) {
        return <>{props.error}</>;
    }

    return <>{props.children}</>;
};
