import React from 'react';
import classNames from 'classnames';
import {ExternalLinkIcon} from '../icons/ExternalLinkIcon';

interface ExternalLinkProps {
    href: string;
    className?: string;
}

export const ExternalLink: React.FunctionComponent<ExternalLinkProps> = ({href, className, children}) => {
    return (
        <a
            className={classNames(className, 'link', 'link_theme_normal')}
            href={href}
            target={'_blank'}
            rel={'noreferrer'}
        >
            {children}
            {' '}
            <ExternalLinkIcon size={'1x'} />
        </a>
    );
};
