import {AsideHeaderFooterItem, AsideHeaderFooterItemProps, AsideHeaderTooltip} from '@yandex-data-ui/navigation';
import {SignInIcon} from '../icons/SignInIcon';
import {getPassportAuthHref} from '@yandex-data-ui/cloud-components/build/components/UserMenu/utils';
import {UserMenuContent, UserMenuView} from '@yandex-data-ui/cloud-components';
import React, {useContext} from 'react';
import {observer} from 'mobx-react-lite';

import {UserContext} from '../../context/UserContex';

interface MenuUserProps {
    isCompact: boolean;
    popupAnchor: AsideHeaderFooterItemProps['popupAnchor'];
}

export const MenuUser: React.FunctionComponent<MenuUserProps> = observer((props) => {
    const user = useContext(UserContext)!;
    const [popupVisible, setPopupVisible] = React.useState<boolean>();
    const [tooltipAnchor, setTooltipAnchor] = React.useState<HTMLDivElement | null>(null);

    const isSignIn = Boolean(user.userinfo);
    const text = isSignIn ? 'Account' : 'Log in';
    const internal = true;

    return (
        <AsideHeaderFooterItem
            text={text}
            icon={isSignIn ? undefined : SignInIcon}
            isCompact={props.isCompact}
            isCurrent={popupVisible}
            onClick={() => {
                if (isSignIn) {
                    setPopupVisible(!popupVisible);
                } else {
                    window.open(getPassportAuthHref(internal), '_self');
                }
            }}
            popupVisible={isSignIn ? popupVisible : false}
            popupAnchor={props.popupAnchor}
            onClosePopup={() => setPopupVisible(false)}
            renderCustomIcon={
                isSignIn
                    ? () => (
                          <>
                              <div
                                  onMouseEnter={(event) => setTooltipAnchor(event.target as HTMLDivElement)}
                                  onMouseLeave={() => setTooltipAnchor(null)}
                              >
                                  <UserMenuView
                                      size="s"
                                      compact={true}
                                      user={user.userinfo?.current}
                                      internal={internal}
                                  />
                              </div>
                              {!popupVisible && props.isCompact && (
                                  <AsideHeaderTooltip anchor={tooltipAnchor} text={text} />
                              )}
                          </>
                      )
                    : undefined
            }
            renderPopupContent={
                isSignIn
                    ? () => (
                          <UserMenuContent
                              user={user.userinfo?.current}
                              internal={internal}
                              accounts={user.userinfo?.accounts}
                          />
                      )
                    : undefined
            }
        />
    );
});
