import React from 'react';
import classNames from 'classnames';
import styles from './Panel.module.css';

export interface PanelProps {
    className?: React.HTMLAttributes<any>['className'];
    style?: React.HTMLAttributes<any>['style'];
}

export const Panel: React.FunctionComponent<PanelProps> = (props) => {
    return <div className={classNames(styles.Panel, props.className)} style={props.style}>{props.children}</div>;
};
