import React from 'react';

const CTYPE = window.location.host === 'tentacles.yandex-team.ru' ? 'production' : 'testing';

interface MonitoringProps {
    allocationZoneId: string;
    daemonset: boolean;
    reallocation: boolean;
}

export const Monitoring: React.FunctionComponent<MonitoringProps> = (props) => {
    const features: string[] = [];

    if (props.daemonset) {
        features.push('daemonset');
    }

    if (props.reallocation) {
        features.push('reallocation');
    }

    return (
        <iframe
            title={'Monitoring'}
            width={'100%'}
            height={680}
            frameBorder={0}
            src={`https://yasm.yandex-team.ru/template/panel/rtc-sla-tentacles-all-metrics-template-production/ctype=${CTYPE};allocation_zone_id=${
                props.allocationZoneId
            };features=${features.join(',')}/?fullscreen=1`}
        />
    );
};
